#include "osl/direction.h"
#include <iostream>

bool osl::isValid(Direction d){
  return DIRECTION_MIN<=d && d<=DIRECTION_MAX;
}

namespace osl
{
  std::ostream& operator<<(std::ostream& os,const Direction d){
    static const char* names[]={
      "UL","U","UR","L",
      "R","DL","D","DR",
      "UUL","UUR","LONG_UL",
      "LONG_U","LONG_UR","LONG_L",
      "LONG_R","LONG_DL","LONG_D","LONG_DR"
    };
    return os << names[static_cast<int>(d)];
  }

}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
