/* boardKey.tcc
 */
#ifndef _BOARD_KEY_TCC
#define _BOARD_KEY_TCC
#include "osl/hash/boardKey.h"
#include "osl/misc/random.h"

template<typename T,size_t SIZE>
osl::hash::GeneralBoardKey<T,SIZE>::
GeneralBoardKey()
{
  elements.fill(0);
}

template<typename T,size_t SIZE>
void osl::hash::GeneralBoardKey<T,SIZE>::setRandom()
{
  elements[0]=misc::Random<T>::newValue() & ~static_cast<T>(1);
  for(size_t i=1;i<SIZE;i++)
    elements[i]=misc::Random<T>::newValue();
}

template<typename SignatureBoardKeyBase>
void osl::hash::GeneralHashKey<SignatureBoardKeyBase>::setRandom()
{
  board_key.setRandom();
  // pieceStandには触らない
}

#endif /* _BOARD_KEY_TCC */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:

