# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20211206222445;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[2-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[2-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{de} = {"4934493", "Gößnitz\ Thüringen",
"495053", "Faßberg\-Müden",
"494509", "Groß\ Grönau",
"49221", "Köln",
"4935753", "Großräschen",
"492339", "Sprockhövel\-Haßlinghausen",
"499636", "Plößberg",
"497355", "Hochdorf\ Riß",
"498807", "Dießen\ am\ Ammersee",
"499242", "Gößweinstein",
"4939976", "Groß\ Bützin",
"499141", "Weißenburg\ in\ Bayern",
"4935240", "Tauscha\ bei\ Großenhain",
"4934445", "Stößen",
"4935841", "Großschönau\ Sachsen",
"4936949", "Obermaßfeld\-Grimmenthal",
"4989", "München",
"4935248", "Schönfeld\ bei\ Großenhain",
"498170", "Straßlach\-Dingharting",
"498633", "Tüßling",
"496364", "Nußbach\ Pfalz",
"493647", "Pößneck",
"499656", "Moosbach\ bei\ Vohenstrauß",
"495827", "Unterlüß",
"498367", "Roßhaupten\ Forggensee",
"499567", "Seßlach\-Gemünda",
"496252", "Heppenheim\ Bergstraße",
"4934901", "Roßlau\ Elbe",
"4938234", "Born\ Darß",
"498536", "Kößlarn",
"497351", "Biberach\ an\ der\ Riß",
"4935938", "Großpostwitz\ OL",
"495064", "Groß\ Düngen",
"495384", "Seesen\-Groß\ Rhüden",
"497162", "Süßen",
"492203", "Köln\-Porz",
"496321", "Neustadt\ an\ der\ Weinstraße",
"4935952", "Großröhrsdorf\ OL",
"496663", "Steinau\ an\ der\ Straße",
"4935726", "Groß\ Särchen",
"49911", "Nürnberg",
"4939883", "Groß\ Dölln",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"4936072", "Weißenborn\-Lüderode",
"494684", "Langeneß\ Hallig",
"4939934", "Groß\ Plasten",
"4936484", "Knau\ bei\ Pößneck",
"494497", "Barßel\-Harkebrügge",
"494483", "Ovelgönne\-Großenmeer",};
$areanames{en} = {"494240", "Syke\-Heiligenfelde",
"498322", "Oberstdorf",
"493636", "Greussen",
"4938232", "Zingst\ Ostseebad",
"494872", "Hanerau\-Hademarschen",
"499088", "Mönchsdeggingen",
"494772", "Oberndorf\ Oste",
"498506", "Bad\ Höhenstadt",
"494745", "Bad\ Bederkesa",
"498257", "Inchenhofen",
"495277", "Höxter\-Fürstenau",
"494971", "Esens",
"494959", "Dollart",
"494845", "Ostenfeld\ Husum",
"4935773", "Schleife",
"497906", "Braunsbach",
"495436", "Nortrup",
"492566", "Legden",
"4936651", "Lobenstein",
"4936730", "Sitzendorf",
"4939747", "Züsedom",
"498102", "Höhenkirchen\-Siegertsbrunn",
"4936462", "Ossmannstedt",
"499661", "Sulzbach\-Rosenberg",
"497965", "Ellwangen\-Röhlingen",
"4939749", "Grambow\ bei\ Pasewalk",
"492505", "Altenberge\ Westfalen",
"492684", "Puderbach\ Westerwald",
"492238", "Pulheim",
"497667", "Breisach\ am\ Rhein",
"498565", "Dietersburg\-Baumgarten",
"497355", "Hochdorf\ Riss",
"492933", "Sundern\ Sauerland",
"492162", "Viersen",
"497392", "Laupheim",
"499920", "Bischofsmais",
"496293", "Schefflenz",
"4939825", "Wokuhl",
"498246", "Waal",
"499253", "Weissenstadt",
"492389", "Werne",
"496221", "Heidelberg",
"4939209", "Wanzleben",
"4969", "Frankfurt\ am\ Main",
"494838", "Tellingstedt",
"499974", "Traitsching",
"495167", "Walsrode\-Westenholz",
"496867", "Perl",
"499636", "Plössberg",
"495035", "Gross\ Munzel",
"4935028", "Krippen",
"494422", "Sande\ Kreis\ Friesl",
"496550", "Irrhausen",
"494664", "Neukirchen\ bei\ Niebüll",
"498469", "Freystadt\-Burggriesbach",
"496287", "Limbach\ Baden",
"495461", "Bramsche\ Hase",
"4934775", "Wippra",
"4939922", "Dambeck\ bei\ Röbel",
"492245", "Much",
"492409", "Stolberg\-Gressenich",
"492272", "Bedburg\ Erft",
"4934208", "Löbnitz\ bei\ Delitzsch",
"4933652", "Neuzelle",
"4939207", "Colbitz",
"492444", "Schleiden\-Gemünd",
"493661", "Greiz",
"494182", "Tostedt",
"496433", "Hadamar",
"4939263", "Unseburg",
"496684", "Hofbieber\-Schwarzbach",
"497066", "Bad\ Rappenau\-Bonfeld",
"495961", "Haselünne",
"496238", "Dirmstein",
"4939775", "Ahlbeck\ bei\ Torgelow",
"4934922", "Mühlanger",
"494267", "Lauenbrück",
"494922", "Borkum",
"493724", "Burgstädt",
"4936425", "Isserstedt",
"496505", "Kordel",
"4939002", "Oebisfelde",
"4939401", "Neuwegersleben",
"4939208", "Loitsche",
"4934207", "Zwochau",
"497174", "Mögglingen",
"492293", "Nümbrecht",
"495379", "Sassenburg\-Grussendorf",
"4939862", "Schmölln\ bei\ Prenzlau",
"495351", "Helmstedt",
"497569", "Isny\-Eisenbach",
"494821", "Itzehoe",
"4934263", "Hohburg",
"494721", "Cuxhaven",
"496162", "Reinheim\ Odenwald",
"495862", "Hitzacker\ Elbe",
"492944", "Rietberg\-Mastholte",
"497158", "Neuhausen\ auf\ den\ Fildern",
"499275", "Speichersdorf",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"4935823", "Ostritz",
"495282", "Schieder\-Schwalenberg",
"492528", "Ennigerloh\-Enniger",
"4939404", "Ausleben",
"4935324", "Crinitz",
"496566", "Körperich",
"499474", "Schmidmühlen",
"4933203", "Kleinmachnow",
"4935027", "Weesenstein",
"499803", "Colmberg",
"499242", "Gössweinstein",
"498033", "Oberaudorf",
"494177", "Drage\ Elbe",
"497465", "Emmingen\-Liptingen",
"499180", "Pyrbaum",
"497386", "Hayingen",
"4938331", "Rakow\ Vorpom",
"496245", "Biblis",
"496531", "Bernkastel\-Kues",
"4933743", "Blönsdorf",
"496444", "Bischoffen",
"497373", "Zwiefalten",
"492433", "Hückelhoven",
"497264", "Bad\ Rappenau",
"495563", "Kreiensen",
"499106", "Markt\ Erlbach",
"496409", "Biebertal",
"496272", "Hirschhorn\ Neckar",
"499724", "Stadtlauringen",
"499824", "Dietenhofen",
"497300", "Roggenburg",
"499420", "Feldkirchen\ Niederbayern",
"499165", "Sugenheim",
"494893", "Hohenaspe",
"498807", "Diessen\ am\ Ammersee",
"4935265", "Glaubitz",
"494793", "Hambergen",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"498707", "Adlkofen",
"494471", "Cloppenburg",
"495674", "Grebenstein",
"499502", "Frensdorf",
"498654", "Freilassing",
"4939748", "Viereck",
"495658", "Wehretal",
"4938334", "Grammendorf",
"498678", "Marktl",
"4936920", "Grossenlupnitz",
"499326", "Markt\ Einersheim",
"497031", "Böblingen",
"492867", "Heiden\ Kreis\ Borken",
"495936", "Twist",
"4939009", "Badel",
"496201", "Weinheim\ Bergstr",
"492683", "Asbach\ Westerwald",
"496452", "Battenberg\ Eder",
"4935022", "Bad\ Schandau",
"4934929", "Straach",
"4938294", "Neubukow",
"4935751", "Welzow",
"492676", "Ulmen",
"494382", "Wangels",
"496294", "Krautheim\ Jagst",
"4937294", "Grünhainichen",
"4933923", "Flecken\ Zechlin",
"492934", "Sundern\-Altenhellefeld",
"4936966", "Kaltennordheim",
"493973", "Pasewalk",
"498642", "Übersee",
"4934202", "Delitzsch",
"4937291", "Augustusburg",
"499571", "Lichtenfels\ Bayern",
"495957", "Lindern\ Oldenburg",
"494251", "Hoya",
"4935754", "Klettwitz",
"494402", "Rastede",
"4934927", "Globig\-Bleddin",
"4939928", "Möllenhagen",
"4939007", "Tangeln",
"495692", "Wolfhagen",
"495367", "Rühen",
"498043", "Jachenau",
"499232", "Wunsiedel",
"497577", "Veringenstadt",
"495655", "Wanfried",
"492429", "Hürtgenwald",
"496096", "Wiesen\ Unterfranken",
"4937431", "Mehltheuer\ Vogtland",
"496235", "Schifferstadt",
"492952", "Rüthen",
"496508", "Hetzerath\ Mosel",
"498302", "Görisried",
"496541", "Traben\-Trarbach",
"4934742", "Sylda",
"494663", "Süderlügum",
"4936785", "Gräfinau\-Angstedt",
"492751", "Bad\ Berleburg",
"495130", "Wedemark",
"496434", "Bad\ Camberg",
"492779", "Greifenstein\-Beilstein",
"492443", "Mechernich",
"495021", "Nienburg\ Weser",
"498029", "Kreuth\ bei\ Tegernsee",
"496599", "Weidenbach\ bei\ Gerolstein",
"492851", "Rees",
"492697", "Blankenheim\-Ahrhütte",
"4939426", "Hessen",
"4936200", "Elxleben\ bei\ Arnstadt",
"497192", "Murrhardt",
"492362", "Dorsten",
"494558", "Todesfelde",
"499278", "Weidenberg",
"492525", "Beckum\-Neubeckum",
"494169", "Sauensiek",
"499254", "Gefrees",
"498122", "Erding",
"493571", "Hoyerswerda",
"499492", "Parsberg",
"4937434", "Bobenneukirchen",
"495946", "Georgsdorf",
"497041", "Mühlacker",
"499973", "Furth\ im\ Wald",
"494230", "Verden\-Walle",
"497582", "Bad\ Buchau",
"498781", "Rottenburg\ an\ der\ Laaber",
"499657", "Waldthurn",
"499365", "Rimpar",
"499804", "Aurach",
"494735", "Butjadingen\-Stollhamm",
"498034", "Brannenburg",
"499704", "Euerdorf",
"496429", "Schweinsberg\ Hessen",
"494835", "Albersdorf\ Holstein",
"499126", "Eckental",
"499955", "Mamming",
"495446", "Rehden",
"497651", "Titisee\-Neustadt",
"499473", "Kallmünz",
"499749", "Oberbach\ Unterfranken",
"498727", "Falkenberg\ Niederbayern",
"4939742", "Brüssow\ bei\ Pasewalk",
"492248", "Hennef\-Uckerath",
"493723", "Hohenstein\-Ernstthal",
"496683", "Ehrenberg\ Rhön",
"492452", "Heinsberg\ Rheinland",
"492943", "Erwitte",
"496082", "Niederreifenberg",
"49760", "Oberried\ Breisgau",
"497426", "Gosheim",
"499306", "Kist",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"499522", "Eltmann",
"498261", "Mindelheim",
"496676", "Hohenroda\ Hessen",
"4934426", "Kayna",
"497173", "Heubach",
"492294", "Morsbach\ Sieg",
"4935693", "Lauschütz",
"498095", "Aying",
"494794", "Worpswede\-Ostersode",
"4939202", "Gross\ Ammensleben",
"496525", "Irrel",
"4933657", "Steinsdorf\ Brandenburg",
"498236", "Fischach",
"498052", "Aschau\ im\ Chiemgau",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"495072", "Neustadt\-Mandelsloh",
"494902", "Jemgum\-Ditzum",
"495686", "Schwarzenborn\ Knüll",
"4933361", "Joachimsthal",
"499085", "Alerheim",
"4938843", "Bennin",
"495457", "Hopsten\-Schale",
"4939927", "Nossentiner\ Hütte",
"4934928", "Seegrehna",
"494848", "Rantrum",
"4937344", "Crottendorf\ Sachsen",
"494748", "Stubben\ bei\ Bremerhaven",
"495673", "Immenhausen\ Hessen",
"495045", "Springe\-Bennigsen",
"499646", "Freihung",
"4939008", "Kunrau",
"492508", "Drensteinfurt",
"4938392", "Sassnitz",
"492541", "Coesfeld",
"493522", "Grossenhain\ Sachsen",
"4934653", "Rottleberode",
"4939929", "Jabel\ bei\ Waren",
"4937341", "Ehrenfriedersdorf",
"492235", "Erftstadt",
"493306", "Gransee",
"496697", "Willingshausen",
"497025", "Neuffen",
"499823", "Leutershausen",
"4935796", "Panschwitz\-Kuckau",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"497358", "Eberhardzell\-Füramoos",
"496362", "Alsenz",
"499723", "Röthlein",
"497374", "Uttenweiler",
"492434", "Wegberg",
"497263", "Waibstadt",
"496751", "Bad\ Sobernheim",
"495564", "Dassel",
"496443", "Ehringshausen\ Dill",
"498171", "Wolfratshausen",
"4933733", "Stülpe",
"492599", "Ascheberg\-Herbern",
"496851", "St\ Wendel",
"495151", "Hameln",
"4939362", "Grieben\ bei\ Tangerhütte",
"494342", "Preetz\ Kreis\ Plön",
"494463", "Wangerland",
"4933201", "Gross\ Glienicke",
"4936742", "Uhlstädt",
"492643", "Altenahr",
"498825", "Krün",
"4934776", "Rothenschirmbach",
"496634", "Gemünden\ Felda",
"498725", "Wurmannsquick",
"4934785", "Sandersleben",
"492324", "Hattingen\ Ruhr",
"494837", "Neuenkirchen\ Dithmarschen",
"499093", "Polsingen",
"497852", "Willstätt",
"494737", "Stadland\-Schwei",
"493946", "Quedlinburg",
"496868", "Mettlach\-Tünsdorf",
"495168", "Walsrode\-Stellichte",
"4934261", "Kühren\ bei\ Wurzen",
"498083", "Isen",
"497361", "Aalen",
"498551", "Freyung",
"495571", "Uslar",
"492191", "Remscheid",
"4935020", "Struppen",
"498682", "Laufen\ Salzach",
"4933204", "Beelitz\ Mark",
"495056", "Winsen\-Meissendorf",
"499367", "Unterpleichfeld",
"495232", "Lage\ Lippe",
"499655", "Tännesberg",
"498076", "Pfaffing",
"492826", "Kranenburg\ Niederrhein",
"497951", "Crailsheim",
"492104", "Mettmann",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"4935323", "Sonnewalde",
"497668", "Ihringen",
"496652", "Hünfeld",
"496695", "Jesberg",
"4936929", "Ruhla",
"4934325", "Mochau\-Lüttewitz",
"4933679", "Wendisch\ Rietz",
"4939826", "Blankensee\ bei\ Neustrelitz",
"497336", "Lonsee",
"492237", "Kerpen\ Rheinland\-Türnich",
"496581", "Saarburg",
"4933744", "Hohenseefeld",
"496053", "Wächtersbach",
"4934673", "Heldrungen",
"498258", "Sielenbach",
"4933741", "Niedergörsdorf",
"495278", "Höxter\-Ovenhausen",
"4936202", "Neudietendorf",
"498442", "Wolnzach",
"497081", "Bad\ Wildbad",
"494602", "Freienwill",
"498274", "Buttenwiesen",
"498363", "Pfronten",
"497553", "Salem\ Baden",
"495254", "Paderborn\-Schloss\ Neuhaus",
"4936927", "Unterellen",
"497834", "Wolfach",
"496339", "Grosssteinhausen",
"4933677", "Glienicke\ bei\ Beeskow",
"496527", "Oberweis",
"4936738", "Königsee",
"497734", "Gailingen",
"4938333", "Horst\ bei\ Grimmen",
"495455", "Tecklenburg\-Brochterbeck",
"499946", "Hohenwarth\ bei\ Kötzing",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"492303", "Unna",
"499087", "Marktoffingen",
"495492", "Steinfeld\ Oldenburg",
"497575", "Messkirch",
"4936695", "Söllmnitz",
"495657", "Meissner",
"498677", "Burghausen\ Salzach",
"495365", "Wolfsburg\-Neindorf",
"4939740", "Nechlin",
"495704", "Petershagen\-Friedewalde",
"4936737", "Drognitz",
"493686", "Eisfeld",
"495126", "Algermissen",
"496826", "Bexbach",
"4933678", "Storkow\ Mark",
"4936928", "Neuenhof\ Thüringen",
"496104", "Heusenstamm",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"496726", "Lorch\ Rheingau",
"497542", "Tettnang",
"497930", "Boxberg\ Baden",
"4935266", "Heyda\ bei\ Riesa",
"498741", "Vilsbiburg",
"498808", "Pähl",
"4935774", "Boxberg\ Sachsen",
"495849", "Waddeweitz",
"495955", "Esterwegen",
"498453", "Reichertshofen\ Oberbayern",
"499446", "Altmannstein",
"498708", "Weihmichl\-Unterneuhausen",
"495473", "Ostercappeln",
"498841", "Murnau\ am\ Staffelsee",
"493564", "Schwarze\ Pumpe",
"496042", "Büdingen\ Hessen",
"4935771", "Bad\ Muskau",
"492983", "Winterberg\-Siedlinghausen",
"4939325", "Vinzelberg",
"4936739", "Rottenbach",
"4936653", "Lehesten\ Thüringer\ Wald",
"494178", "Radbruch",
"496324", "Hassloch",
"497729", "Tennenbronn",
"495306", "Cremlingen",
"494561", "Neustadt\ in\ Holstein",
"497146", "Remseck\ am\ Neckar",
"496643", "Herbstein",
"495522", "Osterode\ am\ Harz",
"492634", "Rengsdorf",
"494154", "Trittau",
"499340", "Königheim\-Brehmen",
"499269", "Tettau\ Kreis\ Kronach",
"499072", "Lauingen\ Donau",
"494536", "Steinhorst\ Lauenburg",
"495085", "Burgdorf\-Ehlershausen",
"4934467", "Eckartsberga",
"496629", "Schenklengsfeld",
"496303", "Enkenbach\-Alsenborn",
"497743", "Ühlingen\-Birkendorf",
"499673", "Tiefenbach\ Oberpfalz",
"497843", "Renchen",
"492339", "Sprockhövel\-Hasslinghausen",
"497202", "Karlsbad",
"497451", "Horb\ am\ Neckar",
"495646", "Willebadessen",
"492527", "Lippetal\-Lippborg",
"4934362", "Mügeln\ bei\ Oschatz",
"495060", "Bodenburg",
"496483", "Selters\ Taunus",
"492652", "Mendig",
"494132", "Amelinghausen",
"494963", "Dörpen",
"497157", "Waldenbuch",
"492695", "Insul",
"4939776", "Hintersee",
"492581", "Warendorf",
"496237", "Maxdorf",
"495723", "Bad\ Nenndorf",
"4939264", "Kroppenstedt",
"497626", "Kandern",
"492053", "Velbert\-Neviges",
"494268", "Bötersen",
"495823", "Bienenbüttel",
"496123", "Eltville\ am\ Rhein",
"4939200", "Gommern",
"499151", "Hersbruck",
"494353", "Ascheffel",
"496476", "Mengerskirchen",
"499179", "Freystadt",
"4936426", "Ottendorf\ bei\ Stadtroda",
"499564", "Bad\ Rodach",
"497259", "Östringen\-Odenheim",
"497271", "Wörth\ am\ Rhein",
"494885", "Bergenhusen",
"498084", "Taufkirchen\ Vils",
"4935691", "Bärenklau\ NL",
"499094", "Tagmersheim",
"494206", "Stuhr\-Heiligenrode",
"492103", "Hilden",
"494557", "Blunk",
"497940", "Künzelsau",
"497532", "Meersburg",
"499277", "Warmensteinach",
"498731", "Dingolfing",
"499436", "Nittenau",
"496139", "Budenheim",
"495839", "Wittingen\-Ohrdorf",
"495661", "Melsungen",
"498669", "Traunreut",
"494622", "Taarstedt",
"494464", "Wittmund\-Carolinensiel",
"496256", "Lampertheim\-Hüttenfeld",
"496032", "Bad\ Nauheim",
"4936732", "Könitz",
"49471", "Bremerhaven",
"4939425", "Dingelstedt\ am\ Huy",
"49481", "Heide\ Holstein",
"4936208", "Ermstedt",
"494265", "Fintel",
"4935694", "Gosda\ bei\ Klinge",
"492323", "Herne",
"496507", "Neumagen\-Dhron",
"496633", "Homberg\ Ohm",
"497136", "Bad\ Friedrichshall",
"492644", "Linz\ am\ Rhein",
"493461", "Merseburg\ Saale",
"498273", "Nordendorf",
"498364", "Seeg",
"4938844", "Gülze",
"497554", "Heiligenberg\ Baden",
"495253", "Bad\ Driburg",
"492391", "Plettenberg",
"497161", "Göppingen",
"494546", "Mustin\ Lauenburg",
"492865", "Raesfeld",
"495368", "Parsau",
"4933731", "Trebbin",
"497578", "Wald\ Hohenz",
"499167", "Oberscheinfeld",
"49221", "Cologne",
"492304", "Schwerte",
"498705", "Altfraunhofen",
"4934651", "Rossla",
"497733", "Engen\ Hegau",
"498805", "Hohenpeissenberg",
"495636", "Lichtenfels\-Goddelsheim",
"4937343", "Jöhstadt",
"497833", "Hornberg\ Schwarzwaldbahn",
"499461", "Roding",
"4934654", "Stolberg\ Harz",
"498766", "Gammelsdorf",
"4934462", "Laucha\ Unstrut",
"494142", "Steinkirchen\ Kreis\ Stade",
"4936965", "Stadtlengsfeld",
"492484", "Mechernich\-Eiserfey",
"496247", "Worms\-Pfeddersheim",
"4933734", "Felgentreu",
"496054", "Birstein",
"494175", "Egestorf\ Nordheide",
"497467", "Neuhausen\ ob\ Eck",
"4933363", "Altenhof\ Kreis\ Barnim",
"4938841", "Neuhaus\ Elbe",
"496078", "Gross\-Umstadt",
"494332", "Hamdorf\ bei\ Rendsburg",
"496698", "Schrecksbach",
"4939061", "Weferlingen",
"497357", "Attenweiler",
"499961", "Mitterfels",
"4935795", "Königsbrück",
"497665", "March\ Breisgau",
"492984", "Hallenberg",
"493563", "Spremberg",
"492256", "Mechernich\-Satzvey",
"492507", "Havixbeck",
"492633", "Brohl\-Lützing",
"499351", "Gemünden\ am\ Main",
"494153", "Lauenburg\ Elbe",
"497222", "Rastatt",
"4933924", "Rägelin",
"497967", "Jagstzell",
"496644", "Grebenhain",
"4937293", "Eppendorf\ Sachsen",
"499762", "Saal\ an\ der\ Saale",
"496323", "Edenkoben",
"4938293", "Kühlungsborn\ Ostseebad",
"4935753", "Grossräschen",
"494847", "Oster\-Ohrstedt",
"498292", "Dinkelscherben",
"495275", "Höxter\-Ottbergen",
"494747", "Beverstedt",
"499282", "Naila",
"4933921", "Zechlinerhütte",
"498454", "Karlshuld",
"495474", "Stemwede\-Dielingen",
"494671", "Bredstedt",
"4939000", "Beetzendorf",
"496103", "Langen\ Hessen",
"495803", "Rosche",
"4934920", "Kropstädt",
"495242", "Rheda\-Wiedenbrück",
"495703", "Hille",
"495458", "Hopsten",
"493762", "Crimmitschau",
"494964", "Rhede\ Ems",
"4933672", "Pfaffendorfb\ Beeskow",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"4936922", "Gerstungen",
"496484", "Beselich",
"493379", "Mahlow",
"4934425", "Droyssig",
"496285", "Walldürn\-Altheim",
"498728", "Geratskirchen",
"497346", "Illerkirchberg",
"499563", "Rödental",
"4936207", "Plaue\ Thüringen",
"494354", "Fleckeby",
"492054", "Essen\-Kettwig",
"492247", "Neunkirchen\-Seelscheid",
"496706", "Wallhausen\ Nahe",
"496124", "Bad\ Schwalbach",
"495824", "Bad\ Bodenteich",
"493961", "Altentreptow",
"496806", "Heusweiler",
"495724", "Obernkirchen",
"495165", "Rethem\ Aller",
"496865", "Mettlach\-Orscholz",
"49209", "Gelsenkirchen",
"496765", "Gemünden\ Hunsrück",
"498432", "Burgheim",
"496391", "Dahn",
"495037", "Bad\ Rehburg",
"4936209", "Klettbach",
"497440", "Bad\ Rippoldsau",
"497844", "Rheinau",
"499674", "Schönsee",
"494756", "Odisheim",
"4937433", "Gutenfürst",
"495502", "Dransfeld",
"494856", "Kronprinzenkoog",
"497744", "Stühlingen",
"496349", "Billigheim\-Ingenheim",
"495326", "Langelsheim",
"499936", "Wallerfing",
"497709", "Wutach",
"499658", "Georgenberg",
"496304", "Wolfstein\ Pfalz",
"49621", "Mannheim",
"499943", "Lam\ Oberpfalz",
"497071", "Tübingen",
"492306", "Lünen",
"495976", "Salzbergen",
"4939348", "Klitsche",
"498284", "Ziemetshausen",
"4934494", "Ehrenhain",
"4934347", "Oelzschau\ bei\ Borna",
"4938307", "Poseritz",
"498638", "Waldkraiburg",
"493541", "Calau",
"495634", "Waldeck\-Sachsenhausen",
"492522", "Oelde",
"4933841", "Belzig",
"4937363", "Zöblitz",
"494431", "Wildeshausen",
"499294", "Regnitzlosau",
"494544", "Berkenthin",
"499077", "Bachhagel",
"497556", "Uhldingen\-Mühlhofen",
"498366", "Oy\-Mittelberg",
"4935384", "Steinsdorf\ bei\ Jessen",
"499495", "Breitenbrunn\ Oberpfalz",
"494509", "Gross\ Grönau",
"499201", "Gesees",
"499452", "Langquaid",
"492804", "Xanten\-Marienbaum",
"494928", "Ihlow\-Riepe",
"496056", "Bad\ Soden\-Salmünster",
"4934298", "Taucha\ bei\ Leipzig",
"496232", "Speyer",
"4939726", "Ducherow",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"497333", "Laichingen",
"492955", "Büren\-Wewelsburg",
"492473", "Simmerath",
"492992", "Marsberg",
"498764", "Mauern\ Kreis\ Freising",
"496571", "Wittlich",
"496559", "Leidenborn",
"498460", "Berching\-Holnstein",
"4933844", "Brück\ Brandenburg",
"497152", "Leonberg\ Württemberg",
"4939456", "Altenbrak",
"494223", "Ganderkesee\-Bookholzberg",
"4938731", "Lübz",
"4936945", "Henneberg",
"4934491", "Schmölln\ Thüringen",
"492486", "Nettersheim",
"492657", "Uersfeld",
"4938309", "Trent",
"49841", "Ingolstadt\ Donau",
"497195", "Winnenden",
"494137", "Barendorf",
"492365", "Marl",
"495768", "Petershagen\-Heimsen",
"495053", "Fassberg\-Müden",
"492823", "Goch",
"498073", "Gars\ am\ Inn",
"494950", "Holtland",
"4933085", "Seilershof",
"492723", "Kirchhundem",
"4933230", "Börnicke\ Kreis\ Havelland",
"499434", "Bodenwöhr",
"494405", "Edewecht",
"4935724", "Lohsa",
"494249", "Bassum\-Nordwohlde",
"4935454", "Uckro",
"498086", "Buchbach\ Oberbayern",
"49201", "Essen",
"49431", "Kiel",
"495695", "Twistetal",
"494204", "Thedinghausen",
"499235", "Thierstein",
"493943", "Wernigerode",
"495652", "Bad\ Sooden\-Allendorf",
"4936842", "Oberhof\ Thüringen",
"496455", "Frankenau\ Hessen",
"495339", "Gielde",
"492646", "Königsfeld\ Eifel",
"499929", "Ruhmannsfelden",
"495527", "Duderstadt",
"498331", "Memmingen",
"4935052", "Kipsdorf\ Kurort",
"4935451", "Dahme\ Brandenburg",
"497134", "Weinsberg",
"494466", "Wittmund\-Ardorf",
"496047", "Altenstadt\ Hessen",
"496254", "Lautertal\ Odenwald",
"494385", "Hohenfelde\ bei\ Kiel",
"4939386", "Seehausen\ Altmark",
"496849", "Kirkel",
"495149", "Wienhausen",
"498141", "Fürstenfeldbruck",
"496473", "Leun",
"4933433", "Buckow\ Märkische\ Schweiz",
"494356", "Gross\ Wittensee",
"493525", "Riesa",
"497344", "Blaubeuren",
"496400", "Mücke",
"496804", "Mandelbachtal",
"4939959", "Dargun",
"495726", "Wiedensahl",
"496704", "Langenlonsheim",
"492232", "Brühl\ Rheinland",
"497623", "Rheinfelden\ Baden",
"492056", "Heiligenhaus",
"499429", "Rain\ Niederbayern",
"495826", "Suderburg",
"497309", "Weissenhorn",
"496126", "Idstein",
"4935931", "Königswartha",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"497022", "Nürtingen",
"496486", "Katzenelnbogen",
"494966", "Neubörger",
"496657", "Hofbieber",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"4939885", "Jakobshagen",
"495191", "Soltau",
"492571", "Greven\ Westfalen",
"496522", "Mettendorf",
"494854", "Friedrichskoog",
"498092", "Grafing\ bei\ München",
"497746", "Wutöschingen",
"498328", "Balderschwang",
"494754", "Bülkau",
"499676", "Winklarn",
"498055", "Halfing",
"495643", "Borgentreich",
"494778", "Wingst",
"4938797", "Karstädt\ Kreis\ Prignitz",
"499082", "Oettingen\ in\ Bayern",
"497129", "Lichtenstein\ Württemberg",
"4938226", "Dierhagen\ Ostseebad",
"496306", "Trippstadt",
"4936606", "Kraftsdorf",
"495324", "Vienenburg",
"4935934", "Grossdubrau",
"4939957", "Gielow",
"493362", "Erkner",
"499683", "Friedenfels",
"495042", "Bad\ Münder\ am\ Deister",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"494533", "Reinfeld\ Holstein",
"494607", "Janneby",
"4939298", "Barby\ Elbe",
"497143", "Besigheim",
"4934297", "Liebertwolkwitz",
"496646", "Grebenau",
"492455", "Waldfeucht",
"49751", "Ravensburg",
"492973", "Eslohe\ Sauerland",
"495303", "Wendeburg",
"498621", "Trostberg",
"496085", "Waldsolms",
"494347", "Flintbek",
"494188", "Welle\ Nordheide",
"4939349", "Parey\ Elbe",
"499525", "Königsberg\ in\ Bayern",
"492254", "Weilerswist",
"497585", "Ostrach",
"4934348", "Frohburg",
"4936703", "Gräfenthal",
"4938308", "Göhren\ Rügen",
"499779", "Nordheim\ von\ der\ Rhön",
"498687", "Taching\-Tengling",
"4936330", "Grossberndten",
"4939347", "Kade",
"499443", "Abensberg",
"498456", "Lenting",
"499851", "Dinkelsbühl",
"495476", "Ostercappeln\-Venne",
"494931", "Norden",
"493683", "Schmalkalden",
"495123", "Schellerten",
"496723", "Oestrich\-Winkel",
"495237", "Augustdorf",
"4935874", "Bernstadt\ an\ der\ Eigen",
"494732", "Stadland\-Rodenkirchen",
"495483", "Lienen",
"494832", "Meldorf",
"4934299", "Gaschwitz",
"499952", "Eichendorf",
"498131", "Dachau",
"4933333", "Tantow",
"492770", "Eschenburg",
"495139", "Burgwedel",
"494425", "Wangerland\-Hooksiel",
"497334", "Deggingen",
"4939952", "Grammentin",
"492474", "Nideggen\-Schmidt",
"498020", "Weyarn",
"4933764", "Mittenwalde\ Mark",
"492803", "Wesel\-Büderich",
"492242", "Hennef\ Sieg",
"492275", "Kerpen\-Buir",
"493867", "Lübstorf",
"494224", "Gross\ Ippener",
"4933834", "Pritzerbe",
"4938792", "Lenzen\ \(Elbe\)",
"499528", "Donnersdorf",
"494185", "Marxen\ Auetal",
"497736", "Tengen",
"499293", "Berg\ Oberfranken",
"495507", "Ebergötzen",
"495633", "Diemelsee",
"497836", "Schiltach",
"4933831", "Weseram",
"498283", "Neuburg\ an\ der\ Kammel",
"499944", "Miltach",
"4936848", "Wernshausen",
"498276", "Baar\ Schwaben",
"493433", "Borna\ Stadt",
"495032", "Neustadt\ am\ Rübenberge",
"496661", "Schlüchtern",
"4935058", "Pretzschendorf",
"494543", "Nusse",
"496636", "Romrod",
"498105", "Gilching",
"497133", "Lauffen\ am\ Neckar",
"4934244", "Mockrehna",
"4936624", "Teichwolframsdorf",
"4938204", "Broderstorf",
"493528", "Radeberg",
"497962", "Fichtenau",
"4933974", "Dessow",
"492502", "Nottuln",
"4937204", "Lichtenstein\ Sachsen",
"497227", "Lichtenau\ Baden",
"4936875", "Straufhain\-Streufdorf",
"499867", "Geslau",
"497352", "Ochsenhausen",
"499221", "Kulmbach",
"498562", "Triftern",
"494529", "Süsel\-Bujendorf",
"4939342", "Gladau",
"492165", "Jüchen",
"497395", "Ehingen\-Dächingen",
"494337", "Jevenstedt",
"4939855", "Parmen\-Weggun",
"4939391", "Lückstedt",
"497761", "Bad\ Säckingen",
"4936762", "Steinach\ Thüringen",
"496253", "Fürth\ Odenwald",
"4939394", "Hohenberg\-Krusemark",
"498325", "Oberstaufen\-Thalkirchdorf",
"493998", "Demmin",
"499433", "Nabburg",
"4935473", "Neu\ Lübbenau",
"494875", "Stafstedt",
"492724", "Finnentrop\-Serkenrode",
"494941", "Aurich",
"495247", "Harsewinkel",
"495054", "Bergen\-Sülze",
"498074", "Schnaitsee",
"492824", "Kalkar",
"494775", "Grossenwörden",
"494742", "Dorum",
"493944", "Blankenburg\ Harz",
"494842", "Nordstrand",
"4934292", "Brandis\ bei\ Wurzen",
"494203", "Weyhe\ bei\ Bremen",
"493909", "Klötze\ Altmark",
"4933971", "Kyritz\ Brandenburg",
"4939605", "Gross\ Nemerow",
"4934241", "Jesewitz",
"498166", "Allershausen\ Oberbayern",
"4936621", "Elsterberg\ bei\ Plauen",
"4938201", "Gelbensande",
"499287", "Selb",
"495323", "Clausthal\-Zellerfeld",
"4933055", "Kremmen",
"499933", "Wallersdorf",
"495609", "Ahnatal",
"499162", "Scheinfeld",
"4937463", "Bergen\ Vogtland",
"494753", "Balje",
"495644", "Willebadessen\-Peckelsheim",
"493531", "Finsterwalde",
"494408", "Hude\ Oldenburg",
"494853", "Sankt\ Michaelisdonn",
"494441", "Vechta",
"4939292", "Biederitz",
"494534", "Steinburg\ Kreis\ Storman",
"492661", "Bad\ Marienberg\ Westerwald",
"494499", "Barssel",
"499505", "Litzendorf",
"4939241", "Leitzkau",
"499238", "Röslau",
"4934605", "Gröbers",
"496703", "Wöllstein\ Rheinhessen",
"497462", "Immendingen",
"497624", "Grenzach\-Wyhlen",
"496458", "Rosenthal\ Hessen",
"496803", "Mandelbachtal\-Ommersheim",
"495103", "Wennigsen\ Deister",
"4939244", "Steutz",
"496242", "Osthofen",
"4933093", "Fürstenberg\ Havel",
"499566", "Meeder",
"492839", "Straelen\-Herongen",
"497343", "Buch\ bei\ Illertissen",
"4936376", "Straussfurt",
"492590", "Dülmen\-Buldern",
"496474", "Villmar\-Aumenau",
"492739", "Wilnsdorf",
"4938302", "Sagard",
"4934342", "Neukieritzsch",
"496275", "Rothenberg\ Odenwald",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"497329", "Steinheim\ am\ Albuch",
"498635", "Pleiskirchen",
"495806", "Barum\ bei\ Bad\ Bevensen",
"496106", "Rodgau",
"499409", "Pielenhofen",
"499272", "Fichtelberg",
"496724", "Stromberg\ Hunsrück",
"495706", "Porta\ Westfalica",
"4939034", "Fleetmark",
"496824", "Ottweiler",
"496420", "Lahntal",
"494552", "Leezen",
"4936043", "Kirchheilingen",
"499444", "Siegenburg",
"4935246", "Ziegenhain\ Sachsen",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"494239", "Dörverden\-Westen",
"4936847", "Steinbach\-Hallenberg",
"499531", "Ebern",
"495484", "Lienen\-Kattenvenne",
"4935057", "Hermsdorf\ Erzgebirge",
"493933", "Genthin",
"494681", "Wyk\ auf\ Föhr",
"499498", "Laaber",
"499245", "Obertrubach",
"495304", "Meine",
"492974", "Schmallenberg\-Fredeburg",
"49521", "Bielefeld",
"496326", "Deidesheim",
"494925", "Hinte",
"494156", "Talkau",
"498341", "Kaufbeuren",
"492636", "Burgbrohl",
"497144", "Marbach\ am\ Neckar",
"4935895", "Klitten",
"4935603", "Burg\ Spreewald",
"492958", "Büren\-Harth",
"4936849", "Kleinschmalkalden",
"496502", "Schweich",
"494627", "Dörpstedt",
"492253", "Bad\ Münstereifel",
"492368", "Oer\-Erkenschwick",
"495765", "Raddestorf",
"4939031", "Dähre",
"496165", "Breuberg",
"495865", "Gusborn",
"496048", "Büdingen\-Eckartshausen",
"496436", "Dornburg\ Hessen",
"4933434", "Herzfelde\ bei\ Strausberg",
"496094", "Weibersbrunn",
"494172", "Salzhausen",
"495528", "Gieboldehausen",
"492351", "Lüdenscheid",
"495909", "Wettrup",
"499633", "Mitterteich",
"492379", "Menden\-Asbeck",
"4935933", "Neschwitz",
"495293", "Paderborn\-Dahl",
"492862", "Südlohn",
"495944", "Hoogstede",
"492620", "Neuhäusel\ Westerwald",
"492762", "Wenden\ Südsauerland",
"4933238", "Senzke",
"49212", "Solingen",
"4933086", "Grieben\ Kreis\ Oberhavel",
"492961", "Brilon",
"498702", "Wörth\ an\ der\ Isar",
"4933702", "Wünsdorf",
"498802", "Huglfing",
"498243", "Fuchstal",
"499256", "Stammbach",
"492674", "Bad\ Bertrich",
"496296", "Ahorn\ Baden",
"494625", "Jübek",
"496035", "Reichelsheim\ Wetterau",
"4936946", "Erbenhausen\ Thüringen",
"496167", "Modautal",
"4939455", "Schierke",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"495767", "Warmsen",
"494927", "Krummhörn\-Loquard",
"4936701", "Lichte",
"494262", "Visselhövede",
"495221", "Herford",
"497903", "Mainhardt",
"492563", "Stadtlohn",
"494882", "Lunden",
"495433", "Badbergen",
"499078", "Mertingen",
"493984", "Prenzlau",
"4936704", "Steinheid",
"4936337", "Schiedungen",
"498503", "Neuhaus\ am\ Inn",
"498637", "Lohkirchen",
"496461", "Biedenkopf",
"4935873", "Herrnhut",
"496620", "Philippsthal\ Werra",
"495162", "Fallingbostel",
"497403", "Dunningen",
"496762", "Kastellaun",
"494121", "Elmshorn",
"499323", "Iphofen",
"498435", "Ehekirchen",
"4937364", "Reitzenhain\ Erzgebirge",
"495933", "Lathen",
"4934493", "Gössnitz\ Thüringen",
"496351", "Eisenberg\ Pfalz",
"4938300", "Insel\ Hiddensee",
"4936338", "Bleicherode",
"497774", "Eigeltingen",
"4938733", "Karbow\-Vietlübbe",
"492330", "Herdecke",
"499644", "Pressath",
"498234", "Bobingen",
"495505", "Hardegsen",
"494796", "Teufelsmoor",
"494481", "Hatten\-Sandkrug",
"4935383", "Elster\ Elbe",
"495684", "Frielendorf",
"495238", "Nieheim\-Himmighausen",
"493765", "Reichenbach\ Vogtland",
"499103", "Cadolzburg",
"493865", "Holthusen",
"494348", "Schönkirchen",
"493391", "Neuruppin",
"494187", "Holm\-Seppensen",
"499170", "Schwanstetten",
"497376", "Langenenslingen",
"492436", "Wegberg\-Rödgen",
"496282", "Walldürn",
"4939972", "Walkendorf",
"494394", "Bokhorst",
"495069", "Nordstemmen",
"4937361", "Neuhausen\ Erzgebirge",
"4933843", "Niemegk",
"498061", "Bad\ Aibling",
"493304", "Velten",
"497383", "Münsingen\-Buttenhausen",
"4935723", "Bernsdorf\ OL",
"498295", "Altenmünster\ Schwaben",
"495272", "Brakel\ Westfalen",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"497939", "Schrozberg\-Spielbach",
"498036", "Stephanskirchen\ Simssee",
"498252", "Schrobenhausen",
"4933237", "Paulinenaue",
"499285", "Kirchenlamitz",
"494641", "Süderbrarup",
"496563", "Kyllburg",
"495444", "Wagenfeld",
"495840", "Schnackenburg",
"494608", "Handewitt",
"495531", "Holzminden",
"492461", "Jülich",
"498327", "Rettenberg",
"493644", "Apolda",
"494777", "Cadenberge",
"4936605", "Bad\ Köstritz",
"4938225", "Trinwillershagen",
"495245", "Herzebrock\-Clarholz",
"494877", "Hennstedt\ bei\ Itzehoe",
"499484", "Brennberg",
"4935453", "Drahnsdorf",
"494335", "Hohn\ bei\ Rendsburg",
"497720", "Schwenningen\ am\ Neckar",
"496658", "Poppenhausen\ Wasserkuppe",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"497424", "Spaichingen",
"49921", "Bayreuth",
"496674", "Friedewald\ Hessen",
"4939886", "Milmersdorf",
"492296", "Reichshof\-Brüchermühle",
"4934385", "Mutzschen",
"4939832", "Wesenberg",
"499260", "Wilhelmsthal\ Oberfranken",
"499349", "Werbach\-Wenkheim",
"497225", "Gaggenau",
"4933239", "Gross\ Behnitz",
"494193", "Henstedt\-Ulzburg",
"499391", "Marktheidenfeld",
"499865", "Adelshofen\ Mittelfranken",
"497063", "Bad\ Wimpfen",
"497184", "Kaisersbach",
"499765", "Trappstadt",
"498381", "Lindenberg\ im\ Allgäu",
"4938464", "Bernitt",
"493695", "Bad\ Salzungen",
"4934978", "Radegast\ Kreis\ Köthen",
"495943", "Emlichheim",
"4937464", "Schöneck\ Vogtland",
"498445", "Gerolsbach",
"499976", "Rötz",
"4939977", "Jördenstorf",
"4939606", "Glienke",
"4933981", "Putlitz",
"494605", "Medelby",
"495294", "Hövelhof\-Espeln",
"499634", "Wiesau",
"492269", "Kierspe\-Rönsahl",
"499288", "Bad\ Steben",
"498057", "Aschau\-Sachrang",
"495201", "Halle\ Westfalen",
"495452", "Mettingen\ Westfalen",
"495248", "Langenberg\ Kreis\ Gütersloh",
"495495", "Vörden\ Kreis\ Vechta",
"493581", "Görlitz",
"4933397", "Wandlitz",
"496655", "Neuhof\ Kreis\ Fulda",
"494338", "Alt\ Duvenstedt",
"496692", "Neustadt\ Hessen",
"4933094", "Löwenberg",
"4939243", "Nedlitz\ bei\ Zerbst",
"492446", "Heimbach\ Eifel",
"4939856", "Beenz\ bei\ Prenzlau",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"494666", "Ladelund",
"497228", "Forbach",
"496093", "Laufach",
"4938461", "Bützow",
"499868", "Schillingsfürst",
"497755", "Weilheim\ Kreis\ Waldshut",
"494289", "Kirchtimke",
"497949", "Pfedelbach\-Untersteinbach",
"498046", "Bad\ Heilbrunn",
"498591", "Obernzell",
"496021", "Aschaffenburg",
"4939033", "Wallstawe",
"494631", "Glücksburg\ Ostsee",
"492151", "Krefeld",
"497904", "Ilshofen",
"496130", "Schwabenheim\ an\ der\ Selz",
"492564", "Vreden",
"495434", "Essen\ Oldenburg",
"493634", "Sömmerda",
"495541", "Hann\.\ Münden",
"498549", "Vilshofen\-Pleinting",
"497250", "Kraichtal",
"495508", "Gleichen\-Rittmarshausen",
"498685", "Kirchanschöring",
"497587", "Hosskirch",
"495235", "Blomberg\ Lippe",
"499652", "Waidhaus",
"498504", "Tittling",
"4936840", "Trusetal",
"493976", "Torgelow\ bei\ Ueckermünde",
"4935601", "Peitz",
"4935604", "Krieschow",
"493868", "Rastow",
"496087", "Waldems",
"4933708", "Rangsdorf",
"499339", "Ippesheim",
"492045", "Bottrop\-Kirchhellen",
"492673", "Ellenz\-Poltersdorf",
"499527", "Knetzgau",
"494769", "Bremervörde\-Iselersheim",
"498822", "Oberammergau",
"4936041", "Bad\ Tennstedt",
"498722", "Gangkofen",
"49861", "Traunstein",
"494372", "Westfehmarn",
"492686", "Weyerbusch",
"4933232", "Brieselang",
"497266", "Kirchardt",
"499149", "Weissenburg\-Suffersheim",
"4933763", "Bestensee",
"496446", "Hohenahr",
"498421", "Eichstätt\ Bayern",
"492367", "Henrichenburg",
"495429", "Melle\-Wellingholzhausen",
"494135", "Kirchgellersen",
"499826", "Weidenbach\ Mittelfranken",
"492655", "Weibern",
"4933334", "Greiffenberg",
"4939485", "Gernrode\ Harz",
"499104", "Emskirchen",
"499726", "Euerbach",
"492692", "Kelberg",
"497384", "Schelklingen\-Hütten",
"496789", "Heimbach\ Nahe",
"493629", "Stadtilm",
"4933833", "Wollin\ bei\ Brandenburg",
"493303", "Birkenwerder",
"492957", "Wünnenberg\-Haaren",
"499191", "Forchheim\ Oberfranken",
"494393", "Boostedt",
"495676", "Liebenau\ Hessen",
"497449", "Baiersbronn\-Obertal",
"499075", "Glött",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"498656", "Anger",
"496340", "Wörth\-Schaidt",
"496269", "Gundelsheim\ Württemberg",
"497773", "Bodman\-Ludwigshafen",
"497404", "Epfendorf",
"499324", "Dettelbach",
"495934", "Haren\-Rütenbrock",
"495082", "Langlingen",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"495683", "Wabern\ Hessen",
"4933331", "Casekow",
"498233", "Kissing",
"4935245", "Burkhardswalde\-Munzig",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"496045", "Gedern",
"496673", "Haunetal",
"497176", "Spraitbach",
"4933398", "Werneuchen",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"499303", "Eibelstadt",
"4937203", "Gersdorf\ bei\ Chemnitz",
"494101", "Pinneberg",
"497423", "Oberndorf\ am\ Neckar",
"494148", "Drochtersen\-Assel",
"4934243", "Bad\ Düben",
"4938203", "Bad\ Doberan",
"4936623", "Berga\ Elster",
"496457", "Burgwald\ Eder",
"493726", "Flöha",
"497183", "Rudersberg\ Württemberg",
"494194", "Sievershütten",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"4935471", "Birkenhainchen",
"4936332", "Ellrich",
"495525", "Walkenried",
"4936375", "Kindelbrück",
"495443", "Lemförde",
"4939978", "Gross\ Roge",
"496151", "Darmstadt",
"4934977", "Quellendorf",
"495851", "Dahlenburg",
"4935474", "Schönwalde\ bei\ Lübben",
"498771", "Ergoldsbach",
"495751", "Rinteln",
"496564", "Neuerburg\ Eifel",
"497572", "Mengen\ Württemberg",
"495362", "Wolfsburg\-Fallersleben",
"4934606", "Teicha\ Sachsen\-Anhalt",
"499123", "Lauf\ an\ der\ Pegnitz",
"494321", "Neumünster",
"4939393", "Werben\ Elbe",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"497545", "Immenstaad\ am\ Bodensee",
"494407", "Wardenburg",
"495952", "Sögel",
"493643", "Weimar\ Thüringen",
"497231", "Pforzheim",
"495654", "Herleshausen",
"494743", "Langen\ bei\ Bremerhaven",
"494202", "Achim\ bei\ Bremen",
"494479", "Molbergen\-Peheim",
"494451", "Varel\ Jadebusen",
"494843", "Viöl",
"4939206", "Eichenbarleben",
"496381", "Kusel",
"49208", "Oberhausen\ Rheinland",
"495707", "Petershagen\ Weser",
"496107", "Kelsterbach",
"495807", "Altenmedingen",
"498563", "Bad\ Birnbach\ Rottal",
"492935", "Sundern\-Hachen",
"497353", "Schwendi",
"499728", "Wülfershausen\ Unterfranken",
"4935792", "Ossling",
"499828", "Rügland",
"496295", "Rosenberg\ Baden",
"496252", "Heppenheim\ Bergstrasse",
"496401", "Grünberg\ Hessen",
"496036", "Wölfersheim",
"494626", "Treia",
"497268", "Bad\ Rappenau\-Obergimpern",
"497132", "Neckarsulm",
"492637", "Weissenthurm",
"497963", "Adelmannsfelden",
"496327", "Neustadt\-Lachen",
"495190", "Soltau\-Emmingen",
"499454", "Aufhausen\ Oberpfalz",
"4935201", "Langebrück",
"495033", "Wunstorf\-Grossenheidorn",
"494542", "Mölln\ Lauenburg",
"499292", "Konradsreuth",
"496061", "Michelstadt",
"499255", "Marktleugast",
"495632", "Willingen\ Upland",
"492524", "Ennigerloh",
"4934327", "Waldheim\ Sachsen",
"498282", "Krumbach\ Schwaben",
"4939328", "Rochau",
"495371", "Gifhorn",
"4933675", "Tauche",
"494146", "Stade\-Bützfleth",
"497561", "Leutkirch\ im\ Allgäu",
"498379", "Waltenhofen\-Oberdorf",
"492948", "Lippstadt\-Rebbeke",
"4936925", "Marksuhl",
"497154", "Kornwestheim",
"4933632", "Hangelsberg",
"498862", "Steingaden\ Oberbayern",
"4934422", "Osterfeld",
"496435", "Wallmerod",
"494829", "Wewelsfleth",
"498762", "Wartenberg\ Oberbayern",
"492994", "Marsberg\-Westheim",
"499567", "Sesslach\-Gemünda",
"4939746", "Krackow",
"4935204", "Wilsdruff",
"496234", "Mutterstadt",
"492243", "Eitorf",
"492802", "Alpen",
"492295", "Ruppichteroth",
"492448", "Hellenthal\-Rescheid",
"492401", "Baesweiler",
"4936735", "Probstzella",
"492252", "Zülpich",
"4934901", "Rosslau\ Elbe",
"4939329", "Möringen",
"4939422", "Badersleben",
"494336", "Owschlag",
"498461", "Beilngries",
"492327", "Bochum\-Wattenscheid",
"4938481", "Witzin",
"499766", "Grosswenkheim",
"4939752", "Blumenhagen\ bei\ Strasburg",
"4933964", "Fretzdorf",
"494668", "Klanxbüll",
"497226", "Bühl\-Sand",
"496637", "Feldatal",
"496503", "Hermeskeil",
"4934746", "Giersleben",
"498167", "Zolling",
"499286", "Oberkotzau",
"499954", "Simbach\ Niederbayern",
"4939820", "Triepkendorf",
"494834", "Büsum",
"498296", "Villenbach",
"499978", "Schönthal\ Oberpfalz",
"4938484", "Ventschow",
"498035", "Raubling",
"494734", "Stadland\-Seefeld",
"499805", "Burgoberbach",
"495246", "Verl",
"499364", "Zellingen",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"493831", "Stralsund",
"494553", "Geschendorf",
"493731", "Freiberg\ Sachsen",
"4934904", "Oranienbaum",
"492381", "Hamm\ Westfalen",
"4939327", "Klietz",
"496229", "Neckarsteinach",
"4934328", "Hartha\ bei\ Döbeln",
"492435", "Erkelenz\-Lövenich",
"4934465", "Bad\ Bibra",
"495565", "Einbeck\-Wenzen",
"497375", "Obermarchtal",
"497024", "Wendlingen\ am\ Neckar",
"498330", "Legau",
"493866", "Cambs",
"4936962", "Vacha",
"492688", "Kroppach",
"4937603", "Wildenfels",
"497463", "Mühlheim\ an\ der\ Donau",
"492234", "Frechen",
"496243", "Monsheim",
"496802", "Völklingen\-Lauterbach",
"495102", "Laatzen",
"4938351", "Mesekenhagen",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"494951", "Weener",
"495257", "Hövelhof",
"495044", "Springe\-Eldagsen",
"4938354", "Wusterhusen",
"493364", "Eisenhüttenstadt",
"499831", "Gunzenhausen",
"4938853", "Drönnewitz\ bei\ Hagenow",
"499932", "Osterhofen",
"495322", "Bad\ Harzburg",
"4934206", "Rötha",
"499084", "Bissingen\ Schwaben",
"494361", "Oldenburg\ in\ Holstein",
"499163", "Dachsbach",
"495506", "Adelebsen",
"497837", "Oberharmersbach",
"494752", "Neuhaus\ Oste",
"494795", "Garlstedt",
"498094", "Steinhöring",
"494852", "Brunsbüttel",
"496524", "Rodershausen",
"498179", "Eurasburg\ an\ der\ Loisach",
"498151", "Starnberg",
"494346", "Gettorf",
"492591", "Lüdinghausen",
"495159", "Coppenbrügge\-Bisperode",
"4939322", "Tangermünde",
"496871", "Wadern",
"495171", "Peine",
"497354", "Erolzheim",
"498564", "Johanniskirchen",
"496771", "St\ Goarshausen",
"4937381", "Penig",
"492685", "Flammersfeld",
"492504", "Telgte",
"497964", "Stödtlen",
"4936644", "Hirschberg\ Saale",
"4934224", "Belgern\ Sachsen",
"496647", "Herbstein\-Stockhausen",
"4934221", "Schildau\ Gneisenaustadt",
"493677", "Ilmenau\ Thüringen",
"4936692", "Bürgel",
"4937384", "Wechselburg",
"494844", "Pellworm",
"495653", "Sontra",
"494744", "Loxstedt",
"498045", "Lenggries\-Fall",
"492921", "Soest",
"498072", "Haag\ in\ Oberbayern",
"492822", "Emmerich",
"493841", "Wismar",
"495052", "Hermannsburg",
"495236", "Blomberg\-Grossenmarpe",
"493741", "Plauen",
"492722", "Attendorn",
"4933638", "Rüdersdorf\ bei\ Berlin",
"4935363", "Fermerswalde",
"498457", "Vohburg\ an\ der\ Donau",
"49261", "Koblenz\ am\ Rhein",
"4939427", "Ströbeck",
"498686", "Petting",
"4936969", "Merkers",
"492445", "Schleiden\ Eifel",
"494967", "Rhauderfehn\-Burlage",
"496656", "Ebersburg",
"4938721", "Ziegendorf",
"494222", "Ganderkesee",
"497153", "Plochingen",
"498269", "Unteregg\ bei\ Mindelheim",
"498340", "Baisweil",
"495261", "Lemgo",
"492244", "Königswinter\-Oberpleis",
"496127", "Niedernhausen\ Taunus",
"4934926", "Pretzsch\ Elbe",
"495827", "Unterlüss",
"4938451", "Hoppenrade\ bei\ Güstrow",
"496233", "Frankenthal\ Pfalz",
"492472", "Monschau",
"497332", "Lauterstein",
"494665", "Emmelsbüll\-Horsbüll",
"4939006", "Miesterhorst",
"494357", "Sehestedt\ Eider",
"492993", "Marsberg\-Canstein",
"494606", "Wanderup",
"496421", "Marburg",
"495034", "Neustadt\-Hagen",
"499741", "Bad\ Brückenau",
"4938454", "Kritzkow",
"498038", "Vogtareuth",
"499841", "Bad\ Windsheim",
"497671", "Todtnau",
"499975", "Waldmünchen\-Geigant",
"499708", "Bad\ Bocklet",
"499453", "Thalmassing",
"498446", "Pörnbach",
"499942", "Viechtach",
"4938724", "Siggelkow",
"496307", "Schopp",
"499677", "Oberviechtach\-Pullenried",
"4936967", "Geisa",
"492523", "Wadersloh",
"497747", "Berau",
"496181", "Hanau",
"494733", "Butjadingen\-Burhave",
"494833", "Wesselburen",
"499097", "Marxheim",
"495482", "Tecklenburg",
"499953", "Pilsting",
"49661", "Fulda",
"4935797", "Schwepnitz",
"499442", "Riedenburg",
"494554", "Wahlstedt",
"4936023", "Horsmar",
"496660", "Steinau\-Marjoss",
"493682", "Zella\-Mehlis",
"496722", "Rüdesheim\ am\ Rhein",
"497546", "Oberteuringen",
"499363", "Arnstein\ Unterfranken",
"494161", "Buxtehude",
"4936968", "Rossdorf\ Rhön",
"499274", "Hollfeld",
"492871", "Bocholt",
"498021", "Waakirchen",
"496591", "Gerolstein",
"4939365", "Bellingen\ bei\ Stendal",
"492945", "Lippstadt\-Benninghausen",
"492859", "Wesel\-Bislich",
"4933656", "Bahro",
"492759", "Bad\ Berleburg\-Aue",
"492771", "Dillenburg",
"496438", "Hünfelden",
"494467", "Wittmund\-Funnix",
"497175", "Leinzell",
"496046", "Ortenberg\ Hessen",
"496504", "Thalfang",
"497142", "Bietigheim\-Bissingen",
"4934782", "Mansfeld\ Südharz",
"492647", "Kesseling",
"4939926", "Grabowhöfe",
"493725", "Zschopau",
"492972", "Schmallenberg",
"495302", "Vechelde",
"4936205", "Gräfenroda",
"4939221", "Möckern\ bei\ Magdeburg",
"499682", "Erbendorf",
"499076", "Wittislingen",
"497557", "Herdwangen\-Schönach",
"498367", "Rosshaupten\ Forggensee",
"495675", "Trendelburg",
"4938874", "Lützow",
"495043", "Lauenau",
"492421", "Düren",
"494532", "Bargteheide",
"4933637", "Beerfelde",
"4938373", "Katzow",
"498093", "Glonn\ Kreis\ Ebersberg",
"496523", "Holsthum",
"493475", "Lutherstadt\ Eisleben",
"495642", "Warburg\-Scherfede",
"492181", "Grevenbroich",
"4939428", "Pabstorf",
"494271", "Sulingen",
"499083", "Möttingen",
"499164", "Langenfeld\ Mittelfranken",
"495977", "Spelle",
"492307", "Kamen",
"499551", "Burgwindheim",
"499825", "Herrieden",
"492656", "Virneburg",
"497023", "Weilheim\ an\ der\ Teck",
"494136", "Scharnebeck",
"499725", "Poppenhausen\ Unterfranken",
"492938", "Ense",
"497265", "Angelbachtal",
"496298", "Möckmühl",
"496445", "Schöffengrund",
"4934322", "Rosswein",
"496209", "Mörlenbach",
"496472", "Weilmünster",
"49771", "Donaueschingen",
"4938871", "Mühlen\ Eichsen",
"499220", "Kasendorf\-Azendorf",
"49781", "Offenburg",
"496057", "Flörsbachtal",
"496244", "Westhofen\ Rheinhessenen",
"4939224", "Büden",
"4934633", "Braunsbedra",
"497622", "Schopfheim",
"492233", "Hürth\ Rheinland",
"497464", "Talheim\ Kreis\ Tuttlingen",
"498823", "Mittenwald",
"492645", "Vettelschoss",
"498723", "Arnstorf",
"499568", "Neustadt\ bei\ Coburg",
"4939745", "Hetzdorf\ bei\ Strasburg",
"494264", "Sottrum\ Kreis\ Rotenburg",
"499171", "Roth\ Mittelfranken",
"493727", "Mittweida",
"496456", "Haina\ Kloster",
"4933676", "Friedland\ bei\ Beeskow",
"4939829", "Blankenförde",
"492947", "Anröchte",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"4936926", "Creuzburg",
"4935268", "Stauchitz",
"494465", "Friedeburg\ Ostfriesland",
"492672", "Treis\-Karden",
"494120", "Ellerhoop",
"4938483", "Brüel",
"496621", "Bad\ Hersfeld",
"494406", "Berne",
"493881", "Grevesmühlen",
"4939827", "Schwarz\ bei\ Neustrelitz",
"499653", "Eslarn",
"492331", "Hagen\ Westfalen",
"497471", "Hechingen",
"497459", "Nagold\-Hochdorf",
"493496", "Köthen\ Anhalt",
"495696", "Bad\ Arolsen\-Landau",
"4939320", "Schinne",
"4934903", "Coswig\ Anhalt",
"499236", "Nagel",
"498085", "Sankt\ Wolfgang",
"494480", "Ovelgönne\-Strückhausen",
"494884", "Schwabstedt",
"498306", "Ronsberg",
"4938851", "Zarrentin",
"497821", "Lahr\ Schwarzwald",
"494158", "Roseburg",
"492638", "Waldbreitbach",
"497721", "Villingen\ im\ Schwarzwald",
"496328", "Elmstein",
"494174", "Stelle\ Kreis\ Harburg",
"4934779", "Abberode",
"496092", "Heimbuchenthal",
"499261", "Kronach",
"496055", "Freigericht",
"492485", "Schleiden\-Dreiborn",
"499727", "Schonungen\-Marktsteinach",
"496693", "Neuental",
"492366", "Herten\ Westfalen",
"499827", "Lichtenau\ Mittelfranken",
"496447", "Langgöns\-Niederkleen",
"498380", "Achberg",
"4937604", "Mosel",
"497267", "Gemmingen",
"4937601", "Mülsen\ Skt\ Jacob",
"4939205", "Langenweddingen",
"4938353", "Gützkow\ bei\ Greifswald",
"498704", "Altdorf\-Pfettrach",
"495841", "Lüchow\ Wendland",
"492305", "Castrop\-Rauxel",
"495975", "Rheine\-Mesum",
"495453", "Recke",
"4934692", "Alsleben\ Saale",
"496108", "Mühlheim\ am\ Main",
"495808", "Gerdau",
"495741", "Lübbecke",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"492764", "Welschen\ Ennest",
"495942", "Uelsen",
"492864", "Reken",
"4936428", "Stadtroda",
"497555", "Deggenhausertal",
"498365", "Wertach",
"4938854", "Redefin",
"495677", "Calden\-Westuffeln",
"498657", "Ramsau\ bei\ Berchtesgaden",
"49241", "Aachen",
"496331", "Pirmasens",
"499482", "Wörth\ an\ der\ Donau",
"4934205", "Markranstädt",
"497838", "Nordrach",
"497586", "Herbertingen",
"495475", "Bohmte\-Hunteburg",
"49203", "Duisburg",
"492621", "Lahnstein",
"497738", "Steisslingen",
"495953", "Börger",
"493675", "Sonneberg\ Thüringen",
"495442", "Barnstorf\ Kreis\ Diepholz",
"495258", "Salzkotten",
"4939777", "Borkenfriede",
"498254", "Altomünster",
"495363", "Wolfsburg\-Vorsfelde",
"495274", "Nieheim",
"49291", "Meschede",
"497573", "Stetten\ am\ kalten\ Markt",
"4936427", "Dornburg\ Saale",
"499122", "Schwabach",
"492687", "Horhausen\ Westerwald",
"497182", "Welzheim",
"492456", "Selfkant",
"496073", "Babenhausen\ Hessen",
"496645", "Ulrichstein",
"4939779", "Eggesin",
"4935025", "Liebstadt",
"496589", "Kell\ am\ See",
"499526", "Riedbach",
"492985", "Winterberg\-Niedersfeld",
"496672", "Eiterfeld",
"4934466", "Janisroda",
"497422", "Schramberg",
"496086", "Grävenwiesbach",
"499302", "Rottendorf\ Unterfranken",
"497664", "Freiburg\-Tiengen",
"496305", "Hochspeyer",
"495682", "Borken\ Hessen",
"497745", "Jestetten",
"493996", "Teterow",
"498232", "Schwabmünchen",
"497971", "Gaildorf",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"497959", "Frankenhardt",
"499675", "Altendorf\ am\ Nabburg",
"498056", "Eggstätt",
"498168", "Attenkirchen",
"499642", "Kemnath\ Stadt",
"49641", "Giessen",
"498571", "Simbach\ am\ Inn",
"497240", "Pfinztal",
"499977", "Arnschwang",
"496764", "Rheinböllen",
"495551", "Northeim",
"495083", "Hohne\ bei\ Celle",
"496864", "Mettlach",
"495164", "Hodenhagen",
"495725", "Lindhorst\ bei\ Stadthagen",
"495825", "Wieren",
"493302", "Hennigsdorf",
"494355", "Rieseby",
"494667", "Dagebüll",
"496638", "Schwalmtal\-Renzendorf",
"494392", "Nortorf\ bei\ Neumünster",
"4934745", "Winningen\ Sachsen\-Anhalt",
"496284", "Mudau",
"492447", "Dahlem\ bei\ Kall",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"4935203", "Tharandt",
"4936736", "Arnsgereuth",
"496485", "Nentershausen\ Westerwald",
"492693", "Antweiler",
"494965", "Surwold",
"4935267", "Diesbar\-Seusslitz",
"494876", "Reher\ Holstein",
"496341", "Landau\ in\ der\ Pfalz",
"499654", "Pleystein",
"498502", "Fürstenzell",
"494776", "Osten\-Altendorf",
"496308", "Olsbrücken",
"497748", "Grafenhausen\ Hochschwarzwald",
"498326", "Fischen\ im\ Allgäu",
"493632", "Sondershausen",
"495432", "Löningen",
"494883", "Süderstapel",
"492562", "Gronau\ Westfalen",
"4936024", "Diedorf\ bei\ Mühlhausen",
"498165", "Neufahrn\ bei\ Freising",
"4934925", "Bad\ Schmiedeberg",
"494263", "Scheessel",
"4939772", "Rothemühl",
"492058", "Wülfrath",
"496128", "Taunusstein",
"495828", "Himbergen",
"492325", "Wanne\-Eickel",
"498724", "Massing",
"4936021", "Schlotheim",
"4936422", "Reinstädt\ Thüringen",
"498106", "Vaterstetten",
"496635", "Kirtorf",
"498824", "Oberau\ Loisach",
"4939005", "Kusey",
"494358", "Loose\ bei\ Eckernförde",
"493969", "Siedenbollentin",
"492297", "Wildbergerhütte",
"494968", "Neulehe",
"493371", "Luckenwalde",
"499190", "Heroldsbach",
"492166", "Mönchengladbach\-Rheydt",
"492131", "Neuss",
"495454", "Hörstel\-Riesenbeck",
"4938873", "Carlow",
"496150", "Weiterstadt",
"495850", "Neetze",
"498458", "Gaimersheim",
"497735", "Öhningen",
"494320", "Heidmühlen",
"498703", "Essenbach",
"497835", "Zell\ am\ Harmersbach",
"498803", "Peissenberg",
"495255", "Altenbeken",
"499632", "Waldsassen",
"495292", "Lichtenau\-Atteln",
"492863", "Velen",
"492763", "Drolshagen\-Bleche",
"4938374", "Lassan\ bei\ Wolgast",
"4938371", "Karlshagen",
"499371", "Miltenberg",
"494173", "Wulfsen",
"499359", "Karlstadt\-Wiesenfeld",
"494426", "Wangerland\-Horumersiel",
"496648", "Bad\ Salzschlirf",
"494186", "Buchholz\-Trelde",
"4939223", "Theessen",
"496694", "Neukirchen\ Knüll",
"492635", "Rheinbrohl",
"4936465", "Oberndorf\ bei\ Apolda",
"494155", "Büchen",
"496074", "Rödermark",
"4935361", "Schlieben",
"494192", "Bad\ Bramstedt",
"496058", "Gründau",
"497062", "Beilstein\ Württemberg",
"494926", "Krummhörn\-Greetsiel",
"496325", "Lambrecht\ Pfalz",
"4936643", "Thimmendorf",
"4934223", "Dommitzsch",
"495766", "Rehburg\-Loccum",
"497663", "Eichstetten",
"499469", "Roding\-Neubäu",
"492937", "Arnsberg\-Oeventrop",
"496166", "Fischbachtal",
"496297", "Ravenstein\ Baden",
"4939822", "Kratzeburg",
"495954", "Lorup",
"495286", "Ottenstein\ Niedersachsen",
"4937383", "Lunzenau",
"498636", "Ampfing",
"493322", "Falkensee",
"496105", "Mörfelden\-Walldorf",
"495805", "Oetzen",
"495978", "Hörstel\-Dreierwalde",
"492308", "Unna\-Hemmerde",
"495705", "Petershagen\-Windheim",
"4936206", "Grossfahner",
"499246", "Pegnitz\-Trockau",
"498253", "Pöttmes",
"495364", "Velpke",
"495273", "Beverungen",
"497574", "Gammertingen",
"496562", "Speicher",
"498368", "Halblech",
"4935364", "Lebusa",
"497558", "Illmensee",
"499565", "Untersiemau",
"492601", "Nauort",
"496283", "Hardheim\ Odenwald",
"4934772", "Helbra",
"4939925", "Wredenhagen",
"4930", "Berlin",
"497382", "Römerstein",
"4939366", "Kehnert",
"492694", "Wershofen",
"499102", "Wilhermsdorf",
"496276", "Hesseneck",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"498661", "Grabenstätt\ Chiemsee",
"494468", "Friedeburg\-Reepsholt",
"497520", "Bodnegg",
"499257", "Zell\ Oberfranken",
"4938453", "Mistorf",
"496131", "Mainz",
"495831", "Wittingen",
"496020", "Heigenbrücken",
"495731", "Bad\ Oeynhausen",
"492150", "Meerbusch\-Lank",
"494630", "Barderup",
"495084", "Hambühren",
"495163", "Fallingbostel\-Dorfmark",
"495932", "Haren\ Ems",
"497251", "Bruchsal",
"497402", "Fluorn\-Winzeln",
"496763", "Kirchberg\ Hunsrück",
"4938723", "Kladrum",
"497777", "Sauldorf",
"499647", "Kirchenthumbach",
"499493", "Beratzhausen",
"4938424", "Bobitz",
"499972", "Waldmünchen",
"4939994", "Metschow",
"4937754", "Zwönitz",
"4939084", "Lindstedt",
"499945", "Arnbruck",
"495456", "Westerkappeln\-Velpe",
"499871", "Windsbach",
"497641", "Emmendingen",
"4938754", "Leussow\ bei\ Ludwigslust",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"498237", "Aindling",
"4939387", "Havelberg",
"494939", "Baltrum",
"498123", "Moosinning",
"4935242", "Nossen",
"4939389", "Schollene",
"494184", "Hanstedt\ Nordheide",
"493421", "Torgau",
"4938228", "Dettmannsdorf\-Kölzow",
"4936608", "Seelingstädt\ bei\ Gera",
"4938751", "Picher",
"492363", "Datteln",
"496696", "Gilserberg",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"49591", "Lingen\ \(Ems\)",
"4939482", "Gatersleben",
"497193", "Sulzbach\ an\ der\ Murr",
"492274", "Elsdorf\ Rheinland",
"4939991", "Daberkow",
"4937421", "Oelsnitz\ Vogtland",
"4933873", "Grosswudicke",
"4934956", "Zörbig",
"498370", "Wiggensbach",
"493307", "Zehdenick",
"495621", "Bad\ Wildungen",
"498303", "Waltenhofen",
"492953", "Wünnenberg",
"498629", "Palling",
"497335", "Wiesensteig",
"494662", "Leck",
"4939296", "Welsleben",
"4935434", "Altdöbern",
"4939727", "Spantekow",
"495447", "Lembruch",
"495693", "Volkmarsen",
"499127", "Rosstal\ Mittelfranken",
"493771", "Aue\ Sachsen",
"499233", "Arzberg\ Oberfranken",
"493871", "Parchim",
"498042", "Lenggries",
"499656", "Moosbach\ bei\ Vohenstrauss",
"492825", "Uedem",
"498075", "Amerang",
"494774", "Hechthausen",
"495055", "Fassberg",
"495328", "Altenau\ Harz",
"492725", "Lennestadt\-Oedingen",
"494874", "Todenbüttel",
"499938", "Moos\ Niederbayern",
"493493", "Bitterfeld",
"494858", "Sankt\ Margarethen\ Holstein",
"498324", "Hindelang",
"493647", "Pössneck",
"494758", "Nordleda",
"494403", "Bad\ Zwischenahn",
"497121", "Reutlingen",
"4939457", "Benneckenstein\ Harz",
"4938306", "Samtens",
"496677", "Neuenstein\ Hessen",
"4934346", "Narsdorf",
"4939459", "Hasselfelde",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"494383", "Grebin",
"497394", "Schelklingen",
"492164", "Jüchen\-Otzenrath",
"4933933", "Lindow\ Mark",
"498191", "Landsberg\ am\ Lech",
"492551", "Steinfurt\-Burgsteinfurt",
"497427", "Schömberg\ bei\ Balingen",
"495199", "Schneverdingen\-Heber",
"499307", "Altertheim",
"495108", "Gehrden\ Han",
"496741", "St\ Goar",
"496841", "Homburg\ Saar",
"495141", "Celle",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"492682", "Hamm\ Sieg",
"496453", "Gemünden\ Wohra",
"4936335", "Grosswechsungen",
"499421", "Straubing",
"498726", "Schönau\ Niederbayern",
"498104", "Sauerlach",
"4935032", "Langenhennersdorf",
"4936372", "Kleinneuhausen",
"497348", "Beimerstetten",
"499822", "Bechhofen\ an\ der\ Heide",
"4935951", "Neukirch\ Lausitz",
"492696", "Nohn\ Eifel",
"499722", "Werneck",
"496363", "Niederkirchen",
"4939346", "Tucheim",
"496274", "Waldbrunn\ Odenwald",
"49961", "Weiden\ in\ der\ Oberpfalz",
"497262", "Eppingen",
"496258", "Gernsheim",
"4936766", "Schalkau",
"496442", "Braunfels",
"496475", "Weilmünster\-Wolfenhausen",
"493523", "Coswig\ bei\ Dresden",
"497138", "Schwaigern",
"495331", "Wolfenbüttel",
"499921", "Regen",
"497625", "Zell\ im\ Wiesental",
"499549", "Lisberg",
"495947", "Laar\ Vechte",
"494208", "Grasberg",
"4936940", "Oepfershausen",
"4934296", "Groitzsch\ bei\ Pegau",
"495086", "Celle\-Scheuen",
"494241", "Bassum",
"4939728", "Medow\ bei\ Anklam",
"498652", "Berchtesgaden",
"499504", "Stadelhofen",
"495672", "Bad\ Karlshafen",
"493445", "Naumburg\ Saale",
"494535", "Nahe",
"498581", "Waldkirchen\ Niederbayern",
"499438", "Fensterbach",
"495645", "Borgentreich\-Borgholz",
"495073", "Neustadt\-Esperke",
"498053", "Bad\ Endorf",
"4939458", "Heudeber",
"494903", "Wymeer",
"4935954", "Grossharthau",
"496083", "Weilrod",
"495864", "Jameln",
"496164", "Reichelsheim\ Odenwald",
"492942", "Geseke",
"493921", "Burg\ bei\ Magdeburg",
"495764", "Steyerberg",
"496551", "Prüm",
"492677", "Lutzerath",
"49541", "Osnabrück",
"499523", "Hofheim\ in\ Unterfranken",
"4938227", "Lüdershagen\ bei\ Barth",
"498868", "Schwabsoien",
"4936607", "Niederpöllnitz",
"4938796", "Viesecke",
"497172", "Lorch\ Württemberg",
"4935341", "Bad\ Liebenwerda",
"497145", "Markgröningen",
"49361", "Erfurt",
"4939956", "Neukalen",
"492741", "Betzdorf",
"493722", "Limbach\-Oberfrohna",
"494924", "Moormerland\-Oldersum",
"495305", "Sickte",
"4933235", "Friesack",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"492975", "Schmallenberg\-Oberkirchen",
"492841", "Moers",
"492453", "Heinsberg\-Randerath",
"496682", "Tann\ Rhön",
"495366", "Jembke",
"499244", "Betzenstein",
"497576", "Krauchenwies",
"495485", "Ladbergen",
"493591", "Bautzen",
"499472", "Hohenfels\ Oberpfalz",
"499209", "Emtmannsberg",
"493987", "Templin",
"496220", "Wilhelmsfeld",
"494501", "Kastorf\ Holstein",
"497583", "Bad\ Schussenried",
"495284", "Schwalenberg",
"497051", "Calw",
"493504", "Dippoldiswalde",
"499445", "Neustadt\ an\ der\ Donau",
"4935843", "Hirschfelde\ bei\ Zittau",
"495956", "Rastdorf",
"4938229", "Bad\ Sülze",
"496825", "Illingen\ Saar",
"493685", "Hildburghausen",
"496725", "Gau\-Algesheim",
"4939388", "Goldbeck\ Altm",
"498634", "Garching\ an\ der\ Alz",
"492364", "Haltern\ Westfalen",
"492273", "Kerpen\-Horrem",
"497194", "Spiegelberg",
"499107", "Trautskirchen",
"4934600", "Ostrau\ Saalkreis",
"496432", "Diez",
"499381", "Volkach",
"494183", "Jesteburg",
"498765", "Bruckberg\ Niederbayern",
"494423", "Fedderwarden",
"4939975", "Thürkow",
"4934722", "Preusslitz",
"4933601", "Podelzig",
"4939932", "Malchow\ bei\ Waren",
"49821", "Augsburg",
"497148", "Grossbottwar",
"498304", "Wildpoldsried",
"492954", "Rüthen\-Oestereiden",
"497387", "Hohenstein\ Württemberg",
"495308", "Lehre",
"498349", "Stötten\ am\ Auerberg",
"494176", "Marschacht",
"495341", "Salzgitter",
"492866", "Dorsten\-Rhade",
"495937", "Geeste\-Gross\ Hesepe",
"494231", "Verden\ Aller",
"493435", "Oschatz",
"494545", "Seedorf\ Lauenburg",
"4933604", "Lebus",
"4936378", "Ostramondra",
"498124", "Forstern\ Oberbayern",
"499448", "Hausen\ Niederbayern",
"499295", "Töpen",
"498706", "Vilsheim",
"499252", "Helmbrechts",
"497321", "Heidenheim\ an\ der\ Brenz",
"499401", "Neutraubling",
"4933395", "Zerpenschleuse",
"495635", "Vöhl",
"498806", "Utting\ am\ Ammersee",
"498285", "Burtenbach",
"496728", "Ober\-Hilbersheim",
"4936083", "Uder",
"495128", "Hohenhameln",
"492932", "Neheim\-Hüsten",
"49345", "Halle\ Saale",
"497393", "Munderkingen",
"492163", "Schwalmtal\ Niederrhein",
"4934382", "Nerchau",
"496292", "Seckach",
"494384", "Selent",
"4935248", "Schönfeld\ bei\ Grossenhain",
"496255", "Lindenfels",
"497135", "Brackenheim",
"493381", "Brandenburg\ an\ der\ Havel",
"496478", "Greifenstein\-Ulm",
"497628", "Efringen\-Kirchen",
"494266", "Brockel",
"498170", "Strasslach\-Dingharting",
"496454", "Lichtenfels\-Sachsenberg",
"492831", "Geldern",
"494491", "Friesoythe",
"499234", "Neusorg",
"495694", "Diemelstadt",
"494205", "Ottersberg",
"493448", "Meuselwitz\ Thüringen",
"496567", "Oberkail",
"494404", "Elsfleth",
"4936450", "Kranichfeld",
"495648", "Brakel\-Gehrden",
"499435", "Schwarzenfeld",
"498323", "Immenstadt\ im\ Allgäu",
"495601", "Schauenburg",
"494873", "Aukrug",
"4938222", "Semlow",
"4936602", "Ronneburg\ Thüringen",
"493494", "Wolfen",
"494773", "Lamstedt",
"493327", "Werder\ Havel",
"4939488", "Güntersberge",
"499503", "Oberhaid\ Oberfranken",
"499637", "Falkenberg\ Oberpfalz",
"4935973", "Stolpen",
"4938324", "Velgast",
"495166", "Walsrode\-Kirchboitzen",
"496866", "Perl\-Nennig",
"493901", "Salzwedel",
"4937324", "Reinsberg\ Sachsen",
"496766", "Kisselbach",
"497631", "Müllheim\ Baden",
"499935", "Stephansposching",
"4935249", "Basslitz",
"4938823", "Selmsdorf",
"495325", "Goslar\-Hahnenklee",
"492828", "Emmerich\-Elten",
"495074", "Rodewald",
"4939487", "Friedrichsbrunn",
"498054", "Breitbrunn\ am\ Chiemsee",
"494755", "Ihlienworth",
"494892", "Schenefeld\ Mittelholstein",
"498247", "Bad\ Wörishofen",
"494792", "Worpswede",
"494855", "Eddelak",
"493994", "Malchin",
"494521", "Eutin",
"4939489", "Strassberg\ Harz",
"495562", "Dassel\-Markoldendorf",
"492432", "Wassenberg",
"49395", "Neubrandenburg",
"499229", "Mainleus",
"496364", "Nussbach\ Pfalz",
"4935247", "Zehren\ Sachsen",
"4933474", "Neutrebbin",
"4939382", "Kamern",
"4936846", "Suhl\-Dietzhausen",
"4937321", "Frankenstein\ Sachsen",
"4938321", "Martensdorf\ bei\ Stralsund",
"4936253", "Georgenthal\ Thüringer\ Wald",
"495105", "Barsinghausen",
"496805", "Kleinblittersdorf",
"497345", "Langenau\ Württemberg",
"496286", "Walldürn\-Rippberg",
"4935056", "Altenberg\ Sachsen",
"4936074", "Worbis",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"495437", "Menslage",
"492567", "Ahaus\-Alstätte",
"496669", "Neuhof\-Hauswurz",
"4936377", "Rastenberg",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"493935", "Tangerhütte",
"499243", "Pottenstein",
"499802", "Ansbach\-Katterbach",
"495276", "Marienmünster",
"499901", "Hengersberg\ Bayern",
"498633", "Tüssling",
"498507", "Neuburg\ am\ Inn",
"4938784", "Kleinow\ Kreis\ Prignitz",
"4936870", "Masserberg",
"499948", "Eschlkam",
"4939054", "Flechtingen",
"497584", "Altshausen",
"495283", "Lügde\-Rischenau",
"4939600", "Zwiedorf",
"492292", "Windeck\ Sieg",
"4934446", "Grosskorbetha",
"492255", "Euskirchen\-Flamersheim",
"499524", "Zeil\ am\ Main",
"4939452", "Ilsenburg",
"4939051", "Calvörde",
"495763", "Uchte",
"497666", "Denzlingen",
"4938781", "Mellen",
"496084", "Schmitten\ Taunus",
"495863", "Zernien",
"496163", "Höchst\ im\ Odenwald",
"496731", "Alzey",
"492850", "Rees\-Haldern",
"4936379", "Holzengel",
"492454", "Gangelt",
"498139", "Röhrmoos",
"494923", "Krummhörn\-Pewsum",
"4934975", "Görzig\ Kreis\ Köthen",
"4939722", "Sarnow\ bei\ Anklam",
"496831", "Saarlouis",
"492750", "Diedenshausen",
"495131", "Garbsen",
"4936071", "Teistungen",
"492246", "Lohmar\ Rheinland",
"496707", "Windesheim",
"49365", "Gera",
"495381", "Seesen",
"498389", "Weissensberg",
"4936336", "Klettenberg",
"497347", "Dietenheim",
"496678", "Wildeck\-Hönebach",
"4934345", "Bad\ Lausick",
"4938305", "Gingst",
"49451", "Lübeck",
"4936949", "Obermassfeld\-Grimmenthal",
"494143", "Drochtersen",
"499341", "Tauberbischofsheim",
"496654", "Gersfeld\ Rhön",
"4933454", "Wölsickendorf\/Wollenberg",
"497428", "Rosenfeld",
"4933052", "Leegebruch",
"495494", "Holdorf\ Niedersachsen",
"4933451", "Heckelberg",
"496190", "Hattersheim\ am\ Main",
"495327", "Bad\ Grund\ Harz",
"498531", "Pocking",
"499937", "Oberpöring",
"497732", "Radolfzell\ am\ Bodensee",
"494857", "Barlt",
"498245", "Türkheim\ Wertach",
"497832", "Haslach\ im\ Kinzigtal",
"494757", "Wanna",
"4936947", "Jüchsen",
"493601", "Mühlhausen\ Thüringen",
"495252", "Bad\ Lippspringe",
"495036", "Neustadt\-Schneeren",
"495401", "Georgsmarienhütte",
"4935953", "Burkau",
"497931", "Bad\ Mergentheim",
"498272", "Wertingen",
"4939295", "Zuchau",
"499635", "Bärnau",
"494604", "Grossenwiehe",
"495295", "Lichtenau\ Westfalen",
"495448", "Barver",
"498444", "Schweitenkirchen",
"499128", "Feucht",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"4934955", "Gossa",
"4938220", "Wustrow\ Ostseebad",
"4935841", "Grossschönau\ Sachsen",
"493341", "Strausberg",
"4936452", "Berlstedt",
"492506", "Münster\-Wolbeck",
"4935892", "Horka\ OL",
"497966", "Unterschneidheim",
"4933087", "Bredereiche",
"492257", "Reckerscheid",
"496033", "Butzbach",
"494623", "Böklund",
"497356", "Schemmerhofen",
"494344", "Schönberg\ Holstein",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"492102", "Ratingen",
"498505", "Hutthurm",
"495234", "Horn\-Bad\ Meinberg",
"497533", "Allensbach",
"4939888", "Lychen",
"498238", "Gessertshausen",
"4933089", "Himmelpfort",
"498684", "Fridolfing",
"494489", "Apen",
"493635", "Kölleda",
"492565", "Gronau\-Epe",
"495435", "Berge\ bei\ Quakenbrück",
"494129", "Haseldorf",
"497905", "Langenburg",
"499648", "Neustadt\ am\ Kulm",
"494746", "Hagen\ bei\ Bremerhaven",
"497854", "Kehl\-Goldscheuer",
"493937", "Osterburg\ Altmark",
"4935844", "Oybin\ Kurort",
"496371", "Landstuhl",
"496359", "Grünstadt",
"497754", "Görwihl",
"494846", "Hattstedt",
"495503", "Nörten\-Hardenberg",
"49731", "Ulm\ Donau",
"497204", "Malsch\-Völkersbach",
"4939993", "Hohenmocker",
"4937423", "Adorf\ Vogtland",
"4938423", "Bad\ Kleinen",
"497249", "Stutensee",
"498550", "Philippsreut",
"4939887", "Gerswalde",
"499166", "Münchsteinach",
"498433", "Königsmoos",
"495935", "Twist\-Schöninghsdorf",
"499325", "Kleinlangheim",
"4938753", "Wöbbelin",
"494547", "Gudow\ Lauenburg",
"499074", "Höchstädt\ an\ der\ Donau",
"4939083", "Messdorf",
"497950", "Schnelldorf",
"493437", "Grimma",
"498221", "Günzburg",
"499562", "Sonnefeld",
"4989", "Munich",
"4939955", "Jürgenstorf",
"497466", "Beuron",
"496246", "Eich\ Rheinhessen",
"497385", "Gomadingen",
"493763", "Glauchau",
"499105", "Grosshabersdorf",
"494134", "Embsen\ Kreis\ Lüneburg",
"4933088", "Falkenthal",
"4939889", "Boitzenburg",
"492654", "Polch",
"493863", "Crivitz",
"492678", "Büchel\ bei\ Cochem",
"498867", "Rottenbuch\ Oberbayern",
"4933874", "Stechow\ Brandenburg",
"497544", "Markdorf",
"496102", "Neu\-Isenburg",
"495802", "Wrestedt",
"499276", "Bischofsgrün",
"4936948", "Römhild",
"4935433", "Vetschau",
"494556", "Ahrensbök\-Gnissau",
"495702", "Petershagen\-Lahde",
"498293", "Welden\ bei\ Augsburg",
"495948", "Itterbeck",
"494207", "Oyten",
"492359", "Kierspe",
"492371", "Iserlohn",
"495901", "Fürstenau\ bei\ Bramsche",
"497431", "Albstadt\-Ebingen",
"4934295", "Krensitz",
"496565", "Dudeldorf",
"4939602", "Kleeth",
"499283", "Rehau",
"4933931", "Rheinsberg\ Mark",
"497223", "Bühl\ Baden",
"494152", "Geesthacht",
"495524", "Bad\ Lauterberg\ im\ Harz",
"492632", "Andernach",
"496506", "Welschbillig",
"494195", "Hartenholm",
"496322", "Bad\ Dürkheim",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"499131", "Erlangen",
"494333", "Erfde",
"4939345", "Parchen",
"496257", "Seeheim\-Jugenheim",
"496044", "Schotten\ Hessen",
"493562", "Forst\ Lausitz",
"4939852", "Schönermark\ bei\ Prenzlau",
"496580", "Zemmer",
"4937323", "Lichtenberg\ Erzgebirge",
"492526", "Sendenhorst",
"495647", "Lichtenau\-Kleinenberg",
"4938323", "Prohn",
"497681", "Waldkirch\ Breisgau",
"492302", "Witten",
"4935974", "Hinterhermsdorf",
"493328", "Teltow",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"498751", "Mainburg",
"493693", "Meiningen",
"495771", "Rahden\ Westfalen",
"498851", "Kochel\ am\ See",
"496159", "Messel",
"495859", "Thomasburg",
"495945", "Wilsum",
"496171", "Oberursel\ Taunus",
"498443", "Hohenwart\ Paar",
"494537", "Sülfeld\ Holstein",
"494603", "Havetoft",
"494329", "Langwedel\ Holstein",
"49228", "Bonn",
"4936458", "Bad\ Berka",
"493447", "Altenburg\ Thüringen",
"4938824", "Mallentin",
"498362", "Füssen",
"497552", "Pfullendorf",
"496568", "Wolsfeld",
"4938821", "Lüdersdorf",
"4935240", "Tauscha\ bei\ Grossenhain",
"496477", "Greifenstein\-Nenderoth",
"4933473", "Zechin",
"497627", "Steinen\ Kreis\ Lörrach",
"49991", "Deggendorf",
"496095", "Bessenbach",
"496052", "Bad\ Orb",
"496236", "Neuhofen\ Pfalz",
"492482", "Hellenthal",
"496653", "Burghaun",
"497156", "Ditzingen",
"499350", "Eussenheim\-Hundsbach",
"4935971", "Sebnitz",
"494144", "Himmelpforten",
"4939882", "Gollin",
"4936254", "Friedrichswerth",
"499621", "Amberg\ Oberpfalz",
"494109", "Tangstedt\ Bz\ Hamburg",
"499447", "Essing",
"4933396", "Klosterfelde",
"498683", "Tittmoning",
"4936370", "Grossenehrich",
"4939857", "Drense",
"495233", "Steinheim\ Westfalen",
"496727", "Gensingen",
"497534", "Reichenau\ Baden",
"496827", "Eppelborn",
"495127", "Harsum",
"499092", "Wemding",
"497753", "Albbruck",
"496261", "Mosbach\ Baden",
"497441", "Freudenstadt",
"495656", "Waldkappel",
"497853", "Kehl\-Bodersweier",
"498082", "Schwindegg",
"4939053", "Süplingen",
"4938783", "Dallmin",
"492642", "Remagen",
"493621", "Gotha\ Thüringen",
"4939976", "Gross\ Bützin",
"495181", "Alfeld\ Leine",
"496881", "Lebach",
"497147", "Sachsenheim\ Württemberg",
"496781", "Idar\-Oberstein",
"497388", "Pfronstetten",
"499199", "Kunreuth",
"492977", "Schmallenberg\-Bödefeld",
"495307", "Braunschweig\-Wenden",
"4939607", "Kotelow",
"494343", "Laboe",
"499141", "Weissenburg\ in\ Bayern",
"4939859", "Fürstenwerder",
"49391", "Magdeburg",
"496034", "Wöllstadt",
"494462", "Wittmund",
"494624", "Kropp",
"492043", "Gladbeck",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"492675", "Ediger\-Eller",
"495722", "Bückeburg",
"494861", "Tönning",
"494761", "Bremervörde",
"4934976", "Gröbzig",
"496122", "Hofheim\-Wallau",
"495822", "Ebstorf",
"492236", "Wesseling\ Rheinland",
"492052", "Velbert\-Langenberg",
"4939608", "Staven",
"494352", "Damp",
"4934607", "Wettin",
"4936081", "Arenshausen",
"497337", "Nellingen\ Alb",
"49561", "Kassel",
"4936482", "Triptis",
"497529", "Waldburg\ Württemberg",
"4934445", "Stössen",
"49341", "Leipzig",
"494133", "Wittorf\ Kreis\ Lüneburg",
"499331", "Ochsenfurt",
"497026", "Lenningen",
"492653", "Kaisersesch",
"496482", "Runkel",
"495921", "Nordhorn",
"493764", "Meerane",
"494962", "Papenburg\-Aschendorf",
"499086", "Fremdingen",
"4933603", "Falkenhagen\ bei\ Seelow",
"496302", "Winnweiler",
"495685", "Knüllwald",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"498541", "Vilshofen\ Niederbayern",
"496526", "Bollendorf",
"497742", "Klettgau",
"495504", "Friedland\ Kreis\ Göttingen",
"497203", "Walzbachtal",
"499672", "Neunburg\ vorm\ Wald",
"497842", "Kappelrodeck",
"4939858", "Bietikow",
"499073", "Gundelfingen\ an\ der\ Donau",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"494281", "Zeven",
"4934609", "Salzmünde",
"497941", "Öhringen",
"4936084", "Heuthen",
"497775", "Mühlingen",
"495438", "Bakum\-Lüsche",
"492568", "Heek",
"498434", "Rennertshofen",
"493366", "Beeskow",
"4936878", "Oberland",
"496029", "Mömbris",
"494639", "Schafflund",
"492171", "Leverkusen\-Opladen",
"492159", "Meerbusch\-Osterath",
"4936845", "Gehlberg",
"499764", "Höchheim",
"493331", "Angermünde",
"4936459", "Blankenhain\ Thüringen",
"496642", "Schlitz",
"497224", "Gernsbach",
"49941", "Regensburg",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"495523", "Bad\ Sachsa",
"492982", "Medebach",
"496043", "Nidda",
"496675", "Breitenbach\ am\ Herzberg",
"499305", "Estenfeld",
"497425", "Trossingen",
"494334", "Bredenbek\ bei\ Rendsburg",
"499366", "Geroldshausen\ Unterfranken",
"497543", "Kressbronn\ am\ Bodensee",
"495244", "Rietberg",
"4933082", "Menz\ Kreis\ Oberhavel",
"492827", "Goch\-Hassum",
"49711", "Stuttgart",
"498248", "Lamerdingen",
"495209", "Gütersloh\-Friedrichsdorf",
"495472", "Bad\ Essen",
"498452", "Geisenfeld",
"495445", "Drebber",
"499956", "Eichendorf\-Aufhausen",
"493672", "Rudolstadt",
"499638", "Neualbenreuth",
"499284", "Schwarzenbach\ an\ der\ Saale",
"493947", "Thale",
"494736", "Butjadingen\-Tossens",
"492261", "Gummersbach",
"498294", "Horgau",
"494836", "Hennstedt\ Dithmarschen",
"4935435", "Gollmitz\ bei\ Calau",
"495383", "Lutter\ am\ Barenberge",
"4936331", "Ilfeld",
"4935472", "Schlepzig",
"494108", "Rosengarten\ Kreis\ Harburg",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"497566", "Argenbühl",
"499343", "Lauda\-Königshofen",
"494141", "Stade",
"4934293", "Naunhof\ bei\ Grimma",
"499462", "Falkenstein\ Oberpfalz",
"499624", "Ensdorf\ Oberpfalz",
"493329", "Stahnsdorf",
"493603", "Bad\ Langensalza",
"493537", "Jessen\ Elster",
"497684", "Glottertal",
"496066", "Michelstadt\-Vielbrunn",
"494447", "Vechta\-Langförden",
"498533", "Rotthalmünster",
"497505", "Fronreute",
"4933456", "Wriezen",
"498754", "Volkenschwand",
"496569", "Bickendorf",
"495774", "Wagenfeld\-Ströhen",
"4937368", "Deutschneudorf",
"498450", "Ingolstadt\-Zuchering",
"495874", "Soltendieck",
"496174", "Königstein\ im\ Taunus",
"494328", "Rickling",
"4936334", "Wolkramshausen",
"497162", "Süssen",
"495858", "Hitzacker\-Wietzetze",
"496158", "Riedstadt",
"4939343", "Jerichow",
"492392", "Werdohl",
"495403", "Bad\ Iburg",
"492667", "Stein\-Neukirch",
"492355", "Schalksmühle",
"497933", "Creglingen",
"498347", "Friesenried",
"495063", "Bad\ Salzdetfurth",
"493624", "Ohrdruf",
"493462", "Bad\ Dürrenberg",
"495184", "Freden\ Leine",
"497389", "Heroldstatt",
"496784", "Weierbach",
"499198", "Heiligenstadt\ in\ Oberfranken",
"495225", "Spenge",
"4938425", "Kirchdorf\ Poel",
"49491", "Leer\ Ostfriesland",
"4939995", "Nossendorf",
"4939085", "Zichtau",
"4937755", "Schönheide\ Erzgebirge",
"499144", "Pleinfeld",
"4938755", "Eldena",
"496406", "Lollar",
"496031", "Friedberg\ Hessen",
"494621", "Schleswig",
"4933437", "Reichenberg\ bei\ Strausberg",
"496120", "Aarbergen",
"495662", "Felsberg\ Hessen",
"495820", "Suhlendorf",
"495424", "Bad\ Rothenfelde",
"4933439", "Fredersdorf\-Vogelsdorf",
"496386", "Altenkirchen\ Pfalz",
"497245", "Durmersheim",
"496465", "Breidenbach\ bei\ Biedenkopf",
"498732", "Frontenhausen",
"4939953", "Schwinkendorf",
"497531", "Konstanz",
"4933332", "Gartz\ Oder",
"496373", "Schönenberg\-Kübelberg",
"494456", "Varel\-Altjührden",
"4938793", "Dergenthin",
"496264", "Neudenau",
"497444", "Alpirsbach",
"4935930", "Seitschen",
"497272", "Rülzheim",
"499603", "Floss",
"495939", "Sustrum",
"4935602", "Drebkau",
"494366", "Grömitz\-Cismar",
"494485", "Elsfleth\-Huntorf",
"498544", "Eging\ am\ See",
"499090", "Rain\ Lech",
"492066", "Duisburg\-Homberg",
"4934953", "Gräfenhainichen",
"498509", "Ruderting",
"4933876", "Buschow",
"497944", "Kupferzell",
"496028", "Sulzbach\ am\ Main",
"494284", "Selsingen",
"494638", "Tarp",
"496392", "Hauenstein\ Pfalz",
"492158", "Grefrath\ bei\ Krefeld",
"496667", "Steinau\-Ulmbach",
"494956", "Uplengen",
"496355", "Albisheim\ Pfrimm",
"498431", "Neuburg\ an\ der\ Donau",
"495439", "Bersenbrück",
"494125", "Seestermühe",
"499836", "Gunzenhausen\-Cronheim",
"4933234", "Wustermark",
"499736", "Oberthulba",
"495594", "Bovenden\-Reyershausen",
"492174", "Burscheid\ Rheinland",
"494864", "Oldenswort",
"4933231", "Pausin",
"497528", "Neukirch\ bei\ Tettnang",
"498065", "Tuntenhausen\-Schönau",
"494764", "Gnarrenburg\-Klenkendorf",
"493962", "Penzlin\ bei\ Waren",
"49441", "Oldenburg",
"498137", "Petershausen",
"4936042", "Tonna",
"498223", "Ichenhausen",
"493395", "Pritzwalk",
"499334", "Giebelstadt",
"493861", "Plate",
"495924", "Bad\ Bentheim\-Gildehaus",
"49214", "Leverkusen",
"4933438", "Altlandsberg",
"494305", "Westensee",
"493761", "Werdau\ Sachsen",
"495208", "Leopoldshöhe",
"494947", "Aurich\-Ogenbargen",
"495241", "Gütersloh",
"493836", "Wolgast",
"493588", "Niesky",
"498249", "Ettringen\ Wertach",
"494672", "Langenhorn",
"492465", "Inden",
"495535", "Polle",
"498204", "Mickhausen",
"49831", "Kempten\ Allgäu",
"4937367", "Lengefeld\ Erzgebirge",
"499281", "Hof\ Saale",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"495903", "Emsbüren",
"499639", "Mähring",
"492373", "Menden\ Sauerland",
"498405", "Stammham\ bei\ Ingolstadt",
"492264", "Marienheide",
"497433", "Balingen",
"498291", "Zusmarshausen",
"4934343", "Regis\-Breitingen",
"4938303", "Sellin\ Ostseebad",
"498385", "Hergatz",
"4938462", "Baumgarten",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"493334", "Eberswalde",
"498466", "Denkendorf\ Oberbayern",
"4937462", "Rothenkirchen\ Vogtland",
"499861", "Rothenburg\ ob\ der\ Tauber",
"4937369", "Wolkenstein",
"499395", "Triefenstein",
"497221", "Baden\-Baden",
"499352", "Lohr\ am\ Main",
"492406", "Herzogenrath",
"496050", "Biebergemünd",
"499962", "Schwarzach\ Niederbayern",
"499227", "Neuenmarkt",
"4935955", "Pulsnitz",
"499133", "Baiersdorf\ Mittelfranken",
"494331", "Rendsburg",
"4939293", "Dreileben",
"493585", "Löbau",
"495491", "Damme\ Dümmer",
"4935053", "Glashütte\ Sachsen",
"498534", "Tettenweis",
"495205", "Bielefeld\-Sennestadt",
"497683", "Simonswald",
"4936256", "Wechmar",
"496186", "Grosskrotzenburg",
"4936843", "Benshausen",
"4935609", "Drachhausen",
"495404", "Westerkappeln",
"497934", "Weikersheim",
"497082", "Neuenbürg\ Württemberg",
"496426", "Fronhausen",
"499129", "Wendelstein",
"497676", "Feldberg\ Schwarzwald",
"499846", "Ipsheim",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"495873", "Eimke",
"496173", "Kronberg\ im\ Taunus",
"493691", "Eisenach\ Thüringen",
"499746", "Zeitlofs",
"498753", "Elsendorf\ Niederbayern",
"4939030", "Brunau",
"495773", "Stemwede\-Wehdem",
"496582", "Freudenburg",
"498388", "Hergensweiler",
"495384", "Seesen\-Gross\ Rhüden",
"499398", "Birkenfeld\ bei\ Würzburg",
"4938826", "Dassow",
"49351", "Dresden",
"4939831", "Feldberg",
"496897", "Sulzbach\ Saar",
"497429", "Egesheim",
"495197", "Soltau\-Frielingen",
"4935607", "Jänschwalde",
"492630", "Mülheim\-Kärlich",
"499344", "Gerchsheim",
"495266", "Lemgo\-Kirchheide",
"496651", "Rasdorf",
"49465", "Sylt",
"4933338", "Stolpe\/Oder",
"494488", "Westerstede",
"498239", "Langenneufnach",
"497952", "Gerabronn",
"495231", "Detmold",
"498681", "Waging\ am\ See",
"499857", "Schopfloch\ Mittelfranken",
"495545", "Hedemünden",
"495572", "Bodenfelde",
"4937467", "Klingenthal\ Sachsen",
"492192", "Hückeswagen",
"496358", "Kriegsfeld",
"499604", "Wernberg\-Köblitz",
"497362", "Bopfingen",
"498552", "Grafenau\ Niederbayern",
"494635", "Sörup",
"4935478", "Goyatz",
"497443", "Dornstetten",
"497851", "Kehl",
"4933989", "Sadenbeck",
"494128", "Kollmar",
"496374", "Weilerbach",
"4934443", "Teuchern",
"496263", "Neckargerach",
"497751", "Waldshut",
"4937362", "Seiffen\ Erzgebirge",
"497525", "Aulendorf",
"493344", "Bad\ Freienwalde",
"496783", "Baumholder",
"493623", "Friedrichroda",
"495064", "Gross\ Düngen",
"4939971", "Gnoien",
"4933605", "Boossen",
"495183", "Lamspringe",
"49951", "Bamberg",
"495423", "Versmold",
"492041", "Bottrop",
"4933394", "Blumberg\ Kreis\ Barnim",
"494308", "Schwedeneck",
"496776", "Dachsenhausen",
"499560", "Grub\ am\ Forst",
"499143", "Pappenheim\ Mittelfranken",
"492596", "Nordkirchen",
"495176", "Edemissen",
"496876", "Weiskirchen\ Saar",
"499195", "Adelsdorf\ Mittelfranken",
"498224", "Offingen\ Donau",
"4936075", "Dingelstädt\ Eichsfeld",
"499152", "Hartenstein\ Mittelfranken",
"494763", "Gnarrenburg",
"492582", "Everswinkel",
"494863", "Sankt\ Peter\-Ording",
"4936702", "Lauscha",
"495228", "Vlotho\-Exter",
"496630", "Schwalmtal\-Storndorf",
"4938785", "Berge\ bei\ Perleberg",
"492651", "Mayen",
"494131", "Lüneburg",
"499333", "Sommerhausen",
"495923", "Schüttorf",
"4939055", "Hörsingen",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"4933970", "Neustadt\ Dosse",
"497452", "Nagold",
"496468", "Dautphetal\-Mornshausen",
"49811", "Hallbergmoos",
"497248", "Marxzell",
"498543", "Aidenbach",
"499556", "Geiselwind",
"494276", "Borstel\ bei\ Sulingen",
"4935477", "Rietzneuendorf\-Friedrichshof",
"495593", "Bovenden\-Lenglern",
"492173", "Langenfeld\ Rheinland",
"499207", "Königsfeld\ Oberfranken",
"4937468", "Treuen\ Vogtland",
"4939390", "Iden",
"497943", "Schöntal\ Jagst",
"499071", "Dillingen\ an\ der\ Donau",
"494283", "Tarmstedt",
"492426", "Nörvenich",
"495521", "Herzberg\ am\ Harz",
"498337", "Altenstadt\ Iller",
"4933830", "Ziesar",
"494562", "Grömitz",
"4938325", "Rolofshagen",
"4937325", "Niederbobritzsch",
"4935608", "Gross\ Ossnig",
"499134", "Neunkirchen\ am\ Brand",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"492776", "Bad\ Endbach\-Hartenrod",
"494105", "Seevetal",
"498026", "Hausham",
"496596", "Üdersdorf",
"49234", "Bochum",
"4933704", "Baruth\ Mark",
"4933337", "Altkünkendorf",
"496041", "Glauburg",
"496008", "Echzell",
"494297", "Ottersberg\-Posthausen",
"497235", "Unterreichenbach\ Kreis\ Calw",
"498203", "Grossaitingen",
"498742", "Velden\ Vils",
"4933701", "Grossbeeren",
"494166", "Ahlerstedt",
"497541", "Friedrichshafen",
"4933475", "Letschin",
"495250", "Delbrück\ Westfalen",
"4933432", "Müncheberg",
"495904", "Lengerich\ Emsl",
"492374", "Iserlohn\-Letmathe",
"497434", "Winterlingen",
"492263", "Engelskirchen",
"492358", "Meinerzhagen\-Valbert",
"496192", "Hofheim\ am\ Taunus",
"495755", "Kalletal\-Varenholz",
"495855", "Nahrendorf",
"499547", "Zapfendorf",
"496155", "Griesheim\ Hessen",
"497042", "Vaihingen\ an\ der\ Enz",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"499205", "Vorbach",
"494234", "Dörverden",
"499491", "Hemau",
"498121", "Markt\ Schwaben",
"4933233", "Ketzin",
"494435", "Grossenkneten",
"495129", "Söhlde",
"499404", "Nittendorf",
"497324", "Herbrechtingen",
"4935727", "Burghammer",
"495746", "Rödinghausen",
"499773", "Unsleben",
"496146", "Hochheim\ am\ Main",
"495846", "Gartow\ Niedersachsen",
"4935938", "Grosspostwitz\ OL",
"499873", "Abenberg\-Wassermungenau",
"497643", "Herbolzheim\ Breisgau",
"492361", "Recklinghausen",
"498427", "Wellheim",
"497191", "Backnang",
"4937756", "Breitenbrunn\ Erzgebirge",
"4939086", "Jävenitz",
"4938756", "Grabow",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"498394", "Lautrach",
"492852", "Hamminkeln",
"493423", "Eilenburg",
"495022", "Wietzen",
"492752", "Bad\ Laasphe",
"499384", "Schwanfeld",
"496575", "Landscheid",
"498348", "Bidingen",
"497726", "Bad\ Dürrheim",
"496542", "Bullay",
"495623", "Edertal",
"499197", "Egloffstein",
"492951", "Büren",
"495309", "Lehre\-Wendhausen",
"497826", "Schuttertal",
"4938426", "Neuburg\-Steinhausen",
"4939996", "Törpin",
"495344", "Lengede",
"499266", "Mitwitz",
"494494", "Bösel\ Oldenburg",
"4935387", "Seyda",
"499231", "Marktredwitz",
"494539", "Westerau",
"4939242", "Prödel",
"495691", "Bad\ Arolsen",
"493773", "Johanngeorgenstadt",
"494327", "Grossenaspe",
"496157", "Pfungstadt",
"499545", "Buttenheim",
"495857", "Bleckede\-Brackede",
"4939291", "Calbe\ Saale",
"497483", "Horb\-Mühringen",
"496626", "Wildeck\-Obersuhl",
"4934497", "Langenleuba\-Niederhain",
"497123", "Metzingen\ Württemberg",
"494252", "Bruchhausen\-Vilsen",
"4934344", "Kohren\-Sahlis",
"4938304", "Garz\ Rügen",
"4938737", "Ganzlin",
"494401", "Brake\ Unterweser",
"493886", "Gadebusch",
"499572", "Burgkunstadt",
"495604", "Grossalmerode",
"497237", "Neulingen\ Enzkreis",
"494295", "Emtinghausen",
"495585", "Herzberg\-Sieber",
"493491", "Lutherstadt\ Wittenberg",
"4933849", "Wiesenburg\ Mark",
"498641", "Grassau\ Kreis\ Traunstein",
"492336", "Schwelm",
"4937360", "Olbernhau",
"497476", "Bisingen",
"498193", "Geltendorf",
"4933847", "Görzke",
"494107", "Siek\ Kreis\ Stormarn",
"492553", "Ochtrup",
"499183", "Burgthann",
"494381", "Lütjenburg",
"4934341", "Geithain",
"4938301", "Putbus",
"4935436", "Laasow\ bei\ Calau",
"4939294", "Gross\ Rosenburg",
"498335", "Fellheim",
"497629", "Tegernau\ Baden",
"497303", "Illertissen",
"49551", "Göttingen",
"499423", "Geiselhöring",
"4935389", "Holzdorf\ Elster",
"495143", "Winsen\ Aller",
"496843", "Gersheim",
"496479", "Waldbrunn\ Westerwald",
"496202", "Schwetzingen",
"492734", "Freudenberg\ Westfalen",
"496451", "Frankenberg\ Eder",
"499176", "Allersberg",
"496743", "Bacharach",
"492834", "Straelen",
"495152", "Hessisch\ Oldendorf",
"496852", "Nohfelden",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"494524", "Scharbeutz\-Pönitz",
"4936761", "Heubisch",
"492575", "Greven\-Reckenfeld",
"495195", "Neuenkirchen\ bei\ Soltau",
"496752", "Kirn\ Nahe",
"4933848", "Raben",
"496361", "Rockenhausen",
"4939341", "Redekin",
"499228", "Thurnau",
"495333", "Dettum",
"499923", "Teisnach",
"4934294", "Rackwitz",
"492542", "Gescher",
"493521", "Meissen",
"498145", "Mammendorf",
"4938202", "Volkenshagen",
"4936622", "Triebes",
"4934242", "Hohenpriessnitz",
"493949", "Oschersleben\ Bode",
"4937202", "Claussnitz\ bei\ Chemnitz",
"4935388", "Klöden",
"4935877", "Cunewalde",
"4933972", "Breddin",
"494802", "Wrohm",
"4934291", "Borsdorf",
"494243", "Twistringen",
"494702", "Sandstedt",
"493904", "Haldensleben",
"495556", "Lindau\ Harz",
"495207", "Schloss\ Holte\-Stukenbrock",
"497634", "Sulzburg",
"494948", "Wiesmoor\-Marcardsmoor",
"4936333", "Heringen\ Helme",
"4938738", "Karow\ bei\ Lübz",
"4939344", "Güsen",
"4934498", "Rositz",
"495071", "Schwarmstedt",
"497976", "Sulzbach\-Laufen",
"498051", "Prien\ am\ Chiemsee",
"498583", "Neureichenau",
"4936764", "Neuhaus\-Schierschnitz",
"493991", "Waren\ Müritz",
"4935939", "Hochkirch",
"4938791", "Bad\ Wilsnack",
"498262", "Mittelneufnach",
"499521", "Hassfurt",
"496553", "Schönecken",
"496081", "Usingen",
"493923", "Zerbst",
"492843", "Rheinberg",
"497527", "Wolfegg",
"492451", "Geilenkirchen",
"492202", "Bergisch\ Gladbach",
"496734", "Flonheim",
"492743", "Daaden",
"496834", "Bous",
"496430", "Hahnstätten",
"498138", "Schwabhausen\ bei\ Dachau",
"4939951", "Faulenrost",
"496027", "Stockstadt\ am\ Main",
"494503", "Timmendorfer\ Strand",
"494637", "Sterup",
"492157", "Nettetal\-Kaldenkirchen",
"496668", "Birstein\-Lichenroth",
"4939954", "Stavenhagen\ Reuterstadt",
"497652", "Hinterzarten",
"4933762", "Zeuthen",
"499904", "Lalling",
"498782", "Pfeffenhausen",
"496336", "Dellfeld",
"494935", "Juist",
"499855", "Dentlein\ am\ Forst",
"497053", "Bad\ Teinach\-Zavelstein",
"492626", "Selters\ Westferwald",
"4933832", "Rogäsen",
"4935937", "Prischwitz",
"4933875", "Rhinow",
"4938794", "Cumlosen",
"4935728", "Uhyst\ Spree",
"497581", "Saulgau",
"494181", "Buchholz\ in\ der\ Nordheide",
"499383", "Wiesentheid",
"494307", "Raisdorf",
"498393", "Holzgünz",
"4939399", "Kleinau",
"492271", "Bergheim\ Erft",
"499376", "Collenberg",
"4933977", "Gumtow",
"4935872", "Neusalza\-Spremberg",
"498067", "Tuntenhausen",
"4937207", "Hainichen\ Sachsen",
"4939248", "Dobritz",
"4938207", "Stäbelow",
"498628", "Kienberg\ Oberbayern",
"495462", "Ankum",
"495624", "Bad\ Emstal",
"492532", "Ostbevern",
"494421", "Wilhelmshaven",
"4933606", "Müllrose",
"498135", "Sulzemoos",
"496357", "Standenbühl",
"496665", "Sinntal\-Altengronau",
"494233", "Blender",
"4937209", "Einsiedel\ bei\ Chemnitz",
"4933979", "Wusterhausen\ Dosse",
"4938209", "Sanitz\ bei\ Rostock",
"494127", "Westerhorn",
"494938", "Hagermarsch",
"494487", "Grossenkneten\-Huntlosen",
"497644", "Kenzingen",
"499874", "Neuendettelsau",
"496222", "Wiesloch",
"4939397", "Geestgottberg",
"499774", "Oberelsbach",
"499403", "Donaustauf",
"497323", "Gerstetten",
"4934973", "Osternienburg",
"497765", "Rickenbach\ Hotzenwald",
"496898", "Völklingen",
"495198", "Schneverdingen\-Wintermoor",
"499184", "Deining\ Oberpfalz",
"497391", "Ehingen\ Donau",
"4935975", "Hohnstein",
"492161", "Mönchengladbach",
"499225", "Stadtsteinach",
"4935932", "Guttau",
"498194", "Vilgertshofen",
"4933837", "Brielow",
"492554", "Laer\ Kreis\ Steinfurt",
"496744", "Oberwesel",
"497260", "Sinsheim\-Hilsbach",
"492833", "Kerken",
"496440", "Kölschhausen",
"4933703", "Sperenberg",
"495144", "Wathlingen",
"496844", "Blieskastel\-Altheim",
"498387", "Weiler\-Simmerberg",
"492733", "Hilchenbach",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"499662", "Vilseck",
"499820", "Lehrberg",
"497304", "Blaustein\ Württemberg",
"49721", "Karlsruhe",
"499424", "Strasskirchen",
"495109", "Ronnenberg",
"496809", "Grossrosseln",
"499397", "Wertheim\-Dertingen",
"4933767", "Friedersdorf\ bei\ Berlin",
"4938825", "Klütz",
"499720", "Üchtelhausen",
"497484", "Simmersfeld",
"4933769", "Töpchin",
"494972", "Langeoog",
"493774", "Schwarzenberg",
"494493", "Friesoythe\-Gehlenberg",
"498407", "Grossmehring",
"493874", "Ludwigslust",
"494771", "Hemmoor",
"498650", "Marktschellenberg",
"494945", "Grossefehn\-Timmel",
"494859", "Windbergen",
"494871", "Hohenwestedt",
"4933839", "Wusterwitz",
"4939038", "Henningen",
"496346", "Annweiler\ am\ Trifels",
"495329", "Schulenberg\ im\ Oberharz",
"497806", "Bad\ Peterstal\-Griesbach",
"495603", "Gudensberg",
"4936255", "Goldbach\ bei\ Gotha",
"498321", "Sonthofen",
"497706", "Oberbaldingen",
"497124", "Trochtelfingen\ Hohenz",
"4936844", "Rohr\ Thüringen",
"497256", "Philippsburg",
"497032", "Herrenberg",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"494244", "Harpstedt",
"492357", "Herscheid\ Westfalen",
"499548", "Mühlhausen\ Mittelfranken",
"494209", "Schwanewede",
"494472", "Lastrup",
"4935054", "Lauenstein\ Sachsen",
"494445", "Visbek\ Kreis\ Vechta",
"494298", "Lilienthal",
"4939037", "Pretzier",
"498584", "Breitenberg\ Niederbayern",
"493535", "Herzberg\ Elster",
"4933476", "Neuhardenberg",
"492222", "Bornheim\ Rheinland",
"497633", "Staufen\ im\ Breisgau",
"499439", "Neunburg\-Kemnath",
"496136", "Nieder\-Olm",
"495836", "Wittingen\-Radenbeck",
"498666", "Teisendorf",
"496271", "Eberbach\ Baden",
"4939039", "Bonese",
"4933838", "Päwesin",
"494523", "Malente",
"492680", "Mündersbach",
"496007", "Rosbach\-Rodheim",
"4935722", "Lauta\ bei\ Hoyerswerda",
"4935452", "Golssen",
"496532", "Zeltingen\-Rachtig",
"498338", "Böhen",
"492606", "Winningen\ Mosel",
"4935600", "Döbern\ NL",
"4933768", "Prieros",
"497139", "Neuenstadt\ am\ Kocher",
"4938326", "Grimmen",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"4937326", "Frauenstein\ Sachsen",
"4936841", "Schleusingen",
"499924", "Bodenmais",
"499241", "Pegnitz",
"499208", "Bindlach",
"493594", "Bischofswerda",
"499535", "Pfarrweisach",
"494504", "Ratekau",
"4934444", "Lützen",
"4939398", "Gross\ Garz",
"495281", "Bad\ Pyrmont",
"496467", "Hatzfeld\ Eder",
"493501", "Pirna",
"497247", "Linkenheim\-Hochstetten",
"497054", "Wildberg\ Württemberg",
"499903", "Schöllnach",
"4939973", "Altkalen",
"498631", "Mühldorf\ am\ Inn",
"498869", "Kinsau",
"494722", "Cuxhaven\-Altenbruch",
"495861", "Dannenberg\ Elbe",
"496161", "Brensbach",
"4939056", "Klüden",
"4938732", "Gallin\ bei\ Lübz",
"495761", "Stolzenau",
"496554", "Waxweiler",
"494822", "Kellinghusen",
"4934492", "Lucka",
"498372", "Obergünzburg",
"496578", "Salmtal",
"495352", "Schöningen",
"49461", "Flensburg",
"4934441", "Hohenmölsen",
"4936076", "Niederorschel",
"4938208", "Kavelstorf",
"4936628", "Zeulenroda",
"4936085", "Reinholterode",
"4939247", "Güterglück",
"4937208", "Auerswalde",
"4933978", "Segeletz",
"498345", "Stöttwang",
"494921", "Emden\ Stadt",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"492744", "Herdorf",
"496833", "Rehlingen\-Siersburg",
"495962", "Herzlake",
"492844", "Rheinberg\-Orsoy",
"492440", "Nettersheim\-Tondorf",
"496733", "Gau\-Odernheim",
"49355", "Cottbus",
"495146", "Wietze",
"494371", "Burg\ auf\ Fehmarn",
"499173", "Thalmässing",
"493968", "Schönbeck",
"497522", "Wangen\ im\ Allgäu",
"492207", "Kürten\-Dürscheid",
"496746", "Pfalzfeld",
"4933747", "Marzahna",
"498721", "Eggenfelden",
"498821", "Garmisch\-Partenkirchen",
"499426", "Oberschneiding",
"497306", "Vöhringen\ Iller",
"496129", "Schlangenbad",
"495829", "Wriedel",
"498267", "Dirlewang",
"499186", "Lauterhofen\ Oberpfalz",
"4936921", "Wutha\-Farnroda",
"498196", "Pürgen",
"492556", "Metelen",
"4933671", "Lieberose",
"4933674", "Trebatsch",
"4934743", "Ermsleben",
"496344", "Schwegenheim",
"497955", "Wallhausen\ Württemberg",
"492333", "Ennepetal",
"499651", "Vohenstrauss",
"4936924", "Mihla",
"497473", "Mössingen",
"497704", "Geisingen\ Baden",
"496623", "Rotenburg\ an\ der\ Fulda",
"493883", "Hagenow",
"497126", "Burladingen\-Melchingen",
"497804", "Oppenau",
"495542", "Witzenhausen",
"492195", "Radevormwald",
"497657", "Eisenbach\ Hochschwarzwald",
"498555", "Perlesreut",
"497365", "Essingen\ Württemberg",
"494632", "Steinbergkirche",
"496398", "Vorderweidenthal",
"492152", "Kempen",
"498592", "Wegscheid\ Niederbayern",
"496022", "Obernburg\ am\ Main",
"497486", "Horb\-Altheim",
"493876", "Perleberg",
"4935205", "Ottendorf\-Okrilla",
"4939268", "Egeln",
"496585", "Ralingen",
"499374", "Eschau",
"499263", "Ludwigsstadt",
"499358", "Gössenheim",
"4934203", "Zwenkau",
"497723", "Furtwangen\ im\ Schwarzwald",
"4935829", "Gersdorf\ bei\ Görlitz",
"495626", "Bad\ Zwesten",
"492547", "Rosendahl\-Osterwick",
"497823", "Seelbach\ Schutter",
"4938856", "Pritzier\ bei\ Hagenow",
"496757", "Becherbach\ bei\ Kirn",
"498177", "Münsing\ Starnberger\ See",
"495157", "Emmerthal\-Börry",
"496857", "Namborn",
"496691", "Schwalmstadt",
"4933209", "Caputh",
"4939062", "Bebertal",
"4933207", "Gross\ Kreutz",
"495743", "Espelkamp\-Gestringen",
"4935023", "Bad\ Gottleuba",
"499776", "Mellrichstadt",
"498459", "Manching",
"495843", "Wustrow\ Wendland",
"495202", "Oerlinghausen",
"499876", "Rohr\ Mittelfranken",
"497646", "Weisweil\ Breisgau",
"495451", "Ibbenbüren",
"49651", "Trier",
"4939400", "Wefensleben",
"4937606", "Lengenfeld\ Vogtland",
"4935827", "Nieder\-Seifersdorf",
"4933922", "Karwesee",
"497085", "Enzklösterle",
"493679", "Neuhaus\ am\ Rennweg",
"494707", "Langen\-Neuenwalde",
"498845", "Bad\ Kohlgrub",
"497056", "Gechingen",
"492623", "Ransbach\-Baumbach",
"497232", "Königsbach\-Stein",
"492309", "Waltrop",
"495951", "Werlte",
"494257", "Schweringen",
"4934464", "Freyburg\ Unstrut",
"498745", "Bodenkirchen",
"4933208", "Fahrland",
"4934652", "Allstedt",
"496333", "Waldfischbach\-Burgalben",
"4938393", "Binz\ Ostseebad",
"494322", "Bordesholm",
"493596", "Neustadt\ in\ Sachsen",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"495361", "Wolfsburg",
"4935828", "Reichenbach\ OL",
"497571", "Sigmaringen",
"498369", "Rückholz",
"496195", "Kelkheim\ Taunus",
"495752", "Auetal\-Hattendorf",
"494506", "Stockelsdorf\-Krumbeck",
"498772", "Mallersdorf\-Pfaffenberg",
"495852", "Bleckede",
"496152", "Gross\-Gerau",
"4938842", "Lüttenmark",
"496059", "Jossgrund",
"496071", "Dieburg",
"492129", "Haan\ Rheinland",
"4939267", "Schneidlingen",
"4938355", "Züssow",
"496207", "Wald\-Michelbach",
"4939203", "Barleben",
"496556", "Pronsfeld",
"494102", "Ahrensburg",
"4934461", "Nebra\ Unstrut",
"499468", "Zell\ Oberpfalz",
"497455", "Dornhan",
"49251", "Münster",
"497973", "Obersontheim",
"4936734", "Leutenberg",
"498586", "Hauzenberg",
"4939743", "Zerrenthin",
"495834", "Wittingen\-Knesebeck",
"496134", "Mainz\-Kastel",
"495734", "Bergkirchen\ Westfalen",
"4935692", "Kerkwitz",
"494246", "Twistringen\-Heiligenloh",
"498573", "Ering",
"495553", "Kalefeld",
"497254", "Waghäusel",
"499099", "Kaisheim",
"4933965", "Herzsprung\ bei\ Wittstock",
"499192", "Gräfenberg",
"492604", "Nassau\ Lahn",
"499155", "Simmelsdorf",
"495336", "Semmenstedt",
"499926", "Frauenau",
"4938485", "Dabel",
"492585", "Warendorf\-Hoetmar",
"4933748", "Treuenbrietzen",
"492691", "Adenau",
"494469", "Wangerooge",
"498664", "Chieming",
"498422", "Dollnstein",
"4936731", "Unterloquitz",
"4934905", "Wörlitz",
"495027", "Linsburg",
"492857", "Rees\-Mehr",
"4940", "Hamburg",
"497803", "Gengenbach",
"497242", "Rheinstetten",
"495606", "Zierenberg",
"496462", "Gladenbach",
"497703", "Bonndorf\ im\ Schwarzwald",
"496624", "Heringen\ Werra",
"498735", "Gangkofen\-Kollbach",
"4934364", "Wermsdorf",
"497458", "Ebhausen",
"4939923", "Priborn",
"492334", "Hagen\-Hohenlimburg",
"497474", "Haigerloch",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"496343", "Bad\ Bergzabern",
"4939262", "Güsten\ Anh",
"498230", "Gablingen",
"494496", "Friesoythe\-Markhausen",
"4938847", "Boizenburg\ Elbe",
"4933653", "Ziltendorf",
"494881", "Friedrichstadt",
"497275", "Kandel",
"4933928", "Wildberg\ Brandenburg",
"499158", "Offenhausen\ Mittelfranken",
"493386", "Premnitz",
"4936026", "Struth\ bei\ Mühlhausen",
"495222", "Bad\ Salzuflen",
"4938455", "Plaaz",
"499569", "Sesslach",
"492588", "Harsewinkel\-Greffen",
"492836", "Wachtendonk",
"494261", "Rotenburg\ Wümme",
"499174", "Hilpoltstein",
"492736", "Burbach\ Siegerl",
"494827", "Wacken",
"4938725", "Gross\ Godems",
"4934361", "Dahlen\ Sachsen",
"495357", "Grasleben",
"498377", "Unterthingau",
"495665", "Guxhagen",
"497326", "Neresheim",
"496109", "Frankfurt\-Bergen\-Enkheim",
"499406", "Mintraching",
"498801", "Seeshaupt",
"4934636", "Schafstädt",
"499120", "Leinburg",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"492962", "Olsberg",
"495844", "Clenze",
"492227", "Bornheim\-Merten",
"497502", "Wolpertswende",
"495744", "Hüllhorst",
"4936463", "Gebstedt",
"492133", "Dormagen",
"494236", "Kirchlinteln",
"492761", "Olpe\ Biggesee",
"492861", "Borken\ Westfalen",
"494477", "Lastrup\-Hemmelte",
"497165", "Göppingen\-Hohenstaufen",
"499480", "Sünching",
"492395", "Finnentrop\-Rönkhausen",
"4936645", "Mühltroff",
"492352", "Altena\ Westfalen",
"496198", "Eppstein",
"497824", "Schwanau",
"497420", "Deisslingen",
"496329", "Weidenthal\ Pfalz",
"497724", "St\ Georgen\ im\ Schwarzwald",
"4935697", "Bagenz",
"4938233", "Prerow\ Ostseebad",
"494159", "Basthorst",
"492639", "Anhausen\ Kreis\ Neuwied",
"499373", "Amorbach",
"494171", "Winsen\ Luhe",
"499264", "Küps",
"495346", "Liebenburg",
"4938376", "Zirchow",
"496670", "Ludwigsau\ Hessen",
"496002", "Ober\-Mörlen",
"4935772", "Rietschen",
"499386", "Prosselsheim",
"499465", "Neukirchen\-Balbini",
"4936204", "Stotternheim",
"498382", "Lindau\ Bodensee",
"4935698", "Hornow",
"496836", "Überherrn",
"495136", "Burgdorf\ Kreis\ Hannover",
"496588", "Pluwig",
"496736", "Bechenheim",
"499392", "Faulbach\ Unterfranken",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"499355", "Frammersbach",
"497661", "Kirchzarten",
"499965", "Sankt\ Englmar",
"496334", "Thaleischweiler\-Fröschen",
"497739", "Hilzingen",
"499906", "Mariaposching",
"497839", "Schapbach",
"4937430", "Eichigt",
"492624", "Höhr\-Grenzhausen",
"495532", "Stadtoldendorf",
"492462", "Linnich",
"494642", "Kappeln\ Schlei",
"498402", "Münchsmünster",
"498251", "Aichach",
"4939225", "Altengrabow",
"495259", "Bad\ Driburg\-Neuenheerse",
"495271", "Höxter",
"494977", "Blomberg\ Ostfriesland",
"4936201", "Walschleben",
"4933742", "Oehna\ Brandenburg",
"496639", "Ottrau",
"498062", "Bruckmühl\ Mangfall",
"493965", "Burow\ bei\ Altentreptow",
"4933927", "Linum",
"4935822", "Hagenwerder",
"495467", "Voltlage",
"496281", "Buchen\ Odenwald",
"492603", "Bad\ Ems",
"494526", "Ascheberg\ Holstein",
"4936741", "Bad\ Blankenburg",
"4934658", "Hayn\ Harz",
"4933202", "Töplitz",
"498663", "Ruhpolding",
"4939361", "Lüderitz",
"494302", "Kirchbarkau",
"4939003", "Jübar",
"497958", "Rot\ Am\ See\-Brettheim",
"496227", "Walldorf\ Baden",
"4939364", "Dolle",
"495733", "Vlotho",
"497636", "Münstertal\ Schwarzwald",
"496133", "Oppenheim",
"495833", "Brome",
"494482", "Hatten",
"4936744", "Remda",
"4934923", "Cobbelsdorf",
"497974", "Bühlerzell",
"4938848", "Vellahn",
"496395", "Münchweiler\ an\ der\ Rodalb",
"4934262", "Falkenhain\ bei\ Wurzen",
"498558", "Hohenau\ Niederbayern",
"496352", "Kirchheimbolanden",
"498574", "Wittibreut",
"495554", "Moringen",
"496761", "Simmern\ Hunsrück",
"4939863", "Seehausen\ bei\ Prenzlau",
"494122", "Uetersen",
"497253", "Bad\ Schönborn",
"4933929", "Gühlen\-Glienicke",
"496861", "Merzig",
"495161", "Walsrode",
"4939408", "Hadmersleben",
"499606", "Pfreimd",
"494453", "Zetel",
"4934463", "Bad\ Kösen",
"494841", "Husum\ Nordsee",
"494975", "Westerholt\ Ostfriesland",
"494708", "Ringstedt",
"492924", "Möhnesee",
"494741", "Nordholz\ bei\ Bremerhaven",
"493844", "Schwaan",
"494942", "Südbrookmerland",
"493744", "Auerbach\ Vogtland",
"4933362", "Liepe\ Kreis\ Barnim",
"496383", "Glan\-Münchweiler",
"4939201", "Wolmirstedt",
"4937605", "Hartenstein\ Sachsen",
"497762", "Wehr\ Baden",
"496403", "Linden\ Hessen",
"4939204", "Niederndodeleben",
"496758", "Waldböckelheim",
"498178", "Icking",
"497620", "Schopfheim\-Gersbach",
"495158", "Hemeringen",
"496858", "Ottweiler\-Fürth",
"495174", "Lahstedt",
"496874", "Wadern\-Nunkirchen",
"492594", "Dülmen",
"499222", "Presseck",
"497351", "Biberach\ an\ der\ Riss",
"498561", "Pfarrkirchen\ Niederbayern",
"496774", "Kaub",
"4937342", "Cranzahl",
"493346", "Seelow",
"492501", "Münster\-Hiltrup",
"499357", "Gräfendorf\ Bayern",
"495066", "Sarstedt",
"497961", "Ellwangen\ Jagst",
"499665", "Königstein\ Oberpfalz",
"4938391", "Altenkirchen\ Rügen",
"492548", "Dülmen\-Rorup",
"4938855", "Lübtheen",
"496424", "Ebsdorfergrund",
"496397", "Leimen\ Pfalz",
"495406", "Belm",
"495031", "Wunstorf",
"498039", "Rott\ am\ Inn",
"497936", "Schrozberg\-Bartenstein",
"4936733", "Kaulsdorf",
"499744", "Zeitlofs\-Detter",
"4935206", "Kreischa\ bei\ Dresden",
"4939744", "Rothenklempenow",
"497674", "Todtmoos",
"499844", "Obernzenn",
"498536", "Kösslarn",
"493606", "Heiligenstadt\ Heilbad",
"496063", "Bad\ König",
"496184", "Langenselbold",
"498268", "Tussenhausen",
"495300", "Salzgitter\-Üfingen",
"492903", "Meschede\-Freienohl",
"495373", "Hillerse\ Kreis\ Gifhorn",
"495264", "Kalletal",
"497563", "Kisslegg",
"499346", "Grünsfeld",
"492241", "Siegburg",
"493967", "Oertzenhof\ bei\ Strasburg",
"4939741", "Jatznick",
"492208", "Niederkassel",
"492535", "Sendenhorst\-Albersloh",
"495465", "Neuenkirchen\ bei\ Bramsche",
"496594", "Birresborn",
"492874", "Isselburg",
"498024", "Holzkirchen",
"494725", "Helgoland",
"492774", "Dietzhölztal",
"496439", "Holzappel",
"494825", "Burg\ Dithmarschen",
"498375", "Weitnau",
"4934906", "Raguhn",
"492403", "Eschweiler\ Rheinland",
"495355", "Frellstedt",
"492758", "Bad\ Berleburg\-Girkhausen",
"495028", "Pennigsehl",
"492858", "Hünxe",
"4934741", "Frose",
"496501", "Konz",
"498342", "Marktoberdorf",
"498463", "Greding",
"495965", "Klein\ Berssen",
"4937432", "Pausa\ Vogtland",
"4938486", "Gustävel",
"495906", "Lünne",
"494682", "Amrum",
"497436", "Messstetten\-Oberdigisheim",
"499532", "Maroldsweisach",
"4936923", "Treffurt",
"4933966", "Dranse",
"497277", "Wörth\-Büchelberg",
"4933673", "Weichensdorf",
"493578", "Kamenz",
"492383", "Bönen",
"494551", "Bad\ Segeberg",
"493733", "Annaberg\-Buchholz",
"494164", "Harsefeld",
"499271", "Thurnau\-Alladorf",
"4934204", "Schkeuditz",
"499467", "Michelsneukirchen",
"4935752", "Ruhland",
"4935021", "Königstein\ Sächsische\ Schweiz",
"496535", "Osann\-Monzel",
"498226", "Bibertal",
"496241", "Worms",
"4938356", "Behrenhoff",
"4939409", "Eilsleben",
"497461", "Tuttlingen",
"4935329", "Dollenchen",
"499833", "Heidenheim\ Mittelfranken",
"4939407", "Seehausen\ Börde",
"4935327", "Priessen",
"499733", "Münnerstadt",
"492424", "Vettweiss",
"492662", "Hachenburg",
"494953", "Bunde",
"4933200", "Bergholz\-Rehbrücke",
"4935024", "Stadt\ Wehlen",
"494475", "Molbergen",
"494442", "Lohne\ Oldenburg",
"4938292", "Kröpelin",
"494258", "Schwarme",
"4937292", "Oederan",
"494274", "Varrel\ bei\ Sulingen",
"494363", "Lensahn",
"499161", "Neustadt\ an\ der\ Aisch",
"492225", "Meckenheim\ Rheinland",
"499554", "Untersteinbach\ Unterfranken",
"4935820", "Zodel",
"497340", "Neenstetten",
"496773", "Kamp\-Bornhofen",
"497269", "Sulzfeld\ Baden",
"499146", "Markt\ Berolzheim",
"498153", "Wessling",
"496449", "Ehringshausen\-Katzenfurt",
"495173", "Uetze",
"496873", "Nonnweiler",
"492593", "Ascheberg\ Westfalen",
"495426", "Glandorf",
"499829", "Flachslanden",
"4936203", "Vieselbach",
"496404", "Lich\ Hessen",
"499729", "Grettstadt",
"4937439", "Jocketa",
"496786", "Kempfeld",
"498332", "Ottobeuren",
"49340", "Dessau\ Anh",
"495186", "Salzhemmendorf\-Wallensen",
"4938332", "Gross\ Bisdorf",
"496205", "Hockenheim",
"4938375", "Koserow",
"495651", "Eschwege",
"497446", "Lossburg",
"492923", "Lippetal\-Herzfeld",
"498671", "Altötting",
"494454", "Jade",
"496266", "Hassmersheim",
"494478", "Cappeln\ Oldenburg",
"495320", "Torfhaus",
"4937437", "Bad\ Elster",
"499542", "Schesslitz",
"4936646", "Tanna\ bei\ Schleiz",
"4934672", "Rossleben",
"494255", "Martfeld",
"49906", "Donauwörth",
"496384", "Konken",
"499575", "Weismain",
"494292", "Ritterhude",
"4934635", "Bad\ Lauchstädt",
"498847", "Obersöchering",
"495582", "Sankt\ Andreasberg",
"492228", "Remagen\-Rolandseck",
"493843", "Güstrow",
"495374", "Isenbüttel",
"494828", "Lägerdorf",
"492904", "Bestwig",
"495263", "Barntrup",
"4937297", "Thum\ Sachsen",
"497564", "Bad\ Wurzach",
"4938297", "Moitin",
"497151", "Waiblingen",
"4938726", "Spornitz",
"4933368", "Hohensaaten",
"4933920", "Walsleben\ bei\ Neuruppin",
"499626", "Hohenburg",
"492855", "Voerde\ Niederrhein",
"4939861", "Gramzow\ bei\ Prenzlau",
"495025", "Estorf\ Weser",
"496572", "Manderscheid\ Eifel",
"492755", "Bad\ Berleburg\-Schwarzenau",
"495358", "Bahrdorf\-Mackendorf",
"498378", "Buchenberg\ bei\ Kempten",
"499157", "Alfeld\ Mittelfranken",
"496545", "Blankenrath",
"4935322", "Doberlug\-Kirchhain",
"4939402", "Völpke",
"492991", "Marsberg\-Bredelar",
"4939001", "Apenburg",
"4936025", "Körner",
"4938456", "Langhagen\ bei\ Güstrow",
"492587", "Ennigerloh\-Westkirchen",
"496231", "Hochdorf\-Assenheim",
"4934921", "Kemberg",
"4934924", "Zahna",
"4937348", "Oberwiesenthal\ Kurort",
"499843", "Burgbernheim",
"498856", "Penzberg",
"497045", "Oberderdingen",
"497673", "Schönau\ im\ Schwarzwald",
"499202", "Waischenfeld",
"499451", "Schierling",
"4936743", "Teichel",
"498756", "Nandlstadt",
"495776", "Preussisch\ Ströhen",
"4939004", "Köckte\ bei\ Gardelegen",
"496423", "Wetter\ Hessen",
"4939363", "Angern",
"494432", "Dötlingen\-Brettorf",
"496183", "Erlensee",
"495883", "Lemgow",
"493542", "Lübbenau\ Spreewald",
"497457", "Rottenburg\-Ergenzingen",
"492521", "Beckum",
"497072", "Gomaringen",
"497367", "Aalen\-Ebnat",
"498557", "Mauth",
"4939924", "Stuer",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"497655", "Feldberg\-Altglashütten",
"499951", "Landau\ an\ der\ Isar",
"4934363", "Cavertitz",
"494731", "Nordenham",
"492266", "Lindlar",
"494163", "Horneburg\ Niederelbe",
"496228", "Schönau\ Odenwald",
"498785", "Rottenburg\-Oberroning",
"497957", "Kressberg",
"493834", "Greifswald",
"494932", "Norderney",
"4933654", "Fünfeichen",
"499852", "Feuchtwangen",
"4933369", "Oderberg",
"498206", "Egling\ an\ der\ Paar",
"492384", "Welver",
"4933367", "Friedrichswalde\ Brandenburg",
"492404", "Alsdorf\ Rheinland",
"4937298", "Oelsnitz\ Erzgebirge",
"498265", "Pfaffenhausen\ Schwaben",
"492773", "Haiger",
"492449", "Blankenheim\ Ahr",
"496593", "Hillesheim\ Eifel",
"492873", "Isselburg\-Werth",
"498023", "Bayrischzell",
"498464", "Dietfurt\ an\ der\ Altmühl",
"498860", "Bernbeuren",
"498622", "Tacherting\-Peterskirchen",
"492205", "Rösrath",
"49881", "Weilheim\ in\ Oberbayern",
"4939921", "Ankershagen",
"4937349", "Scheibenberg",
"49871", "Landshut",
"495468", "Bramsche\-Engter",
"492538", "Drensteinfurt\-Rinkerode",
"494954", "Moormerland",
"4936652", "Wurzbach",
"4936464", "Wormstedt",
"494286", "Gyhum",
"497946", "Bretzfeld",
"495041", "Springe\ Deister",
"492423", "Langerwehe",
"494805", "Schafstedt",
"4939226", "Hohenziatz",
"499734", "Burkardroth",
"494705", "Wremen",
"493361", "Fürstenwalde\ Spree",
"499834", "Theilenhofen",
"4937438", "Bad\ Brambach",
"498546", "Windorf\-Otterskirchen",
"499553", "Ebrach\ Oberfranken",
"494273", "Kirchdorf\ bei\ Sulingen",
"499081", "Nördlingen",
"4938231", "Barth",
"494364", "Dahme\ Kreis\ Ostholstein",
"492064", "Dinslaken",
"492183", "Rommerskirchen",
"498091", "Kirchseeon",
"495155", "Emmerthal",
"496855", "Freisen",
"496755", "Odernheim\ am\ Glan",
"495192", "Munster",
"492572", "Emsdetten",
"497130", "Löwenstein\ Württemberg",
"4938234", "Born\ Darss",
"499336", "Bütthard",
"497021", "Kirchheim\ unter\ Teck",
"495926", "Engden",
"494766", "Basdahl",
"496587", "Zerf",
"4938876", "Roggendorf",
"4935365", "Falkenberg\ Elster",
"492545", "Rosendahl\-Darfeld",
"4936461", "Bad\ Sulza",
"492689", "Dierdorf",
"498142", "Olching",
"499345", "Külsheim\ Baden",
"4933084", "Gutengermendorf",
"494527", "Bosau",
"494339", "Christiansholm",
"496003", "Rosbach\ von\ der\ Höhe",
"4935725", "Wittichenau",
"4933878", "Nennhausen",
"495466", "Merzen",
"499869", "Wettringen\ Mittelfranken",
"4935455", "Walddrehna",
"492536", "Münster\-Albachten",
"4936603", "Weida",
"4938223", "Saal\ Vorpom",
"499372", "Klingenberg\ am\ Main",
"497229", "Iffezheim",
"493338", "Bernau\ Brandenburg",
"499289", "Schwarzenbach\ am\ Wald",
"492268", "Kürten",
"493907", "Gardelegen",
"4934383", "Trebsen\ Mulde",
"499631", "Tirschenreuth",
"492353", "Halver",
"497935", "Schrozberg",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"493605", "Leinefelde",
"498241", "Buchloe",
"497570", "Sigmaringen\-Gutenstein",
"498208", "Eurasburg\ bei\ Augsburg",
"497503", "Wilhelmsdorf\ Württemberg",
"49531", "Braunschweig",
"495204", "Steinhagen\ Westfalen",
"492963", "Brilon\-Messinghausen",
"498535", "Haarbach",
"4933436", "Prötzel",
"492132", "Meerbusch\-Büderich",
"496226", "Meckesheim",
"499338", "Röttingen\ Unterfranken",
"4934495", "Dobitschen",
"4938735", "Plau\ am\ See",
"493372", "Jüterbog",
"4936941", "Wasungen",
"4933457", "Altreetz",
"493869", "Dümmer",
"4936481", "Neustadt\ an\ der\ Orla",
"499666", "Illschwang",
"4936082", "Ershausen",
"495065", "Sibbesse",
"4935385", "Annaburg",
"495223", "Bünde",
"496737", "Köngernheim",
"497524", "Bad\ Waldsee",
"494768", "Hipstedt",
"496837", "Wallerfangen",
"495137", "Seelze",
"494976", "Spiekeroog",
"496375", "Wallhalben",
"494288", "Horstedt\ Kreis\ Rotenburg",
"496024", "Schöllkrippen",
"497948", "Öhringen\-Ohrnberg",
"492154", "Willich",
"494634", "Husby",
"499605", "Weiherhammer",
"4936484", "Knau\ bei\ Pössneck",
"495431", "Quakenbrück",
"492561", "Ahaus",
"495544", "Reinhardshagen",
"493631", "Nordhausen\ Thüringen",
"497243", "Ettlingen",
"497802", "Oberkirch\ Baden",
"4933845", "Borkheide",
"497702", "Blumberg\ Baden",
"4936944", "Rentwertshausen",
"499907", "Zenting",
"495509", "Rosdorf\ Kreis\ Göttingen",
"498501", "Thyrnau",
"4939933", "Vollrathsruhe",
"496342", "Schweigen\-Rechtenbach",
"498548", "Vilshofen\-Sandbach",
"496353", "Freinsheim",
"4939453", "Derenburg",
"497252", "Bretten",
"499321", "Kitzingen",
"494123", "Barmstedt",
"495931", "Meppen",
"496268", "Hüffenhardt",
"494237", "Bendingbostel",
"497448", "Seewald",
"495732", "Löhne",
"494483", "Ovelgönne\-Grossenmeer",
"496132", "Ingelheim\ am\ Rhein",
"495832", "Hankensbüttel",
"492226", "Rheinbach",
"4939723", "Krien",
"497327", "Dischingen",
"499407", "Wenzenbach",
"495428", "Melle\-Neuenkirchen",
"499148", "Ettenstatt",
"498424", "Nassenfels",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"494303", "Schlesen",
"499101", "Langenzenn",
"496039", "Karben",
"4933458", "Falkenberg\ Mark",
"497381", "Münsingen",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"4937366", "Rübenau",
"498063", "Feldkirchen\-Westerham",
"495347", "Burgdorf\ bei\ Salzgitter",
"493628", "Arnstadt",
"496888", "Lebach\-Steinbach",
"496536", "Kleinich",
"492602", "Montabaur",
"498225", "Jettingen\-Scheppach",
"499194", "Ebermannstadt",
"496788", "Sien",
"496154", "Ober\-Ramstadt",
"4939383", "Sandau\ Elbe",
"495854", "Bleckede\-Barskamp",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"494643", "Gelting\ Angeln",
"495754", "Extertal\-Bremke",
"496561", "Bitburg",
"497435", "Albstadt\-Laufen",
"494497", "Barssel\-Harkebrügge",
"492375", "Balve",
"495905", "Beesten",
"4939080", "Kalbe\ Milde",
"498403", "Pförring",
"498858", "Kochel\-Walchensee",
"4938750", "Malliss",
"494324", "Brokstedt",
"493321", "Nauen\ Brandenburg",
"4936252", "Tambach\-Dietharz",
"4939884", "Hassleben\ bei\ Prenzlau",
"492463", "Titz",
"497234", "Tiefenbronn",
"495533", "Bodenwerder",
"495607", "Fuldatal",
"495356", "Helmstedt\-Barmke",
"494149", "Fredenbeck",
"498376", "Sulzberg\ Allgäu",
"499628", "Ursensollen",
"4939881", "Ringenwalde\ bei\ Templin",
"4933877", "Nitzahn",
"494104", "Aumühle\ bei\ Hamburg",
"499135", "Hessdorf\ Mittelfranken",
"494826", "Hohenlockstedt",
"4935935", "Kleinwelka",
"492737", "Netphen\-Deuz",
"498383", "Grünenbach\ Allgäu",
"495966", "Meppen\-Apeldorn",
"492837", "Weeze",
"494191", "Kaltenkirchen\ Holstein",
"499393", "Rothenfels\ Unterfranken",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"492354", "Meinerzhagen",
"4933932", "Fehrbellin",
"4936625", "Langenwetzendorf",
"493576", "Weisswasser",
"4938205", "Tessin\ bei\ Rostock",
"4939601", "Friedland",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"4938780", "Lanz\ Brandenburg",
"496175", "Friedrichsdorf\ Taunus",
"495875", "Emmendorf",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"495941", "Neuenhaus\ Dinkel",
"497046", "Zaberfeld",
"495908", "Wietmarschen\-Lohne",
"492378", "Fröndenberg\-Langschede",
"495775", "Diepenau",
"4939050", "Bartensleben",
"494247", "Affinghausen",
"4936373", "Buttstädt",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"495742", "Preussisch\ Oldendorf",
"493583", "Zittau",
"497504", "Horgenzell",
"495203", "Werther\ Westfalen",
"496142", "Rüsselsheim",
"492964", "Brilon\-Alme",
"495842", "Schnega",
"497685", "Gutach\-Bleibach",
"498250", "Hilgertshausen\-Tandern",
"4939854", "Kleptow",
"495026", "Steimbke",
"4939851", "Göritz\ bei\ Prenzlau",
"499625", "Kastl\ bei\ Amberg",
"4939395", "Wanzer",
"492856", "Hamminkeln\-Brünen",
"496004", "Lich\-Eberstadt",
"496049", "Kefenrod",
"4938466", "Jürgenshagen",
"495337", "Kissenbrück",
"49761", "Freiburg\ im\ Breisgau",
"499262", "Wallenfels",
"495529", "Rhumspringe",
"499927", "Kirchberg\ Wald",
"4936871", "Bad\ Colberg\-Heldburg",
"497722", "Triberg\ im\ Schwarzwald",
"4939604", "Wildberg\ bei\ Altentreptow",
"497822", "Ettenheim",
"497660", "St\ Peter\ Schwarzwald",
"4939483", "Ballenstedt",
"496023", "Alzenau\ in\ Unterfranken",
"498593", "Untergriesbach",
"492153", "Nettetal\-Lobberich",
"493981", "Neustrelitz",
"494633", "Satrup",
"4933765", "Märkisch\ Buchholz",
"4938827", "Kalkhorst",
"497445", "Pfalzgrafenweiler",
"496265", "Billigheim\ Baden",
"4935606", "Briesen\ bei\ Cottbus",
"4938320", "Tribsees",
"49511", "Hannover",
"49681", "Saarbrücken",
"497472", "Rottenburg\ am\ Neckar",
"4936259", "Tabarz\ Thüringer\ Wald",
"49671", "Bad\ Kreuznach",
"4937320", "Mulda\ Sachsen",
"492332", "Gevelsberg",
"494256", "Hilgermissen",
"4933835", "Golzow\ bei\ Brandenburg",
"496622", "Bebra",
"496464", "Angelburg",
"495543", "Staufenberg\ Niedersachsen",
"497244", "Weingarten\ Baden",
"499576", "Lichtenfels\-Isling",
"4933872", "Hohennauen",
"492671", "Cochem",
"495425", "Borgholzhausen",
"494139", "Hohnstorf\ Elbe",
"4936257", "Luisenthal\ Thüringen",
"499145", "Solnhofen",
"496557", "Hallschlag",
"492747", "Molzhain",
"496206", "Lampertheim",
"4933470", "Lietzen",
"499172", "Georgensgmünd",
"4935243", "Weinböhla",
"495224", "Enger\ Westfalen",
"496785", "Herrstein",
"495185", "Duingen",
"49421", "Bremen",
"498423", "Titting",
"4939035", "Kuhfelde",
"495925", "Wietmarschen",
"499335", "Aub\ Kreis\ Würzburg",
"494260", "Visselhövede\-Wittorf",
"498176", "Egling\ bei\ Wolfratshausen",
"4936258", "Friemar",
"494349", "Dänischenhagen",
"493394", "Wittstock\ Dosse",
"495156", "Coppenbrügge",
"496856", "St\ Wendel\-Niederkirchen",
"496756", "Winterbach\ Soonwald",
"4935891", "Rothenburg\ OL",
"492546", "Coesfeld\-Lette",
"499193", "Höchstadt\ an\ der\ Aisch",
"495068", "Elze\ Leine",
"4936451", "Buttelstedt",
"4935842", "Oderwitz",
"493301", "Oranienburg",
"494765", "Ebersdorf\ bei\ Bremervörde",
"498064", "Au\ bei\ Bad\ Aibling",
"494865", "Osterhever",
"492175", "Leichlingen\ Rheinland",
"494806", "Sarzbüttel",
"494124", "Glückstadt",
"495552", "Katlenburg",
"498572", "Tann\ Niederbayern",
"494706", "Schiffdorf",
"4936454", "Magdala",
"497771", "Stockach",
"499608", "Kohlberg\ Oberpfalz",
"497945", "Wüstenrot",
"4935894", "Hähnichen",
"499641", "Grafenwöhr",
"494285", "Rhade\ bei\ Zeven",
"4938828", "Schönberg",
"498231", "Königsbrunn\ bei\ Augsburg",
"497972", "Gschwend\ bei\ Gaildorf",
"49335", "Frankfurt\ \(Oder\)",
"494484", "Hude\-Wüsting",
"498545", "Hofkirchen\ Bayern",
"495681", "Homberg\ Efze",
"499777", "Ostheim\ von\ der\ Rhön",
"4933336", "Passow\ Kreis\ Uckermark",
"4933054", "Liebenwalde",
"499348", "Werbach\-Gamburg",
"492557", "Wettringen\ Kreis\ Steinfurt",
"494103", "Wedel",
"496659", "Eichenzell",
"498266", "Kirchheim\ in\ Schwaben",
"499187", "Altdorf\ bei\ Nürnberg",
"499427", "Leiblfing",
"497307", "Senden\ Iller",
"499394", "Esselbach",
"4935476", "Wittmannsdorf\-Bückchen",
"492206", "Overath",
"496747", "Emmelshausen",
"493335", "Finowfurt",
"497181", "Schorndorf\ Württemberg",
"495147", "Uetze\-Hänigsen",
"4934604", "Niemberg",
"498384", "Röthenbach\ Allgäu",
"4934601", "Teutschenthal",
"494609", "Eggebek",
"494323", "Bornhöved",
"492265", "Reichshof\-Eckenhagen",
"4939245", "Loburg",
"493877", "Wittenberge",
"4936087", "Wüstheuterode",
"498404", "Oberdolling",
"498773", "Neufahrn\ in\ Niederbayern",
"494644", "Karby",
"497938", "Mulfingen\ Jagst",
"495753", "Auetal\-Bernsen",
"495441", "Diepholz",
"497656", "Schluchsee",
"495853", "Neu\ Darchau",
"498205", "Dasing",
"493641", "Jena",
"497233", "Niefern\-Öschelbronn",
"492464", "Aldenhoven\ bei\ Jülich",
"492622", "Bendorf\ am\ Rhein",
"495534", "Eschershausen\ an\ der\ Lenne",
"497127", "Neckartenzlingen",
"49281", "Wesel",
"498538", "Pocking\-Hartkirchen",
"4933452", "Neulewin",
"496332", "Zweibrücken",
"499481", "Pfatter",
"4933051", "Nassenheide",
"49271", "Siegen",
"495882", "Gorleben",
"496182", "Seligenstadt",
"494433", "Dötlingen",
"4933846", "Dippmannsdorf",
"499775", "Schönau\ an\ der\ Brend",
"499908", "Schöfweg",
"4939454", "Elbingerode\ Harz",
"497645", "Freiamt",
"499875", "Wolframs\-Eschenbach",
"497073", "Ammerbuch",
"499941", "Kötzting",
"498547", "Osterhofen\-Gergweis",
"499203", "Neudrossenfeld",
"497672", "St\ Blasien",
"499842", "Uffenheim",
"4939724", "Klein\ Bünzow",
"499742", "Kalbach\ Rhön",
"494287", "Heeslingen\-Boitzen",
"497947", "Forchtenberg",
"499270", "Creussen",
"496422", "Kirchhain",
"494550", "Bühnsdorf",
"496664", "Sinntal\-Sterbfritz",
"4936072", "Weissenborn\-Lüderode",
"498134", "Odelzhausen",
"497331", "Geislingen\ an\ der\ Steige",
"4935386", "Prettin",
"492471", "Roetgen\ Eifel",
"495625", "Naumburg\ Hessen",
"4939721", "Liepen\ bei\ Anklam",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"494767", "Bremervörde\-Bevern",
"4935439", "Zinnitz",
"496838", "Saarwellingen",
"496586", "Beuren\ Hochwald",
"495138", "Sehnde",
"499337", "Gaukönigshofen",
"495262", "Extertal",
"4938782", "Reetz\ bei\ Perleberg",
"499529", "Oberaurach",
"4939052", "Erxleben\ bei\ Haldensleben",
"496500", "Waldrach",
"4938736", "Goldberg",
"494221", "Delmenhorst",
"4939451", "Wasserleben",
"4934496", "Nöbdenitz",
"493425", "Wurzen",
"496573", "Gillenfeld",
"497125", "Bad\ Urach",
"4938757", "Neustadt\-Glewe",
"4937757", "Rittersgrün",
"4939087", "Jerchel\ Altmark",
"494293", "Ottersberg\-Fischerhude",
"498207", "Affing",
"4933472", "Golzow\ bei\ Seelow",
"494944", "Wiesmoor",
"495583", "Braunlage\-Hohegeiss",
"492721", "Lennestadt",
"495051", "Bergen\ Kreis\ Celle",
"492821", "Kleve\ Niederrhein",
"498071", "Wasserburg\ am\ Inn",
"4933435", "Rehfelde",
"4939384", "Arendsee\ Altmark",
"493941", "Halberstadt",
"492922", "Werl",
"492267", "Wipperfürth",
"4939883", "Gross\ Dölln",
"49911", "Nuremberg",
"499543", "Hirschaid",
"498556", "Haidmühle",
"497366", "Abtsgmünd",
"4939997", "Jarmen",
"492196", "Wermelskirchen",
"497485", "Empfingen",
"4938427", "Blowatz",
"4935456", "Terpt",
"4939999", "Tutow",
"4938429", "Glasin",
"497305", "Erbach\ Donau",
"4933870", "Zollchow\ bei\ Rathenow",
"498333", "Babenhausen\ Schwaben",
"4938322", "Richtenberg",
"495145", "Beedenbostel",
"493337", "Biesenthal\ Brandenburg",
"496745", "Gondershausen",
"4937322", "Brand\-Erbisdorf",
"493529", "Heidenau\ Sachsen",
"496772", "Nastätten",
"492555", "Schöppingen",
"49741", "Rottweil",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"492592", "Selm",
"496872", "Losheim\ am\ See",
"495172", "Ilsede",
"498152", "Herrsching\ am\ Ammersee",
"494528", "Schönwalde\ am\ Bungsberg",
"499185", "Mühlhausen\ Oberpfalz",
"4938759", "Tewswoos",
"4935726", "Gross\ Särchen",
"4939089", "Bismark\ Altmark",
"497764", "Herrischried",
"497621", "Lörrach",
"499925", "Bayerisch\ Eisenstein",
"49851", "Passau",
"495335", "Schladen",
"492738", "Netphen",
"492838", "Sonsbeck",
"492586", "Beelen",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"498143", "Inning\ am\ Ammersee",
"496471", "Weilburg",
"499627", "Freudenberg\ Oberpfalz",
"4934381", "Colditz",
"492573", "Nordwalde",
"49791", "Schwäbisch\ Hall",
"496893", "Saarbrücken\-Ensheim",
"495193", "Schneverdingen",
"4938224", "Gresenhorst",
"4936604", "Münchenbernsdorf",
"4935936", "Sohland\ Spree",
"499552", "Burghaslach",
"4939088", "Letzlingen",
"4938221", "Marlow",
"4936601", "Hermsdorf\ Thüringen",
"4938758", "Dömitz",
"494272", "Siedenburg",
"494409", "Westerstede\-Ocholt",
"498649", "Schleching",
"492182", "Grevenbroich\-Kapellen",
"494740", "Loxstedt\-Dedesdorf",
"495641", "Warburg",
"497456", "Haiterbach",
"4934384", "Grossbothen",
"494444", "Goldenstedt",
"498585", "Grainet",
"495608", "Söhrewald",
"494531", "Bad\ Oldesloe",
"492664", "Rennerod",
"493441", "Zeitz",
"492422", "Kreuzau",
"499681", "Windischeschenbach",
"494498", "Saterland\-Ramsloh",
"494245", "Neuenkirchen\ bei\ Bassum",
"4938428", "Hohenkirchen\ bei\ Wismar",
"495777", "Diepenau\-Essern",
"4939998", "Loitz\ bei\ Demmin",
"498857", "Benediktbeuern",
"4935876", "Weissenberg\ Sachsen",
"498623", "Kirchweidach",
"492845", "Neukirchen\-Vluyn",
"495301", "Lehre\-Essenrode",
"492971", "Schmallenberg\-Dorlar",
"492745", "Brachbach\ Sieg",
"4937365", "Sayda",
"498344", "Westendorf\ bei\ Kaufbeuren",
"4939931", "Röbel\ Müritz",
"495187", "Delligsen",
"496887", "Schmelz\ Saar",
"497141", "Ludwigsburg\ Württemberg",
"4934721", "Nienburg\ Saale",
"496787", "Niederbrombach",
"4933602", "Alt\ Zeschdorf",
"492369", "Dorsten\-Wulfen",
"495427", "Melle\-Buer",
"496555", "Bleialf",
"499147", "Nennslingen",
"492772", "Herborn\ Hessen",
"498022", "Tegernsee",
"492872", "Rhede\ Westfalen",
"493925", "Stassfurt",
"496592", "Daun",
"496721", "Bingen\ am\ Rhein",
"4936483", "Ziegenrück",
"494162", "Jork",
"493681", "Suhl",
"494933", "Dornum\ Ostfriesland",
"496821", "Neunkirchen\ Saar",
"495121", "Hildesheim",
"499441", "Kelheim",
"499853", "Wilburgstetten",
"497055", "Neuweiler\ Kreis\ Calw",
"498846", "Uffing\ am\ Staffelsee",
"497328", "Königsbronn",
"499408", "Altenthann",
"494505", "Stockelsdorf\-Curau",
"496196", "Bad\ Soden\ am\ Taunus",
"499499", "Painten",
"4936943", "Bettenhausen\ Thüringen",
"499534", "Burgpreppach",
"4939934", "Gross\ Plasten",
"495481", "Lengerich\ Westfalen",
"496267", "Fahrenbach\ Baden",
"497447", "Baiersbronn\-Schwarzenberg",
"494238", "Neddenaverbergen",
"494684", "Langeness\ Hallig",
"495345", "Baddeckenstedt",
"492801", "Xanten",
"494929", "Ihlow\ Kreis\ Aurich",
"498133", "Haimhausen\ Oberbayern",
"4935342", "Mühlberg\ Elbe",
"498761", "Moosburg\ an\ der\ Isar",
"499385", "Kolitzheim",
"495769", "Steyerberg\-Voigtei",
"496574", "Hasborn",
"498861", "Schongau",
"499466", "Stamsried",
"4933478", "Gross\ Neuendorf",
"498395", "Tannheim\ Württemberg",
"493928", "Schönebeck\ Elbe",
"497562", "Isny\ im\ Allgäu",
"495372", "Meinersen",
"492902", "Warstein",
"496558", "Büdesheim\ Eifel",
"4935605", "Komptendorf",
"4935893", "Mücka",
"4936453", "Mellingen",
"498281", "Thannhausen\ Schwaben",
"495631", "Korbach",
"493544", "Luckau\ Brandenburg",
"4933836", "Butzow\ bei\ Brandenburg",
"499405", "Bad\ Abbach",
"498639", "Neumarkt\-Sankt\ Veit",
"497325", "Sontheim\ an\ der\ Brenz",
"494830", "Süderhastedt",
"494434", "Colnrade",
"496062", "Erbach\ Odenwald",
"496663", "Steinau\ an\ der\ Strasse",
"497166", "Adelberg",
"494541", "Ratzeburg",
"499360", "Thüngen",
"494508", "Krummesse",
"493431", "Döbeln",
"4933766", "Teupitz",
"494235", "Langwedel\-Etelsen",
"4938328", "Miltzow",
"49931", "Würzburg",
"499204", "Plankenfels",
"4937328", "Grossschirma",
"492835", "Issum",
"4933609", "Brieskow\-Finkenheerd",
"4937465", "Tannenbergsthal\ Vogtland",
"492735", "Neunkirchen\ Siegerl",
"499928", "Kirchdorf\ im\ Wald",
"498334", "Bad\ Grönenbach",
"493466", "Artern\ Unstrut",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"497131", "Heilbronn\ Neckar",
"493385", "Rathenow",
"4939396", "Neukirchen\ Altmark",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"496251", "Bensheim",
"497763", "Murg",
"496402", "Hungen",
"499223", "Rugendorf",
"4935952", "Grossröhrsdorf\ OL",
"4938788", "Gross\ Warnow",
"49331", "Potsdam",
"4939058", "Uthmöden",
"495584", "Hattorf\ am\ Harz",
"494943", "Grossefehn",
"495605", "Kaufungen\ Hessen",
"494294", "Riede\ Kreis\ Verden",
"499431", "Schwandorf",
"496382", "Lauterecken",
"4936626", "Auma",
"4938206", "Graal\-Müritz\ Seeheilbad",
"499080", "Harburg\ Schwaben",
"499544", "Baunach",
"4937206", "Frankenberg\ Sachsen",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"4933976", "Wutike",
"4933607", "Briesen\ Mark",
"494452", "Zetel\-Neuenburg",
"492377", "Wickede\ Ruhr",
"495907", "Geeste",
"494248", "Bassum\-Neubruchhausen",
"494495", "Friesoythe\-Thüle",
"494851", "Marne",
"494443", "Dinklage",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"495650", "Cornberg",
"4936873", "Themar",
"494779", "Freiburg\ Elbe",
"494751", "Otterndorf",
"498670", "Reischach\ Kreis\ Altötting",
"493533", "Elsterwerda",
"4938787", "Glöwen",
"497128", "Sonnenbühl",
"494362", "Heiligenhafen",
"495321", "Goslar",
"498537", "Bad\ Füssing\-Aigen",
"499931", "Plattling",
"497635", "Schliengen",
"4939853", "Holzendorf\ bei\ Prenzlau",
"499832", "Wassertrüdingen",
"499732", "Hammelburg",
"4939246", "Lindau\ Anh",
"4936077", "Grossbodungen",
"492663", "Westerburg\ Westerwald",
"495407", "Wallenhorst",
"496396", "Hinterweidenthal",
"497937", "Dörzbach",
"4936374", "Weissensee",
"4933608", "Jacobsdorf\ Mark",
"494952", "Rhauderfehn",
"499428", "Kirchroth",
"498144", "Grafrath",
"4936371", "Schlossvippach",
"497308", "Nersingen",
"4935475", "Straupitz",
"495101", "Pattensen",
"496848", "Homburg\-Einöd",
"495148", "Steinhorst\ Niedersachsen",
"496701", "Sprendlingen\ Rheinhessen",
"493966", "Cölpin",
"499347", "Wittighausen",
"4939603", "Burg\ Stargard",
"492558", "Horstmar",
"4939059", "Wegenstedt",
"492574", "Saerbeck",
"495194", "Bispingen",
"496894", "St\ Ingbert",
"4938789", "Wolfshagen\ bei\ Perleberg",
"499188", "Postbauer\-Heng",
"494525", "Ahrensbök",
"4935241", "Lommatzsch",
"492382", "Ahlen\ Westfalen",
"4933479", "Küstrin\-Kietz",
"499854", "Wittelshofen",
"494934", "Marienhafe",
"4939484", "Harzgerode",
"4933335", "Pinnow\ Kreis\ Uckermark",
"499778", "Fladungen",
"499905", "Bernried\ Niederbayern",
"492520", "Wadersloh\-Diestedde",
"494683", "Oldsum",
"493931", "Stendal",
"4937327", "Rechenberg\-Bienenmühle",
"499607", "Luhe\-Wildenau",
"499533", "Untermerzbach",
"4938327", "Elmenhorst\ Vorpom",
"4937329", "Grosshartmannsdorf",
"497150", "Korntal\-Münchingen",
"499356", "Burgsinn",
"498343", "Aitrang",
"495067", "Bockenem",
"495135", "Burgwedel\-Fuhrberg",
"496835", "Beckingen",
"4938422", "Neukloster",
"496735", "Eppelsheim",
"4937422", "Markneukirchen",
"4939992", "Görmin",
"498624", "Obing",
"498462", "Berching",
"499966", "Wiesenfelden",
"4939481", "Hedersleben\ bei\ Aschersleben",
"4937752", "Eibenstock",
"4939082", "Mieste",
"494189", "Undeloh",
"4939036", "Binde",
"4938752", "Zierzow\ bei\ Ludwigslust",
"492402", "Stolberg\ Rheinland",
"492251", "Euskirchen",
"4933477", "Trebnitz\ bei\ Müncheberg",
"4935244", "Krögis",
"495422", "Melle",
"495664", "Morschen",
"494461", "Jever",
"4933206", "Fichtenwalde",
"498027", "Dietramszell",
"4937607", "Ebersbrunn\ Sachsen",
"496597", "Jünkerath",
"499142", "Treuchtlingen",
"492777", "Breitscheid\ Hessen",
"499175", "Spalt",
"49371", "Chemnitz\ Sachsen",
"4938859", "Alt\ Zachun",
"49381", "Rostock",
"4935826", "Königshain\ bei\ Görlitz",
"4934771", "Querfurt",
"496782", "Birkenfeld\ Nahe",
"492608", "Welschneudorf",
"495182", "Gronau\ Leine",
"493464", "Sangerhausen",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"493622", "Waltershausen\ Thüringen",
"498336", "Erkheim",
"493860", "Raben\ Steinfeld",
"498553", "Spiegelau",
"499546", "Burgebrach",
"497363", "Lauchheim",
"492193", "Dabringhausen",
"497274", "Germersheim",
"495573", "Uslar\-Volpriehausen",
"498081", "Dorfen\ Stadt",
"4934774", "Röblingen\ am\ See",
"497442", "Baiersbronn",
"499091", "Monheim\ Schwaben",
"496262", "Aglasterhausen",
"497258", "Oberderdingen\-Flehingen",
"4937609", "Wolkenburg\ Mulde",
"496138", "Mommenheim",
"495586", "Wieda",
"495838", "Gross\ Oesingen",
"497475", "Burladingen",
"494167", "Apensen",
"492335", "Wetter\ Ruhr",
"497953", "Blaufelden",
"498734", "Reisbach\ Niederbayern",
"496625", "Niederaula",
"494296", "Schwanewede\-Aschwarden",
"499622", "Hirschau\ Oberpfalz",
"4939821", "Carpin",
"499464", "Walderbach",
"4936693", "Crossen\ an\ der\ Elster",
"497220", "Forbach\-Hundsbach",
"49981", "Ansbach",
"49971", "Bad\ Kissingen",
"496051", "Gelnhausen",
"499265", "Pressig",
"496583", "Palzem",
"4935362", "Schönewalde\ bei\ Herzberg",
"497725", "Königsfeld\ im\ Schwarzwald",
"494330", "Emkendorf",
"497825", "Kippenheim",
"497579", "Schwenningen\ Baden",
"492427", "Nideggen",
"498361", "Nesselwang",
"497551", "Überlingen\ Bodensee",
"497083", "Bad\ Herrenalb",
"492394", "Neuenrade\-Affeln",
"4939323", "Schönhausen\ Elbe",
"497164", "Boll\ Kreis\ Göppingen",
"499206", "Mistelgau\-Obernsees",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"495872", "Stoetze",
"495772", "Espelkamp",
"498752", "Au\ in\ der\ Hallertau",
"4933746", "Werbig\ bei\ Jüterbog",
"494277", "Schwaförden",
"495745", "Stemwede\-Levern",
"499280", "Selbitz\ Oberfranken",
"495971", "Rheine",
"492301", "Holzwickede",
"495845", "Bergen\ Dumme",
"496145", "Flörsheim\ am\ Main",
"497682", "Elzach",
"4939824", "Hohenzieritz",
"493546", "Lübben\ Spreewald",
"492262", "Wiehl",
"492927", "Neuengeseke",
"493671", "Saalfeld\ Saale",
"498202", "Althegnenberg",
"492625", "Ochtendung",
"499856", "Dürrwangen",
"495471", "Bohmte",
"495459", "Hörstel",
"4934632", "Mücheln\ Geiseltal",
"494674", "Ockholm",
"498743", "Geisenhausen",
"493847", "Sternberg",
"494936", "Grossheide",
"496335", "Trulben",
"4935200", "Arnsdorf\ bei\ Dresden",
"498157", "Feldafing",
"492597", "Senden\ Westfalen",
"495177", "Edemissen\-Abbensen",
"499964", "Stallwang",
"492981", "Winterberg\ Westfalen",
"4935264", "Strehla",
"499354", "Rieneck",
"494140", "Estorf\ Kreis\ Stade",
"494563", "Scharbeutz\-Haffkrug",
"496641", "Lauterbach\ Hessen",
"493332", "Schwedt\/Oder",
"499378", "Eichenbühl\-Riedern",
"4938372", "Usedom",
"4939266", "Förderstedt",
"495592", "Gleichen\-Bremke",
"499747", "Geroda\ Bayern",
"4939774", "Mönkebude",
"499847", "Ergersheim",
"495555", "Moringen\-Fredelsloh",
"4936424", "Kahla\ Thüringen",
"496427", "Cölbe\-Schönstadt",
"496394", "Bundenthal",
"4938858", "Lassahn",
"494282", "Sittensen",
"497942", "Neuenstein\ Württemberg",
"497841", "Achern",
"499671", "Oberviechtach",
"499659", "Leuchtenberg",
"497975", "Untergröningen",
"497708", "Geisingen\-Leipferdingen",
"497453", "Altensteig\ Württemberg",
"497808", "Hohberg\ bei\ Offenburg",
"497741", "Tiengen\ Hochrhein",
"496187", "Schöneck",
"498542", "Ortenburg",
"4934783", "Gerbstedt",
"496348", "Offenbach\ an\ der\ Queich",
"496301", "Otterbach\ Pfalz",
"494961", "Papenburg",
"493378", "Ludwigsfelde",
"495922", "Bad\ Bentheim",
"499332", "Marktbreit",
"4937608", "Waldenburg\ Sachsen",
"495196", "Wietzendorf",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"4939405", "Hötensleben",
"4936421", "Camburg",
"4936022", "Grossengottern",
"499153", "Schnaittach",
"498146", "Moorenweis",
"494351", "Eckernförde",
"492051", "Velbert",
"493964", "Bredenfelde\ bei\ Strasburg",
"494762", "Kutenholz",
"495821", "Bad\ Bevensen",
"4939771", "Ueckermünde",
"495721", "Stadthagen",
"492583", "Sassenberg",
"494862", "Garding",
"4935696", "Briesnig",
"496372", "Bruchmühlbach\-Miesau",
"4934423", "Heuckewalde",
"498161", "Freising",
"4933633", "Spreenhagen",
"4938377", "Zinnowitz",
"496869", "Merzig\-Silwingen",
"499602", "Neustadt\ an\ der\ Waldnaab",
"497364", "Oberkochen",
"498554", "Schönberg\ Niederbayern",
"497273", "Hagenbach\ Pfalz",
"495574", "Oberweser",
"4936784", "Stützerbach",
"497805", "Appenweier",
"498733", "Mengkofen",
"492387", "Drensteinfurt\-Walstedde",
"497705", "Wolterdingen\ Schwarzw",
"499070", "Tapfheim",
"4934639", "Wallendorf\ Luppe",
"497954", "Kirchberg\ an\ der\ Jagst",
"496345", "Albersweiler",
"494946", "Grossefehn\-Bagband",
"493737", "Rochlitz",
"4934637", "Frankleben",
"493375", "Königs\ Wusterhausen",
"492407", "Herzogenrath\-Kohlscheid",
"495663", "Spangenberg",
"4936781", "Grossbreitenbach",
"4938379", "Benz\ Usedom",
"495062", "Holle\ bei\ Hildesheim",
"496631", "Alsfeld",
"493342", "Neuenhagen\ bei\ Berlin",
"498467", "Kinding",
"4937435", "Reuth\ bei\ Plauen",
"4936027", "Lengenfeld\ Unterm\ Stein",
"499737", "Wartmannsroth",
"499837", "Haundorf",
"496666", "Freiensteinau",
"497084", "Schömberg\ bei\ Neuenbürg",
"492393", "Sundern\-Allendorf",
"494957", "Detern",
"497163", "Ebersbach\ an\ der\ Fils",
"4935793", "Elstra",
"498271", "Meitingen",
"497932", "Niederstetten\ Württemberg",
"498259", "Schiltberg",
"495251", "Paderborn",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"4938295", "Satow\ bei\ Bad\ Doberan",
"497831", "Hausach",
"492628", "Rhens",
"497731", "Singen\ Hohentwiel",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"4937295", "Lugau\ Erzgebirge",
"496338", "Hornbach\ Pfalz",
"498532", "Griesbach\ im\ Rottal",
"494367", "Grossenbrode",
"499342", "Wertheim",
"495520", "Braunlage",
"4935755", "Ortrand",
"497669", "St\ Märgen",
"499463", "Wald\ Oberpfalz",
"498136", "Markt\ Indersdorf",
"495382", "Bad\ Gandersheim",
"496584", "Wellen\ Mosel",
"4936029", "Menteroda",
"499375", "Freudenberg\ Baden",
"493561", "Guben",
"496407", "Rabenau\ Hessen",
"499963", "Konzell",
"499132", "Herzogenaurach",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"499268", "Teuschnitz",
"496650", "Hosenfeld",
"494564", "Schashagen",
"498346", "Pforzen",
"499353", "Karlstadt",
"494151", "Schwarzenbek",
"492631", "Neuwied",
"49202", "Wuppertal",
"494179", "Winsen\-Tönnhausen",
"497728", "Niedereschach",
"4938852", "Wittenburg",
"4936963", "Dorndorf\ Rhön",
"4933926", "Herzberg\ Mark",
"499536", "Kirchlauter",
"4936028", "Kammerforst\ Thüringen",
"497432", "Albstadt\-Tailfingen",
"492372", "Hemer",
"495902", "Freren",
"4938720", "Grebbin",
"495848", "Trebel",
"4938450", "Tarnow\ bei\ Bützow",
"4934691", "Könnern",
"498709", "Eching\ Niederbayern",
"496101", "Bad\ Vilbel",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"498809", "Wessobrunn",
"498744", "Gerzen",
"494673", "Joldelund",
"496387", "Sankt\ Julian",
"4937602", "Kirchberg\ Sachsen",
"4934638", "Zöschen",
"4936640", "Remptendorf",
"498665", "Inzell",
"495377", "Ehra\-Lessien",
"497567", "Leutkirch\-Friesenhofen",
"492584", "Warendorf\-Milte",
"493963", "Woldegk",
"499178", "Abenberg\ Mittelfranken",
"494340", "Achterwehr",
"494269", "Ahausen\-Kirchwalsede",
"499154", "Pommelsbrunn",
"492605", "Löf",
"499561", "Coburg",
"498222", "Burgau\ Schwaben",
"496393", "Fischbach\ bei\ Dahn",
"492666", "Freilingen\ Westerwald",
"4939423", "Wegeleben",
"497255", "Graben\-Neudorf",
"4938378", "Heringsdorf\ Seebad",
"492338", "Breckerfeld",
"497478", "Hirrlingen",
"496135", "Bodenheim\ Rhein",
"495835", "Wahrenholz",
"4939753", "Strasburg",
"494446", "Bakum\ Kreis\ Vechta",
"496628", "Oberaula",
"497454", "Sulz\ am\ Neckar",
"497246", "Malsch\ Kreis\ Karlsruhe",
"495602", "Hessisch\ Lichtenau",
"496385", "Reichenbach\-Steegen",
"499574", "Marktzeuln",
"494254", "Eystrup",
"4934324", "Ostrau\ Sachsen",
"496466", "Dautphetal\-Friedensdorf",
"492428", "Niederzier",
"4935209", "Mohorn",
"494973", "Wittmund\-Burhafe",
"494455", "Jade\-Schweiburg",
"4939222", "Möser",
"4933745", "Petkus",
"4938488", "Demen",
"494492", "Saterland",
"492832", "Kevelaer",
"495226", "Bruchmühlen\ Westfalen",
"49631", "Kaiserslautern",
"492732", "Kreuztal",
"496204", "Viernheim",
"4935263", "Gröditz\ bei\ Riesa",
"4938872", "Rehna",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"496249", "Guntersblum",
"4935207", "Moritzburg",
"493382", "Lehnin",
"496405", "Laubach\ Hessen",
"4934321", "Leisnig",
"496291", "Adelsheim",
"492931", "Arnsberg",
"497506", "Wangen\-Leupolz",
"495837", "Sprakensehl",
"4936423", "Orlamünde",
"494168", "Neu\ Wulmstorf\-Elstorf",
"496223", "Neckargemünd",
"499251", "Münchberg",
"497322", "Giengen\ an\ der\ Brenz",
"499279", "Mistelgau",
"499402", "Regenstauf",
"494559", "Wensin",
"4939773", "Altwarp",
"493574", "Lauchhammer",
"494232", "Langwedel\ Kreis\ Verden",
"497257", "Bruchsal\-Untergrombach",
"497044", "Mönsheim",
"4935825", "Kodersdorf",
"496509", "Büdlich",
"4934781", "Greifenhagen",
"492607", "Kobern\-Gondorf",
"492533", "Münster\-Nienberge",
"496544", "Rhaunen",
"496431", "Limburg\ an\ der\ Lahn",
"499382", "Gerolzhofen",
"492754", "Bad\ Laasphe\-Feudingen",
"493663", "Schleiz",
"4933205", "Michendorf",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"498392", "Markt\ Rettenbach",
"498028", "Fischbachau",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"498667", "Seeon\-Seebruck",
"492905", "Bestwig\-Ramsbeck",
"495375", "Müden\ Aller",
"492778", "Siegbach",
"499396", "Urspringen\ bei\ Lohr",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"4939406", "Harbke",
"492360", "Haltern\-Lippramsdorf",
"4937600", "Neumark\ Sachsen",
"496832", "Beckingen\-Reimsbach",
"495132", "Lehrte",
"4938452", "Lalendorf",
"498386", "Oberstaufen",
"496732", "Wörrstadt",
"492204", "Bensberg",
"49231", "Dortmund",
"498465", "Kipfenberg",
"495963", "Bawinkel",
"493377", "Zossen\ Brandenburg",
"494723", "Cuxhaven\-Altenwalde",
"494823", "Wilster",
"4938722", "Raduhn",
"495353", "Königslutter\ am\ Elm",
"498373", "Altusried",
"492405", "Würselen",
"492291", "Waldbröl",
"497707", "Bräunlingen",
"492385", "Hamm\-Rhynern",
"497807", "Neuried\ Ortenaukreis",
"496188", "Kahl\ am\ Main",
"4938850", "Gammelin",
"495536", "Holzminden\-Neuhaus",
"493735", "Marienberg\ Sachsen",
"496347", "Hochstadt\ Pfalz",
"4934773", "Schwittersdorf",
"498784", "Hohenthann",
"499748", "Motten",
"498406", "Böhmfeld",
"498031", "Rosenheim\ Oberbayern",
"4939265", "Löderburg",
"499848", "Simmershofen",
"499701", "Sandberg\ Unterfranken",
"497654", "Löffingen",
"496428", "Stadtallendorf",
"494646", "Mohrkirch",
"49375", "Zwickau",
"496533", "Morbach\ Hunsrück",
"49385", "Schwerin",
"4935208", "Radeburg",
"4937382", "Geringswalde",
"4936694", "Schkölen\ Thüringen",
"499377", "Freudenberg\-Boxtal",
"4933967", "Freyenstein",
"492509", "Nottuln\-Appelhülsen",
"498066", "Bad\ Feilnbach",
"498158", "Tutzing",
"492598", "Senden\-Ottmarsbocholt",
"4934909", "Aken\ Elbe",
"4939321", "Arneburg",
"497371", "Riedlingen\ Württemberg",
"496754", "Martinstein",
"495561", "Einbeck",
"4935775", "Pechern",
"492431", "Erkelenz",
"494522", "Plön",
"495154", "Aerzen",
"496854", "Oberthal\ Saar",
"494791", "Osterholz\-Scharmbeck",
"492065", "Duisburg\-Rheinhausen",
"4939324", "Kläden\ bei\ Stendal",
"494365", "Heringsdorf\ Holstein",
"492137", "Neuss\-Norf",
"494486", "Edewecht\-Friedrichsfehn",
"497632", "Badenweiler",
"492223", "Königswinter",
"4934907", "Jeber\-Bergfrieden",
"4939823", "Rechlin",
"499835", "Ehingen\ Mittelfranken",
"497033", "Weil\ Der\ Stadt",
"494126", "Horst\ Holstein",
"494704", "Drangstedt",
"493902", "Diesdorf\ Altm",
"499735", "Massbach",
"4933969", "Stepenitz",
"492928", "Soest\-Ostönnen",
"4936691", "Eisenberg\ Thüringen",
"494804", "Nordhastedt",
"498640", "Reit\ Im\ Winkl",
"494749", "Schiffdorf\-Geestenseth",
"494473", "Emstek",
"496356", "Carlsberg\ Pfalz",
"494849", "Hooge",
"4934222", "Arzberg\ bei\ Torgau",
"494955", "Westoverledingen",
"4936642", "Harra",
"4938845", "Kaarssen",
"499422", "Bogen\ Niederbayern",
"4938459", "Laage",
"499664", "Hahnbach",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"492681", "Altenkirchen\ Westerwald",
"496203", "Ladenburg",
"496842", "Blieskastel",
"495142", "Eschede",
"4938352", "Kemnitz\ bei\ Greifswald",
"496742", "Boppard",
"492552", "Steinfurt\-Borghorst",
"496775", "Strüth\ Taunus",
"4936961", "Bad\ Liebenstein",
"498192", "Schondorf\ am\ Ammersee",
"496875", "Nonnweiler\-Primstal",
"495175", "Lehrte\-Arpke",
"492595", "Olfen",
"499182", "Velburg",
"4938729", "Marnitz",
"4935756", "Hosena",
"4938727", "Mestlin",
"499089", "Bissingen\-Unterringingen",
"497122", "St\ Johann\ Württemberg",
"494253", "Asendorf\ Kreis\ Diepholz",
"4938296", "Rerik\ Ostseebad",
"4937296", "Stollberg\ Erzgebirge",
"495546", "Scheden",
"492627", "Braubach",
"499573", "Staffelstein\ Oberfranken",
"496337", "Grossbundenbach",
"493745", "Falkenstein\ Vogtland",
"4936964", "Dermbach\ Rhön",
"493971", "Anklam",
"492925", "Warstein\-Allagen",
"498041", "Bad\ Tölz",
"499738", "Rottershausen",
"493772", "Schneeberg\ Erzgebirge",
"494974", "Neuharlingersiel",
"494958", "Jemgum",
"496026", "Grossostheim",
"497482", "Horb\-Dettingen",
"4938457", "Krakow\ am\ See",
"494636", "Langballig",
"492156", "Willich\-Anrath",
"496543", "Büchenbeuren",
"494661", "Niebüll",
"492534", "Münster\-Roxel",
"495622", "Fritzlar",
"495464", "Alfhausen",
"4936647", "Saalburg\ Thüringen",
"498468", "Altmannstein\-Pondorf",
"49571", "Minden\ Westfalen",
"4939751", "Penkun",
"4937436", "Weischlitz",
"4938482", "Warin",
"49581", "Uelzen",
"49611", "Wiesbaden",
"495265", "Dörentrup",
"4939421", "Osterwieck",
"492441", "Kall",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"492853", "Schermbeck",
"492408", "Aachen\-Kornelimünster",
"494920", "Wirdum",
"492753", "Erndtebrück",
"496185", "Hammersbach\ Hessen",
"499369", "Uettingen",
"492388", "Hamm\-Uentrop",
"497977", "Oberrot\ bei\ Gaildorf",
"499772", "Bischofsheim\ an\ der\ Rhön",
"496224", "Sandhausen\ Baden",
"493586", "Neugersdorf\ Sachsen",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"493838", "Bergen\ auf\ Rügen",
"495206", "Bielefeld\-Jöllenbeck",
"497642", "Endingen\ Kaiserstuhl",
"499872", "Heilsbronn",
"499971", "Cham",
"497675", "Bernau\ Baden",
"499845", "Oberdachstetten",
"4935695", "Simmersdorf",
"497043", "Maulbronn",
"4936649", "Gefell\ bei\ Schleiz",
"4939754", "Löcknitz\ Vorpom",
"499745", "Wildflecken",
"493573", "Senftenberg",
"498630", "Oberneukirchen",
"4933962", "Heiligengrabe",
"496425", "Rauschenberg\ Hessen",
"494839", "Wöhrden\ Dithmarschen",
"498783", "Rohr\ in\ Niederbayern",
"492337", "Hagen\-Dahl",
"497477", "Jungingen\ bei\ Hechingen",
"494165", "Hollenstedt\ Nordheide",
"492529", "Oelde\-Stromberg",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"4938370", "Kröslin",
"496068", "Beerfelden",
"497052", "Bad\ Liebenzell",
"497236", "Keltern",
"496627", "Nentershausen\ Hessen",
"4934424", "Reuden\ bei\ Zeitz",
"494502", "Lübeck\-Travemünde",
"497653", "Lenzkirch",
"499471", "Burglengenfeld",
"493592", "Kirschau",
"4935202", "Klingenberg\ Sachsen",
"494326", "Wankendorf",
"4936783", "Gehren\ Thüringen",
"492203", "Cologne\-Porz",
"496681", "Hilders",
"493821", "Ribnitz\-Damgarten",
"495964", "Lähden",
"492842", "Kamp\-Lintfort",
"494180", "Königsmoor",
"492742", "Wissen",
"499177", "Heideck",
"493721", "Meinersdorf",
"4936648", "Dittersdorf\ bei\ Schleiz",
"496239", "Bobenheim\-Roxheim",
"497159", "Renningen",
"497171", "Schwäbisch\ Gmünd",
"495354", "Jerxheim",
"498263", "Breitenbrunn\ Schwaben",
"498374", "Dietmannsried",
"494824", "Krempe",
"495378", "Sassenburg\-Platendorf",
"492775", "Driedorf",
"496552", "Olzheim",
"497568", "Bad\ Wurzach\-Hauerz",
"4933631", "Bad\ Saarow\-Pieskow",
"496595", "Dockweiler",
"492941", "Lippstadt",
"494724", "Cuxhaven\-Lüdingworth",
"498025", "Miesbach",
"494106", "Quickborn\ Kreis\ Pinneberg",
"496147", "Trebur",
"499555", "Schlüsselfeld\-Aschbach",
"492224", "Bad\ Honnef",
"4933366", "Chorin",
"494275", "Ehrenburg",
"4938728", "Domsühl",
"493471", "Bernburg\ Saale",
"498582", "Röhrnbach",
"4936020", "Ebeleben",
"494474", "Garrel",
"4933925", "Wustrau\-Altfriesack",
"492425", "Nideggen\-Embken",
"495671", "Hofgeismar",
"494770", "Wischhafen",
"495659", "Ringgau",
"498651", "Bad\ Reichenhall",
"498679", "Burgkirchen\ an\ der\ Alz",
"494242", "Syke",
"4938458", "Zehna",
"494803", "Pahlen",
"497034", "Ehningen",
"494458", "Wiefelstede\-Spohle",
"498320", "Missen\-Wilhams",
"494703", "Loxstedt\-Donnern",
"499922", "Zwiesel",
"4937346", "Geyer",
"495332", "Schöppenstedt",
"499267", "Nordhalben",
"49211", "Düsseldorf",
"492543", "Billerbeck\ Westfalen",
"499196", "Wiesenttal",
"497727", "Vöhrenbach",
"496534", "Mülheim\ Mosel",
"496441", "Wetzlar",
"496853", "Marpingen",
"495153", "Salzhemmendorf",
"496408", "Buseck",
"496753", "Meisenheim",
"497261", "Sinsheim",
"499721", "Schweinfurt",
"498426", "Walting\ Kreis\ Eichstätt",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;