/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.spring.beans.refactoring;

import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;

/**
 *
 * @author abadea
 */
public class AttributeValueFinder {

    private final XMLSyntaxSupport xmlSupport;
    private final int start;

    private int foundOffset = -1;
    private String foundValue;

    public AttributeValueFinder(SyntaxSupport syntaxSupport, int start) {
        this.start = start;
        this.xmlSupport = XMLSyntaxSupport.getSyntaxSupport(syntaxSupport.getDocument());
    }

    public AttributeValueFinder(XMLSyntaxSupport syntaxSupport, int start) {
        this.start = start;
        this.xmlSupport = syntaxSupport;
    }

    public boolean find(String attrName) throws BadLocationException {
        foundOffset = -1;
        foundValue = null;
        if (xmlSupport == null) {
            return false;
        }
        Token<XMLTokenId> item = xmlSupport.getNextToken(start);
        if (item == null || item.id() != XMLTokenId.TAG) {
            return false;
        }
        return xmlSupport.runWithSequence(start, (TokenSequence s) -> {
            String currentAttrName = null;
            while (s.moveNext()) {
                Token<XMLTokenId> t = s.token();
                XMLTokenId id = t.id();
                if (id == XMLTokenId.ARGUMENT) {
                    currentAttrName = t.text().toString();
                } else if (id == XMLTokenId.VALUE) {
                    if (currentAttrName != null && currentAttrName.equals(attrName)) {
                        foundOffset = s.offset();
                        foundValue = t.text().toString();
                        return true;
                    }
                } else if (id == XMLTokenId.TAG) {
                    break;
                }
            }
            return false;
        });
    }

    public int getFoundOffset() {
        return foundOffset;
    }

    public String getValue() {
        return foundValue;
    }
}
