/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBufferImpl;
import java.nio.FloatBuffer;
import java.nio.FloatBufferImpl;

class ByteBufferAsFloatBuffer
extends FloatBufferImpl {
    ByteBufferAsFloatBuffer(ByteBufferImpl byteBufferImpl, int n, int n2) {
        super(byteBufferImpl, n, null, n2);
    }

    public FloatBuffer slice() {
        return new ByteBufferAsFloatBuffer(this.parent, this.limit - this.position, this.arrayOffset + (this.position << 2));
    }

    public boolean isDirect() {
        return false;
    }

    public float get(int n) {
        return this.parent.getFloat(this.arrayOffset + (this.checkIndex(n) << 2));
    }

    final void copyToArray(float[] fArray, int n, int n2) {
        int n3 = this.arrayOffset + (this.position << 2);
        for (int i = 0; i < n2; ++i) {
            fArray[n++] = this.parent.getFloat(n3);
            n3 += 4;
        }
    }

    public FloatBuffer put(int n, float f) {
        this.parent.putFloat(this.arrayOffset + (this.checkIndex(n) << 2), f);
        return this;
    }

    void copyFromArray(float[] fArray, int n, int n2) {
        int n3 = this.arrayOffset + (this.position << 2);
        for (int i = 0; i < n2; ++i) {
            this.parent.putFloat(n3, fArray[n++]);
            n3 += 4;
        }
    }

    void copyToFloatBuffer(int n, FloatBuffer floatBuffer) {
        floatBuffer.copyFromByteBufferAsFloatBuffer(this, n);
    }

    void copyFromHeapFloatBuffer(FloatBuffer floatBuffer, int n) {
        ByteBufferAsFloatBuffer.vanillaCopy(floatBuffer, this, n);
    }

    void copyFromByteBufferAsFloatBuffer(FloatBuffer floatBuffer, int n) {
        System.arraycopy(floatBuffer.parent.array, floatBuffer.parent.arrayOffset + (floatBuffer.position << 2), this.parent.array, this.parent.arrayOffset + (this.position << 2), n << 2);
    }

    void copyFromDirectFloatBuffer(FloatBuffer floatBuffer, int n) {
        byte[] byArray = this.parent.array;
        int n2 = this.parent.arrayOffset + this.arrayOffset + (this.position << 2);
        int n3 = floatBuffer.arrayOffset + (floatBuffer.position << 2);
        ByteBufferImpl.memoryToByteArray(n3, byArray, n2, n << 2);
    }
}

