//start of LhaChecksum.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * LhaChecksum.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.util.zip.Checksum;

//import exceptions

/**
 * LHAŎgp P 1oCg̃`FbNTl
 * Zo邽߂̃NXB
 * 
 * <pre>
 * -- revision history --
 * $Log: LhaChecksum.java,v $
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [maintanance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.0 $
 */
public class LhaChecksum implements Checksum{


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  private int checksum
    //------------------------------------------------------------------
    /** 
     * `FbNTl
     */
    private int checksum;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  public LhaChecksum()
    //------------------------------------------------------------------
    /**
     * V `FbNTNX쐬B
     */
    public LhaChecksum(){
        super();
        this.reset();
    }


    //------------------------------------------------------------------
    //  method of java.util.zip.Checksum method
    //------------------------------------------------------------------
    //  update
    //------------------------------------------------------------------
    //  public void update( int byte8 )
    //  public void update( byte[] buffer )
    //  public void update( byte[] buffer, int index, int length )
    //------------------------------------------------------------------
    /**
     * byte8 Ŏw肵 1oCg̃f[^ `FbNTlXVB
     *
     * @param byte8 `FbNTXV1oCg̃f[^
     */
    public void update( int byte8 ){
        this.checksum += byte8;
    }

    /**
     * buffer Ŏw肵oCgz `FbNTlXVB
     * ̃\bh
     *   update( buffer, 0, buffer.length ) 
     * ƓB
     * 
     * @param buffer `FbNTXVf[^oCgz
     */
    public void update( byte[] buffer ){
        this.update( buffer, 0, buffer.length );
    }

    /**
     * buffer Ŏw肵oCgz `FbNTlXVB
     * 
     * @param buffer `FbNTXVf[^oCgz
     * @param index  f[^̊Jnʒu
     * @param length `FbNT̍XVɎgoCg
     */
    public void update( byte[] buffer, int index, int length ){
        while( 0 < length-- )
            this.checksum += buffer[index++];
    }


    //------------------------------------------------------------------
    //  method of java.util.zip.Checksum
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public void reset()
    //  public long getValue()
    //------------------------------------------------------------------
    /**
     * `FbNTllɐݒ肵ȂB
     */
    public void reset(){
        this.checksum = 0;
    }

    /**
     * `FbNTl𓾂B
     * `FbNTl 1oCg̒lłA 
     * 0x00`0xFFɃ}bvB
     * 
     * @return `FbNTl
     */
    public long getValue(){
        return this.checksum & 0xFF;
    }

}
//end of LhaChecksum.java
