// $Id: DeadlockException.java 3152 2006-12-11 21:14:35Z genman $

/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 * Created on Jan 18, 2003
 */
package org.jboss.cache.lock;


/**
 * Used when a lock acquisition would cause a deadlock. This will only be used
 * once deadlock detection is in place.
 *
 * @author Bela Ban
 * @version $Revision: 3152 $
 */
public class DeadlockException extends LockingException
{

   private static final long serialVersionUID = 8651993450626741020L;

   /**
    * Constructor for DeadlockException.
    *
    * @param msg
    */
   public DeadlockException(String msg)
   {
      super(msg);
   }

   public DeadlockException(String msg, Throwable cause)
   {
      super(msg, cause);
   }


}
