/*
 *  @(#)IIssueTypeInfo.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1;

 

/**
 * Information about the owning problem manager.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:51:54 $
 * @since      July 7, 2002
 */
public interface IIssueTypeInfo
{
    
    /**
     * Returns the type name.
     */
    public String getName();
    
    
    /**
     * Returns all states for the current issue type.
     */
    public IIssueState[] getPossibleStates();
    
    
    /**
     * Returns all attributes allowed for an issue of this type.
     */
    public IAttributeInfo[] getSupportedAttributes();
    
    
    /**
     * Returns the state that refer to the associated tests passing.  Allows
     * for multiple states, for situations such as marked-as-fixed and
     * tests pass, or still-open but tests pass.
     */
    public IIssueState[] getTestPassedStates();
    
    
    /**
     * Returns the state that refer to the associated tests failing.  Allows
     * for multiple states, for situations such as marked-as-fixed but
     * tests fail, or still-open but tests fail.
     */
    public IIssueState[] getTestFailedStates();
}

