import unittest
from support import GNATCOLL_TestCase, chdir, pathsep, requires_not_aix


class Test(GNATCOLL_TestCase):
    @chdir("json1")
    def test_json1(self):
        self.gprbuild()
        self.runexec("test_all", "test.out")

    @chdir("M605-001")
    def test_M605_001(self):
        self.gprbuild()
        self.runexec("read", "test.expected")

    @chdir("M626_041")
    def test_M626_041(self):
        self.gprbuild()
        self.runexec("obj/json_test", "test.out")

    @requires_not_aix    # Storage_Error on that machine
    @chdir("MB28-001")
    def test_MB28_001(self):
        self.runexec(["python", "make_json.py"])
        self.gprbuild()
        self.runexec("json_stack_test", "test.out")

    @chdir("utf8")
    def test_utf8(self):
        self.gprbuild()
        self.runexec("obj/json_utf8", "")

    @chdir("P120-002")
    def test_P120_002(self):
        self.gprbuild()
        self.runexec("obj/test_clone", "test.out")

    @chdir("P208_003")
    def test_P208_003(self):
        self.gprbuild()
        self.runexec("obj/test_unset", "test.out")

    # A test for tasking. Before we used atomic counters for the smart
    # pointers in GNATCOLL.JSON, this test would regularly access freed
    # memory.
    @chdir("P401-004")
    def test_P401_004(self):
        self.gprbuild()
        for j in range(0, 30):
            self.runexec("obj/smart", "")
