/******************************************************************
 *  $Id: ex2.c,v 1.1 2004/06/02 11:20:49 snowdrop Exp $
 *
 * CSOAP Project:  A SOAP client/server library in C
 * Copyright (C) 2003  Ferhat Ayaz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 * 
 * Email: ayaz@jprogrammet.net
 ******************************************************************/


/* This header will be generated by xsd2c */
#include "Person_xsd.h"

 /* For stdout writers */
#include "../utils.h"



int main(int argc, char *argv[])
{
  struct Person* person;   /* object created by xsd2c */
  struct Address* address; /* object created by xsd2c */

  /* Create both objects */
  address = Address_Create();
  person = Person_Create();

  /* Set some address data */
  Address_Set_Street(address, "XsdStreet");
  Address_Set_StreetNum(address, "12-A");
  Address_Set_City(address, "Paris");
  Address_Set_Zip(address, 12345);
  Address_Set_Land(address, "France");

  /* Set some person data */
  Person_Set_attr_id(person, "id0001");
  Person_Set_Name(person, "John");
  Person_Set_Lastname(person, "Smith");
  Person_Set_Degree(person, 34);
  Person_Add_Project(person, "csoap");
  Person_Add_Project(person, "xsd2c");
  Person_Set_Address(person, address);

  /* Serialize the Person object. 
    The 3 sax callback functions 
    will just print the data to stdout
  */
  Person_Sax_Serialize(person, "Employee", 
    Writer_StartElement, 
    Writer_Characters,
    Writer_EndElement, 0);

  /* Free both objects */
  Person_Free(person);
  Address_Free(address);

	return 0;
}
