/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.PrintConsumer;
import gnu.mapping.CharArrayOutPort;
import gnu.mapping.OutPort;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public abstract class AbstractFormat
extends Format {
    protected void write(String str, Consumer out) {
        out.write(str);
    }

    public void write(int v, Consumer out) {
        out.write(v);
    }

    public void writeLong(long v, Consumer out) {
        out.writeLong(v);
    }

    public void writeInt(int i, Consumer out) {
        this.writeLong(i, out);
    }

    public void writeBoolean(boolean v, Consumer out) {
        out.writeBoolean(v);
    }

    public void startElement(Object type, Consumer out) {
        this.write("(", out);
        this.write(type.toString(), out);
        this.write(" ", out);
    }

    public void endElement(Consumer out) {
        this.write(")", out);
    }

    public void startAttribute(Object attrType, Consumer out) {
        this.write(attrType.toString(), out);
        this.write(": ", out);
    }

    public void endAttribute(Consumer out) {
        this.write(" ", out);
    }

    public abstract void writeObject(Object var1, Consumer var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(Object value, Consumer out) {
        if (out instanceof OutPort) {
            OutPort pout = (OutPort)out;
            AbstractFormat saveFormat = pout.objectFormat;
            try {
                pout.objectFormat = this;
                out.writeObject(value);
            }
            finally {
                pout.objectFormat = saveFormat;
            }
        } else {
            out.writeObject(value);
        }
    }

    public final void writeObject(Object obj, PrintConsumer out) {
        this.writeObject(obj, (Consumer)out);
    }

    public final void writeObject(Object obj, Writer out) {
        if (out instanceof Consumer) {
            this.writeObject(obj, (Consumer)((Object)out));
        } else {
            OutPort port = new OutPort(out, false, true);
            this.writeObject(obj, (Consumer)((Object)out));
            port.close();
        }
    }

    public StringBuffer format(Object val, StringBuffer sbuf, FieldPosition fpos) {
        CharArrayOutPort out = new CharArrayOutPort();
        this.writeObject(val, out);
        sbuf.append(out.toCharArray());
        out.close();
        return sbuf;
    }

    public Object parseObject(String text, ParsePosition status) {
        throw new Error(this.getClass().getName() + ".parseObject - not implemented");
    }
}

