#!/usr/bin/python
#--
# Copyright (C) 2013 Harald Sitter <apachelogger@ubuntu.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License or (at your option) version 3 or any later version
# accepted by the membership of KDE e.V. (or its successor approved
# by the membership of KDE e.V.), which shall act as a proxy
# defined in Section 14 of version 3 of the license.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#--

import sys
from launchpadlib.launchpad import Launchpad

lp = Launchpad.login_with('kubuntu-l10n', 'production')

team = lp.people['kubuntu-packagers']
project = lp.projects['kubuntu-packaging']
branches = project.getBranches()

branchlist_file = open('branchlist','w')
for branch in branches:
    # Filter out non-official branches.
    if lp.load(branch.owner_link) != team:
        continue

    # Also filter l10n working branches and other stuff we definitely do not
    # need to look at.
    if "-l10n-" in branch.name or "language-pack" in branch.name or "oxygen-icons" in branch.name or "qtwebkit" in branch.name or "kdeartwork" in branch.name or "meta-kde" == branch.name or "kde-wallpapers" == branch.name:
        continue

    # Also filter outdated branches.
    if branch.lifecycle_status == "Merged" or branch.lifecycle_status == "Abandoned":
        continue

    branchlist_file.write(branch.name + '\n')
