/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include<QWidget>
#include<QFrame>
#include<QString>
#include<QStringListModel>
#include<QLabel>
#include <QGridLayout>
#include <QPushButton>
#include <QDir>
#include <QListView>
#include <QStringList>
#include <QGroupBox>
#include <QMessageBox>
#include <QFileDialog>
#include <QFileSystemModel>
#include <QStandardItemModel>
#include <QFileIconProvider>
#include <QStandardItem>
#include <QList>
#include <QTimer>
#include <QSplitter>
#include <QDateTime>
#include "../../core/bean/os_characteristic.h"
#include "../../core/bean/folder.h"
#include "../../../commons/constants.h"
#include "../extend/drop_list_view.h"
#include "../../../commons/cd/change_dir.h"
#include "../../core/xml/xml_creator_client.h"

class ShareFiles : public QFrame
{
    Q_OBJECT
    public:
    ShareFiles(int clientNbr, OsCharacteristic *characteristics, QWidget *parent);


public slots:
    void doubleClicRemoteFolder();
    void doubleClicLocalFolder();
    void drop_local();
    void drop_remote();
    void refresh_view(Folder *folder);
    void refresh();
    void refresh_local_view();
    void remove_from_view(QString file_name, bool is_local);
signals:
    void showMessage(QString title, QString content, int duration);
    void send_to_server(QString msg);
    void ask_file_to_server(QString to, QString from, QString name);
    void send_file_to_server(QString to, QString from, QString name);
    void update_percent(int current, int total);

private:
    QLabel *localPath;
    QString localStringPath;
    QString remoteStringPath;
    OsCharacteristic *osInfo;
    QLabel *path;
    QLabel *remotePath;
    QStringListModel *remoteFilesModel;
    QStandardItemModel *remoteFilesIconModel;
    QList<QStandardItem *> *remoteFilesIconList;
    QStringList localFilesList;
    QStringList localFoldersList;
    QStringList *remoteFilesList;
    QStringList *remoteFoldersList;
    DropListView *remoteList;
    DropListView *localList;
    QPushButton *getButton;
    QPushButton *sendButton;
    QFileIconProvider *iconprovider;
    QString slash;
    int nbr;
    void displayLocalDirectoryContent(QStringList folders_list, QStringList files_list);
    void displayRemoteDirectoryContent(QStringList *folders_list, QStringList *files_list);
    QStringList* convert_QStandardItemModel_to_QStringList(QStandardItemModel *listModel, int len_2);
    QString track_delta(QStringList *previousList, QStringList *newList);
};


