/***************************************************************************
                          contactstatus.h
                             -------------------
    begin                : Saturday March 8th 2008
    copyright            : (C) 2008 by Richard Conway
    email                : richardconway1984 hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MSNSTATUS_H
#define MSNSTATUS_H

#include <QPixmap>


// Forward declarations
class KMenu;



/**
 * Available MSN states
 * @ingroup Contact
 */
enum Status
{
    STATUS_ONLINE          = 0  /// User is online
  , STATUS_BUSY                 /// User is busy
  , STATUS_AWAY                 /// User is away from the keyboard
  , STATUS_AWAY_AUTOREPLY       /// User is away with an automated answer
  , STATUS_IDLE                 /// User is idle
  , STATUS_BE_RIGHT_BACK        /// User is away for a bit
  , STATUS_ON_THE_PHONE         /// User is on the phone
  , STATUS_OUT_TO_LUNCH         /// User is eating
  , STATUS_INVISIBLE            /// User is not visible to others
  , STATUS_OFFLINE              /// User is not connected (keep this as the second last item of the enum)
  , STATES_NUMBER               /// Internal: do not use (keep this as the last item of the enum)
};


/**
 * Contact flags
 *
 * These can be used to apply icon overlays to the status icons
 * @ingroup Contact
 */
enum Flags
{
    FlagNone         = 0
  , FlagBlocked
  , FlagWebMessenger
  , FlagMobile
};


/**
 * Contact Status management class
 *
 * This class contains everything we need to manage the MSN states.
 * The main enumeration which contains the MSN states can be used
 * along the conversion methods, which translate the enum values to
 * string (the three letter character codes like NLN for Online) and
 * to localized strings (like "Out to lunch"). There's also a method
 * to translate the status values to the relative status icon.
 *
 * @author Valerio Pilo <valerio@kmess.org>
 * @author Richard Conway <richardconway1984 at hotmail.com>
 * @ingroup Contact
 */
class MsnStatus
{
  public: // Public static methods
    ~MsnStatus();

    // Returns an icon for a status
    static QPixmap  getIcon( const Status status, const Flags flags = FlagNone );
    // Returns the icon name for the specified status
    static QString           getIconName( const Status status );
    // Returns a three-letter code (like BSY) for a status
    static QString  getCode( const Status status );
    // Returns the localized name for a status
    static QString  getName( const Status status );
    // Create and return a menu with all the states
    static KMenu   *getStatusMenu();
    // Convert a three-letter code to a status
    static Status   codeToStatus( const QString &status );


  private: // Private static properties

    // The status menu
    static KMenu   *statusMenu_;
};


#endif
