
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMediaPlayer.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMediaPlayer>
#include <QVideoWidget>
#include <QGraphicsVideoItem>
#include <QMediaPlaylist>
#include <QAbstractVideoSurface>
#include <QMediaService>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMediaPlayer

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMediaPlayer::staticMetaObject);
}


// void QMediaPlayer::audioAvailableChanged(bool available)


static void _init_f_audioAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("available");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_audioAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->audioAvailableChanged (arg1);
}


// QMultimedia::AvailabilityStatus QMediaPlayer::availability()


static void _init_f_availability_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ();
}

static void _call_f_availability_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ((qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type)qt_gsi::CppToQtAdaptor<QMultimedia::AvailabilityStatus>(((QMediaPlayer *)cls)->availability ()));
}


// bool QMediaPlayer::bind(QObject *)


static void _init_f_bind_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_bind_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<bool > ((bool)((QMediaPlayer *)cls)->bind (arg1));
}


// int QMediaPlayer::bufferStatus()


static void _init_f_bufferStatus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_bufferStatus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayer *)cls)->bufferStatus ());
}


// void QMediaPlayer::bufferStatusChanged(int percentFilled)


static void _init_f_bufferStatusChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("percentFilled");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_bufferStatusChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->bufferStatusChanged (arg1);
}


// QMediaContent QMediaPlayer::currentMedia()


static void _init_f_currentMedia_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaContent > ();
}

static void _call_f_currentMedia_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaContent > ((QMediaContent)((QMediaPlayer *)cls)->currentMedia ());
}


// void QMediaPlayer::currentMediaChanged(const QMediaContent &media)


static void _init_f_currentMediaChanged_2605 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("media");
  decl->add_arg<const QMediaContent & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_currentMediaChanged_2605 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaContent &arg1 = gsi::arg_reader<const QMediaContent & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->currentMediaChanged (arg1);
}


// QNetworkConfiguration QMediaPlayer::currentNetworkConfiguration()


static void _init_f_currentNetworkConfiguration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkConfiguration > ();
}

static void _call_f_currentNetworkConfiguration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QNetworkConfiguration > ((QNetworkConfiguration)((QMediaPlayer *)cls)->currentNetworkConfiguration ());
}


// qint64 QMediaPlayer::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaPlayer *)cls)->duration ());
}


// void QMediaPlayer::durationChanged(qint64 duration)


static void _init_f_durationChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("duration");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_durationChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->durationChanged (arg1);
}


// QMediaPlayer::Error QMediaPlayer::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::Error>::target_type > ((qt_gsi::Converter<QMediaPlayer::Error>::target_type)qt_gsi::CppToQtAdaptor<QMediaPlayer::Error>(((QMediaPlayer *)cls)->error ()));
}


// void QMediaPlayer::error(QMediaPlayer::Error error)


static void _init_f_error_2256 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<const qt_gsi::Converter<QMediaPlayer::Error>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_error_2256 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaPlayer::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaPlayer::Error>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->error (qt_gsi::QtToCppAdaptor<QMediaPlayer::Error>(arg1).cref());
}


// QString QMediaPlayer::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QMediaPlayer *)cls)->errorString ());
}


// bool QMediaPlayer::isAudioAvailable()


static void _init_f_isAudioAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAudioAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayer *)cls)->isAudioAvailable ());
}


// bool QMediaPlayer::isMuted()


static void _init_f_isMuted_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMuted_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayer *)cls)->isMuted ());
}


// bool QMediaPlayer::isSeekable()


static void _init_f_isSeekable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSeekable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayer *)cls)->isSeekable ());
}


// bool QMediaPlayer::isVideoAvailable()


static void _init_f_isVideoAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isVideoAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayer *)cls)->isVideoAvailable ());
}


// QMediaContent QMediaPlayer::media()


static void _init_f_media_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaContent > ();
}

static void _call_f_media_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaContent > ((QMediaContent)((QMediaPlayer *)cls)->media ());
}


// void QMediaPlayer::mediaChanged(const QMediaContent &media)


static void _init_f_mediaChanged_2605 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("media");
  decl->add_arg<const QMediaContent & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mediaChanged_2605 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaContent &arg1 = gsi::arg_reader<const QMediaContent & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->mediaChanged (arg1);
}


// QMediaPlayer::MediaStatus QMediaPlayer::mediaStatus()


static void _init_f_mediaStatus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type > ();
}

static void _call_f_mediaStatus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type > ((qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type)qt_gsi::CppToQtAdaptor<QMediaPlayer::MediaStatus>(((QMediaPlayer *)cls)->mediaStatus ()));
}


// void QMediaPlayer::mediaStatusChanged(QMediaPlayer::MediaStatus status)


static void _init_f_mediaStatusChanged_2858 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("status");
  decl->add_arg<const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mediaStatusChanged_2858 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaPlayer::MediaStatus>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->mediaStatusChanged (qt_gsi::QtToCppAdaptor<QMediaPlayer::MediaStatus>(arg1).cref());
}


// const QIODevice *QMediaPlayer::mediaStream()


static void _init_f_mediaStream_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QIODevice * > ();
}

static void _call_f_mediaStream_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QIODevice * > ((const QIODevice *)((QMediaPlayer *)cls)->mediaStream ());
}


// void QMediaPlayer::mutedChanged(bool muted)


static void _init_f_mutedChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mutedChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->mutedChanged (arg1);
}


// void QMediaPlayer::networkConfigurationChanged(const QNetworkConfiguration &configuration)


static void _init_f_networkConfigurationChanged_3508 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("configuration");
  decl->add_arg<const QNetworkConfiguration & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_networkConfigurationChanged_3508 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkConfiguration &arg1 = gsi::arg_reader<const QNetworkConfiguration & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->networkConfigurationChanged (arg1);
}


// void QMediaPlayer::pause()


static void _init_f_pause_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_pause_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->pause ();
}


// void QMediaPlayer::play()


static void _init_f_play_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_play_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->play ();
}


// double QMediaPlayer::playbackRate()


static void _init_f_playbackRate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_playbackRate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QMediaPlayer *)cls)->playbackRate ());
}


// void QMediaPlayer::playbackRateChanged(double rate)


static void _init_f_playbackRateChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rate");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_playbackRateChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->playbackRateChanged (arg1);
}


// QMediaPlaylist *QMediaPlayer::playlist()


static void _init_f_playlist_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaPlaylist * > ();
}

static void _call_f_playlist_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaPlaylist * > ((QMediaPlaylist *)((QMediaPlayer *)cls)->playlist ());
}


// qint64 QMediaPlayer::position()


static void _init_f_position_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_position_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaPlayer *)cls)->position ());
}


// void QMediaPlayer::positionChanged(qint64 position)


static void _init_f_positionChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_positionChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->positionChanged (arg1);
}


// void QMediaPlayer::seekableChanged(bool seekable)


static void _init_f_seekableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("seekable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_seekableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->seekableChanged (arg1);
}


// void QMediaPlayer::setMedia(const QMediaContent &media, QIODevice *stream)


static void _init_f_setMedia_3944 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("media");
  decl->add_arg<const QMediaContent & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream", true, "0");
  decl->add_arg<QIODevice * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMedia_3944 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaContent &arg1 = gsi::arg_reader<const QMediaContent & >() (args, heap);
  QIODevice *arg2 = args ? gsi::arg_reader<QIODevice * >() (args, heap) : gsi::arg_maker<QIODevice * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setMedia (arg1, arg2);
}


// void QMediaPlayer::setMuted(bool muted)


static void _init_f_setMuted_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMuted_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setMuted (arg1);
}


// void QMediaPlayer::setNetworkConfigurations(const QList<QNetworkConfiguration> &configurations)


static void _init_f_setNetworkConfigurations_4123 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("configurations");
  decl->add_arg<const QList<QNetworkConfiguration> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNetworkConfigurations_4123 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QNetworkConfiguration> &arg1 = gsi::arg_reader<const QList<QNetworkConfiguration> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setNetworkConfigurations (arg1);
}


// void QMediaPlayer::setPlaybackRate(double rate)


static void _init_f_setPlaybackRate_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rate");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlaybackRate_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setPlaybackRate (arg1);
}


// void QMediaPlayer::setPlaylist(QMediaPlaylist *playlist)


static void _init_f_setPlaylist_2033 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("playlist");
  decl->add_arg<QMediaPlaylist * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlaylist_2033 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMediaPlaylist *arg1 = gsi::arg_reader<QMediaPlaylist * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setPlaylist (arg1);
}


// void QMediaPlayer::setPosition(qint64 position)


static void _init_f_setPosition_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPosition_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setPosition (arg1);
}


// void QMediaPlayer::setVideoOutput(QVideoWidget *)


static void _init_f_setVideoOutput_1818 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QVideoWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoOutput_1818 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QVideoWidget *arg1 = gsi::arg_reader<QVideoWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setVideoOutput (arg1);
}


// void QMediaPlayer::setVideoOutput(QGraphicsVideoItem *)


static void _init_f_setVideoOutput_2422 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QGraphicsVideoItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoOutput_2422 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsVideoItem *arg1 = gsi::arg_reader<QGraphicsVideoItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setVideoOutput (arg1);
}


// void QMediaPlayer::setVideoOutput(QAbstractVideoSurface *surface)


static void _init_f_setVideoOutput_2739 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("surface");
  decl->add_arg<QAbstractVideoSurface * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoOutput_2739 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractVideoSurface *arg1 = gsi::arg_reader<QAbstractVideoSurface * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setVideoOutput (arg1);
}


// void QMediaPlayer::setVolume(int volume)


static void _init_f_setVolume_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVolume_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->setVolume (arg1);
}


// QMediaPlayer::State QMediaPlayer::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaPlayer::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaPlayer::State>::target_type > ((qt_gsi::Converter<QMediaPlayer::State>::target_type)qt_gsi::CppToQtAdaptor<QMediaPlayer::State>(((QMediaPlayer *)cls)->state ()));
}


// void QMediaPlayer::stateChanged(QMediaPlayer::State newState)


static void _init_f_stateChanged_2247 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QMediaPlayer::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stateChanged_2247 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaPlayer::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaPlayer::State>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->stateChanged (qt_gsi::QtToCppAdaptor<QMediaPlayer::State>(arg1).cref());
}


// void QMediaPlayer::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->stop ();
}


// void QMediaPlayer::unbind(QObject *)


static void _init_f_unbind_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_unbind_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->unbind (arg1);
}


// void QMediaPlayer::videoAvailableChanged(bool videoAvailable)


static void _init_f_videoAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("videoAvailable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_videoAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->videoAvailableChanged (arg1);
}


// int QMediaPlayer::volume()


static void _init_f_volume_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_volume_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayer *)cls)->volume ());
}


// void QMediaPlayer::volumeChanged(int volume)


static void _init_f_volumeChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_volumeChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer *)cls)->volumeChanged (arg1);
}


// static QMultimedia::SupportEstimate QMediaPlayer::hasSupport(const QString &mimeType, const QStringList &codecs, QFlags<QMediaPlayer::Flag> flags)


static void _init_f_hasSupport_7054 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mimeType");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("codecs", true, "QStringList()");
  decl->add_arg<const QStringList & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "0");
  decl->add_arg<QFlags<QMediaPlayer::Flag> > (argspec_2);
  decl->set_return<qt_gsi::Converter<QMultimedia::SupportEstimate>::target_type > ();
}

static void _call_f_hasSupport_7054 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QStringList &arg2 = args ? gsi::arg_reader<const QStringList & >() (args, heap) : gsi::arg_maker<const QStringList & >() (QStringList(), heap);
  QFlags<QMediaPlayer::Flag> arg3 = args ? gsi::arg_reader<QFlags<QMediaPlayer::Flag> >() (args, heap) : gsi::arg_maker<QFlags<QMediaPlayer::Flag> >() (0, heap);
  ret.write<qt_gsi::Converter<QMultimedia::SupportEstimate>::target_type > ((qt_gsi::Converter<QMultimedia::SupportEstimate>::target_type)qt_gsi::CppToQtAdaptor<QMultimedia::SupportEstimate>(QMediaPlayer::hasSupport (arg1, arg2, arg3)));
}


// static QStringList QMediaPlayer::supportedMimeTypes(QFlags<QMediaPlayer::Flag> flags)


static void _init_f_supportedMimeTypes_2808 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags", true, "0");
  decl->add_arg<QFlags<QMediaPlayer::Flag> > (argspec_0);
  decl->set_return<QStringList > ();
}

static void _call_f_supportedMimeTypes_2808 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QMediaPlayer::Flag> arg1 = args ? gsi::arg_reader<QFlags<QMediaPlayer::Flag> >() (args, heap) : gsi::arg_maker<QFlags<QMediaPlayer::Flag> >() (0, heap);
  ret.write<QStringList > ((QStringList)QMediaPlayer::supportedMimeTypes (arg1));
}


// static QString QMediaPlayer::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaPlayer::tr (arg1, arg2, arg3));
}


// static QString QMediaPlayer::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaPlayer::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QMediaPlayer () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("audioAvailableChanged", "@brief Method void QMediaPlayer::audioAvailableChanged(bool available)\n", false, &_init_f_audioAvailableChanged_864, &_call_f_audioAvailableChanged_864);
  methods += new qt_gsi::GenericMethod ("availability", "@brief Method QMultimedia::AvailabilityStatus QMediaPlayer::availability()\nThis is a reimplementation of QMediaObject::availability", true, &_init_f_availability_c0, &_call_f_availability_c0);
  methods += new qt_gsi::GenericMethod ("bind", "@brief Method bool QMediaPlayer::bind(QObject *)\nThis is a reimplementation of QMediaObject::bind", false, &_init_f_bind_1302, &_call_f_bind_1302);
  methods += new qt_gsi::GenericMethod (":bufferStatus", "@brief Method int QMediaPlayer::bufferStatus()\n", true, &_init_f_bufferStatus_c0, &_call_f_bufferStatus_c0);
  methods += new qt_gsi::GenericMethod ("bufferStatusChanged", "@brief Method void QMediaPlayer::bufferStatusChanged(int percentFilled)\n", false, &_init_f_bufferStatusChanged_767, &_call_f_bufferStatusChanged_767);
  methods += new qt_gsi::GenericMethod (":currentMedia", "@brief Method QMediaContent QMediaPlayer::currentMedia()\n", true, &_init_f_currentMedia_c0, &_call_f_currentMedia_c0);
  methods += new qt_gsi::GenericMethod ("currentMediaChanged", "@brief Method void QMediaPlayer::currentMediaChanged(const QMediaContent &media)\n", false, &_init_f_currentMediaChanged_2605, &_call_f_currentMediaChanged_2605);
  methods += new qt_gsi::GenericMethod ("currentNetworkConfiguration", "@brief Method QNetworkConfiguration QMediaPlayer::currentNetworkConfiguration()\n", true, &_init_f_currentNetworkConfiguration_c0, &_call_f_currentNetworkConfiguration_c0);
  methods += new qt_gsi::GenericMethod (":duration", "@brief Method qint64 QMediaPlayer::duration()\n", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += new qt_gsi::GenericMethod ("durationChanged", "@brief Method void QMediaPlayer::durationChanged(qint64 duration)\n", false, &_init_f_durationChanged_986, &_call_f_durationChanged_986);
  methods += new qt_gsi::GenericMethod (":error", "@brief Method QMediaPlayer::Error QMediaPlayer::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("error_sig", "@brief Method void QMediaPlayer::error(QMediaPlayer::Error error)\n", false, &_init_f_error_2256, &_call_f_error_2256);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QMediaPlayer::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("isAudioAvailable?|:audioAvailable", "@brief Method bool QMediaPlayer::isAudioAvailable()\n", true, &_init_f_isAudioAvailable_c0, &_call_f_isAudioAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isMuted?|:muted", "@brief Method bool QMediaPlayer::isMuted()\n", true, &_init_f_isMuted_c0, &_call_f_isMuted_c0);
  methods += new qt_gsi::GenericMethod ("isSeekable?|:seekable", "@brief Method bool QMediaPlayer::isSeekable()\n", true, &_init_f_isSeekable_c0, &_call_f_isSeekable_c0);
  methods += new qt_gsi::GenericMethod ("isVideoAvailable?|:videoAvailable", "@brief Method bool QMediaPlayer::isVideoAvailable()\n", true, &_init_f_isVideoAvailable_c0, &_call_f_isVideoAvailable_c0);
  methods += new qt_gsi::GenericMethod (":media", "@brief Method QMediaContent QMediaPlayer::media()\n", true, &_init_f_media_c0, &_call_f_media_c0);
  methods += new qt_gsi::GenericMethod ("mediaChanged", "@brief Method void QMediaPlayer::mediaChanged(const QMediaContent &media)\n", false, &_init_f_mediaChanged_2605, &_call_f_mediaChanged_2605);
  methods += new qt_gsi::GenericMethod (":mediaStatus", "@brief Method QMediaPlayer::MediaStatus QMediaPlayer::mediaStatus()\n", true, &_init_f_mediaStatus_c0, &_call_f_mediaStatus_c0);
  methods += new qt_gsi::GenericMethod ("mediaStatusChanged", "@brief Method void QMediaPlayer::mediaStatusChanged(QMediaPlayer::MediaStatus status)\n", false, &_init_f_mediaStatusChanged_2858, &_call_f_mediaStatusChanged_2858);
  methods += new qt_gsi::GenericMethod ("mediaStream", "@brief Method const QIODevice *QMediaPlayer::mediaStream()\n", true, &_init_f_mediaStream_c0, &_call_f_mediaStream_c0);
  methods += new qt_gsi::GenericMethod ("mutedChanged", "@brief Method void QMediaPlayer::mutedChanged(bool muted)\n", false, &_init_f_mutedChanged_864, &_call_f_mutedChanged_864);
  methods += new qt_gsi::GenericMethod ("networkConfigurationChanged", "@brief Method void QMediaPlayer::networkConfigurationChanged(const QNetworkConfiguration &configuration)\n", false, &_init_f_networkConfigurationChanged_3508, &_call_f_networkConfigurationChanged_3508);
  methods += new qt_gsi::GenericMethod ("pause", "@brief Method void QMediaPlayer::pause()\n", false, &_init_f_pause_0, &_call_f_pause_0);
  methods += new qt_gsi::GenericMethod ("play", "@brief Method void QMediaPlayer::play()\n", false, &_init_f_play_0, &_call_f_play_0);
  methods += new qt_gsi::GenericMethod (":playbackRate", "@brief Method double QMediaPlayer::playbackRate()\n", true, &_init_f_playbackRate_c0, &_call_f_playbackRate_c0);
  methods += new qt_gsi::GenericMethod ("playbackRateChanged", "@brief Method void QMediaPlayer::playbackRateChanged(double rate)\n", false, &_init_f_playbackRateChanged_1071, &_call_f_playbackRateChanged_1071);
  methods += new qt_gsi::GenericMethod (":playlist", "@brief Method QMediaPlaylist *QMediaPlayer::playlist()\n", true, &_init_f_playlist_c0, &_call_f_playlist_c0);
  methods += new qt_gsi::GenericMethod (":position", "@brief Method qint64 QMediaPlayer::position()\n", true, &_init_f_position_c0, &_call_f_position_c0);
  methods += new qt_gsi::GenericMethod ("positionChanged", "@brief Method void QMediaPlayer::positionChanged(qint64 position)\n", false, &_init_f_positionChanged_986, &_call_f_positionChanged_986);
  methods += new qt_gsi::GenericMethod ("seekableChanged", "@brief Method void QMediaPlayer::seekableChanged(bool seekable)\n", false, &_init_f_seekableChanged_864, &_call_f_seekableChanged_864);
  methods += new qt_gsi::GenericMethod ("setMedia", "@brief Method void QMediaPlayer::setMedia(const QMediaContent &media, QIODevice *stream)\n", false, &_init_f_setMedia_3944, &_call_f_setMedia_3944);
  methods += new qt_gsi::GenericMethod ("setMuted|muted=", "@brief Method void QMediaPlayer::setMuted(bool muted)\n", false, &_init_f_setMuted_864, &_call_f_setMuted_864);
  methods += new qt_gsi::GenericMethod ("setNetworkConfigurations", "@brief Method void QMediaPlayer::setNetworkConfigurations(const QList<QNetworkConfiguration> &configurations)\n", false, &_init_f_setNetworkConfigurations_4123, &_call_f_setNetworkConfigurations_4123);
  methods += new qt_gsi::GenericMethod ("setPlaybackRate|playbackRate=", "@brief Method void QMediaPlayer::setPlaybackRate(double rate)\n", false, &_init_f_setPlaybackRate_1071, &_call_f_setPlaybackRate_1071);
  methods += new qt_gsi::GenericMethod ("setPlaylist|playlist=", "@brief Method void QMediaPlayer::setPlaylist(QMediaPlaylist *playlist)\n", false, &_init_f_setPlaylist_2033, &_call_f_setPlaylist_2033);
  methods += new qt_gsi::GenericMethod ("setPosition|position=", "@brief Method void QMediaPlayer::setPosition(qint64 position)\n", false, &_init_f_setPosition_986, &_call_f_setPosition_986);
  methods += new qt_gsi::GenericMethod ("setVideoOutput", "@brief Method void QMediaPlayer::setVideoOutput(QVideoWidget *)\n", false, &_init_f_setVideoOutput_1818, &_call_f_setVideoOutput_1818);
  methods += new qt_gsi::GenericMethod ("setVideoOutput", "@brief Method void QMediaPlayer::setVideoOutput(QGraphicsVideoItem *)\n", false, &_init_f_setVideoOutput_2422, &_call_f_setVideoOutput_2422);
  methods += new qt_gsi::GenericMethod ("setVideoOutput", "@brief Method void QMediaPlayer::setVideoOutput(QAbstractVideoSurface *surface)\n", false, &_init_f_setVideoOutput_2739, &_call_f_setVideoOutput_2739);
  methods += new qt_gsi::GenericMethod ("setVolume|volume=", "@brief Method void QMediaPlayer::setVolume(int volume)\n", false, &_init_f_setVolume_767, &_call_f_setVolume_767);
  methods += new qt_gsi::GenericMethod (":state", "@brief Method QMediaPlayer::State QMediaPlayer::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stateChanged", "@brief Method void QMediaPlayer::stateChanged(QMediaPlayer::State newState)\n", false, &_init_f_stateChanged_2247, &_call_f_stateChanged_2247);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QMediaPlayer::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod ("unbind", "@brief Method void QMediaPlayer::unbind(QObject *)\nThis is a reimplementation of QMediaObject::unbind", false, &_init_f_unbind_1302, &_call_f_unbind_1302);
  methods += new qt_gsi::GenericMethod ("videoAvailableChanged", "@brief Method void QMediaPlayer::videoAvailableChanged(bool videoAvailable)\n", false, &_init_f_videoAvailableChanged_864, &_call_f_videoAvailableChanged_864);
  methods += new qt_gsi::GenericMethod (":volume", "@brief Method int QMediaPlayer::volume()\n", true, &_init_f_volume_c0, &_call_f_volume_c0);
  methods += new qt_gsi::GenericMethod ("volumeChanged", "@brief Method void QMediaPlayer::volumeChanged(int volume)\n", false, &_init_f_volumeChanged_767, &_call_f_volumeChanged_767);
  methods += new qt_gsi::GenericStaticMethod ("hasSupport", "@brief Static method QMultimedia::SupportEstimate QMediaPlayer::hasSupport(const QString &mimeType, const QStringList &codecs, QFlags<QMediaPlayer::Flag> flags)\nThis method is static and can be called without an instance.", &_init_f_hasSupport_7054, &_call_f_hasSupport_7054);
  methods += new qt_gsi::GenericStaticMethod ("supportedMimeTypes", "@brief Static method QStringList QMediaPlayer::supportedMimeTypes(QFlags<QMediaPlayer::Flag> flags)\nThis method is static and can be called without an instance.", &_init_f_supportedMimeTypes_2808, &_call_f_supportedMimeTypes_2808);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMediaPlayer::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMediaPlayer::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaObject> &qtdecl_QMediaObject ();

qt_gsi::QtNativeClass<QMediaPlayer> decl_QMediaPlayer (qtdecl_QMediaObject (), "QtMultimedia", "QMediaPlayer_Native",
  methods_QMediaPlayer (),
  "@hide\n@alias QMediaPlayer");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QMediaPlayer> &qtdecl_QMediaPlayer () { return decl_QMediaPlayer; }

}


class QMediaPlayer_Adaptor : public QMediaPlayer, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMediaPlayer_Adaptor();

  //  [adaptor ctor] QMediaPlayer::QMediaPlayer(QObject *parent, QFlags<QMediaPlayer::Flag> flags)
  QMediaPlayer_Adaptor() : QMediaPlayer()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMediaPlayer::QMediaPlayer(QObject *parent, QFlags<QMediaPlayer::Flag> flags)
  QMediaPlayer_Adaptor(QObject *parent) : QMediaPlayer(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMediaPlayer::QMediaPlayer(QObject *parent, QFlags<QMediaPlayer::Flag> flags)
  QMediaPlayer_Adaptor(QObject *parent, QFlags<QMediaPlayer::Flag> flags) : QMediaPlayer(parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QMediaPlayer::addPropertyWatch(QByteArray const &name)
  void fp_QMediaPlayer_addPropertyWatch_2309 (QByteArray const &name) {
    QMediaPlayer::addPropertyWatch(name);
  }

  //  [expose] bool QMediaPlayer::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMediaPlayer_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMediaPlayer::isSignalConnected(signal);
  }

  //  [expose] int QMediaPlayer::receivers(const char *signal)
  int fp_QMediaPlayer_receivers_c1731 (const char *signal) const {
    return QMediaPlayer::receivers(signal);
  }

  //  [expose] void QMediaPlayer::removePropertyWatch(QByteArray const &name)
  void fp_QMediaPlayer_removePropertyWatch_2309 (QByteArray const &name) {
    QMediaPlayer::removePropertyWatch(name);
  }

  //  [expose] QObject *QMediaPlayer::sender()
  QObject * fp_QMediaPlayer_sender_c0 () const {
    return QMediaPlayer::sender();
  }

  //  [expose] int QMediaPlayer::senderSignalIndex()
  int fp_QMediaPlayer_senderSignalIndex_c0 () const {
    return QMediaPlayer::senderSignalIndex();
  }

  //  [adaptor impl] QMultimedia::AvailabilityStatus QMediaPlayer::availability()
  qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type cbs_availability_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QMultimedia::AvailabilityStatus>(QMediaPlayer::availability());
  }

  virtual QMultimedia::AvailabilityStatus availability() const
  {
    if (cb_availability_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QMultimedia::AvailabilityStatus>(cb_availability_c0_0.issue<QMediaPlayer_Adaptor, qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type>(&QMediaPlayer_Adaptor::cbs_availability_c0_0)).cref();
    } else {
      return QMediaPlayer::availability();
    }
  }

  //  [adaptor impl] bool QMediaPlayer::bind(QObject *)
  bool cbs_bind_1302_0(QObject *arg1)
  {
    return QMediaPlayer::bind(arg1);
  }

  virtual bool bind(QObject *arg1)
  {
    if (cb_bind_1302_0.can_issue()) {
      return cb_bind_1302_0.issue<QMediaPlayer_Adaptor, bool, QObject *>(&QMediaPlayer_Adaptor::cbs_bind_1302_0, arg1);
    } else {
      return QMediaPlayer::bind(arg1);
    }
  }

  //  [adaptor impl] bool QMediaPlayer::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QMediaPlayer::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMediaPlayer_Adaptor, bool, QEvent *>(&QMediaPlayer_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QMediaPlayer::event(arg1);
    }
  }

  //  [adaptor impl] bool QMediaPlayer::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QMediaPlayer::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMediaPlayer_Adaptor, bool, QObject *, QEvent *>(&QMediaPlayer_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QMediaPlayer::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QMediaPlayer::isAvailable()
  bool cbs_isAvailable_c0_0() const
  {
    return QMediaPlayer::isAvailable();
  }

  virtual bool isAvailable() const
  {
    if (cb_isAvailable_c0_0.can_issue()) {
      return cb_isAvailable_c0_0.issue<QMediaPlayer_Adaptor, bool>(&QMediaPlayer_Adaptor::cbs_isAvailable_c0_0);
    } else {
      return QMediaPlayer::isAvailable();
    }
  }

  //  [adaptor impl] QMediaService *QMediaPlayer::service()
  QMediaService * cbs_service_c0_0() const
  {
    return QMediaPlayer::service();
  }

  virtual QMediaService * service() const
  {
    if (cb_service_c0_0.can_issue()) {
      return cb_service_c0_0.issue<QMediaPlayer_Adaptor, QMediaService *>(&QMediaPlayer_Adaptor::cbs_service_c0_0);
    } else {
      return QMediaPlayer::service();
    }
  }

  //  [adaptor impl] void QMediaPlayer::unbind(QObject *)
  void cbs_unbind_1302_0(QObject *arg1)
  {
    QMediaPlayer::unbind(arg1);
  }

  virtual void unbind(QObject *arg1)
  {
    if (cb_unbind_1302_0.can_issue()) {
      cb_unbind_1302_0.issue<QMediaPlayer_Adaptor, QObject *>(&QMediaPlayer_Adaptor::cbs_unbind_1302_0, arg1);
    } else {
      QMediaPlayer::unbind(arg1);
    }
  }

  //  [adaptor impl] void QMediaPlayer::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QMediaPlayer::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMediaPlayer_Adaptor, QChildEvent *>(&QMediaPlayer_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QMediaPlayer::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QMediaPlayer::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QMediaPlayer::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMediaPlayer_Adaptor, QEvent *>(&QMediaPlayer_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QMediaPlayer::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QMediaPlayer::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMediaPlayer::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMediaPlayer_Adaptor, const QMetaMethod &>(&QMediaPlayer_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMediaPlayer::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMediaPlayer::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QMediaPlayer::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMediaPlayer_Adaptor, QTimerEvent *>(&QMediaPlayer_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QMediaPlayer::timerEvent(arg1);
    }
  }

  gsi::Callback cb_availability_c0_0;
  gsi::Callback cb_bind_1302_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isAvailable_c0_0;
  gsi::Callback cb_service_c0_0;
  gsi::Callback cb_unbind_1302_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QMediaPlayer_Adaptor::~QMediaPlayer_Adaptor() { }

//  Constructor QMediaPlayer::QMediaPlayer(QObject *parent, QFlags<QMediaPlayer::Flag> flags) (adaptor class)

static void _init_ctor_QMediaPlayer_Adaptor_4002 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "0");
  decl->add_arg<QFlags<QMediaPlayer::Flag> > (argspec_1);
  decl->set_return_new<QMediaPlayer_Adaptor> ();
}

static void _call_ctor_QMediaPlayer_Adaptor_4002 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  QFlags<QMediaPlayer::Flag> arg2 = args ? gsi::arg_reader<QFlags<QMediaPlayer::Flag> >() (args, heap) : gsi::arg_maker<QFlags<QMediaPlayer::Flag> >() (0, heap);
  ret.write<QMediaPlayer_Adaptor *> (new QMediaPlayer_Adaptor (arg1, arg2));
}


// exposed void QMediaPlayer::addPropertyWatch(QByteArray const &name)

static void _init_fp_addPropertyWatch_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<QByteArray const & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addPropertyWatch_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QByteArray const &arg1 = gsi::arg_reader<QByteArray const & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_addPropertyWatch_2309 (arg1);
}


// QMultimedia::AvailabilityStatus QMediaPlayer::availability()

static void _init_cbs_availability_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ();
}

static void _call_cbs_availability_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ((qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type)((QMediaPlayer_Adaptor *)cls)->cbs_availability_c0_0 ());
}

static void _set_callback_cbs_availability_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_availability_c0_0 = cb;
}


// bool QMediaPlayer::bind(QObject *)

static void _init_cbs_bind_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_bind_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  ret.write<bool > ((bool)((QMediaPlayer_Adaptor *)cls)->cbs_bind_1302_0 (arg1));
}

static void _set_callback_cbs_bind_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_bind_1302_0 = cb;
}


// void QMediaPlayer::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMediaPlayer::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QMediaPlayer::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QMediaPlayer::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaPlayer_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMediaPlayer::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaPlayer_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QMediaPlayer::isAvailable()

static void _init_cbs_isAvailable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isAvailable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaPlayer_Adaptor *)cls)->cbs_isAvailable_c0_0 ());
}

static void _set_callback_cbs_isAvailable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_isAvailable_c0_0 = cb;
}


// exposed bool QMediaPlayer::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_isSignalConnected_c2394 (arg1));
}


// exposed int QMediaPlayer::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_receivers_c1731 (arg1));
}


// exposed void QMediaPlayer::removePropertyWatch(QByteArray const &name)

static void _init_fp_removePropertyWatch_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<QByteArray const & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_removePropertyWatch_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QByteArray const &arg1 = gsi::arg_reader<QByteArray const & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_removePropertyWatch_2309 (arg1);
}


// exposed QObject *QMediaPlayer::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_sender_c0 ());
}


// exposed int QMediaPlayer::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaPlayer_Adaptor *)cls)->fp_QMediaPlayer_senderSignalIndex_c0 ());
}


// QMediaService *QMediaPlayer::service()

static void _init_cbs_service_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaService * > ();
}

static void _call_cbs_service_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaService * > ((QMediaService *)((QMediaPlayer_Adaptor *)cls)->cbs_service_c0_0 ());
}

static void _set_callback_cbs_service_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_service_c0_0 = cb;
}


// void QMediaPlayer::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QMediaPlayer::unbind(QObject *)

static void _init_cbs_unbind_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unbind_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaPlayer_Adaptor *)cls)->cbs_unbind_1302_0 (arg1);
}

static void _set_callback_cbs_unbind_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaPlayer_Adaptor *)cls)->cb_unbind_1302_0 = cb;
}


namespace gsi
{

gsi::Class<QMediaPlayer> &qtdecl_QMediaPlayer ();

static gsi::Methods methods_QMediaPlayer_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMediaPlayer::QMediaPlayer(QObject *parent, QFlags<QMediaPlayer::Flag> flags)\nThis method creates an object of class QMediaPlayer.", &_init_ctor_QMediaPlayer_Adaptor_4002, &_call_ctor_QMediaPlayer_Adaptor_4002);
  methods += new qt_gsi::GenericMethod ("*addPropertyWatch", "@brief Method void QMediaPlayer::addPropertyWatch(QByteArray const &name)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addPropertyWatch_2309, &_call_fp_addPropertyWatch_2309);
  methods += new qt_gsi::GenericMethod ("availability", "@brief Virtual method QMultimedia::AvailabilityStatus QMediaPlayer::availability()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_availability_c0_0, &_call_cbs_availability_c0_0);
  methods += new qt_gsi::GenericMethod ("availability", "@hide", true, &_init_cbs_availability_c0_0, &_call_cbs_availability_c0_0, &_set_callback_cbs_availability_c0_0);
  methods += new qt_gsi::GenericMethod ("bind", "@brief Virtual method bool QMediaPlayer::bind(QObject *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_bind_1302_0, &_call_cbs_bind_1302_0);
  methods += new qt_gsi::GenericMethod ("bind", "@hide", false, &_init_cbs_bind_1302_0, &_call_cbs_bind_1302_0, &_set_callback_cbs_bind_1302_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMediaPlayer::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMediaPlayer::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMediaPlayer::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QMediaPlayer::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QMediaPlayer::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isAvailable", "@brief Virtual method bool QMediaPlayer::isAvailable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isAvailable_c0_0, &_call_cbs_isAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("isAvailable", "@hide", true, &_init_cbs_isAvailable_c0_0, &_call_cbs_isAvailable_c0_0, &_set_callback_cbs_isAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMediaPlayer::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMediaPlayer::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*removePropertyWatch", "@brief Method void QMediaPlayer::removePropertyWatch(QByteArray const &name)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_removePropertyWatch_2309, &_call_fp_removePropertyWatch_2309);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMediaPlayer::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMediaPlayer::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("service", "@brief Virtual method QMediaService *QMediaPlayer::service()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_service_c0_0, &_call_cbs_service_c0_0);
  methods += new qt_gsi::GenericMethod ("service", "@hide", true, &_init_cbs_service_c0_0, &_call_cbs_service_c0_0, &_set_callback_cbs_service_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMediaPlayer::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("unbind", "@brief Virtual method void QMediaPlayer::unbind(QObject *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unbind_1302_0, &_call_cbs_unbind_1302_0);
  methods += new qt_gsi::GenericMethod ("unbind", "@hide", false, &_init_cbs_unbind_1302_0, &_call_cbs_unbind_1302_0, &_set_callback_cbs_unbind_1302_0);
  return methods;
}

gsi::Class<QMediaPlayer_Adaptor> decl_QMediaPlayer_Adaptor (qtdecl_QMediaPlayer (), "QtMultimedia", "QMediaPlayer",
  methods_QMediaPlayer_Adaptor (),
  "@qt\n@brief Binding of QMediaPlayer");

}


//  Implementation of the enum wrapper class for QMediaPlayer::Error
namespace qt_gsi
{

static gsi::Enum<QMediaPlayer::Error> decl_QMediaPlayer_Error_Enum ("QtMultimedia", "QMediaPlayer_Error",
    gsi::enum_const ("NoError", QMediaPlayer::NoError, "@brief Enum constant QMediaPlayer::NoError") +
    gsi::enum_const ("ResourceError", QMediaPlayer::ResourceError, "@brief Enum constant QMediaPlayer::ResourceError") +
    gsi::enum_const ("FormatError", QMediaPlayer::FormatError, "@brief Enum constant QMediaPlayer::FormatError") +
    gsi::enum_const ("NetworkError", QMediaPlayer::NetworkError, "@brief Enum constant QMediaPlayer::NetworkError") +
    gsi::enum_const ("AccessDeniedError", QMediaPlayer::AccessDeniedError, "@brief Enum constant QMediaPlayer::AccessDeniedError") +
    gsi::enum_const ("ServiceMissingError", QMediaPlayer::ServiceMissingError, "@brief Enum constant QMediaPlayer::ServiceMissingError") +
    gsi::enum_const ("MediaIsPlaylist", QMediaPlayer::MediaIsPlaylist, "@brief Enum constant QMediaPlayer::MediaIsPlaylist"),
  "@qt\n@brief This class represents the QMediaPlayer::Error enum");

static gsi::QFlagsClass<QMediaPlayer::Error > decl_QMediaPlayer_Error_Enums ("QtMultimedia", "QMediaPlayer_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QMediaPlayer::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaPlayer> inject_QMediaPlayer_Error_Enum_in_parent (decl_QMediaPlayer_Error_Enum.defs ());
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_Error_Enum_as_child (decl_QMediaPlayer_Error_Enum, "Error");
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_Error_Enums_as_child (decl_QMediaPlayer_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QMediaPlayer::Flag
namespace qt_gsi
{

static gsi::Enum<QMediaPlayer::Flag> decl_QMediaPlayer_Flag_Enum ("QtMultimedia", "QMediaPlayer_Flag",
    gsi::enum_const ("LowLatency", QMediaPlayer::LowLatency, "@brief Enum constant QMediaPlayer::LowLatency") +
    gsi::enum_const ("StreamPlayback", QMediaPlayer::StreamPlayback, "@brief Enum constant QMediaPlayer::StreamPlayback") +
    gsi::enum_const ("VideoSurface", QMediaPlayer::VideoSurface, "@brief Enum constant QMediaPlayer::VideoSurface"),
  "@qt\n@brief This class represents the QMediaPlayer::Flag enum");

static gsi::QFlagsClass<QMediaPlayer::Flag > decl_QMediaPlayer_Flag_Enums ("QtMultimedia", "QMediaPlayer_QFlags_Flag",
  "@qt\n@brief This class represents the QFlags<QMediaPlayer::Flag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaPlayer> inject_QMediaPlayer_Flag_Enum_in_parent (decl_QMediaPlayer_Flag_Enum.defs ());
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_Flag_Enum_as_child (decl_QMediaPlayer_Flag_Enum, "Flag");
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_Flag_Enums_as_child (decl_QMediaPlayer_Flag_Enums, "QFlags_Flag");

}


//  Implementation of the enum wrapper class for QMediaPlayer::MediaStatus
namespace qt_gsi
{

static gsi::Enum<QMediaPlayer::MediaStatus> decl_QMediaPlayer_MediaStatus_Enum ("QtMultimedia", "QMediaPlayer_MediaStatus",
    gsi::enum_const ("UnknownMediaStatus", QMediaPlayer::UnknownMediaStatus, "@brief Enum constant QMediaPlayer::UnknownMediaStatus") +
    gsi::enum_const ("NoMedia", QMediaPlayer::NoMedia, "@brief Enum constant QMediaPlayer::NoMedia") +
    gsi::enum_const ("LoadingMedia", QMediaPlayer::LoadingMedia, "@brief Enum constant QMediaPlayer::LoadingMedia") +
    gsi::enum_const ("LoadedMedia", QMediaPlayer::LoadedMedia, "@brief Enum constant QMediaPlayer::LoadedMedia") +
    gsi::enum_const ("StalledMedia", QMediaPlayer::StalledMedia, "@brief Enum constant QMediaPlayer::StalledMedia") +
    gsi::enum_const ("BufferingMedia", QMediaPlayer::BufferingMedia, "@brief Enum constant QMediaPlayer::BufferingMedia") +
    gsi::enum_const ("BufferedMedia", QMediaPlayer::BufferedMedia, "@brief Enum constant QMediaPlayer::BufferedMedia") +
    gsi::enum_const ("EndOfMedia", QMediaPlayer::EndOfMedia, "@brief Enum constant QMediaPlayer::EndOfMedia") +
    gsi::enum_const ("InvalidMedia", QMediaPlayer::InvalidMedia, "@brief Enum constant QMediaPlayer::InvalidMedia"),
  "@qt\n@brief This class represents the QMediaPlayer::MediaStatus enum");

static gsi::QFlagsClass<QMediaPlayer::MediaStatus > decl_QMediaPlayer_MediaStatus_Enums ("QtMultimedia", "QMediaPlayer_QFlags_MediaStatus",
  "@qt\n@brief This class represents the QFlags<QMediaPlayer::MediaStatus> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaPlayer> inject_QMediaPlayer_MediaStatus_Enum_in_parent (decl_QMediaPlayer_MediaStatus_Enum.defs ());
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_MediaStatus_Enum_as_child (decl_QMediaPlayer_MediaStatus_Enum, "MediaStatus");
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_MediaStatus_Enums_as_child (decl_QMediaPlayer_MediaStatus_Enums, "QFlags_MediaStatus");

}


//  Implementation of the enum wrapper class for QMediaPlayer::State
namespace qt_gsi
{

static gsi::Enum<QMediaPlayer::State> decl_QMediaPlayer_State_Enum ("QtMultimedia", "QMediaPlayer_State",
    gsi::enum_const ("StoppedState", QMediaPlayer::StoppedState, "@brief Enum constant QMediaPlayer::StoppedState") +
    gsi::enum_const ("PlayingState", QMediaPlayer::PlayingState, "@brief Enum constant QMediaPlayer::PlayingState") +
    gsi::enum_const ("PausedState", QMediaPlayer::PausedState, "@brief Enum constant QMediaPlayer::PausedState"),
  "@qt\n@brief This class represents the QMediaPlayer::State enum");

static gsi::QFlagsClass<QMediaPlayer::State > decl_QMediaPlayer_State_Enums ("QtMultimedia", "QMediaPlayer_QFlags_State",
  "@qt\n@brief This class represents the QFlags<QMediaPlayer::State> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaPlayer> inject_QMediaPlayer_State_Enum_in_parent (decl_QMediaPlayer_State_Enum.defs ());
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_State_Enum_as_child (decl_QMediaPlayer_State_Enum, "State");
static gsi::ClassExt<QMediaPlayer> decl_QMediaPlayer_State_Enums_as_child (decl_QMediaPlayer_State_Enums, "QFlags_State");

}

