/* 
 * Copyright 2014 Igor Maznitsa (http://www.igormaznitsa.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.igormaznitsa.jcp.expression.functions.xml;

import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import org.junit.Test;
import static org.junit.Assert.*;

public class FunctionXML_OPENTest extends AbstractFunctionXMLTest {

  private static final FunctionXML_OPEN HANDLER = new FunctionXML_OPEN();

  @Test(expected = PreprocessorException.class)
  public void testExecute_FileNotFound() throws Exception {
    HANDLER.executeStr(SPY_CONTEXT, Value.valueOf("unknown_file.xxxxml"));
  }

  @Test(expected = PreprocessorException.class)
  public void testExecute_NoXMLFile() throws Exception {
    HANDLER.executeStr(SPY_CONTEXT, Value.valueOf("noxml.txt"));
  }

  @Test
  public void testExecute() throws Exception {
    HANDLER.executeStr(SPY_CONTEXT, Value.valueOf("test.xml"));
  }

  @Override
  public void testName() {
    assertEquals("xml_open", HANDLER.getName());
  }

  @Override
  public void testReference() {
    assertReference(HANDLER);
  }

  @Override
  public void testArity() {
    assertEquals(1, HANDLER.getArity());
  }

  @Override
  public void testAllowedArgumentTypes() {
    assertAllowedArguments(HANDLER, new ValueType[][]{{ValueType.STRING}});
  }

  @Override
  public void testResultType() {
    assertEquals(ValueType.STRING, HANDLER.getResultType());
  }
}
