/*===================== begin_copyright_notice ==================================

Copyright (c) 2017 Intel Corporation

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


======================= end_copyright_notice ==================================*/

#ifndef __IA32E_COS_D_G_DATA_CL__
#define __IA32E_COS_D_G_DATA_CL__

typedef struct
{
  VUINT32 _dT[512][4][2];
  VUINT32 _dAbsMask[2];
  VUINT32 _dReductionRangeVal[2];
  VUINT32 _dRangeVal[2];
  VUINT32 _dPIu[2];
  VUINT32 _dRShifter[2];
  VUINT32 _lIndexMask[2];
  VUINT32 _dPIoHi[2];
  VUINT32 _dPIoLo[2];
  VUINT32 _dPIoTail[2];
  VUINT32 _dS1[2];
  VUINT32 _dS2[2];
  VUINT32 _dC1[2];
  VUINT32 _dC2[2];
  VUINT32 _dC3[2];
} dCosHA_Table_Type;

__constant dCosHA_Table_Type __ocl_svml_dcos_data_ha = {
  {
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6B78B80C84E1EEuLL) >> 0),
     (VUINT32) ((0x3F6B78B80C84E1EEuLL) >> 32)},
    {(VUINT32) ((0xBF90000000000000uLL) >> 0),
     (VUINT32) ((0xBF90000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFFF62169B92DBuLL) >> 0),
     (VUINT32) ((0x3FEFFF62169B92DBuLL) >> 32)},
    {(VUINT32) ((0x3C85DDA3C0000000uLL) >> 0),
     (VUINT32) ((0x3C85DDA3C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7B7AA821726608uLL) >> 0),
     (VUINT32) ((0x3F7B7AA821726608uLL) >> 32)},
    {(VUINT32) ((0xBFA0000000000000uLL) >> 0),
     (VUINT32) ((0xBFA0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFFD886084CD0DuLL) >> 0),
     (VUINT32) ((0x3FEFFD886084CD0DuLL) >> 32)},
    {(VUINT32) ((0xBC81354D40000000uLL) >> 0),
     (VUINT32) ((0xBC81354D40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF76C32BACA2AE69uLL) >> 0),
     (VUINT32) ((0xBF76C32BACA2AE69uLL) >> 32)},
    {(VUINT32) ((0xBFA0000000000000uLL) >> 0),
     (VUINT32) ((0xBFA0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFFA72EFFEF75DuLL) >> 0),
     (VUINT32) ((0x3FEFFA72EFFEF75DuLL) >> 32)},
    {(VUINT32) ((0xBC88B4CDC0000000uLL) >> 0),
     (VUINT32) ((0xBC88B4CDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8B82683BC89FB0uLL) >> 0),
     (VUINT32) ((0x3F8B82683BC89FB0uLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
     (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFF621E3796D7EuLL) >> 0),
     (VUINT32) ((0x3FEFF621E3796D7EuLL) >> 32)},
    {(VUINT32) ((0xBC6C57BC20000000uLL) >> 0),
     (VUINT32) ((0xBC6C57BC20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F535230C0FBE402uLL) >> 0),
     (VUINT32) ((0x3F535230C0FBE402uLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
     (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFF095658E71ADuLL) >> 0),
     (VUINT32) ((0x3FEFF095658E71ADuLL) >> 32)},
    {(VUINT32) ((0x3C801A8CE0000000uLL) >> 0),
     (VUINT32) ((0x3C801A8CE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF86A9049670CFAEuLL) >> 0),
     (VUINT32) ((0xBF86A9049670CFAEuLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
     (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFE9CDAD01883AuLL) >> 0),
     (VUINT32) ((0x3FEFE9CDAD01883AuLL) >> 32)},
    {(VUINT32) ((0x3C6521ECC0000000uLL) >> 0),
     (VUINT32) ((0x3C6521ECC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF97DB402A6A9063uLL) >> 0),
     (VUINT32) ((0xBF97DB402A6A9063uLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
     (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFE1CAFCBD5B09uLL) >> 0),
     (VUINT32) ((0x3FEFE1CAFCBD5B09uLL) >> 32)},
    {(VUINT32) ((0x3C6A23E320000000uLL) >> 0),
     (VUINT32) ((0x3C6A23E320000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9BA1650F592F50uLL) >> 0),
     (VUINT32) ((0x3F9BA1650F592F50uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFD88DA3D12526uLL) >> 0),
     (VUINT32) ((0x3FEFD88DA3D12526uLL) >> 32)},
    {(VUINT32) ((0xBC887DF620000000uLL) >> 0),
     (VUINT32) ((0xBC887DF620000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8E43D1C309E958uLL) >> 0),
     (VUINT32) ((0x3F8E43D1C309E958uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFCE15FD6DA67BuLL) >> 0),
     (VUINT32) ((0x3FEFCE15FD6DA67BuLL) >> 32)},
    {(VUINT32) ((0xBC75DD6F80000000uLL) >> 0),
     (VUINT32) ((0xBC75DD6F80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6536352AD19E39uLL) >> 0),
     (VUINT32) ((0x3F6536352AD19E39uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFC26470E19FD3uLL) >> 0),
     (VUINT32) ((0x3FEFC26470E19FD3uLL) >> 32)},
    {(VUINT32) ((0x3C81EC8660000000uLL) >> 0),
     (VUINT32) ((0x3C81EC8660000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF839F0CEDAF576BuLL) >> 0),
     (VUINT32) ((0xBF839F0CEDAF576BuLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFB5797195D741uLL) >> 0),
     (VUINT32) ((0x3FEFB5797195D741uLL) >> 32)},
    {(VUINT32) ((0x3C71BFAC60000000uLL) >> 0),
     (VUINT32) ((0x3C71BFAC60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF964083747309D1uLL) >> 0),
     (VUINT32) ((0xBF964083747309D1uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFA7557F08A517uLL) >> 0),
     (VUINT32) ((0x3FEFA7557F08A517uLL) >> 32)},
    {(VUINT32) ((0xBC87A0A8C0000000uLL) >> 0),
     (VUINT32) ((0xBC87A0A8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA155DAC4A4F967uLL) >> 0),
     (VUINT32) ((0xBFA155DAC4A4F967uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF97F924C9099BuLL) >> 0),
     (VUINT32) ((0x3FEF97F924C9099BuLL) >> 32)},
    {(VUINT32) ((0xBC8E2AE0E0000000uLL) >> 0),
     (VUINT32) ((0xBC8E2AE0E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA78851122CFF19uLL) >> 0),
     (VUINT32) ((0xBFA78851122CFF19uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF8764FA714BA9uLL) >> 0),
     (VUINT32) ((0x3FEF8764FA714BA9uLL) >> 32)},
    {(VUINT32) ((0x3C7AB25660000000uLL) >> 0),
     (VUINT32) ((0x3C7AB25660000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFADB7677942FCC5uLL) >> 0),
     (VUINT32) ((0xBFADB7677942FCC5uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF7599A3A12077uLL) >> 0),
     (VUINT32) ((0x3FEF7599A3A12077uLL) >> 32)},
    {(VUINT32) ((0x3C884F31C0000000uLL) >> 0),
     (VUINT32) ((0x3C884F31C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAC1D1F0E5967D5uLL) >> 0),
     (VUINT32) ((0x3FAC1D1F0E5967D5uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF6297CFF75CB0uLL) >> 0),
     (VUINT32) ((0x3FEF6297CFF75CB0uLL) >> 32)},
    {(VUINT32) ((0x3C75621720000000uLL) >> 0),
     (VUINT32) ((0x3C75621720000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA5F57F693FEEBEuLL) >> 0),
     (VUINT32) ((0x3FA5F57F693FEEBEuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF4E603B0B2F2DuLL) >> 0),
     (VUINT32) ((0x3FEF4E603B0B2F2DuLL) >> 32)},
    {(VUINT32) ((0xBC78EE01E0000000uLL) >> 0),
     (VUINT32) ((0xBC78EE01E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9FA3ECAC0D84E8uLL) >> 0),
     (VUINT32) ((0x3F9FA3ECAC0D84E8uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF38F3AC64E589uLL) >> 0),
     (VUINT32) ((0x3FEF38F3AC64E589uLL) >> 32)},
    {(VUINT32) ((0xBC7D7BAFA0000000uLL) >> 0),
     (VUINT32) ((0xBC7D7BAFA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F936580D5D5E775uLL) >> 0),
     (VUINT32) ((0x3F936580D5D5E775uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF2252F7763ADAuLL) >> 0),
     (VUINT32) ((0x3FEF2252F7763ADAuLL) >> 32)},
    {(VUINT32) ((0xBC820CB800000000uLL) >> 0),
     (VUINT32) ((0xBC820CB800000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7CC0D09BD41CAAuLL) >> 0),
     (VUINT32) ((0x3F7CC0D09BD41CAAuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF0A7EFB9230D7uLL) >> 0),
     (VUINT32) ((0x3FEF0A7EFB9230D7uLL) >> 32)},
    {(VUINT32) ((0x3C752C7AC0000000uLL) >> 0),
     (VUINT32) ((0x3C752C7AC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF73EE038DFF6B80uLL) >> 0),
     (VUINT32) ((0xBF73EE038DFF6B80uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEEF178A3E473C2uLL) >> 0),
     (VUINT32) ((0x3FEEF178A3E473C2uLL) >> 32)},
    {(VUINT32) ((0x3C86310A60000000uLL) >> 0),
     (VUINT32) ((0x3C86310A60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF911D262B1F6776uLL) >> 0),
     (VUINT32) ((0xBF911D262B1F6776uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEED740E7684963uLL) >> 0),
     (VUINT32) ((0x3FEED740E7684963uLL) >> 32)},
    {(VUINT32) ((0x3C7E82C780000000uLL) >> 0),
     (VUINT32) ((0x3C7E82C780000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9D3443F4CDB3DDuLL) >> 0),
     (VUINT32) ((0xBF9D3443F4CDB3DDuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEEBBD8C8DF0B74uLL) >> 0),
     (VUINT32) ((0x3FEEBBD8C8DF0B74uLL) >> 32)},
    {(VUINT32) ((0x3C7C6C8C60000000uLL) >> 0),
     (VUINT32) ((0x3C7C6C8C60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA4A03176ACF82DuLL) >> 0),
     (VUINT32) ((0xBFA4A03176ACF82DuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE9F4156C62DDAuLL) >> 0),
     (VUINT32) ((0x3FEE9F4156C62DDAuLL) >> 32)},
    {(VUINT32) ((0x3C8760B1E0000000uLL) >> 0),
     (VUINT32) ((0x3C8760B1E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAAA086170C0A8EuLL) >> 0),
     (VUINT32) ((0xBFAAA086170C0A8EuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE817BAB4CD10DuLL) >> 0),
     (VUINT32) ((0x3FEE817BAB4CD10DuLL) >> 32)},
    {(VUINT32) ((0xBC7D0AFE60000000uLL) >> 0),
     (VUINT32) ((0xBC7D0AFE60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB04D72505D9805uLL) >> 0),
     (VUINT32) ((0xBFB04D72505D9805uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE6288EC48E112uLL) >> 0),
     (VUINT32) ((0x3FEE6288EC48E112uLL) >> 32)},
    {(VUINT32) ((0xBC616B56E0000000uLL) >> 0),
     (VUINT32) ((0xBC616B56E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB3478909E39DA9uLL) >> 0),
     (VUINT32) ((0xBFB3478909E39DA9uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE426A4B2BC17EuLL) >> 0),
     (VUINT32) ((0x3FEE426A4B2BC17EuLL) >> 32)},
    {(VUINT32) ((0x3C8A873880000000uLL) >> 0),
     (VUINT32) ((0x3C8A873880000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB63E69D6AC7F74uLL) >> 0),
     (VUINT32) ((0xBFB63E69D6AC7F74uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE212104F686E5uLL) >> 0),
     (VUINT32) ((0x3FEE212104F686E5uLL) >> 32)},
    {(VUINT32) ((0xBC8014C760000000uLL) >> 0),
     (VUINT32) ((0xBC8014C760000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB931F774FC9F18uLL) >> 0),
     (VUINT32) ((0xBFB931F774FC9F18uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEDFEAE622DBE2BuLL) >> 0),
     (VUINT32) ((0x3FEDFEAE622DBE2BuLL) >> 32)},
    {(VUINT32) ((0xBC8514EA80000000uLL) >> 0),
     (VUINT32) ((0xBC8514EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBC2214C3E9167BuLL) >> 0),
     (VUINT32) ((0xBFBC2214C3E9167BuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEDDB13B6CCC23CuLL) >> 0),
     (VUINT32) ((0x3FEDDB13B6CCC23CuLL) >> 32)},
    {(VUINT32) ((0x3C883C37C0000000uLL) >> 0),
     (VUINT32) ((0x3C883C37C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBF0EA4C477339CuLL) >> 0),
     (VUINT32) ((0xBFBF0EA4C477339CuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEDB6526238A09BuLL) >> 0),
     (VUINT32) ((0x3FEDB6526238A09BuLL) >> 32)},
    {(VUINT32) ((0xBC7ADEE7E0000000uLL) >> 0),
     (VUINT32) ((0xBC7ADEE7E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBE087565455A75uLL) >> 0),
     (VUINT32) ((0x3FBE087565455A75uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED906BCF328D46uLL) >> 0),
     (VUINT32) ((0x3FED906BCF328D46uLL) >> 32)},
    {(VUINT32) ((0x3C7457E600000000uLL) >> 0),
     (VUINT32) ((0x3C7457E600000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBB2356710DB0A3uLL) >> 0),
     (VUINT32) ((0x3FBB2356710DB0A3uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED696173C9E68BuLL) >> 0),
     (VUINT32) ((0x3FED696173C9E68BuLL) >> 32)},
    {(VUINT32) ((0xBC7E8C61C0000000uLL) >> 0),
     (VUINT32) ((0xBC7E8C61C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB8421AF15C49D7uLL) >> 0),
     (VUINT32) ((0x3FB8421AF15C49D7uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED4134D14DC93AuLL) >> 0),
     (VUINT32) ((0x3FED4134D14DC93AuLL) >> 32)},
    {(VUINT32) ((0xBC84EF5280000000uLL) >> 0),
     (VUINT32) ((0xBC84EF5280000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB564DF524B00DAuLL) >> 0),
     (VUINT32) ((0x3FB564DF524B00DAuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED17E7743E35DCuLL) >> 0),
     (VUINT32) ((0x3FED17E7743E35DCuLL) >> 32)},
    {(VUINT32) ((0xBC5101DA20000000uLL) >> 0),
     (VUINT32) ((0xBC5101DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB28BBFD87A8CFFuLL) >> 0),
     (VUINT32) ((0x3FB28BBFD87A8CFFuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FECED7AF43CC773uLL) >> 0),
     (VUINT32) ((0x3FECED7AF43CC773uLL) >> 32)},
    {(VUINT32) ((0xBC5E7B6BA0000000uLL) >> 0),
     (VUINT32) ((0xBC5E7B6BA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAF6DB13FF708CBuLL) >> 0),
     (VUINT32) ((0x3FAF6DB13FF708CBuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FECC1F0F3FCFC5CuLL) >> 0),
     (VUINT32) ((0x3FECC1F0F3FCFC5CuLL) >> 32)},
    {(VUINT32) ((0x3C7E576120000000uLL) >> 0),
     (VUINT32) ((0x3C7E576120000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA9CC8B3671DD0FuLL) >> 0),
     (VUINT32) ((0x3FA9CC8B3671DD0FuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC954B213411F5uLL) >> 0),
     (VUINT32) ((0x3FEC954B213411F5uLL) >> 32)},
    {(VUINT32) ((0xBC52FB7600000000uLL) >> 0),
     (VUINT32) ((0xBC52FB7600000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA4344523C8E3B5uLL) >> 0),
     (VUINT32) ((0x3FA4344523C8E3B5uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC678B3488739BuLL) >> 0),
     (VUINT32) ((0x3FEC678B3488739BuLL) >> 32)},
    {(VUINT32) ((0x3C6D86CAC0000000uLL) >> 0),
     (VUINT32) ((0x3C6D86CAC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9D4A2C7F909C4EuLL) >> 0),
     (VUINT32) ((0x3F9D4A2C7F909C4EuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC38B2F180BDB1uLL) >> 0),
     (VUINT32) ((0x3FEC38B2F180BDB1uLL) >> 32)},
    {(VUINT32) ((0xBC76E0B160000000uLL) >> 0),
     (VUINT32) ((0xBC76E0B160000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F923E6AD10872A7uLL) >> 0),
     (VUINT32) ((0x3F923E6AD10872A7uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC08C426725549uLL) >> 0),
     (VUINT32) ((0x3FEC08C426725549uLL) >> 32)},
    {(VUINT32) ((0x3C5B157FC0000000uLL) >> 0),
     (VUINT32) ((0x3C5B157FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7D16C901D95181uLL) >> 0),
     (VUINT32) ((0x3F7D16C901D95181uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEBD7C0AC6F952AuLL) >> 0),
     (VUINT32) ((0x3FEBD7C0AC6F952AuLL) >> 32)},
    {(VUINT32) ((0xBC8825A720000000uLL) >> 0),
     (VUINT32) ((0xBC8825A720000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6CFC874C3EB6D9uLL) >> 0),
     (VUINT32) ((0xBF6CFC874C3EB6D9uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEBA5AA673590D2uLL) >> 0),
     (VUINT32) ((0x3FEBA5AA673590D2uLL) >> 32)},
    {(VUINT32) ((0x3C87EA4E20000000uLL) >> 0),
     (VUINT32) ((0x3C87EA4E20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8CE1E648BFFB66uLL) >> 0),
     (VUINT32) ((0xBF8CE1E648BFFB66uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEB728345196E3EuLL) >> 0),
     (VUINT32) ((0x3FEB728345196E3EuLL) >> 32)},
    {(VUINT32) ((0xBC8BC69F20000000uLL) >> 0),
     (VUINT32) ((0xBC8BC69F20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF992E09ABB131D4uLL) >> 0),
     (VUINT32) ((0xBF992E09ABB131D4uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEB3E4D3EF55712uLL) >> 0),
     (VUINT32) ((0x3FEB3E4D3EF55712uLL) >> 32)},
    {(VUINT32) ((0xBC8EB6B8A0000000uLL) >> 0),
     (VUINT32) ((0xBC8EB6B8A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA1EB3541B4B228uLL) >> 0),
     (VUINT32) ((0xBFA1EB3541B4B228uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEB090A58150200uLL) >> 0),
     (VUINT32) ((0x3FEB090A58150200uLL) >> 32)},
    {(VUINT32) ((0xBC8926DA20000000uLL) >> 0),
     (VUINT32) ((0xBC8926DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA734D63DEDB48AuLL) >> 0),
     (VUINT32) ((0xBFA734D63DEDB48AuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEAD2BC9E21D511uLL) >> 0),
     (VUINT32) ((0x3FEAD2BC9E21D511uLL) >> 32)},
    {(VUINT32) ((0xBC847FBE00000000uLL) >> 0),
     (VUINT32) ((0xBC847FBE00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAC73B39AE68C87uLL) >> 0),
     (VUINT32) ((0xBFAC73B39AE68C87uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEA9B66290EA1A3uLL) >> 0),
     (VUINT32) ((0x3FEA9B66290EA1A3uLL) >> 32)},
    {(VUINT32) ((0x3C39F630E0000000uLL) >> 0),
     (VUINT32) ((0x3C39F630E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB0D3CCC99F5AC6uLL) >> 0),
     (VUINT32) ((0xBFB0D3CCC99F5AC6uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEA63091B02FAE2uLL) >> 0),
     (VUINT32) ((0x3FEA63091B02FAE2uLL) >> 32)},
    {(VUINT32) ((0xBC7E911140000000uLL) >> 0),
     (VUINT32) ((0xBC7E911140000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB3682A66E896F5uLL) >> 0),
     (VUINT32) ((0xBFB3682A66E896F5uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEA29A7A0462782uLL) >> 0),
     (VUINT32) ((0x3FEA29A7A0462782uLL) >> 32)},
    {(VUINT32) ((0xBC7128BB00000000uLL) >> 0),
     (VUINT32) ((0xBC7128BB00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB5F6D92FD79F50uLL) >> 0),
     (VUINT32) ((0xBFB5F6D92FD79F50uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE9EF43EF29AF94uLL) >> 0),
     (VUINT32) ((0x3FE9EF43EF29AF94uLL) >> 32)},
    {(VUINT32) ((0x3C7B1DFCA0000000uLL) >> 0),
     (VUINT32) ((0x3C7B1DFCA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB87FBFE70B81A7uLL) >> 0),
     (VUINT32) ((0xBFB87FBFE70B81A7uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE9B3E047F38741uLL) >> 0),
     (VUINT32) ((0x3FE9B3E047F38741uLL) >> 32)},
    {(VUINT32) ((0xBC830EE280000000uLL) >> 0),
     (VUINT32) ((0xBC830EE280000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBB02C58832CF96uLL) >> 0),
     (VUINT32) ((0xBFBB02C58832CF96uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE9777EF4C7D742uLL) >> 0),
     (VUINT32) ((0x3FE9777EF4C7D742uLL) >> 32)},
    {(VUINT32) ((0xBC815479A0000000uLL) >> 0),
     (VUINT32) ((0xBC815479A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBD7FD1490285CAuLL) >> 0),
     (VUINT32) ((0xBFBD7FD1490285CAuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE93A22499263FBuLL) >> 0),
     (VUINT32) ((0x3FE93A22499263FBuLL) >> 32)},
    {(VUINT32) ((0x3C83D419A0000000uLL) >> 0),
     (VUINT32) ((0x3C83D419A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBFF6CA9A2AB6A2uLL) >> 0),
     (VUINT32) ((0xBFBFF6CA9A2AB6A2uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE8FBCCA3EF940DuLL) >> 0),
     (VUINT32) ((0x3FE8FBCCA3EF940DuLL) >> 32)},
    {(VUINT32) ((0xBC66DFA980000000uLL) >> 0),
     (VUINT32) ((0xBC66DFA980000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC133CC94247758uLL) >> 0),
     (VUINT32) ((0xBFC133CC94247758uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE8BC806B151741uLL) >> 0),
     (VUINT32) ((0x3FE8BC806B151741uLL) >> 32)},
    {(VUINT32) ((0xBC82C5E120000000uLL) >> 0),
     (VUINT32) ((0xBC82C5E120000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC269126E6C24E3uLL) >> 0),
     (VUINT32) ((0xBFC269126E6C24E3uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE87C400FBA2EBFuLL) >> 0),
     (VUINT32) ((0x3FE87C400FBA2EBFuLL) >> 32)},
    {(VUINT32) ((0xBC82DABC00000000uLL) >> 0),
     (VUINT32) ((0xBC82DABC00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC39B2AEF8F97A4uLL) >> 0),
     (VUINT32) ((0xBFC39B2AEF8F97A4uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE83B0E0BFF976EuLL) >> 0),
     (VUINT32) ((0x3FE83B0E0BFF976EuLL) >> 32)},
    {(VUINT32) ((0xBC76F420E0000000uLL) >> 0),
     (VUINT32) ((0xBC76F420E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC4CA0A4A8D5657uLL) >> 0),
     (VUINT32) ((0xBFC4CA0A4A8D5657uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE7F8ECE3571771uLL) >> 0),
     (VUINT32) ((0x3FE7F8ECE3571771uLL) >> 32)},
    {(VUINT32) ((0xBC89C8D8C0000000uLL) >> 0),
     (VUINT32) ((0xBC89C8D8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC5F5A4D233B27FuLL) >> 0),
     (VUINT32) ((0xBFC5F5A4D233B27FuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE7B5DF226AAFAFuLL) >> 0),
     (VUINT32) ((0x3FE7B5DF226AAFAFuLL) >> 32)},
    {(VUINT32) ((0xBC70F537A0000000uLL) >> 0),
     (VUINT32) ((0xBC70F537A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC71DEEF9940631uLL) >> 0),
     (VUINT32) ((0xBFC71DEEF9940631uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE771E75F037261uLL) >> 0),
     (VUINT32) ((0x3FE771E75F037261uLL) >> 32)},
    {(VUINT32) ((0x3C75CFCE80000000uLL) >> 0),
     (VUINT32) ((0x3C75CFCE80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC842DD5474B37BuLL) >> 0),
     (VUINT32) ((0xBFC842DD5474B37BuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE72D0837EFFF96uLL) >> 0),
     (VUINT32) ((0x3FE72D0837EFFF96uLL) >> 32)},
    {(VUINT32) ((0x3C80D4EF00000000uLL) >> 0),
     (VUINT32) ((0x3C80D4EF00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC9646497C1E0F6uLL) >> 0),
     (VUINT32) ((0xBFC9646497C1E0F6uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE6E74454EAA8AFuLL) >> 0),
     (VUINT32) ((0x3FE6E74454EAA8AFuLL) >> 32)},
    {(VUINT32) ((0xBC8DBC03C0000000uLL) >> 0),
     (VUINT32) ((0xBC8DBC03C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCA827999FCEF32uLL) >> 0),
     (VUINT32) ((0xBFCA827999FCEF32uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE6A09E667F3BCDuLL) >> 0),
     (VUINT32) ((0x3FE6A09E667F3BCDuLL) >> 32)},
    {(VUINT32) ((0xBC8BDD3400000000uLL) >> 0),
     (VUINT32) ((0xBC8BDD3400000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCB9D1153AAA2BAuLL) >> 0),
     (VUINT32) ((0xBFCB9D1153AAA2BAuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE6591925F0783DuLL) >> 0),
     (VUINT32) ((0x3FE6591925F0783DuLL) >> 32)},
    {(VUINT32) ((0x3C8C3D64E0000000uLL) >> 0),
     (VUINT32) ((0x3C8C3D64E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCCB420DFBFFE59uLL) >> 0),
     (VUINT32) ((0xBFCCB420DFBFFE59uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE610B7551D2CDFuLL) >> 0),
     (VUINT32) ((0x3FE610B7551D2CDFuLL) >> 32)},
    {(VUINT32) ((0xBC7251B340000000uLL) >> 0),
     (VUINT32) ((0xBC7251B340000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCDC79D7C0DC985uLL) >> 0),
     (VUINT32) ((0xBFCDC79D7C0DC985uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE5C77BBE65018CuLL) >> 0),
     (VUINT32) ((0x3FE5C77BBE65018CuLL) >> 32)},
    {(VUINT32) ((0x3C8069EA80000000uLL) >> 0),
     (VUINT32) ((0x3C8069EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCED77C89AABEBBuLL) >> 0),
     (VUINT32) ((0xBFCED77C89AABEBBuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE57D69348CECA0uLL) >> 0),
     (VUINT32) ((0x3FE57D69348CECA0uLL) >> 32)},
    {(VUINT32) ((0xBC87572080000000uLL) >> 0),
     (VUINT32) ((0xBC87572080000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCFE3B38D5C5DC2uLL) >> 0),
     (VUINT32) ((0xBFCFE3B38D5C5DC2uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE5328292A35596uLL) >> 0),
     (VUINT32) ((0x3FE5328292A35596uLL) >> 32)},
    {(VUINT32) ((0xBC7A12EB80000000uLL) >> 0),
     (VUINT32) ((0xBC7A12EB80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCF13C7D001A249uLL) >> 0),
     (VUINT32) ((0x3FCF13C7D001A249uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE4E6CABBE3E5E9uLL) >> 0),
     (VUINT32) ((0x3FE4E6CABBE3E5E9uLL) >> 32)},
    {(VUINT32) ((0x3C63C293E0000000uLL) >> 0),
     (VUINT32) ((0x3C63C293E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCE0EFFC1174505uLL) >> 0),
     (VUINT32) ((0x3FCE0EFFC1174505uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE49A449B9B0939uLL) >> 0),
     (VUINT32) ((0x3FE49A449B9B0939uLL) >> 32)},
    {(VUINT32) ((0xBC827EE160000000uLL) >> 0),
     (VUINT32) ((0xBC827EE160000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCD0DFE53ABA2FDuLL) >> 0),
     (VUINT32) ((0x3FCD0DFE53ABA2FDuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE44CF325091DD6uLL) >> 0),
     (VUINT32) ((0x3FE44CF325091DD6uLL) >> 32)},
    {(VUINT32) ((0x3C68076A20000000uLL) >> 0),
     (VUINT32) ((0x3C68076A20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCC10CD7041AFCCuLL) >> 0),
     (VUINT32) ((0x3FCC10CD7041AFCCuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE3FED9534556D4uLL) >> 0),
     (VUINT32) ((0x3FE3FED9534556D4uLL) >> 32)},
    {(VUINT32) ((0x3C83691660000000uLL) >> 0),
     (VUINT32) ((0x3C83691660000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCB1776D9B67013uLL) >> 0),
     (VUINT32) ((0x3FCB1776D9B67013uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE3AFFA292050B9uLL) >> 0),
     (VUINT32) ((0x3FE3AFFA292050B9uLL) >> 32)},
    {(VUINT32) ((0x3C7E3E25E0000000uLL) >> 0),
     (VUINT32) ((0x3C7E3E25E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCA22042CE0A2F9uLL) >> 0),
     (VUINT32) ((0x3FCA22042CE0A2F9uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE36058B10659F3uLL) >> 0),
     (VUINT32) ((0x3FE36058B10659F3uLL) >> 32)},
    {(VUINT32) ((0xBC81FCB3A0000000uLL) >> 0),
     (VUINT32) ((0xBC81FCB3A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC9307EE031E2FDuLL) >> 0),
     (VUINT32) ((0x3FC9307EE031E2FDuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE30FF7FCE17035uLL) >> 0),
     (VUINT32) ((0x3FE30FF7FCE17035uLL) >> 32)},
    {(VUINT32) ((0xBC6EFCC620000000uLL) >> 0),
     (VUINT32) ((0xBC6EFCC620000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC842F0435941AFuLL) >> 0),
     (VUINT32) ((0x3FC842F0435941AFuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE2BEDB25FAF3EAuLL) >> 0),
     (VUINT32) ((0x3FE2BEDB25FAF3EAuLL) >> 32)},
    {(VUINT32) ((0xBC514981C0000000uLL) >> 0),
     (VUINT32) ((0xBC514981C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC759617EE761F9uLL) >> 0),
     (VUINT32) ((0x3FC759617EE761F9uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE26D054CDD12DFuLL) >> 0),
     (VUINT32) ((0x3FE26D054CDD12DFuLL) >> 32)},
    {(VUINT32) ((0xBC85DA7420000000uLL) >> 0),
     (VUINT32) ((0xBC85DA7420000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC673DB93F41479uLL) >> 0),
     (VUINT32) ((0x3FC673DB93F41479uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE21A799933EB59uLL) >> 0),
     (VUINT32) ((0x3FE21A799933EB59uLL) >> 32)},
    {(VUINT32) ((0xBC83A7B160000000uLL) >> 0),
     (VUINT32) ((0xBC83A7B160000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC592675BC57974uLL) >> 0),
     (VUINT32) ((0x3FC592675BC57974uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE1C73B39AE68C8uLL) >> 0),
     (VUINT32) ((0x3FE1C73B39AE68C8uLL) >> 32)},
    {(VUINT32) ((0x3C8B25DD20000000uLL) >> 0),
     (VUINT32) ((0x3C8B25DD20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC4B50D8778ABBDuLL) >> 0),
     (VUINT32) ((0x3FC4B50D8778ABBDuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE1734D63DEDB49uLL) >> 0),
     (VUINT32) ((0x3FE1734D63DEDB49uLL) >> 32)},
    {(VUINT32) ((0xBC87EEF2C0000000uLL) >> 0),
     (VUINT32) ((0xBC87EEF2C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC3DBD69FABF802uLL) >> 0),
     (VUINT32) ((0x3FC3DBD69FABF802uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE11EB3541B4B23uLL) >> 0),
     (VUINT32) ((0x3FE11EB3541B4B23uLL) >> 32)},
    {(VUINT32) ((0xBC8EF23B60000000uLL) >> 0),
     (VUINT32) ((0xBC8EF23B60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC306CB042AA3BAuLL) >> 0),
     (VUINT32) ((0x3FC306CB042AA3BAuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE0C9704D5D898FuLL) >> 0),
     (VUINT32) ((0x3FE0C9704D5D898FuLL) >> 32)},
    {(VUINT32) ((0xBC88D3D7C0000000uLL) >> 0),
     (VUINT32) ((0xBC88D3D7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC235F2EB9A470AuLL) >> 0),
     (VUINT32) ((0x3FC235F2EB9A470AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE073879922FFEEuLL) >> 0),
     (VUINT32) ((0x3FE073879922FFEEuLL) >> 32)},
    {(VUINT32) ((0xBC8A5A0140000000uLL) >> 0),
     (VUINT32) ((0xBC8A5A0140000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC169566329BCB7uLL) >> 0),
     (VUINT32) ((0x3FC169566329BCB7uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE01CFC874C3EB7uLL) >> 0),
     (VUINT32) ((0x3FE01CFC874C3EB7uLL) >> 32)},
    {(VUINT32) ((0xBC734A35E0000000uLL) >> 0),
     (VUINT32) ((0xBC734A35E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC0A0FD4E41AB5AuLL) >> 0),
     (VUINT32) ((0x3FC0A0FD4E41AB5AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDF8BA4DBF89ABAuLL) >> 0),
     (VUINT32) ((0x3FDF8BA4DBF89ABAuLL) >> 32)},
    {(VUINT32) ((0xBC32EC1FC0000000uLL) >> 0),
     (VUINT32) ((0xBC32EC1FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBFB9DECC6D55B8uLL) >> 0),
     (VUINT32) ((0x3FBFB9DECC6D55B8uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDEDC1952EF78D6uLL) >> 0),
     (VUINT32) ((0x3FDEDC1952EF78D6uLL) >> 32)},
    {(VUINT32) ((0xBC7DD0F7C0000000uLL) >> 0),
     (VUINT32) ((0xBC7DD0F7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBE3A6873FA1279uLL) >> 0),
     (VUINT32) ((0x3FBE3A6873FA1279uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDE2B5D3806F63BuLL) >> 0),
     (VUINT32) ((0x3FDE2B5D3806F63BuLL) >> 32)},
    {(VUINT32) ((0x3C5E0D8900000000uLL) >> 0),
     (VUINT32) ((0x3C5E0D8900000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBCC3A65BBC6327uLL) >> 0),
     (VUINT32) ((0x3FBCC3A65BBC6327uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDD79775B86E389uLL) >> 0),
     (VUINT32) ((0x3FDD79775B86E389uLL) >> 32)},
    {(VUINT32) ((0x3C7550EC80000000uLL) >> 0),
     (VUINT32) ((0x3C7550EC80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBB55A6F65F7058uLL) >> 0),
     (VUINT32) ((0x3FBB55A6F65F7058uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDCC66E9931C45EuLL) >> 0),
     (VUINT32) ((0x3FDCC66E9931C45EuLL) >> 32)},
    {(VUINT32) ((0x3C56850E40000000uLL) >> 0),
     (VUINT32) ((0x3C56850E40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB9F07860181D1EuLL) >> 0),
     (VUINT32) ((0x3FB9F07860181D1EuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDC1249D8011EE7uLL) >> 0),
     (VUINT32) ((0x3FDC1249D8011EE7uLL) >> 32)},
    {(VUINT32) ((0xBC7813AAA0000000uLL) >> 0),
     (VUINT32) ((0xBC7813AAA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB894285E19C468uLL) >> 0),
     (VUINT32) ((0x3FB894285E19C468uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDB5D1009E15CC0uLL) >> 0),
     (VUINT32) ((0x3FDB5D1009E15CC0uLL) >> 32)},
    {(VUINT32) ((0x3C65B362C0000000uLL) >> 0),
     (VUINT32) ((0x3C65B362C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB740C45E0E5120uLL) >> 0),
     (VUINT32) ((0x3FB740C45E0E5120uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDAA6C82B6D3FCAuLL) >> 0),
     (VUINT32) ((0x3FDAA6C82B6D3FCAuLL) >> 32)},
    {(VUINT32) ((0xBC7D5F1060000000uLL) >> 0),
     (VUINT32) ((0xBC7D5F1060000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB5F6597591B633uLL) >> 0),
     (VUINT32) ((0x3FB5F6597591B633uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD9EF7943A8ED8AuLL) >> 0),
     (VUINT32) ((0x3FD9EF7943A8ED8AuLL) >> 32)},
    {(VUINT32) ((0x3C66DA8120000000uLL) >> 0),
     (VUINT32) ((0x3C66DA8120000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB4B4F461B0CBAAuLL) >> 0),
     (VUINT32) ((0x3FB4B4F461B0CBAAuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD9372A63BC93D7uLL) >> 0),
     (VUINT32) ((0x3FD9372A63BC93D7uLL) >> 32)},
    {(VUINT32) ((0x3C66843180000000uLL) >> 0),
     (VUINT32) ((0x3C66843180000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB37CA1866B95CFuLL) >> 0),
     (VUINT32) ((0x3FB37CA1866B95CFuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD87DE2A6AEA963uLL) >> 0),
     (VUINT32) ((0x3FD87DE2A6AEA963uLL) >> 32)},
    {(VUINT32) ((0xBC672CEDC0000000uLL) >> 0),
     (VUINT32) ((0xBC672CEDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB24D6CEE3AFB2AuLL) >> 0),
     (VUINT32) ((0x3FB24D6CEE3AFB2AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD7C3A9311DCCE7uLL) >> 0),
     (VUINT32) ((0x3FD7C3A9311DCCE7uLL) >> 32)},
    {(VUINT32) ((0x3C19A3F200000000uLL) >> 0),
     (VUINT32) ((0x3C19A3F200000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB127624999EE1DuLL) >> 0),
     (VUINT32) ((0x3FB127624999EE1DuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD7088530FA459FuLL) >> 0),
     (VUINT32) ((0x3FD7088530FA459FuLL) >> 32)},
    {(VUINT32) ((0xBC744B19E0000000uLL) >> 0),
     (VUINT32) ((0xBC744B19E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB00A8CEE920EABuLL) >> 0),
     (VUINT32) ((0x3FB00A8CEE920EABuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD64C7DDD3F27C6uLL) >> 0),
     (VUINT32) ((0x3FD64C7DDD3F27C6uLL) >> 32)},
    {(VUINT32) ((0x3C510D2B40000000uLL) >> 0),
     (VUINT32) ((0x3C510D2B40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FADEDEFB09791B4uLL) >> 0),
     (VUINT32) ((0x3FADEDEFB09791B4uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD58F9A75AB1FDDuLL) >> 0),
     (VUINT32) ((0x3FD58F9A75AB1FDDuLL) >> 32)},
    {(VUINT32) ((0xBC1EFDC0C0000000uLL) >> 0),
     (VUINT32) ((0xBC1EFDC0C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FABD95B4D43E819uLL) >> 0),
     (VUINT32) ((0x3FABD95B4D43E819uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD4D1E24278E76AuLL) >> 0),
     (VUINT32) ((0x3FD4D1E24278E76AuLL) >> 32)},
    {(VUINT32) ((0x3C62417200000000uLL) >> 0),
     (VUINT32) ((0x3C62417200000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA9D7713B71EEE1uLL) >> 0),
     (VUINT32) ((0x3FA9D7713B71EEE1uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD4135C94176601uLL) >> 0),
     (VUINT32) ((0x3FD4135C94176601uLL) >> 32)},
    {(VUINT32) ((0x3C70C97C40000000uLL) >> 0),
     (VUINT32) ((0x3C70C97C40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA7E8454B32EF34uLL) >> 0),
     (VUINT32) ((0x3FA7E8454B32EF34uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD35410C2E18152uLL) >> 0),
     (VUINT32) ((0x3FD35410C2E18152uLL) >> 32)},
    {(VUINT32) ((0xBC73CB0020000000uLL) >> 0),
     (VUINT32) ((0xBC73CB0020000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA60BEA939D225AuLL) >> 0),
     (VUINT32) ((0x3FA60BEA939D225AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD294062ED59F06uLL) >> 0),
     (VUINT32) ((0x3FD294062ED59F06uLL) >> 32)},
    {(VUINT32) ((0xBC75D28DA0000000uLL) >> 0),
     (VUINT32) ((0xBC75D28DA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA44273720F48BCuLL) >> 0),
     (VUINT32) ((0x3FA44273720F48BCuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD1D3443F4CDB3EuLL) >> 0),
     (VUINT32) ((0x3FD1D3443F4CDB3EuLL) >> 32)},
    {(VUINT32) ((0xBC6720D400000000uLL) >> 0),
     (VUINT32) ((0xBC6720D400000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA28BF1897B69CCuLL) >> 0),
     (VUINT32) ((0x3FA28BF1897B69CCuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD111D262B1F677uLL) >> 0),
     (VUINT32) ((0x3FD111D262B1F677uLL) >> 32)},
    {(VUINT32) ((0x3C7824C200000000uLL) >> 0),
     (VUINT32) ((0x3C7824C200000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA0E875C1B8C3DAuLL) >> 0),
     (VUINT32) ((0x3FA0E875C1B8C3DAuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD04FB80E37FDAEuLL) >> 0),
     (VUINT32) ((0x3FD04FB80E37FDAEuLL) >> 32)},
    {(VUINT32) ((0xBC0412CDA0000000uLL) >> 0),
     (VUINT32) ((0xBC0412CDA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9EB0208DB9E51BuLL) >> 0),
     (VUINT32) ((0x3F9EB0208DB9E51BuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCF19F97B215F1BuLL) >> 0),
     (VUINT32) ((0x3FCF19F97B215F1BuLL) >> 32)},
    {(VUINT32) ((0xBC642DEEE0000000uLL) >> 0),
     (VUINT32) ((0xBC642DEEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9BB5A11138A4C9uLL) >> 0),
     (VUINT32) ((0x3F9BB5A11138A4C9uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCD934FE5454311uLL) >> 0),
     (VUINT32) ((0x3FCD934FE5454311uLL) >> 32)},
    {(VUINT32) ((0x3C675B9220000000uLL) >> 0),
     (VUINT32) ((0x3C675B9220000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F98E18A73634EE7uLL) >> 0),
     (VUINT32) ((0x3F98E18A73634EE7uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCC0B826A7E4F63uLL) >> 0),
     (VUINT32) ((0x3FCC0B826A7E4F63uLL) >> 32)},
    {(VUINT32) ((0xBC1AF14380000000uLL) >> 0),
     (VUINT32) ((0xBC1AF14380000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9633F89E9A1A66uLL) >> 0),
     (VUINT32) ((0x3F9633F89E9A1A66uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCA82A025B00451uLL) >> 0),
     (VUINT32) ((0x3FCA82A025B00451uLL) >> 32)},
    {(VUINT32) ((0xBC687905E0000000uLL) >> 0),
     (VUINT32) ((0xBC687905E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F93AD06011469FBuLL) >> 0),
     (VUINT32) ((0x3F93AD06011469FBuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC8F8B83C69A60BuLL) >> 0),
     (VUINT32) ((0x3FC8F8B83C69A60BuLL) >> 32)},
    {(VUINT32) ((0xBC626D19A0000000uLL) >> 0),
     (VUINT32) ((0xBC626D19A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F914CCB8BDBF114uLL) >> 0),
     (VUINT32) ((0x3F914CCB8BDBF114uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC76DD9DE50BF31uLL) >> 0),
     (VUINT32) ((0x3FC76DD9DE50BF31uLL) >> 32)},
    {(VUINT32) ((0x3C61D5EEE0000000uLL) >> 0),
     (VUINT32) ((0x3C61D5EEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8E26C163AD15B3uLL) >> 0),
     (VUINT32) ((0x3F8E26C163AD15B3uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC5E214448B3FC6uLL) >> 0),
     (VUINT32) ((0x3FC5E214448B3FC6uLL) >> 32)},
    {(VUINT32) ((0x3C6531FF60000000uLL) >> 0),
     (VUINT32) ((0x3C6531FF60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8A01B6CDBD995EuLL) >> 0),
     (VUINT32) ((0x3F8A01B6CDBD995EuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC45576B1293E5AuLL) >> 0),
     (VUINT32) ((0x3FC45576B1293E5AuLL) >> 32)},
    {(VUINT32) ((0xBC5285A240000000uLL) >> 0),
     (VUINT32) ((0xBC5285A240000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F862AA03DD6BA58uLL) >> 0),
     (VUINT32) ((0x3F862AA03DD6BA58uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC2C8106E8E613AuLL) >> 0),
     (VUINT32) ((0x3FC2C8106E8E613AuLL) >> 32)},
    {(VUINT32) ((0x3C513000A0000000uLL) >> 0),
     (VUINT32) ((0x3C513000A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F82A1A39A8A2FB7uLL) >> 0),
     (VUINT32) ((0x3F82A1A39A8A2FB7uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC139F0CEDAF577uLL) >> 0),
     (VUINT32) ((0x3FC139F0CEDAF577uLL) >> 32)},
    {(VUINT32) ((0xBC65234340000000uLL) >> 0),
     (VUINT32) ((0xBC65234340000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7ECDC78F30165CuLL) >> 0),
     (VUINT32) ((0x3F7ECDC78F30165CuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBF564E56A9730EuLL) >> 0),
     (VUINT32) ((0x3FBF564E56A9730EuLL) >> 32)},
    {(VUINT32) ((0x3C4A270460000000uLL) >> 0),
     (VUINT32) ((0x3C4A270460000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F78F501492CC296uLL) >> 0),
     (VUINT32) ((0x3F78F501492CC296uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBC3785C79EC2D5uLL) >> 0),
     (VUINT32) ((0x3FBC3785C79EC2D5uLL) >> 32)},
    {(VUINT32) ((0xBC24F39DE0000000uLL) >> 0),
     (VUINT32) ((0xBC24F39DE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F73B92E176D6D31uLL) >> 0),
     (VUINT32) ((0x3F73B92E176D6D31uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB917A6BC29B42CuLL) >> 0),
     (VUINT32) ((0x3FB917A6BC29B42CuLL) >> 32)},
    {(VUINT32) ((0xBC3E2718C0000000uLL) >> 0),
     (VUINT32) ((0xBC3E2718C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6E350342A4F6E6uLL) >> 0),
     (VUINT32) ((0x3F6E350342A4F6E6uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5F6D00A9AA419uLL) >> 0),
     (VUINT32) ((0x3FB5F6D00A9AA419uLL) >> 32)},
    {(VUINT32) ((0xBC4F4022C0000000uLL) >> 0),
     (VUINT32) ((0xBC4F4022C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F663252FE77C5EBuLL) >> 0),
     (VUINT32) ((0x3F663252FE77C5EBuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB2D52092CE19F6uLL) >> 0),
     (VUINT32) ((0x3FB2D52092CE19F6uLL) >> 32)},
    {(VUINT32) ((0xBC49A088A0000000uLL) >> 0),
     (VUINT32) ((0xBC49A088A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F5ED534E31CA57FuLL) >> 0),
     (VUINT32) ((0x3F5ED534E31CA57FuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FAF656E79F820E0uLL) >> 0),
     (VUINT32) ((0x3FAF656E79F820E0uLL) >> 32)},
    {(VUINT32) ((0xBC22E1EBE0000000uLL) >> 0),
     (VUINT32) ((0xBC22E1EBE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F53BC390D250439uLL) >> 0),
     (VUINT32) ((0x3F53BC390D250439uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA91F65F10DD814uLL) >> 0),
     (VUINT32) ((0x3FA91F65F10DD814uLL) >> 32)},
    {(VUINT32) ((0xBC2912BD00000000uLL) >> 0),
     (VUINT32) ((0xBC2912BD00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F46344004228D8BuLL) >> 0),
     (VUINT32) ((0x3F46344004228D8BuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA2D865759455CDuLL) >> 0),
     (VUINT32) ((0x3FA2D865759455CDuLL) >> 32)},
    {(VUINT32) ((0x3C2686F640000000uLL) >> 0),
     (VUINT32) ((0x3C2686F640000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F33BCFBD9979A27uLL) >> 0),
     (VUINT32) ((0x3F33BCFBD9979A27uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F992155F7A3667EuLL) >> 0),
     (VUINT32) ((0x3F992155F7A3667EuLL) >> 32)},
    {(VUINT32) ((0xBBFB1D6300000000uLL) >> 0),
     (VUINT32) ((0xBBFB1D6300000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F13BD2C8DA49511uLL) >> 0),
     (VUINT32) ((0x3F13BD2C8DA49511uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F8921D1FCDEC784uLL) >> 0),
     (VUINT32) ((0x3F8921D1FCDEC784uLL) >> 32)},
    {(VUINT32) ((0x3C29878EA0000000uLL) >> 0),
     (VUINT32) ((0x3C29878EA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F13BD2C8DA49511uLL) >> 0),
     (VUINT32) ((0x3F13BD2C8DA49511uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF8921D1FCDEC784uLL) >> 0),
     (VUINT32) ((0xBF8921D1FCDEC784uLL) >> 32)},
    {(VUINT32) ((0xBC29878EA0000000uLL) >> 0),
     (VUINT32) ((0xBC29878EA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F33BCFBD9979A27uLL) >> 0),
     (VUINT32) ((0x3F33BCFBD9979A27uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF992155F7A3667EuLL) >> 0),
     (VUINT32) ((0xBF992155F7A3667EuLL) >> 32)},
    {(VUINT32) ((0x3BFB1D6300000000uLL) >> 0),
     (VUINT32) ((0x3BFB1D6300000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F46344004228D8BuLL) >> 0),
     (VUINT32) ((0x3F46344004228D8BuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA2D865759455CDuLL) >> 0),
     (VUINT32) ((0xBFA2D865759455CDuLL) >> 32)},
    {(VUINT32) ((0xBC2686F640000000uLL) >> 0),
     (VUINT32) ((0xBC2686F640000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F53BC390D250439uLL) >> 0),
     (VUINT32) ((0x3F53BC390D250439uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA91F65F10DD814uLL) >> 0),
     (VUINT32) ((0xBFA91F65F10DD814uLL) >> 32)},
    {(VUINT32) ((0x3C2912BD00000000uLL) >> 0),
     (VUINT32) ((0x3C2912BD00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F5ED534E31CA57FuLL) >> 0),
     (VUINT32) ((0x3F5ED534E31CA57FuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFAF656E79F820E0uLL) >> 0),
     (VUINT32) ((0xBFAF656E79F820E0uLL) >> 32)},
    {(VUINT32) ((0x3C22E1EBE0000000uLL) >> 0),
     (VUINT32) ((0x3C22E1EBE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F663252FE77C5EBuLL) >> 0),
     (VUINT32) ((0x3F663252FE77C5EBuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB2D52092CE19F6uLL) >> 0),
     (VUINT32) ((0xBFB2D52092CE19F6uLL) >> 32)},
    {(VUINT32) ((0x3C49A088A0000000uLL) >> 0),
     (VUINT32) ((0x3C49A088A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6E350342A4F6E6uLL) >> 0),
     (VUINT32) ((0x3F6E350342A4F6E6uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB5F6D00A9AA419uLL) >> 0),
     (VUINT32) ((0xBFB5F6D00A9AA419uLL) >> 32)},
    {(VUINT32) ((0x3C4F4022C0000000uLL) >> 0),
     (VUINT32) ((0x3C4F4022C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F73B92E176D6D31uLL) >> 0),
     (VUINT32) ((0x3F73B92E176D6D31uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB917A6BC29B42CuLL) >> 0),
     (VUINT32) ((0xBFB917A6BC29B42CuLL) >> 32)},
    {(VUINT32) ((0x3C3E2718C0000000uLL) >> 0),
     (VUINT32) ((0x3C3E2718C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F78F501492CC296uLL) >> 0),
     (VUINT32) ((0x3F78F501492CC296uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBC3785C79EC2D5uLL) >> 0),
     (VUINT32) ((0xBFBC3785C79EC2D5uLL) >> 32)},
    {(VUINT32) ((0x3C24F39DE0000000uLL) >> 0),
     (VUINT32) ((0x3C24F39DE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7ECDC78F30165CuLL) >> 0),
     (VUINT32) ((0x3F7ECDC78F30165CuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBF564E56A9730EuLL) >> 0),
     (VUINT32) ((0xBFBF564E56A9730EuLL) >> 32)},
    {(VUINT32) ((0xBC4A270460000000uLL) >> 0),
     (VUINT32) ((0xBC4A270460000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F82A1A39A8A2FB7uLL) >> 0),
     (VUINT32) ((0x3F82A1A39A8A2FB7uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC139F0CEDAF577uLL) >> 0),
     (VUINT32) ((0xBFC139F0CEDAF577uLL) >> 32)},
    {(VUINT32) ((0x3C65234340000000uLL) >> 0),
     (VUINT32) ((0x3C65234340000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F862AA03DD6BA58uLL) >> 0),
     (VUINT32) ((0x3F862AA03DD6BA58uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC2C8106E8E613AuLL) >> 0),
     (VUINT32) ((0xBFC2C8106E8E613AuLL) >> 32)},
    {(VUINT32) ((0xBC513000A0000000uLL) >> 0),
     (VUINT32) ((0xBC513000A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8A01B6CDBD995EuLL) >> 0),
     (VUINT32) ((0x3F8A01B6CDBD995EuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC45576B1293E5AuLL) >> 0),
     (VUINT32) ((0xBFC45576B1293E5AuLL) >> 32)},
    {(VUINT32) ((0x3C5285A240000000uLL) >> 0),
     (VUINT32) ((0x3C5285A240000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8E26C163AD15B3uLL) >> 0),
     (VUINT32) ((0x3F8E26C163AD15B3uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC5E214448B3FC6uLL) >> 0),
     (VUINT32) ((0xBFC5E214448B3FC6uLL) >> 32)},
    {(VUINT32) ((0xBC6531FF60000000uLL) >> 0),
     (VUINT32) ((0xBC6531FF60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F914CCB8BDBF114uLL) >> 0),
     (VUINT32) ((0x3F914CCB8BDBF114uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC76DD9DE50BF31uLL) >> 0),
     (VUINT32) ((0xBFC76DD9DE50BF31uLL) >> 32)},
    {(VUINT32) ((0xBC61D5EEE0000000uLL) >> 0),
     (VUINT32) ((0xBC61D5EEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F93AD06011469FBuLL) >> 0),
     (VUINT32) ((0x3F93AD06011469FBuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC8F8B83C69A60BuLL) >> 0),
     (VUINT32) ((0xBFC8F8B83C69A60BuLL) >> 32)},
    {(VUINT32) ((0x3C626D19A0000000uLL) >> 0),
     (VUINT32) ((0x3C626D19A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9633F89E9A1A66uLL) >> 0),
     (VUINT32) ((0x3F9633F89E9A1A66uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCA82A025B00451uLL) >> 0),
     (VUINT32) ((0xBFCA82A025B00451uLL) >> 32)},
    {(VUINT32) ((0x3C687905E0000000uLL) >> 0),
     (VUINT32) ((0x3C687905E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F98E18A73634EE7uLL) >> 0),
     (VUINT32) ((0x3F98E18A73634EE7uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCC0B826A7E4F63uLL) >> 0),
     (VUINT32) ((0xBFCC0B826A7E4F63uLL) >> 32)},
    {(VUINT32) ((0x3C1AF14380000000uLL) >> 0),
     (VUINT32) ((0x3C1AF14380000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9BB5A11138A4C9uLL) >> 0),
     (VUINT32) ((0x3F9BB5A11138A4C9uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCD934FE5454311uLL) >> 0),
     (VUINT32) ((0xBFCD934FE5454311uLL) >> 32)},
    {(VUINT32) ((0xBC675B9220000000uLL) >> 0),
     (VUINT32) ((0xBC675B9220000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9EB0208DB9E51BuLL) >> 0),
     (VUINT32) ((0x3F9EB0208DB9E51BuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCF19F97B215F1BuLL) >> 0),
     (VUINT32) ((0xBFCF19F97B215F1BuLL) >> 32)},
    {(VUINT32) ((0x3C642DEEE0000000uLL) >> 0),
     (VUINT32) ((0x3C642DEEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA0E875C1B8C3DAuLL) >> 0),
     (VUINT32) ((0x3FA0E875C1B8C3DAuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD04FB80E37FDAEuLL) >> 0),
     (VUINT32) ((0xBFD04FB80E37FDAEuLL) >> 32)},
    {(VUINT32) ((0x3C0412CDA0000000uLL) >> 0),
     (VUINT32) ((0x3C0412CDA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA28BF1897B69CCuLL) >> 0),
     (VUINT32) ((0x3FA28BF1897B69CCuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD111D262B1F677uLL) >> 0),
     (VUINT32) ((0xBFD111D262B1F677uLL) >> 32)},
    {(VUINT32) ((0xBC7824C200000000uLL) >> 0),
     (VUINT32) ((0xBC7824C200000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA44273720F48BCuLL) >> 0),
     (VUINT32) ((0x3FA44273720F48BCuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD1D3443F4CDB3EuLL) >> 0),
     (VUINT32) ((0xBFD1D3443F4CDB3EuLL) >> 32)},
    {(VUINT32) ((0x3C6720D400000000uLL) >> 0),
     (VUINT32) ((0x3C6720D400000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA60BEA939D225AuLL) >> 0),
     (VUINT32) ((0x3FA60BEA939D225AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD294062ED59F06uLL) >> 0),
     (VUINT32) ((0xBFD294062ED59F06uLL) >> 32)},
    {(VUINT32) ((0x3C75D28DA0000000uLL) >> 0),
     (VUINT32) ((0x3C75D28DA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA7E8454B32EF34uLL) >> 0),
     (VUINT32) ((0x3FA7E8454B32EF34uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD35410C2E18152uLL) >> 0),
     (VUINT32) ((0xBFD35410C2E18152uLL) >> 32)},
    {(VUINT32) ((0x3C73CB0020000000uLL) >> 0),
     (VUINT32) ((0x3C73CB0020000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA9D7713B71EEE1uLL) >> 0),
     (VUINT32) ((0x3FA9D7713B71EEE1uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD4135C94176601uLL) >> 0),
     (VUINT32) ((0xBFD4135C94176601uLL) >> 32)},
    {(VUINT32) ((0xBC70C97C40000000uLL) >> 0),
     (VUINT32) ((0xBC70C97C40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FABD95B4D43E819uLL) >> 0),
     (VUINT32) ((0x3FABD95B4D43E819uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD4D1E24278E76AuLL) >> 0),
     (VUINT32) ((0xBFD4D1E24278E76AuLL) >> 32)},
    {(VUINT32) ((0xBC62417200000000uLL) >> 0),
     (VUINT32) ((0xBC62417200000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FADEDEFB09791B4uLL) >> 0),
     (VUINT32) ((0x3FADEDEFB09791B4uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD58F9A75AB1FDDuLL) >> 0),
     (VUINT32) ((0xBFD58F9A75AB1FDDuLL) >> 32)},
    {(VUINT32) ((0x3C1EFDC0C0000000uLL) >> 0),
     (VUINT32) ((0x3C1EFDC0C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB00A8CEE920EABuLL) >> 0),
     (VUINT32) ((0x3FB00A8CEE920EABuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD64C7DDD3F27C6uLL) >> 0),
     (VUINT32) ((0xBFD64C7DDD3F27C6uLL) >> 32)},
    {(VUINT32) ((0xBC510D2B40000000uLL) >> 0),
     (VUINT32) ((0xBC510D2B40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB127624999EE1DuLL) >> 0),
     (VUINT32) ((0x3FB127624999EE1DuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD7088530FA459FuLL) >> 0),
     (VUINT32) ((0xBFD7088530FA459FuLL) >> 32)},
    {(VUINT32) ((0x3C744B19E0000000uLL) >> 0),
     (VUINT32) ((0x3C744B19E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB24D6CEE3AFB2AuLL) >> 0),
     (VUINT32) ((0x3FB24D6CEE3AFB2AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD7C3A9311DCCE7uLL) >> 0),
     (VUINT32) ((0xBFD7C3A9311DCCE7uLL) >> 32)},
    {(VUINT32) ((0xBC19A3F200000000uLL) >> 0),
     (VUINT32) ((0xBC19A3F200000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB37CA1866B95CFuLL) >> 0),
     (VUINT32) ((0x3FB37CA1866B95CFuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD87DE2A6AEA963uLL) >> 0),
     (VUINT32) ((0xBFD87DE2A6AEA963uLL) >> 32)},
    {(VUINT32) ((0x3C672CEDC0000000uLL) >> 0),
     (VUINT32) ((0x3C672CEDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB4B4F461B0CBAAuLL) >> 0),
     (VUINT32) ((0x3FB4B4F461B0CBAAuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD9372A63BC93D7uLL) >> 0),
     (VUINT32) ((0xBFD9372A63BC93D7uLL) >> 32)},
    {(VUINT32) ((0xBC66843180000000uLL) >> 0),
     (VUINT32) ((0xBC66843180000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB5F6597591B633uLL) >> 0),
     (VUINT32) ((0x3FB5F6597591B633uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD9EF7943A8ED8AuLL) >> 0),
     (VUINT32) ((0xBFD9EF7943A8ED8AuLL) >> 32)},
    {(VUINT32) ((0xBC66DA8120000000uLL) >> 0),
     (VUINT32) ((0xBC66DA8120000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB740C45E0E5120uLL) >> 0),
     (VUINT32) ((0x3FB740C45E0E5120uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDAA6C82B6D3FCAuLL) >> 0),
     (VUINT32) ((0xBFDAA6C82B6D3FCAuLL) >> 32)},
    {(VUINT32) ((0x3C7D5F1060000000uLL) >> 0),
     (VUINT32) ((0x3C7D5F1060000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB894285E19C468uLL) >> 0),
     (VUINT32) ((0x3FB894285E19C468uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDB5D1009E15CC0uLL) >> 0),
     (VUINT32) ((0xBFDB5D1009E15CC0uLL) >> 32)},
    {(VUINT32) ((0xBC65B362C0000000uLL) >> 0),
     (VUINT32) ((0xBC65B362C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB9F07860181D1EuLL) >> 0),
     (VUINT32) ((0x3FB9F07860181D1EuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDC1249D8011EE7uLL) >> 0),
     (VUINT32) ((0xBFDC1249D8011EE7uLL) >> 32)},
    {(VUINT32) ((0x3C7813AAA0000000uLL) >> 0),
     (VUINT32) ((0x3C7813AAA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBB55A6F65F7058uLL) >> 0),
     (VUINT32) ((0x3FBB55A6F65F7058uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDCC66E9931C45EuLL) >> 0),
     (VUINT32) ((0xBFDCC66E9931C45EuLL) >> 32)},
    {(VUINT32) ((0xBC56850E40000000uLL) >> 0),
     (VUINT32) ((0xBC56850E40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBCC3A65BBC6327uLL) >> 0),
     (VUINT32) ((0x3FBCC3A65BBC6327uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDD79775B86E389uLL) >> 0),
     (VUINT32) ((0xBFDD79775B86E389uLL) >> 32)},
    {(VUINT32) ((0xBC7550EC80000000uLL) >> 0),
     (VUINT32) ((0xBC7550EC80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBE3A6873FA1279uLL) >> 0),
     (VUINT32) ((0x3FBE3A6873FA1279uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDE2B5D3806F63BuLL) >> 0),
     (VUINT32) ((0xBFDE2B5D3806F63BuLL) >> 32)},
    {(VUINT32) ((0xBC5E0D8900000000uLL) >> 0),
     (VUINT32) ((0xBC5E0D8900000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBFB9DECC6D55B8uLL) >> 0),
     (VUINT32) ((0x3FBFB9DECC6D55B8uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDEDC1952EF78D6uLL) >> 0),
     (VUINT32) ((0xBFDEDC1952EF78D6uLL) >> 32)},
    {(VUINT32) ((0x3C7DD0F7C0000000uLL) >> 0),
     (VUINT32) ((0x3C7DD0F7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC0A0FD4E41AB5AuLL) >> 0),
     (VUINT32) ((0x3FC0A0FD4E41AB5AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDF8BA4DBF89ABAuLL) >> 0),
     (VUINT32) ((0xBFDF8BA4DBF89ABAuLL) >> 32)},
    {(VUINT32) ((0x3C32EC1FC0000000uLL) >> 0),
     (VUINT32) ((0x3C32EC1FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC169566329BCB7uLL) >> 0),
     (VUINT32) ((0x3FC169566329BCB7uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE01CFC874C3EB7uLL) >> 0),
     (VUINT32) ((0xBFE01CFC874C3EB7uLL) >> 32)},
    {(VUINT32) ((0x3C734A35E0000000uLL) >> 0),
     (VUINT32) ((0x3C734A35E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC235F2EB9A470AuLL) >> 0),
     (VUINT32) ((0x3FC235F2EB9A470AuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE073879922FFEEuLL) >> 0),
     (VUINT32) ((0xBFE073879922FFEEuLL) >> 32)},
    {(VUINT32) ((0x3C8A5A0140000000uLL) >> 0),
     (VUINT32) ((0x3C8A5A0140000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC306CB042AA3BAuLL) >> 0),
     (VUINT32) ((0x3FC306CB042AA3BAuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE0C9704D5D898FuLL) >> 0),
     (VUINT32) ((0xBFE0C9704D5D898FuLL) >> 32)},
    {(VUINT32) ((0x3C88D3D7C0000000uLL) >> 0),
     (VUINT32) ((0x3C88D3D7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC3DBD69FABF802uLL) >> 0),
     (VUINT32) ((0x3FC3DBD69FABF802uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE11EB3541B4B23uLL) >> 0),
     (VUINT32) ((0xBFE11EB3541B4B23uLL) >> 32)},
    {(VUINT32) ((0x3C8EF23B60000000uLL) >> 0),
     (VUINT32) ((0x3C8EF23B60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC4B50D8778ABBDuLL) >> 0),
     (VUINT32) ((0x3FC4B50D8778ABBDuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE1734D63DEDB49uLL) >> 0),
     (VUINT32) ((0xBFE1734D63DEDB49uLL) >> 32)},
    {(VUINT32) ((0x3C87EEF2C0000000uLL) >> 0),
     (VUINT32) ((0x3C87EEF2C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC592675BC57974uLL) >> 0),
     (VUINT32) ((0x3FC592675BC57974uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE1C73B39AE68C8uLL) >> 0),
     (VUINT32) ((0xBFE1C73B39AE68C8uLL) >> 32)},
    {(VUINT32) ((0xBC8B25DD20000000uLL) >> 0),
     (VUINT32) ((0xBC8B25DD20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC673DB93F41479uLL) >> 0),
     (VUINT32) ((0x3FC673DB93F41479uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE21A799933EB59uLL) >> 0),
     (VUINT32) ((0xBFE21A799933EB59uLL) >> 32)},
    {(VUINT32) ((0x3C83A7B160000000uLL) >> 0),
     (VUINT32) ((0x3C83A7B160000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC759617EE761F9uLL) >> 0),
     (VUINT32) ((0x3FC759617EE761F9uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE26D054CDD12DFuLL) >> 0),
     (VUINT32) ((0xBFE26D054CDD12DFuLL) >> 32)},
    {(VUINT32) ((0x3C85DA7420000000uLL) >> 0),
     (VUINT32) ((0x3C85DA7420000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC842F0435941AFuLL) >> 0),
     (VUINT32) ((0x3FC842F0435941AFuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE2BEDB25FAF3EAuLL) >> 0),
     (VUINT32) ((0xBFE2BEDB25FAF3EAuLL) >> 32)},
    {(VUINT32) ((0x3C514981C0000000uLL) >> 0),
     (VUINT32) ((0x3C514981C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC9307EE031E2FDuLL) >> 0),
     (VUINT32) ((0x3FC9307EE031E2FDuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE30FF7FCE17035uLL) >> 0),
     (VUINT32) ((0xBFE30FF7FCE17035uLL) >> 32)},
    {(VUINT32) ((0x3C6EFCC620000000uLL) >> 0),
     (VUINT32) ((0x3C6EFCC620000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCA22042CE0A2F9uLL) >> 0),
     (VUINT32) ((0x3FCA22042CE0A2F9uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE36058B10659F3uLL) >> 0),
     (VUINT32) ((0xBFE36058B10659F3uLL) >> 32)},
    {(VUINT32) ((0x3C81FCB3A0000000uLL) >> 0),
     (VUINT32) ((0x3C81FCB3A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCB1776D9B67013uLL) >> 0),
     (VUINT32) ((0x3FCB1776D9B67013uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE3AFFA292050B9uLL) >> 0),
     (VUINT32) ((0xBFE3AFFA292050B9uLL) >> 32)},
    {(VUINT32) ((0xBC7E3E25E0000000uLL) >> 0),
     (VUINT32) ((0xBC7E3E25E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCC10CD7041AFCCuLL) >> 0),
     (VUINT32) ((0x3FCC10CD7041AFCCuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE3FED9534556D4uLL) >> 0),
     (VUINT32) ((0xBFE3FED9534556D4uLL) >> 32)},
    {(VUINT32) ((0xBC83691660000000uLL) >> 0),
     (VUINT32) ((0xBC83691660000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCD0DFE53ABA2FDuLL) >> 0),
     (VUINT32) ((0x3FCD0DFE53ABA2FDuLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE44CF325091DD6uLL) >> 0),
     (VUINT32) ((0xBFE44CF325091DD6uLL) >> 32)},
    {(VUINT32) ((0xBC68076A20000000uLL) >> 0),
     (VUINT32) ((0xBC68076A20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCE0EFFC1174505uLL) >> 0),
     (VUINT32) ((0x3FCE0EFFC1174505uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE49A449B9B0939uLL) >> 0),
     (VUINT32) ((0xBFE49A449B9B0939uLL) >> 32)},
    {(VUINT32) ((0x3C827EE160000000uLL) >> 0),
     (VUINT32) ((0x3C827EE160000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCF13C7D001A249uLL) >> 0),
     (VUINT32) ((0x3FCF13C7D001A249uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE4E6CABBE3E5E9uLL) >> 0),
     (VUINT32) ((0xBFE4E6CABBE3E5E9uLL) >> 32)},
    {(VUINT32) ((0xBC63C293E0000000uLL) >> 0),
     (VUINT32) ((0xBC63C293E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCFE3B38D5C5DC2uLL) >> 0),
     (VUINT32) ((0xBFCFE3B38D5C5DC2uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE5328292A35596uLL) >> 0),
     (VUINT32) ((0xBFE5328292A35596uLL) >> 32)},
    {(VUINT32) ((0x3C7A12EB80000000uLL) >> 0),
     (VUINT32) ((0x3C7A12EB80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCED77C89AABEBBuLL) >> 0),
     (VUINT32) ((0xBFCED77C89AABEBBuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE57D69348CECA0uLL) >> 0),
     (VUINT32) ((0xBFE57D69348CECA0uLL) >> 32)},
    {(VUINT32) ((0x3C87572080000000uLL) >> 0),
     (VUINT32) ((0x3C87572080000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCDC79D7C0DC985uLL) >> 0),
     (VUINT32) ((0xBFCDC79D7C0DC985uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE5C77BBE65018CuLL) >> 0),
     (VUINT32) ((0xBFE5C77BBE65018CuLL) >> 32)},
    {(VUINT32) ((0xBC8069EA80000000uLL) >> 0),
     (VUINT32) ((0xBC8069EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCCB420DFBFFE59uLL) >> 0),
     (VUINT32) ((0xBFCCB420DFBFFE59uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE610B7551D2CDFuLL) >> 0),
     (VUINT32) ((0xBFE610B7551D2CDFuLL) >> 32)},
    {(VUINT32) ((0x3C7251B340000000uLL) >> 0),
     (VUINT32) ((0x3C7251B340000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCB9D1153AAA2BAuLL) >> 0),
     (VUINT32) ((0xBFCB9D1153AAA2BAuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE6591925F0783DuLL) >> 0),
     (VUINT32) ((0xBFE6591925F0783DuLL) >> 32)},
    {(VUINT32) ((0xBC8C3D64E0000000uLL) >> 0),
     (VUINT32) ((0xBC8C3D64E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCA827999FCEF32uLL) >> 0),
     (VUINT32) ((0xBFCA827999FCEF32uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE6A09E667F3BCDuLL) >> 0),
     (VUINT32) ((0xBFE6A09E667F3BCDuLL) >> 32)},
    {(VUINT32) ((0x3C8BDD3400000000uLL) >> 0),
     (VUINT32) ((0x3C8BDD3400000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC9646497C1E0F6uLL) >> 0),
     (VUINT32) ((0xBFC9646497C1E0F6uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE6E74454EAA8AFuLL) >> 0),
     (VUINT32) ((0xBFE6E74454EAA8AFuLL) >> 32)},
    {(VUINT32) ((0x3C8DBC03C0000000uLL) >> 0),
     (VUINT32) ((0x3C8DBC03C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC842DD5474B37BuLL) >> 0),
     (VUINT32) ((0xBFC842DD5474B37BuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE72D0837EFFF96uLL) >> 0),
     (VUINT32) ((0xBFE72D0837EFFF96uLL) >> 32)},
    {(VUINT32) ((0xBC80D4EF00000000uLL) >> 0),
     (VUINT32) ((0xBC80D4EF00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC71DEEF9940631uLL) >> 0),
     (VUINT32) ((0xBFC71DEEF9940631uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE771E75F037261uLL) >> 0),
     (VUINT32) ((0xBFE771E75F037261uLL) >> 32)},
    {(VUINT32) ((0xBC75CFCE80000000uLL) >> 0),
     (VUINT32) ((0xBC75CFCE80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC5F5A4D233B27FuLL) >> 0),
     (VUINT32) ((0xBFC5F5A4D233B27FuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE7B5DF226AAFAFuLL) >> 0),
     (VUINT32) ((0xBFE7B5DF226AAFAFuLL) >> 32)},
    {(VUINT32) ((0x3C70F537A0000000uLL) >> 0),
     (VUINT32) ((0x3C70F537A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC4CA0A4A8D5657uLL) >> 0),
     (VUINT32) ((0xBFC4CA0A4A8D5657uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE7F8ECE3571771uLL) >> 0),
     (VUINT32) ((0xBFE7F8ECE3571771uLL) >> 32)},
    {(VUINT32) ((0x3C89C8D8C0000000uLL) >> 0),
     (VUINT32) ((0x3C89C8D8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC39B2AEF8F97A4uLL) >> 0),
     (VUINT32) ((0xBFC39B2AEF8F97A4uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE83B0E0BFF976EuLL) >> 0),
     (VUINT32) ((0xBFE83B0E0BFF976EuLL) >> 32)},
    {(VUINT32) ((0x3C76F420E0000000uLL) >> 0),
     (VUINT32) ((0x3C76F420E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC269126E6C24E3uLL) >> 0),
     (VUINT32) ((0xBFC269126E6C24E3uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE87C400FBA2EBFuLL) >> 0),
     (VUINT32) ((0xBFE87C400FBA2EBFuLL) >> 32)},
    {(VUINT32) ((0x3C82DABC00000000uLL) >> 0),
     (VUINT32) ((0x3C82DABC00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC133CC94247758uLL) >> 0),
     (VUINT32) ((0xBFC133CC94247758uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE8BC806B151741uLL) >> 0),
     (VUINT32) ((0xBFE8BC806B151741uLL) >> 32)},
    {(VUINT32) ((0x3C82C5E120000000uLL) >> 0),
     (VUINT32) ((0x3C82C5E120000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBFF6CA9A2AB6A2uLL) >> 0),
     (VUINT32) ((0xBFBFF6CA9A2AB6A2uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE8FBCCA3EF940DuLL) >> 0),
     (VUINT32) ((0xBFE8FBCCA3EF940DuLL) >> 32)},
    {(VUINT32) ((0x3C66DFA980000000uLL) >> 0),
     (VUINT32) ((0x3C66DFA980000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBD7FD1490285CAuLL) >> 0),
     (VUINT32) ((0xBFBD7FD1490285CAuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE93A22499263FBuLL) >> 0),
     (VUINT32) ((0xBFE93A22499263FBuLL) >> 32)},
    {(VUINT32) ((0xBC83D419A0000000uLL) >> 0),
     (VUINT32) ((0xBC83D419A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBB02C58832CF96uLL) >> 0),
     (VUINT32) ((0xBFBB02C58832CF96uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE9777EF4C7D742uLL) >> 0),
     (VUINT32) ((0xBFE9777EF4C7D742uLL) >> 32)},
    {(VUINT32) ((0x3C815479A0000000uLL) >> 0),
     (VUINT32) ((0x3C815479A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB87FBFE70B81A7uLL) >> 0),
     (VUINT32) ((0xBFB87FBFE70B81A7uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE9B3E047F38741uLL) >> 0),
     (VUINT32) ((0xBFE9B3E047F38741uLL) >> 32)},
    {(VUINT32) ((0x3C830EE280000000uLL) >> 0),
     (VUINT32) ((0x3C830EE280000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB5F6D92FD79F50uLL) >> 0),
     (VUINT32) ((0xBFB5F6D92FD79F50uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE9EF43EF29AF94uLL) >> 0),
     (VUINT32) ((0xBFE9EF43EF29AF94uLL) >> 32)},
    {(VUINT32) ((0xBC7B1DFCA0000000uLL) >> 0),
     (VUINT32) ((0xBC7B1DFCA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB3682A66E896F5uLL) >> 0),
     (VUINT32) ((0xBFB3682A66E896F5uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEA29A7A0462782uLL) >> 0),
     (VUINT32) ((0xBFEA29A7A0462782uLL) >> 32)},
    {(VUINT32) ((0x3C7128BB00000000uLL) >> 0),
     (VUINT32) ((0x3C7128BB00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB0D3CCC99F5AC6uLL) >> 0),
     (VUINT32) ((0xBFB0D3CCC99F5AC6uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEA63091B02FAE2uLL) >> 0),
     (VUINT32) ((0xBFEA63091B02FAE2uLL) >> 32)},
    {(VUINT32) ((0x3C7E911140000000uLL) >> 0),
     (VUINT32) ((0x3C7E911140000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAC73B39AE68C87uLL) >> 0),
     (VUINT32) ((0xBFAC73B39AE68C87uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEA9B66290EA1A3uLL) >> 0),
     (VUINT32) ((0xBFEA9B66290EA1A3uLL) >> 32)},
    {(VUINT32) ((0xBC39F630E0000000uLL) >> 0),
     (VUINT32) ((0xBC39F630E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA734D63DEDB48AuLL) >> 0),
     (VUINT32) ((0xBFA734D63DEDB48AuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEAD2BC9E21D511uLL) >> 0),
     (VUINT32) ((0xBFEAD2BC9E21D511uLL) >> 32)},
    {(VUINT32) ((0x3C847FBE00000000uLL) >> 0),
     (VUINT32) ((0x3C847FBE00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA1EB3541B4B228uLL) >> 0),
     (VUINT32) ((0xBFA1EB3541B4B228uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEB090A58150200uLL) >> 0),
     (VUINT32) ((0xBFEB090A58150200uLL) >> 32)},
    {(VUINT32) ((0x3C8926DA20000000uLL) >> 0),
     (VUINT32) ((0x3C8926DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF992E09ABB131D4uLL) >> 0),
     (VUINT32) ((0xBF992E09ABB131D4uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEB3E4D3EF55712uLL) >> 0),
     (VUINT32) ((0xBFEB3E4D3EF55712uLL) >> 32)},
    {(VUINT32) ((0x3C8EB6B8A0000000uLL) >> 0),
     (VUINT32) ((0x3C8EB6B8A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8CE1E648BFFB66uLL) >> 0),
     (VUINT32) ((0xBF8CE1E648BFFB66uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEB728345196E3EuLL) >> 0),
     (VUINT32) ((0xBFEB728345196E3EuLL) >> 32)},
    {(VUINT32) ((0x3C8BC69F20000000uLL) >> 0),
     (VUINT32) ((0x3C8BC69F20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6CFC874C3EB6D9uLL) >> 0),
     (VUINT32) ((0xBF6CFC874C3EB6D9uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEBA5AA673590D2uLL) >> 0),
     (VUINT32) ((0xBFEBA5AA673590D2uLL) >> 32)},
    {(VUINT32) ((0xBC87EA4E20000000uLL) >> 0),
     (VUINT32) ((0xBC87EA4E20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7D16C901D95181uLL) >> 0),
     (VUINT32) ((0x3F7D16C901D95181uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEBD7C0AC6F952AuLL) >> 0),
     (VUINT32) ((0xBFEBD7C0AC6F952AuLL) >> 32)},
    {(VUINT32) ((0x3C8825A720000000uLL) >> 0),
     (VUINT32) ((0x3C8825A720000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F923E6AD10872A7uLL) >> 0),
     (VUINT32) ((0x3F923E6AD10872A7uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC08C426725549uLL) >> 0),
     (VUINT32) ((0xBFEC08C426725549uLL) >> 32)},
    {(VUINT32) ((0xBC5B157FC0000000uLL) >> 0),
     (VUINT32) ((0xBC5B157FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9D4A2C7F909C4EuLL) >> 0),
     (VUINT32) ((0x3F9D4A2C7F909C4EuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC38B2F180BDB1uLL) >> 0),
     (VUINT32) ((0xBFEC38B2F180BDB1uLL) >> 32)},
    {(VUINT32) ((0x3C76E0B160000000uLL) >> 0),
     (VUINT32) ((0x3C76E0B160000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA4344523C8E3B5uLL) >> 0),
     (VUINT32) ((0x3FA4344523C8E3B5uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC678B3488739BuLL) >> 0),
     (VUINT32) ((0xBFEC678B3488739BuLL) >> 32)},
    {(VUINT32) ((0xBC6D86CAC0000000uLL) >> 0),
     (VUINT32) ((0xBC6D86CAC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA9CC8B3671DD0FuLL) >> 0),
     (VUINT32) ((0x3FA9CC8B3671DD0FuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC954B213411F5uLL) >> 0),
     (VUINT32) ((0xBFEC954B213411F5uLL) >> 32)},
    {(VUINT32) ((0x3C52FB7600000000uLL) >> 0),
     (VUINT32) ((0x3C52FB7600000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAF6DB13FF708CBuLL) >> 0),
     (VUINT32) ((0x3FAF6DB13FF708CBuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFECC1F0F3FCFC5CuLL) >> 0),
     (VUINT32) ((0xBFECC1F0F3FCFC5CuLL) >> 32)},
    {(VUINT32) ((0xBC7E576120000000uLL) >> 0),
     (VUINT32) ((0xBC7E576120000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB28BBFD87A8CFFuLL) >> 0),
     (VUINT32) ((0x3FB28BBFD87A8CFFuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFECED7AF43CC773uLL) >> 0),
     (VUINT32) ((0xBFECED7AF43CC773uLL) >> 32)},
    {(VUINT32) ((0x3C5E7B6BA0000000uLL) >> 0),
     (VUINT32) ((0x3C5E7B6BA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB564DF524B00DAuLL) >> 0),
     (VUINT32) ((0x3FB564DF524B00DAuLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED17E7743E35DCuLL) >> 0),
     (VUINT32) ((0xBFED17E7743E35DCuLL) >> 32)},
    {(VUINT32) ((0x3C5101DA20000000uLL) >> 0),
     (VUINT32) ((0x3C5101DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB8421AF15C49D7uLL) >> 0),
     (VUINT32) ((0x3FB8421AF15C49D7uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED4134D14DC93AuLL) >> 0),
     (VUINT32) ((0xBFED4134D14DC93AuLL) >> 32)},
    {(VUINT32) ((0x3C84EF5280000000uLL) >> 0),
     (VUINT32) ((0x3C84EF5280000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBB2356710DB0A3uLL) >> 0),
     (VUINT32) ((0x3FBB2356710DB0A3uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED696173C9E68BuLL) >> 0),
     (VUINT32) ((0xBFED696173C9E68BuLL) >> 32)},
    {(VUINT32) ((0x3C7E8C61C0000000uLL) >> 0),
     (VUINT32) ((0x3C7E8C61C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBE087565455A75uLL) >> 0),
     (VUINT32) ((0x3FBE087565455A75uLL) >> 32)},
    {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
     (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED906BCF328D46uLL) >> 0),
     (VUINT32) ((0xBFED906BCF328D46uLL) >> 32)},
    {(VUINT32) ((0xBC7457E600000000uLL) >> 0),
     (VUINT32) ((0xBC7457E600000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBF0EA4C477339CuLL) >> 0),
     (VUINT32) ((0xBFBF0EA4C477339CuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEDB6526238A09BuLL) >> 0),
     (VUINT32) ((0xBFEDB6526238A09BuLL) >> 32)},
    {(VUINT32) ((0x3C7ADEE7E0000000uLL) >> 0),
     (VUINT32) ((0x3C7ADEE7E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBC2214C3E9167BuLL) >> 0),
     (VUINT32) ((0xBFBC2214C3E9167BuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEDDB13B6CCC23CuLL) >> 0),
     (VUINT32) ((0xBFEDDB13B6CCC23CuLL) >> 32)},
    {(VUINT32) ((0xBC883C37C0000000uLL) >> 0),
     (VUINT32) ((0xBC883C37C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB931F774FC9F18uLL) >> 0),
     (VUINT32) ((0xBFB931F774FC9F18uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEDFEAE622DBE2BuLL) >> 0),
     (VUINT32) ((0xBFEDFEAE622DBE2BuLL) >> 32)},
    {(VUINT32) ((0x3C8514EA80000000uLL) >> 0),
     (VUINT32) ((0x3C8514EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB63E69D6AC7F74uLL) >> 0),
     (VUINT32) ((0xBFB63E69D6AC7F74uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE212104F686E5uLL) >> 0),
     (VUINT32) ((0xBFEE212104F686E5uLL) >> 32)},
    {(VUINT32) ((0x3C8014C760000000uLL) >> 0),
     (VUINT32) ((0x3C8014C760000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB3478909E39DA9uLL) >> 0),
     (VUINT32) ((0xBFB3478909E39DA9uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE426A4B2BC17EuLL) >> 0),
     (VUINT32) ((0xBFEE426A4B2BC17EuLL) >> 32)},
    {(VUINT32) ((0xBC8A873880000000uLL) >> 0),
     (VUINT32) ((0xBC8A873880000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB04D72505D9805uLL) >> 0),
     (VUINT32) ((0xBFB04D72505D9805uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE6288EC48E112uLL) >> 0),
     (VUINT32) ((0xBFEE6288EC48E112uLL) >> 32)},
    {(VUINT32) ((0x3C616B56E0000000uLL) >> 0),
     (VUINT32) ((0x3C616B56E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAAA086170C0A8EuLL) >> 0),
     (VUINT32) ((0xBFAAA086170C0A8EuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE817BAB4CD10DuLL) >> 0),
     (VUINT32) ((0xBFEE817BAB4CD10DuLL) >> 32)},
    {(VUINT32) ((0x3C7D0AFE60000000uLL) >> 0),
     (VUINT32) ((0x3C7D0AFE60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA4A03176ACF82DuLL) >> 0),
     (VUINT32) ((0xBFA4A03176ACF82DuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE9F4156C62DDAuLL) >> 0),
     (VUINT32) ((0xBFEE9F4156C62DDAuLL) >> 32)},
    {(VUINT32) ((0xBC8760B1E0000000uLL) >> 0),
     (VUINT32) ((0xBC8760B1E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9D3443F4CDB3DDuLL) >> 0),
     (VUINT32) ((0xBF9D3443F4CDB3DDuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEEBBD8C8DF0B74uLL) >> 0),
     (VUINT32) ((0xBFEEBBD8C8DF0B74uLL) >> 32)},
    {(VUINT32) ((0xBC7C6C8C60000000uLL) >> 0),
     (VUINT32) ((0xBC7C6C8C60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF911D262B1F6776uLL) >> 0),
     (VUINT32) ((0xBF911D262B1F6776uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEED740E7684963uLL) >> 0),
     (VUINT32) ((0xBFEED740E7684963uLL) >> 32)},
    {(VUINT32) ((0xBC7E82C780000000uLL) >> 0),
     (VUINT32) ((0xBC7E82C780000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF73EE038DFF6B80uLL) >> 0),
     (VUINT32) ((0xBF73EE038DFF6B80uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEEF178A3E473C2uLL) >> 0),
     (VUINT32) ((0xBFEEF178A3E473C2uLL) >> 32)},
    {(VUINT32) ((0xBC86310A60000000uLL) >> 0),
     (VUINT32) ((0xBC86310A60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7CC0D09BD41CAAuLL) >> 0),
     (VUINT32) ((0x3F7CC0D09BD41CAAuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF0A7EFB9230D7uLL) >> 0),
     (VUINT32) ((0xBFEF0A7EFB9230D7uLL) >> 32)},
    {(VUINT32) ((0xBC752C7AC0000000uLL) >> 0),
     (VUINT32) ((0xBC752C7AC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F936580D5D5E775uLL) >> 0),
     (VUINT32) ((0x3F936580D5D5E775uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF2252F7763ADAuLL) >> 0),
     (VUINT32) ((0xBFEF2252F7763ADAuLL) >> 32)},
    {(VUINT32) ((0x3C820CB800000000uLL) >> 0),
     (VUINT32) ((0x3C820CB800000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9FA3ECAC0D84E8uLL) >> 0),
     (VUINT32) ((0x3F9FA3ECAC0D84E8uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF38F3AC64E589uLL) >> 0),
     (VUINT32) ((0xBFEF38F3AC64E589uLL) >> 32)},
    {(VUINT32) ((0x3C7D7BAFA0000000uLL) >> 0),
     (VUINT32) ((0x3C7D7BAFA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA5F57F693FEEBEuLL) >> 0),
     (VUINT32) ((0x3FA5F57F693FEEBEuLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF4E603B0B2F2DuLL) >> 0),
     (VUINT32) ((0xBFEF4E603B0B2F2DuLL) >> 32)},
    {(VUINT32) ((0x3C78EE01E0000000uLL) >> 0),
     (VUINT32) ((0x3C78EE01E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAC1D1F0E5967D5uLL) >> 0),
     (VUINT32) ((0x3FAC1D1F0E5967D5uLL) >> 32)},
    {(VUINT32) ((0xBFD0000000000000uLL) >> 0),
     (VUINT32) ((0xBFD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF6297CFF75CB0uLL) >> 0),
     (VUINT32) ((0xBFEF6297CFF75CB0uLL) >> 32)},
    {(VUINT32) ((0xBC75621720000000uLL) >> 0),
     (VUINT32) ((0xBC75621720000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFADB7677942FCC5uLL) >> 0),
     (VUINT32) ((0xBFADB7677942FCC5uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF7599A3A12077uLL) >> 0),
     (VUINT32) ((0xBFEF7599A3A12077uLL) >> 32)},
    {(VUINT32) ((0xBC884F31C0000000uLL) >> 0),
     (VUINT32) ((0xBC884F31C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA78851122CFF19uLL) >> 0),
     (VUINT32) ((0xBFA78851122CFF19uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF8764FA714BA9uLL) >> 0),
     (VUINT32) ((0xBFEF8764FA714BA9uLL) >> 32)},
    {(VUINT32) ((0xBC7AB25660000000uLL) >> 0),
     (VUINT32) ((0xBC7AB25660000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA155DAC4A4F967uLL) >> 0),
     (VUINT32) ((0xBFA155DAC4A4F967uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF97F924C9099BuLL) >> 0),
     (VUINT32) ((0xBFEF97F924C9099BuLL) >> 32)},
    {(VUINT32) ((0x3C8E2AE0E0000000uLL) >> 0),
     (VUINT32) ((0x3C8E2AE0E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF964083747309D1uLL) >> 0),
     (VUINT32) ((0xBF964083747309D1uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFA7557F08A517uLL) >> 0),
     (VUINT32) ((0xBFEFA7557F08A517uLL) >> 32)},
    {(VUINT32) ((0x3C87A0A8C0000000uLL) >> 0),
     (VUINT32) ((0x3C87A0A8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF839F0CEDAF576BuLL) >> 0),
     (VUINT32) ((0xBF839F0CEDAF576BuLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFB5797195D741uLL) >> 0),
     (VUINT32) ((0xBFEFB5797195D741uLL) >> 32)},
    {(VUINT32) ((0xBC71BFAC60000000uLL) >> 0),
     (VUINT32) ((0xBC71BFAC60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6536352AD19E39uLL) >> 0),
     (VUINT32) ((0x3F6536352AD19E39uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFC26470E19FD3uLL) >> 0),
     (VUINT32) ((0xBFEFC26470E19FD3uLL) >> 32)},
    {(VUINT32) ((0xBC81EC8660000000uLL) >> 0),
     (VUINT32) ((0xBC81EC8660000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8E43D1C309E958uLL) >> 0),
     (VUINT32) ((0x3F8E43D1C309E958uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFCE15FD6DA67BuLL) >> 0),
     (VUINT32) ((0xBFEFCE15FD6DA67BuLL) >> 32)},
    {(VUINT32) ((0x3C75DD6F80000000uLL) >> 0),
     (VUINT32) ((0x3C75DD6F80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9BA1650F592F50uLL) >> 0),
     (VUINT32) ((0x3F9BA1650F592F50uLL) >> 32)},
    {(VUINT32) ((0xBFC0000000000000uLL) >> 0),
     (VUINT32) ((0xBFC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFD88DA3D12526uLL) >> 0),
     (VUINT32) ((0xBFEFD88DA3D12526uLL) >> 32)},
    {(VUINT32) ((0x3C887DF620000000uLL) >> 0),
     (VUINT32) ((0x3C887DF620000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF97DB402A6A9063uLL) >> 0),
     (VUINT32) ((0xBF97DB402A6A9063uLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
     (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFE1CAFCBD5B09uLL) >> 0),
     (VUINT32) ((0xBFEFE1CAFCBD5B09uLL) >> 32)},
    {(VUINT32) ((0xBC6A23E320000000uLL) >> 0),
     (VUINT32) ((0xBC6A23E320000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF86A9049670CFAEuLL) >> 0),
     (VUINT32) ((0xBF86A9049670CFAEuLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
     (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFE9CDAD01883AuLL) >> 0),
     (VUINT32) ((0xBFEFE9CDAD01883AuLL) >> 32)},
    {(VUINT32) ((0xBC6521ECC0000000uLL) >> 0),
     (VUINT32) ((0xBC6521ECC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F535230C0FBE402uLL) >> 0),
     (VUINT32) ((0x3F535230C0FBE402uLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
     (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFF095658E71ADuLL) >> 0),
     (VUINT32) ((0xBFEFF095658E71ADuLL) >> 32)},
    {(VUINT32) ((0xBC801A8CE0000000uLL) >> 0),
     (VUINT32) ((0xBC801A8CE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8B82683BC89FB0uLL) >> 0),
     (VUINT32) ((0x3F8B82683BC89FB0uLL) >> 32)},
    {(VUINT32) ((0xBFB0000000000000uLL) >> 0),
     (VUINT32) ((0xBFB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFF621E3796D7EuLL) >> 0),
     (VUINT32) ((0xBFEFF621E3796D7EuLL) >> 32)},
    {(VUINT32) ((0x3C6C57BC20000000uLL) >> 0),
     (VUINT32) ((0x3C6C57BC20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF76C32BACA2AE69uLL) >> 0),
     (VUINT32) ((0xBF76C32BACA2AE69uLL) >> 32)},
    {(VUINT32) ((0xBFA0000000000000uLL) >> 0),
     (VUINT32) ((0xBFA0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFFA72EFFEF75DuLL) >> 0),
     (VUINT32) ((0xBFEFFA72EFFEF75DuLL) >> 32)},
    {(VUINT32) ((0x3C88B4CDC0000000uLL) >> 0),
     (VUINT32) ((0x3C88B4CDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F7B7AA821726608uLL) >> 0),
     (VUINT32) ((0x3F7B7AA821726608uLL) >> 32)},
    {(VUINT32) ((0xBFA0000000000000uLL) >> 0),
     (VUINT32) ((0xBFA0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFFD886084CD0DuLL) >> 0),
     (VUINT32) ((0xBFEFFD886084CD0DuLL) >> 32)},
    {(VUINT32) ((0x3C81354D40000000uLL) >> 0),
     (VUINT32) ((0x3C81354D40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6B78B80C84E1EEuLL) >> 0),
     (VUINT32) ((0x3F6B78B80C84E1EEuLL) >> 32)},
    {(VUINT32) ((0xBF90000000000000uLL) >> 0),
     (VUINT32) ((0xBF90000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFFF62169B92DBuLL) >> 0),
     (VUINT32) ((0xBFEFFF62169B92DBuLL) >> 32)},
    {(VUINT32) ((0xBC85DDA3C0000000uLL) >> 0),
     (VUINT32) ((0xBC85DDA3C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6B78B80C84E1EEuLL) >> 0),
     (VUINT32) ((0xBF6B78B80C84E1EEuLL) >> 32)},
    {(VUINT32) ((0x3F90000000000000uLL) >> 0),
     (VUINT32) ((0x3F90000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFFF62169B92DBuLL) >> 0),
     (VUINT32) ((0xBFEFFF62169B92DBuLL) >> 32)},
    {(VUINT32) ((0xBC85DDA3C0000000uLL) >> 0),
     (VUINT32) ((0xBC85DDA3C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7B7AA821726608uLL) >> 0),
     (VUINT32) ((0xBF7B7AA821726608uLL) >> 32)},
    {(VUINT32) ((0x3FA0000000000000uLL) >> 0),
     (VUINT32) ((0x3FA0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFFD886084CD0DuLL) >> 0),
     (VUINT32) ((0xBFEFFD886084CD0DuLL) >> 32)},
    {(VUINT32) ((0x3C81354D40000000uLL) >> 0),
     (VUINT32) ((0x3C81354D40000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F76C32BACA2AE69uLL) >> 0),
     (VUINT32) ((0x3F76C32BACA2AE69uLL) >> 32)},
    {(VUINT32) ((0x3FA0000000000000uLL) >> 0),
     (VUINT32) ((0x3FA0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFFA72EFFEF75DuLL) >> 0),
     (VUINT32) ((0xBFEFFA72EFFEF75DuLL) >> 32)},
    {(VUINT32) ((0x3C88B4CDC0000000uLL) >> 0),
     (VUINT32) ((0x3C88B4CDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8B82683BC89FB0uLL) >> 0),
     (VUINT32) ((0xBF8B82683BC89FB0uLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
     (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFF621E3796D7EuLL) >> 0),
     (VUINT32) ((0xBFEFF621E3796D7EuLL) >> 32)},
    {(VUINT32) ((0x3C6C57BC20000000uLL) >> 0),
     (VUINT32) ((0x3C6C57BC20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF535230C0FBE402uLL) >> 0),
     (VUINT32) ((0xBF535230C0FBE402uLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
     (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFF095658E71ADuLL) >> 0),
     (VUINT32) ((0xBFEFF095658E71ADuLL) >> 32)},
    {(VUINT32) ((0xBC801A8CE0000000uLL) >> 0),
     (VUINT32) ((0xBC801A8CE0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F86A9049670CFAEuLL) >> 0),
     (VUINT32) ((0x3F86A9049670CFAEuLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
     (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFE9CDAD01883AuLL) >> 0),
     (VUINT32) ((0xBFEFE9CDAD01883AuLL) >> 32)},
    {(VUINT32) ((0xBC6521ECC0000000uLL) >> 0),
     (VUINT32) ((0xBC6521ECC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F97DB402A6A9063uLL) >> 0),
     (VUINT32) ((0x3F97DB402A6A9063uLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
     (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFE1CAFCBD5B09uLL) >> 0),
     (VUINT32) ((0xBFEFE1CAFCBD5B09uLL) >> 32)},
    {(VUINT32) ((0xBC6A23E320000000uLL) >> 0),
     (VUINT32) ((0xBC6A23E320000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9BA1650F592F50uLL) >> 0),
     (VUINT32) ((0xBF9BA1650F592F50uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFD88DA3D12526uLL) >> 0),
     (VUINT32) ((0xBFEFD88DA3D12526uLL) >> 32)},
    {(VUINT32) ((0x3C887DF620000000uLL) >> 0),
     (VUINT32) ((0x3C887DF620000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8E43D1C309E958uLL) >> 0),
     (VUINT32) ((0xBF8E43D1C309E958uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFCE15FD6DA67BuLL) >> 0),
     (VUINT32) ((0xBFEFCE15FD6DA67BuLL) >> 32)},
    {(VUINT32) ((0x3C75DD6F80000000uLL) >> 0),
     (VUINT32) ((0x3C75DD6F80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6536352AD19E39uLL) >> 0),
     (VUINT32) ((0xBF6536352AD19E39uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFC26470E19FD3uLL) >> 0),
     (VUINT32) ((0xBFEFC26470E19FD3uLL) >> 32)},
    {(VUINT32) ((0xBC81EC8660000000uLL) >> 0),
     (VUINT32) ((0xBC81EC8660000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F839F0CEDAF576BuLL) >> 0),
     (VUINT32) ((0x3F839F0CEDAF576BuLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFB5797195D741uLL) >> 0),
     (VUINT32) ((0xBFEFB5797195D741uLL) >> 32)},
    {(VUINT32) ((0xBC71BFAC60000000uLL) >> 0),
     (VUINT32) ((0xBC71BFAC60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F964083747309D1uLL) >> 0),
     (VUINT32) ((0x3F964083747309D1uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEFA7557F08A517uLL) >> 0),
     (VUINT32) ((0xBFEFA7557F08A517uLL) >> 32)},
    {(VUINT32) ((0x3C87A0A8C0000000uLL) >> 0),
     (VUINT32) ((0x3C87A0A8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA155DAC4A4F967uLL) >> 0),
     (VUINT32) ((0x3FA155DAC4A4F967uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF97F924C9099BuLL) >> 0),
     (VUINT32) ((0xBFEF97F924C9099BuLL) >> 32)},
    {(VUINT32) ((0x3C8E2AE0E0000000uLL) >> 0),
     (VUINT32) ((0x3C8E2AE0E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA78851122CFF19uLL) >> 0),
     (VUINT32) ((0x3FA78851122CFF19uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF8764FA714BA9uLL) >> 0),
     (VUINT32) ((0xBFEF8764FA714BA9uLL) >> 32)},
    {(VUINT32) ((0xBC7AB25660000000uLL) >> 0),
     (VUINT32) ((0xBC7AB25660000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FADB7677942FCC5uLL) >> 0),
     (VUINT32) ((0x3FADB7677942FCC5uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF7599A3A12077uLL) >> 0),
     (VUINT32) ((0xBFEF7599A3A12077uLL) >> 32)},
    {(VUINT32) ((0xBC884F31C0000000uLL) >> 0),
     (VUINT32) ((0xBC884F31C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAC1D1F0E5967D5uLL) >> 0),
     (VUINT32) ((0xBFAC1D1F0E5967D5uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF6297CFF75CB0uLL) >> 0),
     (VUINT32) ((0xBFEF6297CFF75CB0uLL) >> 32)},
    {(VUINT32) ((0xBC75621720000000uLL) >> 0),
     (VUINT32) ((0xBC75621720000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA5F57F693FEEBEuLL) >> 0),
     (VUINT32) ((0xBFA5F57F693FEEBEuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF4E603B0B2F2DuLL) >> 0),
     (VUINT32) ((0xBFEF4E603B0B2F2DuLL) >> 32)},
    {(VUINT32) ((0x3C78EE01E0000000uLL) >> 0),
     (VUINT32) ((0x3C78EE01E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9FA3ECAC0D84E8uLL) >> 0),
     (VUINT32) ((0xBF9FA3ECAC0D84E8uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF38F3AC64E589uLL) >> 0),
     (VUINT32) ((0xBFEF38F3AC64E589uLL) >> 32)},
    {(VUINT32) ((0x3C7D7BAFA0000000uLL) >> 0),
     (VUINT32) ((0x3C7D7BAFA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF936580D5D5E775uLL) >> 0),
     (VUINT32) ((0xBF936580D5D5E775uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF2252F7763ADAuLL) >> 0),
     (VUINT32) ((0xBFEF2252F7763ADAuLL) >> 32)},
    {(VUINT32) ((0x3C820CB800000000uLL) >> 0),
     (VUINT32) ((0x3C820CB800000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7CC0D09BD41CAAuLL) >> 0),
     (VUINT32) ((0xBF7CC0D09BD41CAAuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF0A7EFB9230D7uLL) >> 0),
     (VUINT32) ((0xBFEF0A7EFB9230D7uLL) >> 32)},
    {(VUINT32) ((0xBC752C7AC0000000uLL) >> 0),
     (VUINT32) ((0xBC752C7AC0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F73EE038DFF6B80uLL) >> 0),
     (VUINT32) ((0x3F73EE038DFF6B80uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEEF178A3E473C2uLL) >> 0),
     (VUINT32) ((0xBFEEF178A3E473C2uLL) >> 32)},
    {(VUINT32) ((0xBC86310A60000000uLL) >> 0),
     (VUINT32) ((0xBC86310A60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F911D262B1F6776uLL) >> 0),
     (VUINT32) ((0x3F911D262B1F6776uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEED740E7684963uLL) >> 0),
     (VUINT32) ((0xBFEED740E7684963uLL) >> 32)},
    {(VUINT32) ((0xBC7E82C780000000uLL) >> 0),
     (VUINT32) ((0xBC7E82C780000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9D3443F4CDB3DDuLL) >> 0),
     (VUINT32) ((0x3F9D3443F4CDB3DDuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEEBBD8C8DF0B74uLL) >> 0),
     (VUINT32) ((0xBFEEBBD8C8DF0B74uLL) >> 32)},
    {(VUINT32) ((0xBC7C6C8C60000000uLL) >> 0),
     (VUINT32) ((0xBC7C6C8C60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA4A03176ACF82DuLL) >> 0),
     (VUINT32) ((0x3FA4A03176ACF82DuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE9F4156C62DDAuLL) >> 0),
     (VUINT32) ((0xBFEE9F4156C62DDAuLL) >> 32)},
    {(VUINT32) ((0xBC8760B1E0000000uLL) >> 0),
     (VUINT32) ((0xBC8760B1E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAAA086170C0A8EuLL) >> 0),
     (VUINT32) ((0x3FAAA086170C0A8EuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE817BAB4CD10DuLL) >> 0),
     (VUINT32) ((0xBFEE817BAB4CD10DuLL) >> 32)},
    {(VUINT32) ((0x3C7D0AFE60000000uLL) >> 0),
     (VUINT32) ((0x3C7D0AFE60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB04D72505D9805uLL) >> 0),
     (VUINT32) ((0x3FB04D72505D9805uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE6288EC48E112uLL) >> 0),
     (VUINT32) ((0xBFEE6288EC48E112uLL) >> 32)},
    {(VUINT32) ((0x3C616B56E0000000uLL) >> 0),
     (VUINT32) ((0x3C616B56E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB3478909E39DA9uLL) >> 0),
     (VUINT32) ((0x3FB3478909E39DA9uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE426A4B2BC17EuLL) >> 0),
     (VUINT32) ((0xBFEE426A4B2BC17EuLL) >> 32)},
    {(VUINT32) ((0xBC8A873880000000uLL) >> 0),
     (VUINT32) ((0xBC8A873880000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB63E69D6AC7F74uLL) >> 0),
     (VUINT32) ((0x3FB63E69D6AC7F74uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE212104F686E5uLL) >> 0),
     (VUINT32) ((0xBFEE212104F686E5uLL) >> 32)},
    {(VUINT32) ((0x3C8014C760000000uLL) >> 0),
     (VUINT32) ((0x3C8014C760000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB931F774FC9F18uLL) >> 0),
     (VUINT32) ((0x3FB931F774FC9F18uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEDFEAE622DBE2BuLL) >> 0),
     (VUINT32) ((0xBFEDFEAE622DBE2BuLL) >> 32)},
    {(VUINT32) ((0x3C8514EA80000000uLL) >> 0),
     (VUINT32) ((0x3C8514EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBC2214C3E9167BuLL) >> 0),
     (VUINT32) ((0x3FBC2214C3E9167BuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEDDB13B6CCC23CuLL) >> 0),
     (VUINT32) ((0xBFEDDB13B6CCC23CuLL) >> 32)},
    {(VUINT32) ((0xBC883C37C0000000uLL) >> 0),
     (VUINT32) ((0xBC883C37C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBF0EA4C477339CuLL) >> 0),
     (VUINT32) ((0x3FBF0EA4C477339CuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEDB6526238A09BuLL) >> 0),
     (VUINT32) ((0xBFEDB6526238A09BuLL) >> 32)},
    {(VUINT32) ((0x3C7ADEE7E0000000uLL) >> 0),
     (VUINT32) ((0x3C7ADEE7E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBE087565455A75uLL) >> 0),
     (VUINT32) ((0xBFBE087565455A75uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED906BCF328D46uLL) >> 0),
     (VUINT32) ((0xBFED906BCF328D46uLL) >> 32)},
    {(VUINT32) ((0xBC7457E600000000uLL) >> 0),
     (VUINT32) ((0xBC7457E600000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBB2356710DB0A3uLL) >> 0),
     (VUINT32) ((0xBFBB2356710DB0A3uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED696173C9E68BuLL) >> 0),
     (VUINT32) ((0xBFED696173C9E68BuLL) >> 32)},
    {(VUINT32) ((0x3C7E8C61C0000000uLL) >> 0),
     (VUINT32) ((0x3C7E8C61C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB8421AF15C49D7uLL) >> 0),
     (VUINT32) ((0xBFB8421AF15C49D7uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED4134D14DC93AuLL) >> 0),
     (VUINT32) ((0xBFED4134D14DC93AuLL) >> 32)},
    {(VUINT32) ((0x3C84EF5280000000uLL) >> 0),
     (VUINT32) ((0x3C84EF5280000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB564DF524B00DAuLL) >> 0),
     (VUINT32) ((0xBFB564DF524B00DAuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED17E7743E35DCuLL) >> 0),
     (VUINT32) ((0xBFED17E7743E35DCuLL) >> 32)},
    {(VUINT32) ((0x3C5101DA20000000uLL) >> 0),
     (VUINT32) ((0x3C5101DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB28BBFD87A8CFFuLL) >> 0),
     (VUINT32) ((0xBFB28BBFD87A8CFFuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFECED7AF43CC773uLL) >> 0),
     (VUINT32) ((0xBFECED7AF43CC773uLL) >> 32)},
    {(VUINT32) ((0x3C5E7B6BA0000000uLL) >> 0),
     (VUINT32) ((0x3C5E7B6BA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAF6DB13FF708CBuLL) >> 0),
     (VUINT32) ((0xBFAF6DB13FF708CBuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFECC1F0F3FCFC5CuLL) >> 0),
     (VUINT32) ((0xBFECC1F0F3FCFC5CuLL) >> 32)},
    {(VUINT32) ((0xBC7E576120000000uLL) >> 0),
     (VUINT32) ((0xBC7E576120000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA9CC8B3671DD0FuLL) >> 0),
     (VUINT32) ((0xBFA9CC8B3671DD0FuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC954B213411F5uLL) >> 0),
     (VUINT32) ((0xBFEC954B213411F5uLL) >> 32)},
    {(VUINT32) ((0x3C52FB7600000000uLL) >> 0),
     (VUINT32) ((0x3C52FB7600000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA4344523C8E3B5uLL) >> 0),
     (VUINT32) ((0xBFA4344523C8E3B5uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC678B3488739BuLL) >> 0),
     (VUINT32) ((0xBFEC678B3488739BuLL) >> 32)},
    {(VUINT32) ((0xBC6D86CAC0000000uLL) >> 0),
     (VUINT32) ((0xBC6D86CAC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9D4A2C7F909C4EuLL) >> 0),
     (VUINT32) ((0xBF9D4A2C7F909C4EuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC38B2F180BDB1uLL) >> 0),
     (VUINT32) ((0xBFEC38B2F180BDB1uLL) >> 32)},
    {(VUINT32) ((0x3C76E0B160000000uLL) >> 0),
     (VUINT32) ((0x3C76E0B160000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF923E6AD10872A7uLL) >> 0),
     (VUINT32) ((0xBF923E6AD10872A7uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC08C426725549uLL) >> 0),
     (VUINT32) ((0xBFEC08C426725549uLL) >> 32)},
    {(VUINT32) ((0xBC5B157FC0000000uLL) >> 0),
     (VUINT32) ((0xBC5B157FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7D16C901D95181uLL) >> 0),
     (VUINT32) ((0xBF7D16C901D95181uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEBD7C0AC6F952AuLL) >> 0),
     (VUINT32) ((0xBFEBD7C0AC6F952AuLL) >> 32)},
    {(VUINT32) ((0x3C8825A720000000uLL) >> 0),
     (VUINT32) ((0x3C8825A720000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6CFC874C3EB6D9uLL) >> 0),
     (VUINT32) ((0x3F6CFC874C3EB6D9uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEBA5AA673590D2uLL) >> 0),
     (VUINT32) ((0xBFEBA5AA673590D2uLL) >> 32)},
    {(VUINT32) ((0xBC87EA4E20000000uLL) >> 0),
     (VUINT32) ((0xBC87EA4E20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8CE1E648BFFB66uLL) >> 0),
     (VUINT32) ((0x3F8CE1E648BFFB66uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEB728345196E3EuLL) >> 0),
     (VUINT32) ((0xBFEB728345196E3EuLL) >> 32)},
    {(VUINT32) ((0x3C8BC69F20000000uLL) >> 0),
     (VUINT32) ((0x3C8BC69F20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F992E09ABB131D4uLL) >> 0),
     (VUINT32) ((0x3F992E09ABB131D4uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEB3E4D3EF55712uLL) >> 0),
     (VUINT32) ((0xBFEB3E4D3EF55712uLL) >> 32)},
    {(VUINT32) ((0x3C8EB6B8A0000000uLL) >> 0),
     (VUINT32) ((0x3C8EB6B8A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA1EB3541B4B228uLL) >> 0),
     (VUINT32) ((0x3FA1EB3541B4B228uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEB090A58150200uLL) >> 0),
     (VUINT32) ((0xBFEB090A58150200uLL) >> 32)},
    {(VUINT32) ((0x3C8926DA20000000uLL) >> 0),
     (VUINT32) ((0x3C8926DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA734D63DEDB48AuLL) >> 0),
     (VUINT32) ((0x3FA734D63DEDB48AuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEAD2BC9E21D511uLL) >> 0),
     (VUINT32) ((0xBFEAD2BC9E21D511uLL) >> 32)},
    {(VUINT32) ((0x3C847FBE00000000uLL) >> 0),
     (VUINT32) ((0x3C847FBE00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAC73B39AE68C87uLL) >> 0),
     (VUINT32) ((0x3FAC73B39AE68C87uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEA9B66290EA1A3uLL) >> 0),
     (VUINT32) ((0xBFEA9B66290EA1A3uLL) >> 32)},
    {(VUINT32) ((0xBC39F630E0000000uLL) >> 0),
     (VUINT32) ((0xBC39F630E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB0D3CCC99F5AC6uLL) >> 0),
     (VUINT32) ((0x3FB0D3CCC99F5AC6uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEA63091B02FAE2uLL) >> 0),
     (VUINT32) ((0xBFEA63091B02FAE2uLL) >> 32)},
    {(VUINT32) ((0x3C7E911140000000uLL) >> 0),
     (VUINT32) ((0x3C7E911140000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB3682A66E896F5uLL) >> 0),
     (VUINT32) ((0x3FB3682A66E896F5uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEA29A7A0462782uLL) >> 0),
     (VUINT32) ((0xBFEA29A7A0462782uLL) >> 32)},
    {(VUINT32) ((0x3C7128BB00000000uLL) >> 0),
     (VUINT32) ((0x3C7128BB00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB5F6D92FD79F50uLL) >> 0),
     (VUINT32) ((0x3FB5F6D92FD79F50uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE9EF43EF29AF94uLL) >> 0),
     (VUINT32) ((0xBFE9EF43EF29AF94uLL) >> 32)},
    {(VUINT32) ((0xBC7B1DFCA0000000uLL) >> 0),
     (VUINT32) ((0xBC7B1DFCA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB87FBFE70B81A7uLL) >> 0),
     (VUINT32) ((0x3FB87FBFE70B81A7uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE9B3E047F38741uLL) >> 0),
     (VUINT32) ((0xBFE9B3E047F38741uLL) >> 32)},
    {(VUINT32) ((0x3C830EE280000000uLL) >> 0),
     (VUINT32) ((0x3C830EE280000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBB02C58832CF96uLL) >> 0),
     (VUINT32) ((0x3FBB02C58832CF96uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE9777EF4C7D742uLL) >> 0),
     (VUINT32) ((0xBFE9777EF4C7D742uLL) >> 32)},
    {(VUINT32) ((0x3C815479A0000000uLL) >> 0),
     (VUINT32) ((0x3C815479A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBD7FD1490285CAuLL) >> 0),
     (VUINT32) ((0x3FBD7FD1490285CAuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE93A22499263FBuLL) >> 0),
     (VUINT32) ((0xBFE93A22499263FBuLL) >> 32)},
    {(VUINT32) ((0xBC83D419A0000000uLL) >> 0),
     (VUINT32) ((0xBC83D419A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBFF6CA9A2AB6A2uLL) >> 0),
     (VUINT32) ((0x3FBFF6CA9A2AB6A2uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE8FBCCA3EF940DuLL) >> 0),
     (VUINT32) ((0xBFE8FBCCA3EF940DuLL) >> 32)},
    {(VUINT32) ((0x3C66DFA980000000uLL) >> 0),
     (VUINT32) ((0x3C66DFA980000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC133CC94247758uLL) >> 0),
     (VUINT32) ((0x3FC133CC94247758uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE8BC806B151741uLL) >> 0),
     (VUINT32) ((0xBFE8BC806B151741uLL) >> 32)},
    {(VUINT32) ((0x3C82C5E120000000uLL) >> 0),
     (VUINT32) ((0x3C82C5E120000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC269126E6C24E3uLL) >> 0),
     (VUINT32) ((0x3FC269126E6C24E3uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE87C400FBA2EBFuLL) >> 0),
     (VUINT32) ((0xBFE87C400FBA2EBFuLL) >> 32)},
    {(VUINT32) ((0x3C82DABC00000000uLL) >> 0),
     (VUINT32) ((0x3C82DABC00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC39B2AEF8F97A4uLL) >> 0),
     (VUINT32) ((0x3FC39B2AEF8F97A4uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE83B0E0BFF976EuLL) >> 0),
     (VUINT32) ((0xBFE83B0E0BFF976EuLL) >> 32)},
    {(VUINT32) ((0x3C76F420E0000000uLL) >> 0),
     (VUINT32) ((0x3C76F420E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC4CA0A4A8D5657uLL) >> 0),
     (VUINT32) ((0x3FC4CA0A4A8D5657uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE7F8ECE3571771uLL) >> 0),
     (VUINT32) ((0xBFE7F8ECE3571771uLL) >> 32)},
    {(VUINT32) ((0x3C89C8D8C0000000uLL) >> 0),
     (VUINT32) ((0x3C89C8D8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC5F5A4D233B27FuLL) >> 0),
     (VUINT32) ((0x3FC5F5A4D233B27FuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE7B5DF226AAFAFuLL) >> 0),
     (VUINT32) ((0xBFE7B5DF226AAFAFuLL) >> 32)},
    {(VUINT32) ((0x3C70F537A0000000uLL) >> 0),
     (VUINT32) ((0x3C70F537A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC71DEEF9940631uLL) >> 0),
     (VUINT32) ((0x3FC71DEEF9940631uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE771E75F037261uLL) >> 0),
     (VUINT32) ((0xBFE771E75F037261uLL) >> 32)},
    {(VUINT32) ((0xBC75CFCE80000000uLL) >> 0),
     (VUINT32) ((0xBC75CFCE80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC842DD5474B37BuLL) >> 0),
     (VUINT32) ((0x3FC842DD5474B37BuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE72D0837EFFF96uLL) >> 0),
     (VUINT32) ((0xBFE72D0837EFFF96uLL) >> 32)},
    {(VUINT32) ((0xBC80D4EF00000000uLL) >> 0),
     (VUINT32) ((0xBC80D4EF00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC9646497C1E0F6uLL) >> 0),
     (VUINT32) ((0x3FC9646497C1E0F6uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE6E74454EAA8AFuLL) >> 0),
     (VUINT32) ((0xBFE6E74454EAA8AFuLL) >> 32)},
    {(VUINT32) ((0x3C8DBC03C0000000uLL) >> 0),
     (VUINT32) ((0x3C8DBC03C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCA827999FCEF32uLL) >> 0),
     (VUINT32) ((0x3FCA827999FCEF32uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE6A09E667F3BCDuLL) >> 0),
     (VUINT32) ((0xBFE6A09E667F3BCDuLL) >> 32)},
    {(VUINT32) ((0x3C8BDD3400000000uLL) >> 0),
     (VUINT32) ((0x3C8BDD3400000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCB9D1153AAA2BAuLL) >> 0),
     (VUINT32) ((0x3FCB9D1153AAA2BAuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE6591925F0783DuLL) >> 0),
     (VUINT32) ((0xBFE6591925F0783DuLL) >> 32)},
    {(VUINT32) ((0xBC8C3D64E0000000uLL) >> 0),
     (VUINT32) ((0xBC8C3D64E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCCB420DFBFFE59uLL) >> 0),
     (VUINT32) ((0x3FCCB420DFBFFE59uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE610B7551D2CDFuLL) >> 0),
     (VUINT32) ((0xBFE610B7551D2CDFuLL) >> 32)},
    {(VUINT32) ((0x3C7251B340000000uLL) >> 0),
     (VUINT32) ((0x3C7251B340000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCDC79D7C0DC985uLL) >> 0),
     (VUINT32) ((0x3FCDC79D7C0DC985uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE5C77BBE65018CuLL) >> 0),
     (VUINT32) ((0xBFE5C77BBE65018CuLL) >> 32)},
    {(VUINT32) ((0xBC8069EA80000000uLL) >> 0),
     (VUINT32) ((0xBC8069EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCED77C89AABEBBuLL) >> 0),
     (VUINT32) ((0x3FCED77C89AABEBBuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE57D69348CECA0uLL) >> 0),
     (VUINT32) ((0xBFE57D69348CECA0uLL) >> 32)},
    {(VUINT32) ((0x3C87572080000000uLL) >> 0),
     (VUINT32) ((0x3C87572080000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCFE3B38D5C5DC2uLL) >> 0),
     (VUINT32) ((0x3FCFE3B38D5C5DC2uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE5328292A35596uLL) >> 0),
     (VUINT32) ((0xBFE5328292A35596uLL) >> 32)},
    {(VUINT32) ((0x3C7A12EB80000000uLL) >> 0),
     (VUINT32) ((0x3C7A12EB80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCF13C7D001A249uLL) >> 0),
     (VUINT32) ((0xBFCF13C7D001A249uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE4E6CABBE3E5E9uLL) >> 0),
     (VUINT32) ((0xBFE4E6CABBE3E5E9uLL) >> 32)},
    {(VUINT32) ((0xBC63C293E0000000uLL) >> 0),
     (VUINT32) ((0xBC63C293E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCE0EFFC1174505uLL) >> 0),
     (VUINT32) ((0xBFCE0EFFC1174505uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE49A449B9B0939uLL) >> 0),
     (VUINT32) ((0xBFE49A449B9B0939uLL) >> 32)},
    {(VUINT32) ((0x3C827EE160000000uLL) >> 0),
     (VUINT32) ((0x3C827EE160000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCD0DFE53ABA2FDuLL) >> 0),
     (VUINT32) ((0xBFCD0DFE53ABA2FDuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE44CF325091DD6uLL) >> 0),
     (VUINT32) ((0xBFE44CF325091DD6uLL) >> 32)},
    {(VUINT32) ((0xBC68076A20000000uLL) >> 0),
     (VUINT32) ((0xBC68076A20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCC10CD7041AFCCuLL) >> 0),
     (VUINT32) ((0xBFCC10CD7041AFCCuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE3FED9534556D4uLL) >> 0),
     (VUINT32) ((0xBFE3FED9534556D4uLL) >> 32)},
    {(VUINT32) ((0xBC83691660000000uLL) >> 0),
     (VUINT32) ((0xBC83691660000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCB1776D9B67013uLL) >> 0),
     (VUINT32) ((0xBFCB1776D9B67013uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE3AFFA292050B9uLL) >> 0),
     (VUINT32) ((0xBFE3AFFA292050B9uLL) >> 32)},
    {(VUINT32) ((0xBC7E3E25E0000000uLL) >> 0),
     (VUINT32) ((0xBC7E3E25E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCA22042CE0A2F9uLL) >> 0),
     (VUINT32) ((0xBFCA22042CE0A2F9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE36058B10659F3uLL) >> 0),
     (VUINT32) ((0xBFE36058B10659F3uLL) >> 32)},
    {(VUINT32) ((0x3C81FCB3A0000000uLL) >> 0),
     (VUINT32) ((0x3C81FCB3A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC9307EE031E2FDuLL) >> 0),
     (VUINT32) ((0xBFC9307EE031E2FDuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE30FF7FCE17035uLL) >> 0),
     (VUINT32) ((0xBFE30FF7FCE17035uLL) >> 32)},
    {(VUINT32) ((0x3C6EFCC620000000uLL) >> 0),
     (VUINT32) ((0x3C6EFCC620000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC842F0435941AFuLL) >> 0),
     (VUINT32) ((0xBFC842F0435941AFuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE2BEDB25FAF3EAuLL) >> 0),
     (VUINT32) ((0xBFE2BEDB25FAF3EAuLL) >> 32)},
    {(VUINT32) ((0x3C514981C0000000uLL) >> 0),
     (VUINT32) ((0x3C514981C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC759617EE761F9uLL) >> 0),
     (VUINT32) ((0xBFC759617EE761F9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE26D054CDD12DFuLL) >> 0),
     (VUINT32) ((0xBFE26D054CDD12DFuLL) >> 32)},
    {(VUINT32) ((0x3C85DA7420000000uLL) >> 0),
     (VUINT32) ((0x3C85DA7420000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC673DB93F41479uLL) >> 0),
     (VUINT32) ((0xBFC673DB93F41479uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE21A799933EB59uLL) >> 0),
     (VUINT32) ((0xBFE21A799933EB59uLL) >> 32)},
    {(VUINT32) ((0x3C83A7B160000000uLL) >> 0),
     (VUINT32) ((0x3C83A7B160000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC592675BC57974uLL) >> 0),
     (VUINT32) ((0xBFC592675BC57974uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE1C73B39AE68C8uLL) >> 0),
     (VUINT32) ((0xBFE1C73B39AE68C8uLL) >> 32)},
    {(VUINT32) ((0xBC8B25DD20000000uLL) >> 0),
     (VUINT32) ((0xBC8B25DD20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC4B50D8778ABBDuLL) >> 0),
     (VUINT32) ((0xBFC4B50D8778ABBDuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE1734D63DEDB49uLL) >> 0),
     (VUINT32) ((0xBFE1734D63DEDB49uLL) >> 32)},
    {(VUINT32) ((0x3C87EEF2C0000000uLL) >> 0),
     (VUINT32) ((0x3C87EEF2C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC3DBD69FABF802uLL) >> 0),
     (VUINT32) ((0xBFC3DBD69FABF802uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE11EB3541B4B23uLL) >> 0),
     (VUINT32) ((0xBFE11EB3541B4B23uLL) >> 32)},
    {(VUINT32) ((0x3C8EF23B60000000uLL) >> 0),
     (VUINT32) ((0x3C8EF23B60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC306CB042AA3BAuLL) >> 0),
     (VUINT32) ((0xBFC306CB042AA3BAuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE0C9704D5D898FuLL) >> 0),
     (VUINT32) ((0xBFE0C9704D5D898FuLL) >> 32)},
    {(VUINT32) ((0x3C88D3D7C0000000uLL) >> 0),
     (VUINT32) ((0x3C88D3D7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC235F2EB9A470AuLL) >> 0),
     (VUINT32) ((0xBFC235F2EB9A470AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE073879922FFEEuLL) >> 0),
     (VUINT32) ((0xBFE073879922FFEEuLL) >> 32)},
    {(VUINT32) ((0x3C8A5A0140000000uLL) >> 0),
     (VUINT32) ((0x3C8A5A0140000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC169566329BCB7uLL) >> 0),
     (VUINT32) ((0xBFC169566329BCB7uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE01CFC874C3EB7uLL) >> 0),
     (VUINT32) ((0xBFE01CFC874C3EB7uLL) >> 32)},
    {(VUINT32) ((0x3C734A35E0000000uLL) >> 0),
     (VUINT32) ((0x3C734A35E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC0A0FD4E41AB5AuLL) >> 0),
     (VUINT32) ((0xBFC0A0FD4E41AB5AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDF8BA4DBF89ABAuLL) >> 0),
     (VUINT32) ((0xBFDF8BA4DBF89ABAuLL) >> 32)},
    {(VUINT32) ((0x3C32EC1FC0000000uLL) >> 0),
     (VUINT32) ((0x3C32EC1FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBFB9DECC6D55B8uLL) >> 0),
     (VUINT32) ((0xBFBFB9DECC6D55B8uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDEDC1952EF78D6uLL) >> 0),
     (VUINT32) ((0xBFDEDC1952EF78D6uLL) >> 32)},
    {(VUINT32) ((0x3C7DD0F7C0000000uLL) >> 0),
     (VUINT32) ((0x3C7DD0F7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBE3A6873FA1279uLL) >> 0),
     (VUINT32) ((0xBFBE3A6873FA1279uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDE2B5D3806F63BuLL) >> 0),
     (VUINT32) ((0xBFDE2B5D3806F63BuLL) >> 32)},
    {(VUINT32) ((0xBC5E0D8900000000uLL) >> 0),
     (VUINT32) ((0xBC5E0D8900000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBCC3A65BBC6327uLL) >> 0),
     (VUINT32) ((0xBFBCC3A65BBC6327uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDD79775B86E389uLL) >> 0),
     (VUINT32) ((0xBFDD79775B86E389uLL) >> 32)},
    {(VUINT32) ((0xBC7550EC80000000uLL) >> 0),
     (VUINT32) ((0xBC7550EC80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBB55A6F65F7058uLL) >> 0),
     (VUINT32) ((0xBFBB55A6F65F7058uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDCC66E9931C45EuLL) >> 0),
     (VUINT32) ((0xBFDCC66E9931C45EuLL) >> 32)},
    {(VUINT32) ((0xBC56850E40000000uLL) >> 0),
     (VUINT32) ((0xBC56850E40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB9F07860181D1EuLL) >> 0),
     (VUINT32) ((0xBFB9F07860181D1EuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDC1249D8011EE7uLL) >> 0),
     (VUINT32) ((0xBFDC1249D8011EE7uLL) >> 32)},
    {(VUINT32) ((0x3C7813AAA0000000uLL) >> 0),
     (VUINT32) ((0x3C7813AAA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB894285E19C468uLL) >> 0),
     (VUINT32) ((0xBFB894285E19C468uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDB5D1009E15CC0uLL) >> 0),
     (VUINT32) ((0xBFDB5D1009E15CC0uLL) >> 32)},
    {(VUINT32) ((0xBC65B362C0000000uLL) >> 0),
     (VUINT32) ((0xBC65B362C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB740C45E0E5120uLL) >> 0),
     (VUINT32) ((0xBFB740C45E0E5120uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDAA6C82B6D3FCAuLL) >> 0),
     (VUINT32) ((0xBFDAA6C82B6D3FCAuLL) >> 32)},
    {(VUINT32) ((0x3C7D5F1060000000uLL) >> 0),
     (VUINT32) ((0x3C7D5F1060000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB5F6597591B633uLL) >> 0),
     (VUINT32) ((0xBFB5F6597591B633uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD9EF7943A8ED8AuLL) >> 0),
     (VUINT32) ((0xBFD9EF7943A8ED8AuLL) >> 32)},
    {(VUINT32) ((0xBC66DA8120000000uLL) >> 0),
     (VUINT32) ((0xBC66DA8120000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB4B4F461B0CBAAuLL) >> 0),
     (VUINT32) ((0xBFB4B4F461B0CBAAuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD9372A63BC93D7uLL) >> 0),
     (VUINT32) ((0xBFD9372A63BC93D7uLL) >> 32)},
    {(VUINT32) ((0xBC66843180000000uLL) >> 0),
     (VUINT32) ((0xBC66843180000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB37CA1866B95CFuLL) >> 0),
     (VUINT32) ((0xBFB37CA1866B95CFuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD87DE2A6AEA963uLL) >> 0),
     (VUINT32) ((0xBFD87DE2A6AEA963uLL) >> 32)},
    {(VUINT32) ((0x3C672CEDC0000000uLL) >> 0),
     (VUINT32) ((0x3C672CEDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB24D6CEE3AFB2AuLL) >> 0),
     (VUINT32) ((0xBFB24D6CEE3AFB2AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD7C3A9311DCCE7uLL) >> 0),
     (VUINT32) ((0xBFD7C3A9311DCCE7uLL) >> 32)},
    {(VUINT32) ((0xBC19A3F200000000uLL) >> 0),
     (VUINT32) ((0xBC19A3F200000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB127624999EE1DuLL) >> 0),
     (VUINT32) ((0xBFB127624999EE1DuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD7088530FA459FuLL) >> 0),
     (VUINT32) ((0xBFD7088530FA459FuLL) >> 32)},
    {(VUINT32) ((0x3C744B19E0000000uLL) >> 0),
     (VUINT32) ((0x3C744B19E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB00A8CEE920EABuLL) >> 0),
     (VUINT32) ((0xBFB00A8CEE920EABuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD64C7DDD3F27C6uLL) >> 0),
     (VUINT32) ((0xBFD64C7DDD3F27C6uLL) >> 32)},
    {(VUINT32) ((0xBC510D2B40000000uLL) >> 0),
     (VUINT32) ((0xBC510D2B40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFADEDEFB09791B4uLL) >> 0),
     (VUINT32) ((0xBFADEDEFB09791B4uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD58F9A75AB1FDDuLL) >> 0),
     (VUINT32) ((0xBFD58F9A75AB1FDDuLL) >> 32)},
    {(VUINT32) ((0x3C1EFDC0C0000000uLL) >> 0),
     (VUINT32) ((0x3C1EFDC0C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFABD95B4D43E819uLL) >> 0),
     (VUINT32) ((0xBFABD95B4D43E819uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD4D1E24278E76AuLL) >> 0),
     (VUINT32) ((0xBFD4D1E24278E76AuLL) >> 32)},
    {(VUINT32) ((0xBC62417200000000uLL) >> 0),
     (VUINT32) ((0xBC62417200000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA9D7713B71EEE1uLL) >> 0),
     (VUINT32) ((0xBFA9D7713B71EEE1uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD4135C94176601uLL) >> 0),
     (VUINT32) ((0xBFD4135C94176601uLL) >> 32)},
    {(VUINT32) ((0xBC70C97C40000000uLL) >> 0),
     (VUINT32) ((0xBC70C97C40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA7E8454B32EF34uLL) >> 0),
     (VUINT32) ((0xBFA7E8454B32EF34uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD35410C2E18152uLL) >> 0),
     (VUINT32) ((0xBFD35410C2E18152uLL) >> 32)},
    {(VUINT32) ((0x3C73CB0020000000uLL) >> 0),
     (VUINT32) ((0x3C73CB0020000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA60BEA939D225AuLL) >> 0),
     (VUINT32) ((0xBFA60BEA939D225AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD294062ED59F06uLL) >> 0),
     (VUINT32) ((0xBFD294062ED59F06uLL) >> 32)},
    {(VUINT32) ((0x3C75D28DA0000000uLL) >> 0),
     (VUINT32) ((0x3C75D28DA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA44273720F48BCuLL) >> 0),
     (VUINT32) ((0xBFA44273720F48BCuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD1D3443F4CDB3EuLL) >> 0),
     (VUINT32) ((0xBFD1D3443F4CDB3EuLL) >> 32)},
    {(VUINT32) ((0x3C6720D400000000uLL) >> 0),
     (VUINT32) ((0x3C6720D400000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA28BF1897B69CCuLL) >> 0),
     (VUINT32) ((0xBFA28BF1897B69CCuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD111D262B1F677uLL) >> 0),
     (VUINT32) ((0xBFD111D262B1F677uLL) >> 32)},
    {(VUINT32) ((0xBC7824C200000000uLL) >> 0),
     (VUINT32) ((0xBC7824C200000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA0E875C1B8C3DAuLL) >> 0),
     (VUINT32) ((0xBFA0E875C1B8C3DAuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD04FB80E37FDAEuLL) >> 0),
     (VUINT32) ((0xBFD04FB80E37FDAEuLL) >> 32)},
    {(VUINT32) ((0x3C0412CDA0000000uLL) >> 0),
     (VUINT32) ((0x3C0412CDA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9EB0208DB9E51BuLL) >> 0),
     (VUINT32) ((0xBF9EB0208DB9E51BuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCF19F97B215F1BuLL) >> 0),
     (VUINT32) ((0xBFCF19F97B215F1BuLL) >> 32)},
    {(VUINT32) ((0x3C642DEEE0000000uLL) >> 0),
     (VUINT32) ((0x3C642DEEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9BB5A11138A4C9uLL) >> 0),
     (VUINT32) ((0xBF9BB5A11138A4C9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCD934FE5454311uLL) >> 0),
     (VUINT32) ((0xBFCD934FE5454311uLL) >> 32)},
    {(VUINT32) ((0xBC675B9220000000uLL) >> 0),
     (VUINT32) ((0xBC675B9220000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF98E18A73634EE7uLL) >> 0),
     (VUINT32) ((0xBF98E18A73634EE7uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCC0B826A7E4F63uLL) >> 0),
     (VUINT32) ((0xBFCC0B826A7E4F63uLL) >> 32)},
    {(VUINT32) ((0x3C1AF14380000000uLL) >> 0),
     (VUINT32) ((0x3C1AF14380000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9633F89E9A1A66uLL) >> 0),
     (VUINT32) ((0xBF9633F89E9A1A66uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCA82A025B00451uLL) >> 0),
     (VUINT32) ((0xBFCA82A025B00451uLL) >> 32)},
    {(VUINT32) ((0x3C687905E0000000uLL) >> 0),
     (VUINT32) ((0x3C687905E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF93AD06011469FBuLL) >> 0),
     (VUINT32) ((0xBF93AD06011469FBuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC8F8B83C69A60BuLL) >> 0),
     (VUINT32) ((0xBFC8F8B83C69A60BuLL) >> 32)},
    {(VUINT32) ((0x3C626D19A0000000uLL) >> 0),
     (VUINT32) ((0x3C626D19A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF914CCB8BDBF114uLL) >> 0),
     (VUINT32) ((0xBF914CCB8BDBF114uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC76DD9DE50BF31uLL) >> 0),
     (VUINT32) ((0xBFC76DD9DE50BF31uLL) >> 32)},
    {(VUINT32) ((0xBC61D5EEE0000000uLL) >> 0),
     (VUINT32) ((0xBC61D5EEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8E26C163AD15B3uLL) >> 0),
     (VUINT32) ((0xBF8E26C163AD15B3uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC5E214448B3FC6uLL) >> 0),
     (VUINT32) ((0xBFC5E214448B3FC6uLL) >> 32)},
    {(VUINT32) ((0xBC6531FF60000000uLL) >> 0),
     (VUINT32) ((0xBC6531FF60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8A01B6CDBD995EuLL) >> 0),
     (VUINT32) ((0xBF8A01B6CDBD995EuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC45576B1293E5AuLL) >> 0),
     (VUINT32) ((0xBFC45576B1293E5AuLL) >> 32)},
    {(VUINT32) ((0x3C5285A240000000uLL) >> 0),
     (VUINT32) ((0x3C5285A240000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF862AA03DD6BA58uLL) >> 0),
     (VUINT32) ((0xBF862AA03DD6BA58uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC2C8106E8E613AuLL) >> 0),
     (VUINT32) ((0xBFC2C8106E8E613AuLL) >> 32)},
    {(VUINT32) ((0xBC513000A0000000uLL) >> 0),
     (VUINT32) ((0xBC513000A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF82A1A39A8A2FB7uLL) >> 0),
     (VUINT32) ((0xBF82A1A39A8A2FB7uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC139F0CEDAF577uLL) >> 0),
     (VUINT32) ((0xBFC139F0CEDAF577uLL) >> 32)},
    {(VUINT32) ((0x3C65234340000000uLL) >> 0),
     (VUINT32) ((0x3C65234340000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7ECDC78F30165CuLL) >> 0),
     (VUINT32) ((0xBF7ECDC78F30165CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBF564E56A9730EuLL) >> 0),
     (VUINT32) ((0xBFBF564E56A9730EuLL) >> 32)},
    {(VUINT32) ((0xBC4A270460000000uLL) >> 0),
     (VUINT32) ((0xBC4A270460000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF78F501492CC296uLL) >> 0),
     (VUINT32) ((0xBF78F501492CC296uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBC3785C79EC2D5uLL) >> 0),
     (VUINT32) ((0xBFBC3785C79EC2D5uLL) >> 32)},
    {(VUINT32) ((0x3C24F39DE0000000uLL) >> 0),
     (VUINT32) ((0x3C24F39DE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF73B92E176D6D31uLL) >> 0),
     (VUINT32) ((0xBF73B92E176D6D31uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB917A6BC29B42CuLL) >> 0),
     (VUINT32) ((0xBFB917A6BC29B42CuLL) >> 32)},
    {(VUINT32) ((0x3C3E2718C0000000uLL) >> 0),
     (VUINT32) ((0x3C3E2718C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6E350342A4F6E6uLL) >> 0),
     (VUINT32) ((0xBF6E350342A4F6E6uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB5F6D00A9AA419uLL) >> 0),
     (VUINT32) ((0xBFB5F6D00A9AA419uLL) >> 32)},
    {(VUINT32) ((0x3C4F4022C0000000uLL) >> 0),
     (VUINT32) ((0x3C4F4022C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF663252FE77C5EBuLL) >> 0),
     (VUINT32) ((0xBF663252FE77C5EBuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB2D52092CE19F6uLL) >> 0),
     (VUINT32) ((0xBFB2D52092CE19F6uLL) >> 32)},
    {(VUINT32) ((0x3C49A088A0000000uLL) >> 0),
     (VUINT32) ((0x3C49A088A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF5ED534E31CA57FuLL) >> 0),
     (VUINT32) ((0xBF5ED534E31CA57FuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFAF656E79F820E0uLL) >> 0),
     (VUINT32) ((0xBFAF656E79F820E0uLL) >> 32)},
    {(VUINT32) ((0x3C22E1EBE0000000uLL) >> 0),
     (VUINT32) ((0x3C22E1EBE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF53BC390D250439uLL) >> 0),
     (VUINT32) ((0xBF53BC390D250439uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA91F65F10DD814uLL) >> 0),
     (VUINT32) ((0xBFA91F65F10DD814uLL) >> 32)},
    {(VUINT32) ((0x3C2912BD00000000uLL) >> 0),
     (VUINT32) ((0x3C2912BD00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF46344004228D8BuLL) >> 0),
     (VUINT32) ((0xBF46344004228D8BuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA2D865759455CDuLL) >> 0),
     (VUINT32) ((0xBFA2D865759455CDuLL) >> 32)},
    {(VUINT32) ((0xBC2686F640000000uLL) >> 0),
     (VUINT32) ((0xBC2686F640000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF33BCFBD9979A27uLL) >> 0),
     (VUINT32) ((0xBF33BCFBD9979A27uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF992155F7A3667EuLL) >> 0),
     (VUINT32) ((0xBF992155F7A3667EuLL) >> 32)},
    {(VUINT32) ((0x3BFB1D6300000000uLL) >> 0),
     (VUINT32) ((0x3BFB1D6300000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF13BD2C8DA49511uLL) >> 0),
     (VUINT32) ((0xBF13BD2C8DA49511uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF8921D1FCDEC784uLL) >> 0),
     (VUINT32) ((0xBF8921D1FCDEC784uLL) >> 32)},
    {(VUINT32) ((0xBC29878EA0000000uLL) >> 0),
     (VUINT32) ((0xBC29878EA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF13BD2C8DA49511uLL) >> 0),
     (VUINT32) ((0xBF13BD2C8DA49511uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F8921D1FCDEC784uLL) >> 0),
     (VUINT32) ((0x3F8921D1FCDEC784uLL) >> 32)},
    {(VUINT32) ((0x3C29878EA0000000uLL) >> 0),
     (VUINT32) ((0x3C29878EA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF33BCFBD9979A27uLL) >> 0),
     (VUINT32) ((0xBF33BCFBD9979A27uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F992155F7A3667EuLL) >> 0),
     (VUINT32) ((0x3F992155F7A3667EuLL) >> 32)},
    {(VUINT32) ((0xBBFB1D6300000000uLL) >> 0),
     (VUINT32) ((0xBBFB1D6300000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF46344004228D8BuLL) >> 0),
     (VUINT32) ((0xBF46344004228D8BuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA2D865759455CDuLL) >> 0),
     (VUINT32) ((0x3FA2D865759455CDuLL) >> 32)},
    {(VUINT32) ((0x3C2686F640000000uLL) >> 0),
     (VUINT32) ((0x3C2686F640000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF53BC390D250439uLL) >> 0),
     (VUINT32) ((0xBF53BC390D250439uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA91F65F10DD814uLL) >> 0),
     (VUINT32) ((0x3FA91F65F10DD814uLL) >> 32)},
    {(VUINT32) ((0xBC2912BD00000000uLL) >> 0),
     (VUINT32) ((0xBC2912BD00000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF5ED534E31CA57FuLL) >> 0),
     (VUINT32) ((0xBF5ED534E31CA57FuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FAF656E79F820E0uLL) >> 0),
     (VUINT32) ((0x3FAF656E79F820E0uLL) >> 32)},
    {(VUINT32) ((0xBC22E1EBE0000000uLL) >> 0),
     (VUINT32) ((0xBC22E1EBE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF663252FE77C5EBuLL) >> 0),
     (VUINT32) ((0xBF663252FE77C5EBuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB2D52092CE19F6uLL) >> 0),
     (VUINT32) ((0x3FB2D52092CE19F6uLL) >> 32)},
    {(VUINT32) ((0xBC49A088A0000000uLL) >> 0),
     (VUINT32) ((0xBC49A088A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6E350342A4F6E6uLL) >> 0),
     (VUINT32) ((0xBF6E350342A4F6E6uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5F6D00A9AA419uLL) >> 0),
     (VUINT32) ((0x3FB5F6D00A9AA419uLL) >> 32)},
    {(VUINT32) ((0xBC4F4022C0000000uLL) >> 0),
     (VUINT32) ((0xBC4F4022C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF73B92E176D6D31uLL) >> 0),
     (VUINT32) ((0xBF73B92E176D6D31uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB917A6BC29B42CuLL) >> 0),
     (VUINT32) ((0x3FB917A6BC29B42CuLL) >> 32)},
    {(VUINT32) ((0xBC3E2718C0000000uLL) >> 0),
     (VUINT32) ((0xBC3E2718C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF78F501492CC296uLL) >> 0),
     (VUINT32) ((0xBF78F501492CC296uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBC3785C79EC2D5uLL) >> 0),
     (VUINT32) ((0x3FBC3785C79EC2D5uLL) >> 32)},
    {(VUINT32) ((0xBC24F39DE0000000uLL) >> 0),
     (VUINT32) ((0xBC24F39DE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7ECDC78F30165CuLL) >> 0),
     (VUINT32) ((0xBF7ECDC78F30165CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBF564E56A9730EuLL) >> 0),
     (VUINT32) ((0x3FBF564E56A9730EuLL) >> 32)},
    {(VUINT32) ((0x3C4A270460000000uLL) >> 0),
     (VUINT32) ((0x3C4A270460000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF82A1A39A8A2FB7uLL) >> 0),
     (VUINT32) ((0xBF82A1A39A8A2FB7uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC139F0CEDAF577uLL) >> 0),
     (VUINT32) ((0x3FC139F0CEDAF577uLL) >> 32)},
    {(VUINT32) ((0xBC65234340000000uLL) >> 0),
     (VUINT32) ((0xBC65234340000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF862AA03DD6BA58uLL) >> 0),
     (VUINT32) ((0xBF862AA03DD6BA58uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC2C8106E8E613AuLL) >> 0),
     (VUINT32) ((0x3FC2C8106E8E613AuLL) >> 32)},
    {(VUINT32) ((0x3C513000A0000000uLL) >> 0),
     (VUINT32) ((0x3C513000A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8A01B6CDBD995EuLL) >> 0),
     (VUINT32) ((0xBF8A01B6CDBD995EuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC45576B1293E5AuLL) >> 0),
     (VUINT32) ((0x3FC45576B1293E5AuLL) >> 32)},
    {(VUINT32) ((0xBC5285A240000000uLL) >> 0),
     (VUINT32) ((0xBC5285A240000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8E26C163AD15B3uLL) >> 0),
     (VUINT32) ((0xBF8E26C163AD15B3uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC5E214448B3FC6uLL) >> 0),
     (VUINT32) ((0x3FC5E214448B3FC6uLL) >> 32)},
    {(VUINT32) ((0x3C6531FF60000000uLL) >> 0),
     (VUINT32) ((0x3C6531FF60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF914CCB8BDBF114uLL) >> 0),
     (VUINT32) ((0xBF914CCB8BDBF114uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC76DD9DE50BF31uLL) >> 0),
     (VUINT32) ((0x3FC76DD9DE50BF31uLL) >> 32)},
    {(VUINT32) ((0x3C61D5EEE0000000uLL) >> 0),
     (VUINT32) ((0x3C61D5EEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF93AD06011469FBuLL) >> 0),
     (VUINT32) ((0xBF93AD06011469FBuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC8F8B83C69A60BuLL) >> 0),
     (VUINT32) ((0x3FC8F8B83C69A60BuLL) >> 32)},
    {(VUINT32) ((0xBC626D19A0000000uLL) >> 0),
     (VUINT32) ((0xBC626D19A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9633F89E9A1A66uLL) >> 0),
     (VUINT32) ((0xBF9633F89E9A1A66uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCA82A025B00451uLL) >> 0),
     (VUINT32) ((0x3FCA82A025B00451uLL) >> 32)},
    {(VUINT32) ((0xBC687905E0000000uLL) >> 0),
     (VUINT32) ((0xBC687905E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF98E18A73634EE7uLL) >> 0),
     (VUINT32) ((0xBF98E18A73634EE7uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCC0B826A7E4F63uLL) >> 0),
     (VUINT32) ((0x3FCC0B826A7E4F63uLL) >> 32)},
    {(VUINT32) ((0xBC1AF14380000000uLL) >> 0),
     (VUINT32) ((0xBC1AF14380000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9BB5A11138A4C9uLL) >> 0),
     (VUINT32) ((0xBF9BB5A11138A4C9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCD934FE5454311uLL) >> 0),
     (VUINT32) ((0x3FCD934FE5454311uLL) >> 32)},
    {(VUINT32) ((0x3C675B9220000000uLL) >> 0),
     (VUINT32) ((0x3C675B9220000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9EB0208DB9E51BuLL) >> 0),
     (VUINT32) ((0xBF9EB0208DB9E51BuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCF19F97B215F1BuLL) >> 0),
     (VUINT32) ((0x3FCF19F97B215F1BuLL) >> 32)},
    {(VUINT32) ((0xBC642DEEE0000000uLL) >> 0),
     (VUINT32) ((0xBC642DEEE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA0E875C1B8C3DAuLL) >> 0),
     (VUINT32) ((0xBFA0E875C1B8C3DAuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD04FB80E37FDAEuLL) >> 0),
     (VUINT32) ((0x3FD04FB80E37FDAEuLL) >> 32)},
    {(VUINT32) ((0xBC0412CDA0000000uLL) >> 0),
     (VUINT32) ((0xBC0412CDA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA28BF1897B69CCuLL) >> 0),
     (VUINT32) ((0xBFA28BF1897B69CCuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD111D262B1F677uLL) >> 0),
     (VUINT32) ((0x3FD111D262B1F677uLL) >> 32)},
    {(VUINT32) ((0x3C7824C200000000uLL) >> 0),
     (VUINT32) ((0x3C7824C200000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA44273720F48BCuLL) >> 0),
     (VUINT32) ((0xBFA44273720F48BCuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD1D3443F4CDB3EuLL) >> 0),
     (VUINT32) ((0x3FD1D3443F4CDB3EuLL) >> 32)},
    {(VUINT32) ((0xBC6720D400000000uLL) >> 0),
     (VUINT32) ((0xBC6720D400000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA60BEA939D225AuLL) >> 0),
     (VUINT32) ((0xBFA60BEA939D225AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD294062ED59F06uLL) >> 0),
     (VUINT32) ((0x3FD294062ED59F06uLL) >> 32)},
    {(VUINT32) ((0xBC75D28DA0000000uLL) >> 0),
     (VUINT32) ((0xBC75D28DA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA7E8454B32EF34uLL) >> 0),
     (VUINT32) ((0xBFA7E8454B32EF34uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD35410C2E18152uLL) >> 0),
     (VUINT32) ((0x3FD35410C2E18152uLL) >> 32)},
    {(VUINT32) ((0xBC73CB0020000000uLL) >> 0),
     (VUINT32) ((0xBC73CB0020000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA9D7713B71EEE1uLL) >> 0),
     (VUINT32) ((0xBFA9D7713B71EEE1uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD4135C94176601uLL) >> 0),
     (VUINT32) ((0x3FD4135C94176601uLL) >> 32)},
    {(VUINT32) ((0x3C70C97C40000000uLL) >> 0),
     (VUINT32) ((0x3C70C97C40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFABD95B4D43E819uLL) >> 0),
     (VUINT32) ((0xBFABD95B4D43E819uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD4D1E24278E76AuLL) >> 0),
     (VUINT32) ((0x3FD4D1E24278E76AuLL) >> 32)},
    {(VUINT32) ((0x3C62417200000000uLL) >> 0),
     (VUINT32) ((0x3C62417200000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFADEDEFB09791B4uLL) >> 0),
     (VUINT32) ((0xBFADEDEFB09791B4uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD58F9A75AB1FDDuLL) >> 0),
     (VUINT32) ((0x3FD58F9A75AB1FDDuLL) >> 32)},
    {(VUINT32) ((0xBC1EFDC0C0000000uLL) >> 0),
     (VUINT32) ((0xBC1EFDC0C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB00A8CEE920EABuLL) >> 0),
     (VUINT32) ((0xBFB00A8CEE920EABuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD64C7DDD3F27C6uLL) >> 0),
     (VUINT32) ((0x3FD64C7DDD3F27C6uLL) >> 32)},
    {(VUINT32) ((0x3C510D2B40000000uLL) >> 0),
     (VUINT32) ((0x3C510D2B40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB127624999EE1DuLL) >> 0),
     (VUINT32) ((0xBFB127624999EE1DuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD7088530FA459FuLL) >> 0),
     (VUINT32) ((0x3FD7088530FA459FuLL) >> 32)},
    {(VUINT32) ((0xBC744B19E0000000uLL) >> 0),
     (VUINT32) ((0xBC744B19E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB24D6CEE3AFB2AuLL) >> 0),
     (VUINT32) ((0xBFB24D6CEE3AFB2AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD7C3A9311DCCE7uLL) >> 0),
     (VUINT32) ((0x3FD7C3A9311DCCE7uLL) >> 32)},
    {(VUINT32) ((0x3C19A3F200000000uLL) >> 0),
     (VUINT32) ((0x3C19A3F200000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB37CA1866B95CFuLL) >> 0),
     (VUINT32) ((0xBFB37CA1866B95CFuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD87DE2A6AEA963uLL) >> 0),
     (VUINT32) ((0x3FD87DE2A6AEA963uLL) >> 32)},
    {(VUINT32) ((0xBC672CEDC0000000uLL) >> 0),
     (VUINT32) ((0xBC672CEDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB4B4F461B0CBAAuLL) >> 0),
     (VUINT32) ((0xBFB4B4F461B0CBAAuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD9372A63BC93D7uLL) >> 0),
     (VUINT32) ((0x3FD9372A63BC93D7uLL) >> 32)},
    {(VUINT32) ((0x3C66843180000000uLL) >> 0),
     (VUINT32) ((0x3C66843180000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB5F6597591B633uLL) >> 0),
     (VUINT32) ((0xBFB5F6597591B633uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD9EF7943A8ED8AuLL) >> 0),
     (VUINT32) ((0x3FD9EF7943A8ED8AuLL) >> 32)},
    {(VUINT32) ((0x3C66DA8120000000uLL) >> 0),
     (VUINT32) ((0x3C66DA8120000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB740C45E0E5120uLL) >> 0),
     (VUINT32) ((0xBFB740C45E0E5120uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDAA6C82B6D3FCAuLL) >> 0),
     (VUINT32) ((0x3FDAA6C82B6D3FCAuLL) >> 32)},
    {(VUINT32) ((0xBC7D5F1060000000uLL) >> 0),
     (VUINT32) ((0xBC7D5F1060000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB894285E19C468uLL) >> 0),
     (VUINT32) ((0xBFB894285E19C468uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDB5D1009E15CC0uLL) >> 0),
     (VUINT32) ((0x3FDB5D1009E15CC0uLL) >> 32)},
    {(VUINT32) ((0x3C65B362C0000000uLL) >> 0),
     (VUINT32) ((0x3C65B362C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB9F07860181D1EuLL) >> 0),
     (VUINT32) ((0xBFB9F07860181D1EuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDC1249D8011EE7uLL) >> 0),
     (VUINT32) ((0x3FDC1249D8011EE7uLL) >> 32)},
    {(VUINT32) ((0xBC7813AAA0000000uLL) >> 0),
     (VUINT32) ((0xBC7813AAA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBB55A6F65F7058uLL) >> 0),
     (VUINT32) ((0xBFBB55A6F65F7058uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDCC66E9931C45EuLL) >> 0),
     (VUINT32) ((0x3FDCC66E9931C45EuLL) >> 32)},
    {(VUINT32) ((0x3C56850E40000000uLL) >> 0),
     (VUINT32) ((0x3C56850E40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBCC3A65BBC6327uLL) >> 0),
     (VUINT32) ((0xBFBCC3A65BBC6327uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDD79775B86E389uLL) >> 0),
     (VUINT32) ((0x3FDD79775B86E389uLL) >> 32)},
    {(VUINT32) ((0x3C7550EC80000000uLL) >> 0),
     (VUINT32) ((0x3C7550EC80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBE3A6873FA1279uLL) >> 0),
     (VUINT32) ((0xBFBE3A6873FA1279uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDE2B5D3806F63BuLL) >> 0),
     (VUINT32) ((0x3FDE2B5D3806F63BuLL) >> 32)},
    {(VUINT32) ((0x3C5E0D8900000000uLL) >> 0),
     (VUINT32) ((0x3C5E0D8900000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBFB9DECC6D55B8uLL) >> 0),
     (VUINT32) ((0xBFBFB9DECC6D55B8uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDEDC1952EF78D6uLL) >> 0),
     (VUINT32) ((0x3FDEDC1952EF78D6uLL) >> 32)},
    {(VUINT32) ((0xBC7DD0F7C0000000uLL) >> 0),
     (VUINT32) ((0xBC7DD0F7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC0A0FD4E41AB5AuLL) >> 0),
     (VUINT32) ((0xBFC0A0FD4E41AB5AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDF8BA4DBF89ABAuLL) >> 0),
     (VUINT32) ((0x3FDF8BA4DBF89ABAuLL) >> 32)},
    {(VUINT32) ((0xBC32EC1FC0000000uLL) >> 0),
     (VUINT32) ((0xBC32EC1FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC169566329BCB7uLL) >> 0),
     (VUINT32) ((0xBFC169566329BCB7uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE01CFC874C3EB7uLL) >> 0),
     (VUINT32) ((0x3FE01CFC874C3EB7uLL) >> 32)},
    {(VUINT32) ((0xBC734A35E0000000uLL) >> 0),
     (VUINT32) ((0xBC734A35E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC235F2EB9A470AuLL) >> 0),
     (VUINT32) ((0xBFC235F2EB9A470AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE073879922FFEEuLL) >> 0),
     (VUINT32) ((0x3FE073879922FFEEuLL) >> 32)},
    {(VUINT32) ((0xBC8A5A0140000000uLL) >> 0),
     (VUINT32) ((0xBC8A5A0140000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC306CB042AA3BAuLL) >> 0),
     (VUINT32) ((0xBFC306CB042AA3BAuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE0C9704D5D898FuLL) >> 0),
     (VUINT32) ((0x3FE0C9704D5D898FuLL) >> 32)},
    {(VUINT32) ((0xBC88D3D7C0000000uLL) >> 0),
     (VUINT32) ((0xBC88D3D7C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC3DBD69FABF802uLL) >> 0),
     (VUINT32) ((0xBFC3DBD69FABF802uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE11EB3541B4B23uLL) >> 0),
     (VUINT32) ((0x3FE11EB3541B4B23uLL) >> 32)},
    {(VUINT32) ((0xBC8EF23B60000000uLL) >> 0),
     (VUINT32) ((0xBC8EF23B60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC4B50D8778ABBDuLL) >> 0),
     (VUINT32) ((0xBFC4B50D8778ABBDuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE1734D63DEDB49uLL) >> 0),
     (VUINT32) ((0x3FE1734D63DEDB49uLL) >> 32)},
    {(VUINT32) ((0xBC87EEF2C0000000uLL) >> 0),
     (VUINT32) ((0xBC87EEF2C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC592675BC57974uLL) >> 0),
     (VUINT32) ((0xBFC592675BC57974uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE1C73B39AE68C8uLL) >> 0),
     (VUINT32) ((0x3FE1C73B39AE68C8uLL) >> 32)},
    {(VUINT32) ((0x3C8B25DD20000000uLL) >> 0),
     (VUINT32) ((0x3C8B25DD20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC673DB93F41479uLL) >> 0),
     (VUINT32) ((0xBFC673DB93F41479uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE21A799933EB59uLL) >> 0),
     (VUINT32) ((0x3FE21A799933EB59uLL) >> 32)},
    {(VUINT32) ((0xBC83A7B160000000uLL) >> 0),
     (VUINT32) ((0xBC83A7B160000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC759617EE761F9uLL) >> 0),
     (VUINT32) ((0xBFC759617EE761F9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE26D054CDD12DFuLL) >> 0),
     (VUINT32) ((0x3FE26D054CDD12DFuLL) >> 32)},
    {(VUINT32) ((0xBC85DA7420000000uLL) >> 0),
     (VUINT32) ((0xBC85DA7420000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC842F0435941AFuLL) >> 0),
     (VUINT32) ((0xBFC842F0435941AFuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE2BEDB25FAF3EAuLL) >> 0),
     (VUINT32) ((0x3FE2BEDB25FAF3EAuLL) >> 32)},
    {(VUINT32) ((0xBC514981C0000000uLL) >> 0),
     (VUINT32) ((0xBC514981C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFC9307EE031E2FDuLL) >> 0),
     (VUINT32) ((0xBFC9307EE031E2FDuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE30FF7FCE17035uLL) >> 0),
     (VUINT32) ((0x3FE30FF7FCE17035uLL) >> 32)},
    {(VUINT32) ((0xBC6EFCC620000000uLL) >> 0),
     (VUINT32) ((0xBC6EFCC620000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCA22042CE0A2F9uLL) >> 0),
     (VUINT32) ((0xBFCA22042CE0A2F9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE36058B10659F3uLL) >> 0),
     (VUINT32) ((0x3FE36058B10659F3uLL) >> 32)},
    {(VUINT32) ((0xBC81FCB3A0000000uLL) >> 0),
     (VUINT32) ((0xBC81FCB3A0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCB1776D9B67013uLL) >> 0),
     (VUINT32) ((0xBFCB1776D9B67013uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE3AFFA292050B9uLL) >> 0),
     (VUINT32) ((0x3FE3AFFA292050B9uLL) >> 32)},
    {(VUINT32) ((0x3C7E3E25E0000000uLL) >> 0),
     (VUINT32) ((0x3C7E3E25E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCC10CD7041AFCCuLL) >> 0),
     (VUINT32) ((0xBFCC10CD7041AFCCuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE3FED9534556D4uLL) >> 0),
     (VUINT32) ((0x3FE3FED9534556D4uLL) >> 32)},
    {(VUINT32) ((0x3C83691660000000uLL) >> 0),
     (VUINT32) ((0x3C83691660000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCD0DFE53ABA2FDuLL) >> 0),
     (VUINT32) ((0xBFCD0DFE53ABA2FDuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE44CF325091DD6uLL) >> 0),
     (VUINT32) ((0x3FE44CF325091DD6uLL) >> 32)},
    {(VUINT32) ((0x3C68076A20000000uLL) >> 0),
     (VUINT32) ((0x3C68076A20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCE0EFFC1174505uLL) >> 0),
     (VUINT32) ((0xBFCE0EFFC1174505uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE49A449B9B0939uLL) >> 0),
     (VUINT32) ((0x3FE49A449B9B0939uLL) >> 32)},
    {(VUINT32) ((0xBC827EE160000000uLL) >> 0),
     (VUINT32) ((0xBC827EE160000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFCF13C7D001A249uLL) >> 0),
     (VUINT32) ((0xBFCF13C7D001A249uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE4E6CABBE3E5E9uLL) >> 0),
     (VUINT32) ((0x3FE4E6CABBE3E5E9uLL) >> 32)},
    {(VUINT32) ((0x3C63C293E0000000uLL) >> 0),
     (VUINT32) ((0x3C63C293E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCFE3B38D5C5DC2uLL) >> 0),
     (VUINT32) ((0x3FCFE3B38D5C5DC2uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE5328292A35596uLL) >> 0),
     (VUINT32) ((0x3FE5328292A35596uLL) >> 32)},
    {(VUINT32) ((0xBC7A12EB80000000uLL) >> 0),
     (VUINT32) ((0xBC7A12EB80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCED77C89AABEBBuLL) >> 0),
     (VUINT32) ((0x3FCED77C89AABEBBuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE57D69348CECA0uLL) >> 0),
     (VUINT32) ((0x3FE57D69348CECA0uLL) >> 32)},
    {(VUINT32) ((0xBC87572080000000uLL) >> 0),
     (VUINT32) ((0xBC87572080000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCDC79D7C0DC985uLL) >> 0),
     (VUINT32) ((0x3FCDC79D7C0DC985uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE5C77BBE65018CuLL) >> 0),
     (VUINT32) ((0x3FE5C77BBE65018CuLL) >> 32)},
    {(VUINT32) ((0x3C8069EA80000000uLL) >> 0),
     (VUINT32) ((0x3C8069EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCCB420DFBFFE59uLL) >> 0),
     (VUINT32) ((0x3FCCB420DFBFFE59uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE610B7551D2CDFuLL) >> 0),
     (VUINT32) ((0x3FE610B7551D2CDFuLL) >> 32)},
    {(VUINT32) ((0xBC7251B340000000uLL) >> 0),
     (VUINT32) ((0xBC7251B340000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCB9D1153AAA2BAuLL) >> 0),
     (VUINT32) ((0x3FCB9D1153AAA2BAuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE6591925F0783DuLL) >> 0),
     (VUINT32) ((0x3FE6591925F0783DuLL) >> 32)},
    {(VUINT32) ((0x3C8C3D64E0000000uLL) >> 0),
     (VUINT32) ((0x3C8C3D64E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FCA827999FCEF32uLL) >> 0),
     (VUINT32) ((0x3FCA827999FCEF32uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE6A09E667F3BCDuLL) >> 0),
     (VUINT32) ((0x3FE6A09E667F3BCDuLL) >> 32)},
    {(VUINT32) ((0xBC8BDD3400000000uLL) >> 0),
     (VUINT32) ((0xBC8BDD3400000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC9646497C1E0F6uLL) >> 0),
     (VUINT32) ((0x3FC9646497C1E0F6uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE6E74454EAA8AFuLL) >> 0),
     (VUINT32) ((0x3FE6E74454EAA8AFuLL) >> 32)},
    {(VUINT32) ((0xBC8DBC03C0000000uLL) >> 0),
     (VUINT32) ((0xBC8DBC03C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC842DD5474B37BuLL) >> 0),
     (VUINT32) ((0x3FC842DD5474B37BuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE72D0837EFFF96uLL) >> 0),
     (VUINT32) ((0x3FE72D0837EFFF96uLL) >> 32)},
    {(VUINT32) ((0x3C80D4EF00000000uLL) >> 0),
     (VUINT32) ((0x3C80D4EF00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC71DEEF9940631uLL) >> 0),
     (VUINT32) ((0x3FC71DEEF9940631uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE771E75F037261uLL) >> 0),
     (VUINT32) ((0x3FE771E75F037261uLL) >> 32)},
    {(VUINT32) ((0x3C75CFCE80000000uLL) >> 0),
     (VUINT32) ((0x3C75CFCE80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC5F5A4D233B27FuLL) >> 0),
     (VUINT32) ((0x3FC5F5A4D233B27FuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE7B5DF226AAFAFuLL) >> 0),
     (VUINT32) ((0x3FE7B5DF226AAFAFuLL) >> 32)},
    {(VUINT32) ((0xBC70F537A0000000uLL) >> 0),
     (VUINT32) ((0xBC70F537A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC4CA0A4A8D5657uLL) >> 0),
     (VUINT32) ((0x3FC4CA0A4A8D5657uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE7F8ECE3571771uLL) >> 0),
     (VUINT32) ((0x3FE7F8ECE3571771uLL) >> 32)},
    {(VUINT32) ((0xBC89C8D8C0000000uLL) >> 0),
     (VUINT32) ((0xBC89C8D8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC39B2AEF8F97A4uLL) >> 0),
     (VUINT32) ((0x3FC39B2AEF8F97A4uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE83B0E0BFF976EuLL) >> 0),
     (VUINT32) ((0x3FE83B0E0BFF976EuLL) >> 32)},
    {(VUINT32) ((0xBC76F420E0000000uLL) >> 0),
     (VUINT32) ((0xBC76F420E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC269126E6C24E3uLL) >> 0),
     (VUINT32) ((0x3FC269126E6C24E3uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE87C400FBA2EBFuLL) >> 0),
     (VUINT32) ((0x3FE87C400FBA2EBFuLL) >> 32)},
    {(VUINT32) ((0xBC82DABC00000000uLL) >> 0),
     (VUINT32) ((0xBC82DABC00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FC133CC94247758uLL) >> 0),
     (VUINT32) ((0x3FC133CC94247758uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE8BC806B151741uLL) >> 0),
     (VUINT32) ((0x3FE8BC806B151741uLL) >> 32)},
    {(VUINT32) ((0xBC82C5E120000000uLL) >> 0),
     (VUINT32) ((0xBC82C5E120000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBFF6CA9A2AB6A2uLL) >> 0),
     (VUINT32) ((0x3FBFF6CA9A2AB6A2uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE8FBCCA3EF940DuLL) >> 0),
     (VUINT32) ((0x3FE8FBCCA3EF940DuLL) >> 32)},
    {(VUINT32) ((0xBC66DFA980000000uLL) >> 0),
     (VUINT32) ((0xBC66DFA980000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBD7FD1490285CAuLL) >> 0),
     (VUINT32) ((0x3FBD7FD1490285CAuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE93A22499263FBuLL) >> 0),
     (VUINT32) ((0x3FE93A22499263FBuLL) >> 32)},
    {(VUINT32) ((0x3C83D419A0000000uLL) >> 0),
     (VUINT32) ((0x3C83D419A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBB02C58832CF96uLL) >> 0),
     (VUINT32) ((0x3FBB02C58832CF96uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE9777EF4C7D742uLL) >> 0),
     (VUINT32) ((0x3FE9777EF4C7D742uLL) >> 32)},
    {(VUINT32) ((0xBC815479A0000000uLL) >> 0),
     (VUINT32) ((0xBC815479A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB87FBFE70B81A7uLL) >> 0),
     (VUINT32) ((0x3FB87FBFE70B81A7uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE9B3E047F38741uLL) >> 0),
     (VUINT32) ((0x3FE9B3E047F38741uLL) >> 32)},
    {(VUINT32) ((0xBC830EE280000000uLL) >> 0),
     (VUINT32) ((0xBC830EE280000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB5F6D92FD79F50uLL) >> 0),
     (VUINT32) ((0x3FB5F6D92FD79F50uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE9EF43EF29AF94uLL) >> 0),
     (VUINT32) ((0x3FE9EF43EF29AF94uLL) >> 32)},
    {(VUINT32) ((0x3C7B1DFCA0000000uLL) >> 0),
     (VUINT32) ((0x3C7B1DFCA0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB3682A66E896F5uLL) >> 0),
     (VUINT32) ((0x3FB3682A66E896F5uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEA29A7A0462782uLL) >> 0),
     (VUINT32) ((0x3FEA29A7A0462782uLL) >> 32)},
    {(VUINT32) ((0xBC7128BB00000000uLL) >> 0),
     (VUINT32) ((0xBC7128BB00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB0D3CCC99F5AC6uLL) >> 0),
     (VUINT32) ((0x3FB0D3CCC99F5AC6uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEA63091B02FAE2uLL) >> 0),
     (VUINT32) ((0x3FEA63091B02FAE2uLL) >> 32)},
    {(VUINT32) ((0xBC7E911140000000uLL) >> 0),
     (VUINT32) ((0xBC7E911140000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAC73B39AE68C87uLL) >> 0),
     (VUINT32) ((0x3FAC73B39AE68C87uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEA9B66290EA1A3uLL) >> 0),
     (VUINT32) ((0x3FEA9B66290EA1A3uLL) >> 32)},
    {(VUINT32) ((0x3C39F630E0000000uLL) >> 0),
     (VUINT32) ((0x3C39F630E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA734D63DEDB48AuLL) >> 0),
     (VUINT32) ((0x3FA734D63DEDB48AuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEAD2BC9E21D511uLL) >> 0),
     (VUINT32) ((0x3FEAD2BC9E21D511uLL) >> 32)},
    {(VUINT32) ((0xBC847FBE00000000uLL) >> 0),
     (VUINT32) ((0xBC847FBE00000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA1EB3541B4B228uLL) >> 0),
     (VUINT32) ((0x3FA1EB3541B4B228uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEB090A58150200uLL) >> 0),
     (VUINT32) ((0x3FEB090A58150200uLL) >> 32)},
    {(VUINT32) ((0xBC8926DA20000000uLL) >> 0),
     (VUINT32) ((0xBC8926DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F992E09ABB131D4uLL) >> 0),
     (VUINT32) ((0x3F992E09ABB131D4uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEB3E4D3EF55712uLL) >> 0),
     (VUINT32) ((0x3FEB3E4D3EF55712uLL) >> 32)},
    {(VUINT32) ((0xBC8EB6B8A0000000uLL) >> 0),
     (VUINT32) ((0xBC8EB6B8A0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F8CE1E648BFFB66uLL) >> 0),
     (VUINT32) ((0x3F8CE1E648BFFB66uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEB728345196E3EuLL) >> 0),
     (VUINT32) ((0x3FEB728345196E3EuLL) >> 32)},
    {(VUINT32) ((0xBC8BC69F20000000uLL) >> 0),
     (VUINT32) ((0xBC8BC69F20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F6CFC874C3EB6D9uLL) >> 0),
     (VUINT32) ((0x3F6CFC874C3EB6D9uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEBA5AA673590D2uLL) >> 0),
     (VUINT32) ((0x3FEBA5AA673590D2uLL) >> 32)},
    {(VUINT32) ((0x3C87EA4E20000000uLL) >> 0),
     (VUINT32) ((0x3C87EA4E20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7D16C901D95181uLL) >> 0),
     (VUINT32) ((0xBF7D16C901D95181uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEBD7C0AC6F952AuLL) >> 0),
     (VUINT32) ((0x3FEBD7C0AC6F952AuLL) >> 32)},
    {(VUINT32) ((0xBC8825A720000000uLL) >> 0),
     (VUINT32) ((0xBC8825A720000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF923E6AD10872A7uLL) >> 0),
     (VUINT32) ((0xBF923E6AD10872A7uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC08C426725549uLL) >> 0),
     (VUINT32) ((0x3FEC08C426725549uLL) >> 32)},
    {(VUINT32) ((0x3C5B157FC0000000uLL) >> 0),
     (VUINT32) ((0x3C5B157FC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9D4A2C7F909C4EuLL) >> 0),
     (VUINT32) ((0xBF9D4A2C7F909C4EuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC38B2F180BDB1uLL) >> 0),
     (VUINT32) ((0x3FEC38B2F180BDB1uLL) >> 32)},
    {(VUINT32) ((0xBC76E0B160000000uLL) >> 0),
     (VUINT32) ((0xBC76E0B160000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA4344523C8E3B5uLL) >> 0),
     (VUINT32) ((0xBFA4344523C8E3B5uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC678B3488739BuLL) >> 0),
     (VUINT32) ((0x3FEC678B3488739BuLL) >> 32)},
    {(VUINT32) ((0x3C6D86CAC0000000uLL) >> 0),
     (VUINT32) ((0x3C6D86CAC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA9CC8B3671DD0FuLL) >> 0),
     (VUINT32) ((0xBFA9CC8B3671DD0FuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC954B213411F5uLL) >> 0),
     (VUINT32) ((0x3FEC954B213411F5uLL) >> 32)},
    {(VUINT32) ((0xBC52FB7600000000uLL) >> 0),
     (VUINT32) ((0xBC52FB7600000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAF6DB13FF708CBuLL) >> 0),
     (VUINT32) ((0xBFAF6DB13FF708CBuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FECC1F0F3FCFC5CuLL) >> 0),
     (VUINT32) ((0x3FECC1F0F3FCFC5CuLL) >> 32)},
    {(VUINT32) ((0x3C7E576120000000uLL) >> 0),
     (VUINT32) ((0x3C7E576120000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB28BBFD87A8CFFuLL) >> 0),
     (VUINT32) ((0xBFB28BBFD87A8CFFuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FECED7AF43CC773uLL) >> 0),
     (VUINT32) ((0x3FECED7AF43CC773uLL) >> 32)},
    {(VUINT32) ((0xBC5E7B6BA0000000uLL) >> 0),
     (VUINT32) ((0xBC5E7B6BA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB564DF524B00DAuLL) >> 0),
     (VUINT32) ((0xBFB564DF524B00DAuLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED17E7743E35DCuLL) >> 0),
     (VUINT32) ((0x3FED17E7743E35DCuLL) >> 32)},
    {(VUINT32) ((0xBC5101DA20000000uLL) >> 0),
     (VUINT32) ((0xBC5101DA20000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFB8421AF15C49D7uLL) >> 0),
     (VUINT32) ((0xBFB8421AF15C49D7uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED4134D14DC93AuLL) >> 0),
     (VUINT32) ((0x3FED4134D14DC93AuLL) >> 32)},
    {(VUINT32) ((0xBC84EF5280000000uLL) >> 0),
     (VUINT32) ((0xBC84EF5280000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBB2356710DB0A3uLL) >> 0),
     (VUINT32) ((0xBFBB2356710DB0A3uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED696173C9E68BuLL) >> 0),
     (VUINT32) ((0x3FED696173C9E68BuLL) >> 32)},
    {(VUINT32) ((0xBC7E8C61C0000000uLL) >> 0),
     (VUINT32) ((0xBC7E8C61C0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFBE087565455A75uLL) >> 0),
     (VUINT32) ((0xBFBE087565455A75uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED906BCF328D46uLL) >> 0),
     (VUINT32) ((0x3FED906BCF328D46uLL) >> 32)},
    {(VUINT32) ((0x3C7457E600000000uLL) >> 0),
     (VUINT32) ((0x3C7457E600000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBF0EA4C477339CuLL) >> 0),
     (VUINT32) ((0x3FBF0EA4C477339CuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEDB6526238A09BuLL) >> 0),
     (VUINT32) ((0x3FEDB6526238A09BuLL) >> 32)},
    {(VUINT32) ((0xBC7ADEE7E0000000uLL) >> 0),
     (VUINT32) ((0xBC7ADEE7E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FBC2214C3E9167BuLL) >> 0),
     (VUINT32) ((0x3FBC2214C3E9167BuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEDDB13B6CCC23CuLL) >> 0),
     (VUINT32) ((0x3FEDDB13B6CCC23CuLL) >> 32)},
    {(VUINT32) ((0x3C883C37C0000000uLL) >> 0),
     (VUINT32) ((0x3C883C37C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB931F774FC9F18uLL) >> 0),
     (VUINT32) ((0x3FB931F774FC9F18uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEDFEAE622DBE2BuLL) >> 0),
     (VUINT32) ((0x3FEDFEAE622DBE2BuLL) >> 32)},
    {(VUINT32) ((0xBC8514EA80000000uLL) >> 0),
     (VUINT32) ((0xBC8514EA80000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB63E69D6AC7F74uLL) >> 0),
     (VUINT32) ((0x3FB63E69D6AC7F74uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE212104F686E5uLL) >> 0),
     (VUINT32) ((0x3FEE212104F686E5uLL) >> 32)},
    {(VUINT32) ((0xBC8014C760000000uLL) >> 0),
     (VUINT32) ((0xBC8014C760000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB3478909E39DA9uLL) >> 0),
     (VUINT32) ((0x3FB3478909E39DA9uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE426A4B2BC17EuLL) >> 0),
     (VUINT32) ((0x3FEE426A4B2BC17EuLL) >> 32)},
    {(VUINT32) ((0x3C8A873880000000uLL) >> 0),
     (VUINT32) ((0x3C8A873880000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FB04D72505D9805uLL) >> 0),
     (VUINT32) ((0x3FB04D72505D9805uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE6288EC48E112uLL) >> 0),
     (VUINT32) ((0x3FEE6288EC48E112uLL) >> 32)},
    {(VUINT32) ((0xBC616B56E0000000uLL) >> 0),
     (VUINT32) ((0xBC616B56E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FAAA086170C0A8EuLL) >> 0),
     (VUINT32) ((0x3FAAA086170C0A8EuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE817BAB4CD10DuLL) >> 0),
     (VUINT32) ((0x3FEE817BAB4CD10DuLL) >> 32)},
    {(VUINT32) ((0xBC7D0AFE60000000uLL) >> 0),
     (VUINT32) ((0xBC7D0AFE60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA4A03176ACF82DuLL) >> 0),
     (VUINT32) ((0x3FA4A03176ACF82DuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE9F4156C62DDAuLL) >> 0),
     (VUINT32) ((0x3FEE9F4156C62DDAuLL) >> 32)},
    {(VUINT32) ((0x3C8760B1E0000000uLL) >> 0),
     (VUINT32) ((0x3C8760B1E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F9D3443F4CDB3DDuLL) >> 0),
     (VUINT32) ((0x3F9D3443F4CDB3DDuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEEBBD8C8DF0B74uLL) >> 0),
     (VUINT32) ((0x3FEEBBD8C8DF0B74uLL) >> 32)},
    {(VUINT32) ((0x3C7C6C8C60000000uLL) >> 0),
     (VUINT32) ((0x3C7C6C8C60000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F911D262B1F6776uLL) >> 0),
     (VUINT32) ((0x3F911D262B1F6776uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEED740E7684963uLL) >> 0),
     (VUINT32) ((0x3FEED740E7684963uLL) >> 32)},
    {(VUINT32) ((0x3C7E82C780000000uLL) >> 0),
     (VUINT32) ((0x3C7E82C780000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F73EE038DFF6B80uLL) >> 0),
     (VUINT32) ((0x3F73EE038DFF6B80uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEEF178A3E473C2uLL) >> 0),
     (VUINT32) ((0x3FEEF178A3E473C2uLL) >> 32)},
    {(VUINT32) ((0x3C86310A60000000uLL) >> 0),
     (VUINT32) ((0x3C86310A60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7CC0D09BD41CAAuLL) >> 0),
     (VUINT32) ((0xBF7CC0D09BD41CAAuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF0A7EFB9230D7uLL) >> 0),
     (VUINT32) ((0x3FEF0A7EFB9230D7uLL) >> 32)},
    {(VUINT32) ((0x3C752C7AC0000000uLL) >> 0),
     (VUINT32) ((0x3C752C7AC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF936580D5D5E775uLL) >> 0),
     (VUINT32) ((0xBF936580D5D5E775uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF2252F7763ADAuLL) >> 0),
     (VUINT32) ((0x3FEF2252F7763ADAuLL) >> 32)},
    {(VUINT32) ((0xBC820CB800000000uLL) >> 0),
     (VUINT32) ((0xBC820CB800000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9FA3ECAC0D84E8uLL) >> 0),
     (VUINT32) ((0xBF9FA3ECAC0D84E8uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF38F3AC64E589uLL) >> 0),
     (VUINT32) ((0x3FEF38F3AC64E589uLL) >> 32)},
    {(VUINT32) ((0xBC7D7BAFA0000000uLL) >> 0),
     (VUINT32) ((0xBC7D7BAFA0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFA5F57F693FEEBEuLL) >> 0),
     (VUINT32) ((0xBFA5F57F693FEEBEuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF4E603B0B2F2DuLL) >> 0),
     (VUINT32) ((0x3FEF4E603B0B2F2DuLL) >> 32)},
    {(VUINT32) ((0xBC78EE01E0000000uLL) >> 0),
     (VUINT32) ((0xBC78EE01E0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBFAC1D1F0E5967D5uLL) >> 0),
     (VUINT32) ((0xBFAC1D1F0E5967D5uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF6297CFF75CB0uLL) >> 0),
     (VUINT32) ((0x3FEF6297CFF75CB0uLL) >> 32)},
    {(VUINT32) ((0x3C75621720000000uLL) >> 0),
     (VUINT32) ((0x3C75621720000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FADB7677942FCC5uLL) >> 0),
     (VUINT32) ((0x3FADB7677942FCC5uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF7599A3A12077uLL) >> 0),
     (VUINT32) ((0x3FEF7599A3A12077uLL) >> 32)},
    {(VUINT32) ((0x3C884F31C0000000uLL) >> 0),
     (VUINT32) ((0x3C884F31C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA78851122CFF19uLL) >> 0),
     (VUINT32) ((0x3FA78851122CFF19uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF8764FA714BA9uLL) >> 0),
     (VUINT32) ((0x3FEF8764FA714BA9uLL) >> 32)},
    {(VUINT32) ((0x3C7AB25660000000uLL) >> 0),
     (VUINT32) ((0x3C7AB25660000000uLL) >> 32)}},
   {{(VUINT32) ((0x3FA155DAC4A4F967uLL) >> 0),
     (VUINT32) ((0x3FA155DAC4A4F967uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF97F924C9099BuLL) >> 0),
     (VUINT32) ((0x3FEF97F924C9099BuLL) >> 32)},
    {(VUINT32) ((0xBC8E2AE0E0000000uLL) >> 0),
     (VUINT32) ((0xBC8E2AE0E0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F964083747309D1uLL) >> 0),
     (VUINT32) ((0x3F964083747309D1uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFA7557F08A517uLL) >> 0),
     (VUINT32) ((0x3FEFA7557F08A517uLL) >> 32)},
    {(VUINT32) ((0xBC87A0A8C0000000uLL) >> 0),
     (VUINT32) ((0xBC87A0A8C0000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F839F0CEDAF576BuLL) >> 0),
     (VUINT32) ((0x3F839F0CEDAF576BuLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFB5797195D741uLL) >> 0),
     (VUINT32) ((0x3FEFB5797195D741uLL) >> 32)},
    {(VUINT32) ((0x3C71BFAC60000000uLL) >> 0),
     (VUINT32) ((0x3C71BFAC60000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6536352AD19E39uLL) >> 0),
     (VUINT32) ((0xBF6536352AD19E39uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFC26470E19FD3uLL) >> 0),
     (VUINT32) ((0x3FEFC26470E19FD3uLL) >> 32)},
    {(VUINT32) ((0x3C81EC8660000000uLL) >> 0),
     (VUINT32) ((0x3C81EC8660000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8E43D1C309E958uLL) >> 0),
     (VUINT32) ((0xBF8E43D1C309E958uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFCE15FD6DA67BuLL) >> 0),
     (VUINT32) ((0x3FEFCE15FD6DA67BuLL) >> 32)},
    {(VUINT32) ((0xBC75DD6F80000000uLL) >> 0),
     (VUINT32) ((0xBC75DD6F80000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF9BA1650F592F50uLL) >> 0),
     (VUINT32) ((0xBF9BA1650F592F50uLL) >> 32)},
    {(VUINT32) ((0x3FC0000000000000uLL) >> 0),
     (VUINT32) ((0x3FC0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFD88DA3D12526uLL) >> 0),
     (VUINT32) ((0x3FEFD88DA3D12526uLL) >> 32)},
    {(VUINT32) ((0xBC887DF620000000uLL) >> 0),
     (VUINT32) ((0xBC887DF620000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F97DB402A6A9063uLL) >> 0),
     (VUINT32) ((0x3F97DB402A6A9063uLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
     (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFE1CAFCBD5B09uLL) >> 0),
     (VUINT32) ((0x3FEFE1CAFCBD5B09uLL) >> 32)},
    {(VUINT32) ((0x3C6A23E320000000uLL) >> 0),
     (VUINT32) ((0x3C6A23E320000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F86A9049670CFAEuLL) >> 0),
     (VUINT32) ((0x3F86A9049670CFAEuLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
     (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFE9CDAD01883AuLL) >> 0),
     (VUINT32) ((0x3FEFE9CDAD01883AuLL) >> 32)},
    {(VUINT32) ((0x3C6521ECC0000000uLL) >> 0),
     (VUINT32) ((0x3C6521ECC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF535230C0FBE402uLL) >> 0),
     (VUINT32) ((0xBF535230C0FBE402uLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
     (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFF095658E71ADuLL) >> 0),
     (VUINT32) ((0x3FEFF095658E71ADuLL) >> 32)},
    {(VUINT32) ((0x3C801A8CE0000000uLL) >> 0),
     (VUINT32) ((0x3C801A8CE0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF8B82683BC89FB0uLL) >> 0),
     (VUINT32) ((0xBF8B82683BC89FB0uLL) >> 32)},
    {(VUINT32) ((0x3FB0000000000000uLL) >> 0),
     (VUINT32) ((0x3FB0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFF621E3796D7EuLL) >> 0),
     (VUINT32) ((0x3FEFF621E3796D7EuLL) >> 32)},
    {(VUINT32) ((0xBC6C57BC20000000uLL) >> 0),
     (VUINT32) ((0xBC6C57BC20000000uLL) >> 32)}},
   {{(VUINT32) ((0x3F76C32BACA2AE69uLL) >> 0),
     (VUINT32) ((0x3F76C32BACA2AE69uLL) >> 32)},
    {(VUINT32) ((0x3FA0000000000000uLL) >> 0),
     (VUINT32) ((0x3FA0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFFA72EFFEF75DuLL) >> 0),
     (VUINT32) ((0x3FEFFA72EFFEF75DuLL) >> 32)},
    {(VUINT32) ((0xBC88B4CDC0000000uLL) >> 0),
     (VUINT32) ((0xBC88B4CDC0000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF7B7AA821726608uLL) >> 0),
     (VUINT32) ((0xBF7B7AA821726608uLL) >> 32)},
    {(VUINT32) ((0x3FA0000000000000uLL) >> 0),
     (VUINT32) ((0x3FA0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFFD886084CD0DuLL) >> 0),
     (VUINT32) ((0x3FEFFD886084CD0DuLL) >> 32)},
    {(VUINT32) ((0xBC81354D40000000uLL) >> 0),
     (VUINT32) ((0xBC81354D40000000uLL) >> 32)}},
   {{(VUINT32) ((0xBF6B78B80C84E1EEuLL) >> 0),
     (VUINT32) ((0xBF6B78B80C84E1EEuLL) >> 32)},
    {(VUINT32) ((0x3F90000000000000uLL) >> 0),
     (VUINT32) ((0x3F90000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEFFF62169B92DBuLL) >> 0),
     (VUINT32) ((0x3FEFFF62169B92DBuLL) >> 32)},
    {(VUINT32) ((0x3C85DDA3C0000000uLL) >> 0),
     (VUINT32) ((0x3C85DDA3C0000000uLL) >> 32)}},
   },
  {(VUINT32) ((0x7FFFFFFFFFFFFFFFuLL) >> 0),
   (VUINT32) ((0x7FFFFFFFFFFFFFFFuLL) >> 32)},
  {(VUINT32) ((0x40F000000E4DB24CuLL) >> 0),
   (VUINT32) ((0x40F000000E4DB24CuLL) >> 32)},

  {(VUINT32) ((0x7FF0000000000000uLL) >> 0),
   (VUINT32) ((0x7FF0000000000000uLL) >> 32)},
  {(VUINT32) ((0x40545F306DC9C883uLL) >> 0),
   (VUINT32) ((0x40545F306DC9C883uLL) >> 32)},
  {(VUINT32) ((0x4338000000000000uLL) >> 0),
   (VUINT32) ((0x4338000000000000uLL) >> 32)},
  {(VUINT32) ((0x00000000000001FFuLL) >> 0),
   (VUINT32) ((0x00000000000001FFuLL) >> 32)},
  {(VUINT32) ((0x3F8921FB54400000uLL) >> 0),
   (VUINT32) ((0x3F8921FB54400000uLL) >> 32)},
  {(VUINT32) ((0x3D60B4611A600000uLL) >> 0),
   (VUINT32) ((0x3D60B4611A600000uLL) >> 32)},
  {(VUINT32) ((0x3B33198A2E037073uLL) >> 0),
   (VUINT32) ((0x3B33198A2E037073uLL) >> 32)},
  {(VUINT32) ((0xBFC5555555554448uLL) >> 0),
   (VUINT32) ((0xBFC5555555554448uLL) >> 32)},
  {(VUINT32) ((0x3F81110FABB3551CuLL) >> 0),
   (VUINT32) ((0x3F81110FABB3551CuLL) >> 32)},
  {(VUINT32) ((0xBFE0000000000000uLL) >> 0),
   (VUINT32) ((0xBFE0000000000000uLL) >> 32)},
  {(VUINT32) ((0x3FA5555555554CCFuLL) >> 0),
   (VUINT32) ((0x3FA5555555554CCFuLL) >> 32)},
  {(VUINT32) ((0xBF56C16AB163B2D7uLL) >> 0),
   (VUINT32) ((0xBF56C16AB163B2D7uLL) >> 32)},
};

typedef struct
{
  VUINT32 _dAbsMask[2];
  VUINT32 _dRangeVal[2];
  VUINT32 _dHalfPI[2];
  VUINT32 _dInvPI[2];
  VUINT32 _dRShifter[2];
  VUINT32 _dOneHalf[2];
  VUINT32 _dPI1[2];
  VUINT32 _dPI2[2];
  VUINT32 _dPI3[2];
  VUINT32 _dPI4[2];
  VUINT32 _dPI1_FMA[2];
  VUINT32 _dPI2_FMA[2];
  VUINT32 _dPI3_FMA[2];
  VUINT32 _dC1[2];
  VUINT32 _dC2[2];
  VUINT32 _dC3[2];
  VUINT32 _dC4[2];
  VUINT32 _dC5[2];
  VUINT32 _dC6[2];
  VUINT32 _dC7[2];

  VUINT32 _dAbsMask_la[2];
  VUINT32 _dInvPI_la[2];
  VUINT32 _dRShifter_la[2];
  VUINT32 _dRShifterm5_la[2];
  VUINT32 _dRXmax_la[2];

} dCos_Table_Type;

__constant dCos_Table_Type __ocl_svml_dcos_data = {

  {(VUINT32) ((0x7FFFFFFFFFFFFFFFuLL) >> 0),
   (VUINT32) ((0x7FFFFFFFFFFFFFFFuLL) >> 32)},
  {(VUINT32) ((0x4160000000000000uLL) >> 0),
   (VUINT32) ((0x4160000000000000uLL) >> 32)},
  {(VUINT32) ((0x3FF921FB54442D18uLL) >> 0),
   (VUINT32) ((0x3FF921FB54442D18uLL) >> 32)},
  {(VUINT32) ((0x3FD45F306DC9C883uLL) >> 0),
   (VUINT32) ((0x3FD45F306DC9C883uLL) >> 32)},
  {(VUINT32) ((0x4338000000000000uLL) >> 0),
   (VUINT32) ((0x4338000000000000uLL) >> 32)},
  {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
   (VUINT32) ((0x3FE0000000000000uLL) >> 32)},

  {(VUINT32) ((0x400921FB40000000uLL) >> 0),
   (VUINT32) ((0x400921FB40000000uLL) >> 32)},
  {(VUINT32) ((0x3E84442D00000000uLL) >> 0),
   (VUINT32) ((0x3E84442D00000000uLL) >> 32)},
  {(VUINT32) ((0x3D08469880000000uLL) >> 0),
   (VUINT32) ((0x3D08469880000000uLL) >> 32)},
  {(VUINT32) ((0x3B88CC51701B839AuLL) >> 0),
   (VUINT32) ((0x3B88CC51701B839AuLL) >> 32)},

  {(VUINT32) ((0x400921fb54442d18uLL) >> 0),
   (VUINT32) ((0x400921fb54442d18uLL) >> 32)},
  {(VUINT32) ((0x3ca1a62633145c06uLL) >> 0),
   (VUINT32) ((0x3ca1a62633145c06uLL) >> 32)},
  {(VUINT32) ((0x395c1cd129024e09uLL) >> 0),
   (VUINT32) ((0x395c1cd129024e09uLL) >> 32)},

  {(VUINT32) ((0xbfc55555555554a7uLL) >> 0),
   (VUINT32) ((0xbfc55555555554a7uLL) >> 32)},
  {(VUINT32) ((0x3f8111111110a4a8uLL) >> 0),
   (VUINT32) ((0x3f8111111110a4a8uLL) >> 32)},
  {(VUINT32) ((0xbf2a01a019a5b86duLL) >> 0),
   (VUINT32) ((0xbf2a01a019a5b86duLL) >> 32)},
  {(VUINT32) ((0x3ec71de38030fea0uLL) >> 0),
   (VUINT32) ((0x3ec71de38030fea0uLL) >> 32)},
  {(VUINT32) ((0xbe5ae63546002231uLL) >> 0),
   (VUINT32) ((0xbe5ae63546002231uLL) >> 32)},
  {(VUINT32) ((0x3de60e6857a2f220uLL) >> 0),
   (VUINT32) ((0x3de60e6857a2f220uLL) >> 32)},
  {(VUINT32) ((0xbd69f0d60811aac8uLL) >> 0),
   (VUINT32) ((0xbd69f0d60811aac8uLL) >> 32)},

  {(VUINT32) ((0x7FFFFFFFFFFFFFFFuLL) >> 0),
   (VUINT32) ((0x7FFFFFFFFFFFFFFFuLL) >> 32)},
  {(VUINT32) ((0x3FD45F306DC9C883uLL) >> 0),
   (VUINT32) ((0x3FD45F306DC9C883uLL) >> 32)},
  {(VUINT32) ((0x4330000000000000uLL) >> 0),
   (VUINT32) ((0x4330000000000000uLL) >> 32)},
  {(VUINT32) ((0x432FFFFFFFFFFFFFuLL) >> 0),
   (VUINT32) ((0x432FFFFFFFFFFFFFuLL) >> 32)},
  {(VUINT32) ((0x43300000007FFFFEuLL) >> 0),
   (VUINT32) ((0x43300000007FFFFEuLL) >> 32)},

};

#endif
