/*
 * Copyright (C) 2017-2020 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#pragma once
#include "../execution_model/device_enqueue.h"

#define WA_PROFILING_PREEMPTION 1
#define WA_SCHEDULER_PREEMPTION 1
#define WA_KERNEL_PREEMPTION 1
#define WA_ARB_CHECK_AFTER_MSF 1
#define WA_MI_ATOMIC_BEFORE_MEDIA_ID_LOAD 1

#define OCLRT_GPGPU_WALKER_CMD_DEVICE_CMD_G9 (15 * sizeof(uint))
#define OCLRT_PIPE_CONTROL_CMD_DEVICE_CMD_G9 (6 * sizeof(uint))
#define OCLRT_LOAD_REGISTER_IMM_CMD_G9 (3 * sizeof(uint))

#define OCLRT_GPGPU_WALKER_CMD_DEVICE_CMD_G9_DWORD_OFFSET (15)
#define OCLRT_PIPE_CONTROL_CMD_DEVICE_CMD_G9_DWORD_OFFSET (6)

// Changed: MediaVFE state cmd size removal
#define SECOND_LEVEL_BUFFER_SPACE_FOR_EACH_ENQUEUE_GEN9 (OCLRT_SIZEOF_MEDIA_STATE_FLUSH + OCLRT_SIZEOF_MI_ARB_CHECK + OCLRT_PIPE_CONTROL_CMD_DEVICE_CMD_G9 + OCLRT_PIPE_CONTROL_CMD_DEVICE_CMD_G9 + OCLRT_SIZEOF_MI_ATOMIC_CMD + OCLRT_SIZEOF_MEDIA_INTERFACE_DESCRIPTOR_LOAD_DEVICE_CMD + OCLRT_GPGPU_WALKER_CMD_DEVICE_CMD_G9 + OCLRT_SIZEOF_MEDIA_STATE_FLUSH + OCLRT_SIZEOF_MI_ARB_CHECK + OCLRT_PIPE_CONTROL_CMD_DEVICE_CMD_G9 + OCLRT_PIPE_CONTROL_CMD_DEVICE_CMD_G9 + CS_PREFETCH_SIZE)
#define SECOND_LEVEL_BUFFER_NUMBER_OF_ENQUEUES_GEN9 (128)