/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  Generic implementation of iEventObservers
//

#ifndef IGGCOMMONEVENTOBSERVERS_H
#define IGGCOMMONEVENTOBSERVERS_H


#include "icommoneventobservers.h"


class iggWidget;
class iggWidgetProgressBar;


class iggProgressEventObserver : public iProgressEventObserver
{
	
	friend class iShellFactory;

public:
	
	vtkTypeMacro(iggProgressEventObserver,iProgressEventObserver);

	void SetProgressBar(iggWidgetProgressBar *pb);

protected:

	iggProgressEventObserver(iViewModule *vm);

	virtual void ChildStarted();
	virtual void ChildFinished();
	virtual bool CheckAbort();
	virtual void SetProgressBody(float fraction);

	iggWidgetProgressBar *mProgressBar;
};


class iggAbortRenderEventObserver : public iAbortRenderEventObserver
{
	
	friend class iShellFactory;

public:
	
	vtkTypeMacro(iggAbortRenderEventObserver,iAbortRenderEventObserver);

	virtual void Started();
	virtual void Finished();
	virtual bool CheckAbort();
	virtual void PostFinished();

protected:

	iggAbortRenderEventObserver(iViewModule *vm) : iAbortRenderEventObserver(vm){}
};


class iggPickEventObserver : public iPickEventObserver
{
	
	friend class iShellFactory;

public:
	
	vtkTypeMacro(iggPickEventObserver,iPickEventObserver);

	virtual void Started();
	virtual void Finished();

protected:

	iggPickEventObserver(iViewModule *vm) : iPickEventObserver(vm){}
};


class iggParallelUpdateEventObserver : public iParallelUpdateEventObserver
{
	
	friend class iShellFactory;

public:
	
	vtkTypeMacro(iggParallelUpdateEventObserver,iParallelUpdateEventObserver);

	virtual void UpdateInformation();

protected:

	iggParallelUpdateEventObserver(iControlModule *cm) : iParallelUpdateEventObserver(cm){}
};


class iggAnimatorEventObserver : public iAnimatorEventObserver
{
	
	friend class iShellFactory;

public:
	
	vtkTypeMacro(iggAnimatorEventObserver,iAnimatorEventObserver);

	virtual void OnCameraPath(int step);

	void AddDependent(iggWidget *w);

protected:

	iggAnimatorEventObserver(iViewModule *vm);

	iggWidget *mDependent;
};

#endif // IGGCOMMONEVENTOBSERVERS_H

