package CParse::Struct;

use 5.6.0;
use strict;
use warnings;

use File::Spec;
use CType::Struct;
use CType::Ref;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;
    my $tag = shift;
    my $declarations = shift;
    my $attributes1 = shift;
    my $attributes2 = shift;
    my $self = {tag => $tag,
                declarations => $declarations,
                attributes1 => $attributes1,
                attributes2 => $attributes2,
               };
    bless $self, $class;
    return $self;
  }

sub dump_c
  {
    my $self = shift;

    my $str = '';

    $str .= "struct";
    if ($self->{attributes1})
      {
        $str .= " " . $self->{attributes1}->dump_c;
      }
    if ($self->{tag})
      {
        $str .= " $self->{tag}";
      }
    $str .= "\n{\n";
    foreach my $declaration (@{$self->{declarations}})
      {
        my @dump = split /\n/, $declaration->dump_c;
        $str .= join('', map {"  $_\n"} @dump);
      }
    $str .= "}";
    if ($self->{attributes2})
      {
        $str .= " " . $self->{attributes2}->dump_c;
      }

    return $str;
  }

sub construct_type
  {
    my $self = shift;
    my $namespace = shift;

    my @attributes;
    push @attributes, $self->{attributes1}->attributes if $self->{attributes1};
    push @attributes, $self->{attributes2}->attributes if $self->{attributes2};

    my @members = map {$_->get_members($namespace)} @{$self->{declarations}};

    return new CType::Struct \@members, \@attributes, $CParse::current_location;
  }

sub process
  {
    my $self = shift;

    my $namespace = shift;

    if ($self->{tag})
      {
        # Heuristic: we'll ignore redefinitions that occur at the same file:line
        my $old = $namespace->get('struct', $self->{tag});
        if ($old and
            (File::Spec->canonpath($old->{file}) ne File::Spec->canonpath($CParse::current_location->{file})
             or $old->{line} ne $CParse::current_location->{line}))
          {
            die "Redefinition of struct $self->{tag}\n (old definition at $old->{file}:$old->{line})\n";
          }

        my $type = $self->construct_type($namespace);
        $namespace->set('struct', $self->{tag}, $type);
      }
  }

sub get_type
  {
    my $self = shift;

    my $namespace = shift;

    if ($self->{tag})
      {
        return new CType::Ref 'struct', $self->{tag}, $namespace;
      }
    else
      {
        return $self->construct_type($namespace);
      }
  }

1;
