{-# language CPP, ForeignFunctionInterface #-}

module Clocked.WinTimePeriod (withTimePeriod) where

#ifdef mingw32_HOST_OS


import Control.Monad.CatchIO
import Control.Monad.IO.Class

import Foreign.C.Types

foreign import ccall c_timeBeginPeriod :: CUInt -> IO ()
foreign import ccall c_timeEndPeriod :: CUInt -> IO ()

withTimePeriod :: MonadCatchIO m => CUInt -> m a -> m a
withTimePeriod n cmd =
    bracket (liftIO $ c_timeBeginPeriod n) (const $ liftIO $ c_timeEndPeriod n) (const $ cmd)

    
#else


import Control.Monad.CatchIO

import Foreign.C.Types

withTimePeriod :: MonadCatchIO m => CUInt -> m a -> m a
withTimePeriod _ = id


#endif
