(**************************************************************************)
(*                                                                        *)
(*  This file is part of Frama-C.                                         *)
(*                                                                        *)
(*  Copyright (C) 2007-2019                                               *)
(*    CEA (Commissariat à l'énergie atomique et aux énergies              *)
(*         alternatives)                                                  *)
(*                                                                        *)
(*  you can redistribute it and/or modify it under the terms of the GNU   *)
(*  Lesser General Public License as published by the Free Software       *)
(*  Foundation, version 2.1.                                              *)
(*                                                                        *)
(*  It is distributed in the hope that it will be useful,                 *)
(*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *)
(*  GNU Lesser General Public License for more details.                   *)
(*                                                                        *)
(*  See the GNU Lesser General Public License version 2.1                 *)
(*  for more details (enclosed in the file licenses/LGPLv2.1).            *)
(*                                                                        *)
(**************************************************************************)

include Abstract_value.Leaf

val pretty_debug : t Pretty_utils.formatter

(** Reduction of an error value according to a floating-point interval. *)
val reduce: Fval.t -> t -> t Eval.or_bottom

val set_absolute_to_top : t -> t
val set_relative_to_top : t -> t

(** Returns the abstraction corresponding to the join of the approximation of
    the inputs. The real is set to the same abstraction and the errors are set
    to zero. *)
val dbetween : t -> t -> t Eval.or_bottom

(** Returns the abstraction corresponding to the join of the approximation of
    the inputs. The real is set to the same abstraction but for this function,
    we consider that the approximation is generated by rounding the exact and so
    the errors are set to the maximal error bounds for the real abstration. *)
val rbetween : t -> t -> t Eval.or_bottom

val of_ints : prec:Numerors_utils.Precisions.t -> int -> int -> t

val sqrt : t -> t Eval.or_bottom

val log : t -> t Eval.or_bottom
val exp : t -> t Eval.or_bottom

val get_max_absolute_error : t -> Numerors_float.t option
val get_max_relative_error : t -> Numerors_float.t option
