/*
 * FCML - Free Code Manipulation Library.
 * Copyright (C) 2010-2017 Slawomir Wojtasiak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>

#include "fcml_dialect_int.h"
#include "fcml_intel_dialect.h"
#include "fcml_mnemonic_parser.h"
#include "fcml_env_int.h"
#include "fcml_coll.h"
#include "fcml_intel_rend.h"
#include "fcml_intel_parser.h"
#include "fcml_common_dialect.h"

/* **************/
/* * MNEMONICS **/
/* **************/

fcml_st_dialect_mnemonic fcml_arr_dialect_intel_mnemonics[] = {
    { FCML_TEXT("aaa"), FCML_ASM_DIALECT_INSTRUCTION( F_AAA, FCML_AM_ALL ), 0 },
    { FCML_TEXT("aad"), FCML_ASM_DIALECT_INSTRUCTION( F_AAD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("aam"), FCML_ASM_DIALECT_INSTRUCTION( F_AAM, FCML_AM_ALL ), 0 },
    { FCML_TEXT("aas"), FCML_ASM_DIALECT_INSTRUCTION( F_AAS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("adc"), FCML_ASM_DIALECT_INSTRUCTION( F_ADC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("add"), FCML_ASM_DIALECT_INSTRUCTION( F_ADD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("addpd"), FCML_ASM_DIALECT_INSTRUCTION( F_ADDPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vaddpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VADDPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("addps"), FCML_ASM_DIALECT_INSTRUCTION( F_ADDPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vaddps"), FCML_ASM_DIALECT_INSTRUCTION( F_VADDPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("addsd"), FCML_ASM_DIALECT_INSTRUCTION( F_ADDSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vaddsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VADDSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("addss"), FCML_ASM_DIALECT_INSTRUCTION( F_ADDSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vaddss"), FCML_ASM_DIALECT_INSTRUCTION( F_VADDSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("addsubpd"), FCML_ASM_DIALECT_INSTRUCTION( F_ADDSUBPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vaddsubpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VADDSUBPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("addsubps"), FCML_ASM_DIALECT_INSTRUCTION( F_ADDSUBPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vaddsubps"), FCML_ASM_DIALECT_INSTRUCTION( F_VADDSUBPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("aesdec"), FCML_ASM_DIALECT_INSTRUCTION( F_AESDEC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vaesdec"), FCML_ASM_DIALECT_INSTRUCTION( F_VAESDEC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("aesdeclast"), FCML_ASM_DIALECT_INSTRUCTION( F_AESDECLAST, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vaesdeclast"), FCML_ASM_DIALECT_INSTRUCTION( F_VAESDECLAST, FCML_AM_ALL ), 0 },
    { FCML_TEXT("aesenc"), FCML_ASM_DIALECT_INSTRUCTION( F_AESENC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vaesenc"), FCML_ASM_DIALECT_INSTRUCTION( F_VAESENC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("aesenclast"), FCML_ASM_DIALECT_INSTRUCTION( F_AESENCLAST, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vaesenclast"), FCML_ASM_DIALECT_INSTRUCTION( F_VAESENCLAST, FCML_AM_ALL ), 0 },
    { FCML_TEXT("aesimc"), FCML_ASM_DIALECT_INSTRUCTION( F_AESIMC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vaesimc"), FCML_ASM_DIALECT_INSTRUCTION( F_VAESIMC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("aeskeygenassist"), FCML_ASM_DIALECT_INSTRUCTION( F_AESKEYGENASSIST, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vaeskeygenassist"), FCML_ASM_DIALECT_INSTRUCTION( F_VAESKEYGENASSIST, FCML_AM_ALL ), 0 },
    { FCML_TEXT("and"), FCML_ASM_DIALECT_INSTRUCTION( F_AND, FCML_AM_ALL ), 0 },
    { FCML_TEXT("andpd"), FCML_ASM_DIALECT_INSTRUCTION( F_ANDPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vandpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VANDPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("andps"), FCML_ASM_DIALECT_INSTRUCTION( F_ANDPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vandps"), FCML_ASM_DIALECT_INSTRUCTION( F_VANDPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("andnpd"), FCML_ASM_DIALECT_INSTRUCTION( F_ANDNPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vandnpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VANDNPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("andnps"), FCML_ASM_DIALECT_INSTRUCTION( F_ANDNPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vandnps"), FCML_ASM_DIALECT_INSTRUCTION( F_VANDNPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("arpl"), FCML_ASM_DIALECT_INSTRUCTION( F_ARPL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("andn"), FCML_ASM_DIALECT_INSTRUCTION( F_ANDN, FCML_AM_ALL ), 0 },
    { FCML_TEXT("adcx"), FCML_ASM_DIALECT_INSTRUCTION( F_ADCX, FCML_AM_ALL ), 0 },
    { FCML_TEXT("adox"), FCML_ASM_DIALECT_INSTRUCTION( F_ADOX, FCML_AM_ALL ), 0 },
    { FCML_TEXT("blendpd"), FCML_ASM_DIALECT_INSTRUCTION( F_BLENDPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vblendpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VBLENDPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("blendps"), FCML_ASM_DIALECT_INSTRUCTION( F_BLENDPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vblendps"), FCML_ASM_DIALECT_INSTRUCTION( F_VBLENDPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("blendvpd"), FCML_ASM_DIALECT_INSTRUCTION( F_BLENDVPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vblendvpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VBLENDVPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("blendvps"), FCML_ASM_DIALECT_INSTRUCTION( F_BLENDVPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vblendvps"), FCML_ASM_DIALECT_INSTRUCTION( F_VBLENDVPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("bound"), FCML_ASM_DIALECT_INSTRUCTION( F_BOUND, FCML_AM_ALL ), 0 },
    { FCML_TEXT("bsf"), FCML_ASM_DIALECT_INSTRUCTION( F_BSF, FCML_AM_ALL ), 0 },
    { FCML_TEXT("bsr"), FCML_ASM_DIALECT_INSTRUCTION( F_BSR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("bswap"), FCML_ASM_DIALECT_INSTRUCTION( F_BSWAP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("bt"), FCML_ASM_DIALECT_INSTRUCTION( F_BT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("btc"), FCML_ASM_DIALECT_INSTRUCTION( F_BTC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("btr"), FCML_ASM_DIALECT_INSTRUCTION( F_BTR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("bts"), FCML_ASM_DIALECT_INSTRUCTION( F_BTS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("bexr;bextr"), FCML_ASM_DIALECT_INSTRUCTION( F_BEXR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("blcfill"), FCML_ASM_DIALECT_INSTRUCTION( F_BLCFILL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("blci"), FCML_ASM_DIALECT_INSTRUCTION( F_BLCI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("blcic"), FCML_ASM_DIALECT_INSTRUCTION( F_BLCIC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("blcmsk"), FCML_ASM_DIALECT_INSTRUCTION( F_BLCMSK, FCML_AM_ALL ), 0 },
    { FCML_TEXT("blcs"), FCML_ASM_DIALECT_INSTRUCTION( F_BLCS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("blsfill"), FCML_ASM_DIALECT_INSTRUCTION( F_BLSFILL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("blsi"), FCML_ASM_DIALECT_INSTRUCTION( F_BLSI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("blsic"), FCML_ASM_DIALECT_INSTRUCTION( F_BLSIC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("blsmsk"), FCML_ASM_DIALECT_INSTRUCTION( F_BLSMSK, FCML_AM_ALL ), 0 },
    { FCML_TEXT("blsr"), FCML_ASM_DIALECT_INSTRUCTION( F_BLSR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("bzhi"), FCML_ASM_DIALECT_INSTRUCTION( F_BZHI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("call"), FCML_ASM_DIALECT_INSTRUCTION( F_CALL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cbw[ow];cwde[od];cdqe[oq]"), FCML_ASM_DIALECT_INSTRUCTION( F_CBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("clc"), FCML_ASM_DIALECT_INSTRUCTION( F_CLC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cld"), FCML_ASM_DIALECT_INSTRUCTION( F_CLD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("clflush"), FCML_ASM_DIALECT_INSTRUCTION( F_CLFLUSH, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cli"), FCML_ASM_DIALECT_INSTRUCTION( F_CLI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("clgi"), FCML_ASM_DIALECT_INSTRUCTION( F_CLGI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("clts"), FCML_ASM_DIALECT_INSTRUCTION( F_CLTS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cmc"), FCML_ASM_DIALECT_INSTRUCTION( F_CMC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cmov"), FCML_ASM_DIALECT_INSTRUCTION( F_CMOV, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cmp"), FCML_ASM_DIALECT_INSTRUCTION( F_CMP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cmppd;cmpeqpd[p00];cmpltpd[p01];cmplepd[p02];cmpunordpd[p03];cmpneqpd[p04];cmpnltpd[p05];cmpnlepd[p06];cmpordpd[p07]"), FCML_ASM_DIALECT_INSTRUCTION( F_CMPPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcmppd;vcmpeqpd[p00];vcmpltpd[p01];vcmplepd[p02];vcmpunordpd[p03];vcmpneqpd[p04];vcmpnltpd[p05];vcmpnlepd[p06];vcmpordpd[p07];vcmpeq_uqpd[p08];vcmpngepd[p09];vcmpngtpd[p0a];vcmpfalsepd[p0b];vcmpneq_oqpd[p0c];vcmpgepd[p0d];vcmpgtpd[p0e];vcmptruepd[p0f];vcmpeq_ospd[p10];vcmplt_oqpd[p11];vcmple_oqpd[p12];vcmpunord_spd[p13];vcmpneq_uspd[p14];vcmpnlt_uqpd[p15];vcmpnle_uqpd[p16];vcmpord_spd[p17];vcmpeq_uspd[p18];vcmpnge_uqpd[p19];vcmpngt_uqpd[p1a];vcmpfalse_ospd[p1b];vcmpneq_ospd[p1c];vcmpge_oqpd[p1d];vcmpgt_oqpd[p1e];vcmptrue_uspd[p1f]"), FCML_ASM_DIALECT_INSTRUCTION( F_VCMPPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cmpps;cmpeqps[p00];cmpltps[p01];cmpleps[p02];cmpunordps[p03];cmpneqps[p04];cmpnltps[p05];cmpnleps[p06];cmpordps[p07]"), FCML_ASM_DIALECT_INSTRUCTION( F_CMPPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcmpps;vcmpeqps[p00];vcmpltps[p01];vcmpleps[p02];vcmpunordps[p03];vcmpneqps[p04];vcmpnltps[p05];vcmpnleps[p06];vcmpordps[p07];vcmpeq_uqps[p08];vcmpngeps[p09];vcmpngtps[p0a];vcmpfalseps[p0b];vcmpneq_oqps[p0c];vcmpgeps[p0d];vcmpgtps[p0e];vcmptrueps[p0f];vcmpeq_osps[p10];vcmplt_oqps[p11];vcmple_oqps[p12];vcmpunord_sps[p13];vcmpneq_usps[p14];vcmpnlt_uqps[p15];vcmpnle_uqps[p16];vcmpord_sps[p17];vcmpeq_usps[p18];vcmpnge_uqps[p19];vcmpngt_uqps[p1a];vcmpfalse_osps[p1b];vcmpneq_osps[p1c];vcmpge_oqps[p1d];vcmpgt_oqps[p1e];vcmptrue_usps[p1f]"), FCML_ASM_DIALECT_INSTRUCTION( F_VCMPPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cmps;cmpsb[ts]"), FCML_ASM_DIALECT_INSTRUCTION( F_CMPS, FCML_AM_M8_M8 ), 0 },
    { FCML_TEXT("cmps;cmpsw[ts,ow,a*];cmpsd[ts,od,a*];cmpsq[ts,oq,a*]"), FCML_ASM_DIALECT_INSTRUCTION( F_CMPS, FCML_AM_MO_MO ), 0 },
    { FCML_TEXT("cmpsd;cmpeqsd[p00];cmpltsd[p01];cmplesd[p02];cmpunordsd[p03];cmpneqsd[p04];cmpnltsd[p05];cmpnlesd[p06];cmpordsd[p07]"), FCML_ASM_DIALECT_INSTRUCTION( F_CMPSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcmpsd;vcmpeqsd[p00];vcmpltsd[p01];vcmplesd[p02];vcmpunordsd[p03];vcmpneqsd[p04];vcmpnltsd[p05];vcmpnlesd[p06];vcmpordsd[p07];vcmpeq_uqsd[p08];vcmpngesd[p09];vcmpngtsd[p0a];vcmpfalsesd[p0b];vcmpneq_oqsd[p0c];vcmpgesd[p0d];vcmpgtsd[p0e];vcmptruesd[p0f];vcmpeq_ossd[p10];vcmplt_oqsd[p11];vcmple_oqsd[p12];vcmpunord_ssd[p13];vcmpneq_ussd[p14];vcmpnlt_uqsd[p15];vcmpnle_uqsd[p16];vcmpord_ssd[p17];vcmpeq_ussd[p18];vcmpnge_uqsd[p19];vcmpngt_uqsd[p1a];vcmpfalse_ossd[p1b];vcmpneq_ossd[p1c];vcmpge_oqsd[p1d];vcmpgt_oqsd[p1e];vcmptrue_ussd[p1f]"), FCML_ASM_DIALECT_INSTRUCTION( F_VCMPSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cmpss;cmpeqss[p00];cmpltss[p01];cmpless[p02];cmpunordss[p03];cmpneqss[p04];cmpnltss[p05];cmpnless[p06];cmpordss[p07]"), FCML_ASM_DIALECT_INSTRUCTION( F_CMPSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcmpss;vcmpeqss[p00];vcmpltss[p01];vcmpless[p02];vcmpunordss[p03];vcmpneqss[p04];vcmpnltss[p05];vcmpnless[p06];vcmpordss[p07];vcmpeq_uqss[p08];vcmpngess[p09];vcmpngtss[p0a];vcmpfalsess[p0b];vcmpneq_oqss[p0c];vcmpgess[p0d];vcmpgtss[p0e];vcmptruess[p0f];vcmpeq_osss[p10];vcmplt_oqss[p11];vcmple_oqss[p12];vcmpunord_sss[p13];vcmpneq_usss[p14];vcmpnlt_uqss[p15];vcmpnle_uqss[p16];vcmpord_sss[p17];vcmpeq_usss[p18];vcmpnge_uqss[p19];vcmpngt_uqss[p1a];vcmpfalse_osss[p1b];vcmpneq_osss[p1c];vcmpge_oqss[p1d];vcmpgt_oqss[p1e];vcmptrue_usss[p1f]"), FCML_ASM_DIALECT_INSTRUCTION( F_VCMPSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cmpxchg"), FCML_ASM_DIALECT_INSTRUCTION( F_CMPXCHG, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cmpxchg8b"), FCML_ASM_DIALECT_INSTRUCTION( F_CMPXCHGxB, FCML_AM_M64 ), 0 },
    { FCML_TEXT("cmpxchg16b"), FCML_ASM_DIALECT_INSTRUCTION( F_CMPXCHGxB, FCML_AM_M128 ), 0 },
    { FCML_TEXT("cpuid"), FCML_ASM_DIALECT_INSTRUCTION( F_CPUID, FCML_AM_ALL ), 0 },
    { FCML_TEXT("crc32"), FCML_ASM_DIALECT_INSTRUCTION( F_CRC32, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtdq2pd"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTDQ2PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvtdq2pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTDQ2PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtdq2ps"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTDQ2PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvtdq2ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTDQ2PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtpd2dq"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTPD2DQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvtpd2dq"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTPD2DQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtpd2pi"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTPD2PI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtpd2ps"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTPD2PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvtpd2ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTPD2PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtpi2pd"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTPI2PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtpi2ps"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTPI2PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtps2dq"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTPS2DQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvtps2dq"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTPS2DQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtps2pd"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTPS2PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvtps2pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTPS2PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtps2pi"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTPS2PI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtsd2si"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTSD2SI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvtsd2si"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTSD2SI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtsd2ss"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTSD2SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvtsd2ss"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTSD2SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtsi2sd"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTSI2SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvtsi2sd"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTSI2SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtsi2ss"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTSI2SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvtsi2ss"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTSI2SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtss2sd"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTSS2SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvtss2sd"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTSS2SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvtss2si"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTSS2SI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvtss2si"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTSS2SI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvttpd2dq"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTTPD2DQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvttpd2dq"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTTPD2DQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvttpd2pi"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTTPD2PI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvttps2dq"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTTPS2DQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvttps2dq"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTTPS2DQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvttps2pi"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTTPS2PI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvttsd2si"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTTSD2SI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvttsd2si"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTTSD2SI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cvttss2si"), FCML_ASM_DIALECT_INSTRUCTION( F_CVTTSS2SI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvttss2si"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTTSS2SI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("cwd[ow];cdq[od];cqo[oq]"), FCML_ASM_DIALECT_INSTRUCTION( F_CWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("comisd"), FCML_ASM_DIALECT_INSTRUCTION( F_COMISD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcomisd"), FCML_ASM_DIALECT_INSTRUCTION( F_VCOMISD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("comiss"), FCML_ASM_DIALECT_INSTRUCTION( F_COMISS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcomiss"), FCML_ASM_DIALECT_INSTRUCTION( F_VCOMISS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("daa"), FCML_ASM_DIALECT_INSTRUCTION( F_DAA, FCML_AM_ALL ), 0 },
    { FCML_TEXT("das"), FCML_ASM_DIALECT_INSTRUCTION( F_DAS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("dec"), FCML_ASM_DIALECT_INSTRUCTION( F_DEC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("div"), FCML_ASM_DIALECT_INSTRUCTION( F_DIV, FCML_AM_ALL ), 0 },
    { FCML_TEXT("divpd"), FCML_ASM_DIALECT_INSTRUCTION( F_DIVPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vdivpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VDIVPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("divps"), FCML_ASM_DIALECT_INSTRUCTION( F_DIVPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vdivps"), FCML_ASM_DIALECT_INSTRUCTION( F_VDIVPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("divsd"), FCML_ASM_DIALECT_INSTRUCTION( F_DIVSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vdivsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VDIVSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("divss"), FCML_ASM_DIALECT_INSTRUCTION( F_DIVSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vdivss"), FCML_ASM_DIALECT_INSTRUCTION( F_VDIVSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("dppd"), FCML_ASM_DIALECT_INSTRUCTION( F_DPPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vdppd"), FCML_ASM_DIALECT_INSTRUCTION( F_VDPPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("dpps"), FCML_ASM_DIALECT_INSTRUCTION( F_DPPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vdpps"), FCML_ASM_DIALECT_INSTRUCTION( F_VDPPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("emms"), FCML_ASM_DIALECT_INSTRUCTION( F_EMMS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("enter"), FCML_ASM_DIALECT_INSTRUCTION( F_ENTER, FCML_AM_ALL ), 0 },
    { FCML_TEXT("extractps"), FCML_ASM_DIALECT_INSTRUCTION( F_EXTRACTPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vextractps"), FCML_ASM_DIALECT_INSTRUCTION( F_VEXTRACTPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("extrq"), FCML_ASM_DIALECT_INSTRUCTION( F_EXTRQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("f2xm1"), FCML_ASM_DIALECT_INSTRUCTION( F_F2XM1, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fabs"), FCML_ASM_DIALECT_INSTRUCTION( F_FABS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fadd"), FCML_ASM_DIALECT_INSTRUCTION( F_FADD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fiadd"), FCML_ASM_DIALECT_INSTRUCTION( F_FIADD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("faddp"), FCML_ASM_DIALECT_INSTRUCTION( F_FADDP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fbld"), FCML_ASM_DIALECT_INSTRUCTION( F_FBLD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fbstp"), FCML_ASM_DIALECT_INSTRUCTION( F_FBSTP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fchs"), FCML_ASM_DIALECT_INSTRUCTION( F_FCHS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fclex"), FCML_ASM_DIALECT_INSTRUCTION( F_FCLEX, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fnclex"), FCML_ASM_DIALECT_INSTRUCTION( F_FNCLEX, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fcmovb"), FCML_ASM_DIALECT_INSTRUCTION( F_FCMOVB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fcmove"), FCML_ASM_DIALECT_INSTRUCTION( F_FCMOVE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fcmovbe"), FCML_ASM_DIALECT_INSTRUCTION( F_FCMOVBE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fcmovu"), FCML_ASM_DIALECT_INSTRUCTION( F_FCMOVU, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fcmovnb"), FCML_ASM_DIALECT_INSTRUCTION( F_FCMOVNB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fcmovne"), FCML_ASM_DIALECT_INSTRUCTION( F_FCMOVNE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fcmovnbe"), FCML_ASM_DIALECT_INSTRUCTION( F_FCMOVNBE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fcmovnu"), FCML_ASM_DIALECT_INSTRUCTION( F_FCMOVNU, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fcos"), FCML_ASM_DIALECT_INSTRUCTION( F_FCOS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fcom"), FCML_ASM_DIALECT_INSTRUCTION( F_FCOM, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fcomp"), FCML_ASM_DIALECT_INSTRUCTION( F_FCOMP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fcompp"), FCML_ASM_DIALECT_INSTRUCTION( F_FCOMPP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fcomi"), FCML_ASM_DIALECT_INSTRUCTION( F_FCOMI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fcomip"), FCML_ASM_DIALECT_INSTRUCTION( F_FCOMIP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fucomi"), FCML_ASM_DIALECT_INSTRUCTION( F_FUCOMI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fucomip"), FCML_ASM_DIALECT_INSTRUCTION( F_FUCOMIP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fdecstp"), FCML_ASM_DIALECT_INSTRUCTION( F_FDECSTP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fdiv"), FCML_ASM_DIALECT_INSTRUCTION( F_FDIV, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fdivp"), FCML_ASM_DIALECT_INSTRUCTION( F_FDIVP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fidiv"), FCML_ASM_DIALECT_INSTRUCTION( F_FIDIV, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fdivr"), FCML_ASM_DIALECT_INSTRUCTION( F_FDIVR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fdivrp"), FCML_ASM_DIALECT_INSTRUCTION( F_FDIVRP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fidivr"), FCML_ASM_DIALECT_INSTRUCTION( F_FIDIVR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("ffree"), FCML_ASM_DIALECT_INSTRUCTION( F_FFREE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("ficom"), FCML_ASM_DIALECT_INSTRUCTION( F_FICOM, FCML_AM_ALL ), 0 },
    { FCML_TEXT("ficomp"), FCML_ASM_DIALECT_INSTRUCTION( F_FICOMP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fild"), FCML_ASM_DIALECT_INSTRUCTION( F_FILD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fincstp"), FCML_ASM_DIALECT_INSTRUCTION( F_FINCSTP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("finit"), FCML_ASM_DIALECT_INSTRUCTION( F_FINIT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fninit"), FCML_ASM_DIALECT_INSTRUCTION( F_FNINIT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fist"), FCML_ASM_DIALECT_INSTRUCTION( F_FIST, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fistp"), FCML_ASM_DIALECT_INSTRUCTION( F_FISTP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fld"), FCML_ASM_DIALECT_INSTRUCTION( F_FLD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fld1"), FCML_ASM_DIALECT_INSTRUCTION( F_FLD1, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fldl2t"), FCML_ASM_DIALECT_INSTRUCTION( F_FLDL2T, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fldl2e"), FCML_ASM_DIALECT_INSTRUCTION( F_FLDL2E, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fldpi"), FCML_ASM_DIALECT_INSTRUCTION( F_FLDPI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fldlg2"), FCML_ASM_DIALECT_INSTRUCTION( F_FLDLG2, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fldln2"), FCML_ASM_DIALECT_INSTRUCTION( F_FLDLN2, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fldz"), FCML_ASM_DIALECT_INSTRUCTION( F_FLDZ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fldcw"), FCML_ASM_DIALECT_INSTRUCTION( F_FLDCW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fldenv"), FCML_ASM_DIALECT_INSTRUCTION( F_FLDENV, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fmul"), FCML_ASM_DIALECT_INSTRUCTION( F_FMUL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fmulp"), FCML_ASM_DIALECT_INSTRUCTION( F_FMULP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fimul"), FCML_ASM_DIALECT_INSTRUCTION( F_FIMUL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fnop"), FCML_ASM_DIALECT_INSTRUCTION( F_FNOP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fpatan"), FCML_ASM_DIALECT_INSTRUCTION( F_FPATAN, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fprem"), FCML_ASM_DIALECT_INSTRUCTION( F_FPREM, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fprem1"), FCML_ASM_DIALECT_INSTRUCTION( F_FPREM1, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fptan"), FCML_ASM_DIALECT_INSTRUCTION( F_FPTAN, FCML_AM_ALL ), 0 },
    { FCML_TEXT("frndint"), FCML_ASM_DIALECT_INSTRUCTION( F_FRNDINT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("frstor"), FCML_ASM_DIALECT_INSTRUCTION( F_FRSTOR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fsave"), FCML_ASM_DIALECT_INSTRUCTION( F_FSAVE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fnsave"), FCML_ASM_DIALECT_INSTRUCTION( F_FNSAVE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fscale"), FCML_ASM_DIALECT_INSTRUCTION( F_FSCALE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fsin"), FCML_ASM_DIALECT_INSTRUCTION( F_FSIN, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fsincos"), FCML_ASM_DIALECT_INSTRUCTION( F_FSINCOS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fsqrt"), FCML_ASM_DIALECT_INSTRUCTION( F_FSQRT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fst"), FCML_ASM_DIALECT_INSTRUCTION( F_FST, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fstp"), FCML_ASM_DIALECT_INSTRUCTION( F_FSTP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fstcw"), FCML_ASM_DIALECT_INSTRUCTION( F_FSTCW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fnstcw"), FCML_ASM_DIALECT_INSTRUCTION( F_FNSTCW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fstenv"), FCML_ASM_DIALECT_INSTRUCTION( F_FSTENV, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fnstenv"), FCML_ASM_DIALECT_INSTRUCTION( F_FNSTENV, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fstsw"), FCML_ASM_DIALECT_INSTRUCTION( F_FSTSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fnstsw"), FCML_ASM_DIALECT_INSTRUCTION( F_FNSTSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fsub"), FCML_ASM_DIALECT_INSTRUCTION( F_FSUB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fsubp"), FCML_ASM_DIALECT_INSTRUCTION( F_FSUBP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fisub"), FCML_ASM_DIALECT_INSTRUCTION( F_FISUB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fsubr"), FCML_ASM_DIALECT_INSTRUCTION( F_FSUBR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fsubrp"), FCML_ASM_DIALECT_INSTRUCTION( F_FSUBRP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fisubr"), FCML_ASM_DIALECT_INSTRUCTION( F_FISUBR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("ftst"), FCML_ASM_DIALECT_INSTRUCTION( F_FTST, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fucom"), FCML_ASM_DIALECT_INSTRUCTION( F_FUCOM, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fucomp"), FCML_ASM_DIALECT_INSTRUCTION( F_FUCOMP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fucompp"), FCML_ASM_DIALECT_INSTRUCTION( F_FUCOMPP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fxam"), FCML_ASM_DIALECT_INSTRUCTION( F_FXAM, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fxch"), FCML_ASM_DIALECT_INSTRUCTION( F_FXCH, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fxrstor"), FCML_ASM_DIALECT_INSTRUCTION( F_FXRSTOR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fxrstor64"), FCML_ASM_DIALECT_INSTRUCTION( F_FXRSTOR64, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fxsave"), FCML_ASM_DIALECT_INSTRUCTION( F_FXSAVE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fxsave64"), FCML_ASM_DIALECT_INSTRUCTION( F_FXSAVE64, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fxtract"), FCML_ASM_DIALECT_INSTRUCTION( F_FXTRACT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fyl2x"), FCML_ASM_DIALECT_INSTRUCTION( F_FYL2X, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fyl2xp1"), FCML_ASM_DIALECT_INSTRUCTION( F_FYL2XP1, FCML_AM_ALL ), 0 },
    { FCML_TEXT("femms"), FCML_ASM_DIALECT_INSTRUCTION( F_FEMMS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("fisttp"), FCML_ASM_DIALECT_INSTRUCTION( F_FISTTP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("getsec"), FCML_ASM_DIALECT_INSTRUCTION( F_GETSEC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("haddpd"), FCML_ASM_DIALECT_INSTRUCTION( F_HADDPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vhaddpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VHADDPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("haddps"), FCML_ASM_DIALECT_INSTRUCTION( F_HADDPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vhaddps"), FCML_ASM_DIALECT_INSTRUCTION( F_VHADDPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("hlt"), FCML_ASM_DIALECT_INSTRUCTION( F_HLT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("hsubpd"), FCML_ASM_DIALECT_INSTRUCTION( F_HSUBPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vhsubpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VHSUBPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("hsubps"), FCML_ASM_DIALECT_INSTRUCTION( F_HSUBPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vhsubps"), FCML_ASM_DIALECT_INSTRUCTION( F_VHSUBPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("invept"), FCML_ASM_DIALECT_INSTRUCTION( F_INVEPT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("invvpid"), FCML_ASM_DIALECT_INSTRUCTION( F_INVVPID, FCML_AM_ALL ), 0 },
    { FCML_TEXT("idiv"), FCML_ASM_DIALECT_INSTRUCTION( F_IDIV, FCML_AM_ALL ), 0 },
    { FCML_TEXT("imul"), FCML_ASM_DIALECT_INSTRUCTION( F_IMUL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("in"), FCML_ASM_DIALECT_INSTRUCTION( F_IN, FCML_AM_ALL ), 0 },
    { FCML_TEXT("inc"), FCML_ASM_DIALECT_INSTRUCTION( F_INC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("ins;insb[ts]"), FCML_ASM_DIALECT_INSTRUCTION( F_INS, FCML_AM_M8 ), 0 },
    { FCML_TEXT("ins;insw[ts]"), FCML_ASM_DIALECT_INSTRUCTION( F_INS, FCML_AM_M16 ), 0 },
    { FCML_TEXT("ins;insd[ts]"), FCML_ASM_DIALECT_INSTRUCTION( F_INS, FCML_AM_M32 ), 0 },
    { FCML_TEXT("insertps"), FCML_ASM_DIALECT_INSTRUCTION( F_INSERTPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vinsertps"), FCML_ASM_DIALECT_INSTRUCTION( F_VINSERTPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vextractf128"), FCML_ASM_DIALECT_INSTRUCTION( F_VEXTRACTF128, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vextractf32x4"), FCML_ASM_DIALECT_INSTRUCTION(F_VEXTRACTF32X4, FCML_AM_ALL), 0 },
    { FCML_TEXT("vextractf64x2"), FCML_ASM_DIALECT_INSTRUCTION(F_VEXTRACTF64X2, FCML_AM_ALL), 0 },
    { FCML_TEXT("vextractf32x8"), FCML_ASM_DIALECT_INSTRUCTION(F_VEXTRACTF32X8, FCML_AM_ALL), 0 },
    { FCML_TEXT("vextractf64x4"), FCML_ASM_DIALECT_INSTRUCTION(F_VEXTRACTF64X4, FCML_AM_ALL), 0 },
    { FCML_TEXT("vextracti32x4"), FCML_ASM_DIALECT_INSTRUCTION(F_VEXTRACTI32X4, FCML_AM_ALL), 0 },
    { FCML_TEXT("vextracti64x2"), FCML_ASM_DIALECT_INSTRUCTION(F_VEXTRACTI64X2, FCML_AM_ALL), 0 },
    { FCML_TEXT("vextracti32x8"), FCML_ASM_DIALECT_INSTRUCTION(F_VEXTRACTI32X8, FCML_AM_ALL), 0 },
    { FCML_TEXT("vextracti64x4"), FCML_ASM_DIALECT_INSTRUCTION(F_VEXTRACTI64X4, FCML_AM_ALL), 0 },
    { FCML_TEXT("vinsertf128"), FCML_ASM_DIALECT_INSTRUCTION( F_VINSERTF128, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfixupimmpd"), FCML_ASM_DIALECT_INSTRUCTION(F_VFIXUPIMMPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vfixupimmps"), FCML_ASM_DIALECT_INSTRUCTION(F_VFIXUPIMMPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vfixupimmsd"), FCML_ASM_DIALECT_INSTRUCTION(F_VFIXUPIMMSD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vfixupimmss"), FCML_ASM_DIALECT_INSTRUCTION(F_VFIXUPIMMSS, FCML_AM_ALL), 0 },
    { FCML_TEXT("insertq"), FCML_ASM_DIALECT_INSTRUCTION( F_INSERTQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("int3"), FCML_ASM_DIALECT_INSTRUCTION( F_INT3, FCML_AM_ALL ), 0 },
    { FCML_TEXT("int"), FCML_ASM_DIALECT_INSTRUCTION( F_INT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("into"), FCML_ASM_DIALECT_INSTRUCTION( F_INTO, FCML_AM_ALL ), 0 },
    { FCML_TEXT("invd"), FCML_ASM_DIALECT_INSTRUCTION( F_INVD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("invlpg"), FCML_ASM_DIALECT_INSTRUCTION( F_INVLPG, FCML_AM_ALL ), 0 },
    { FCML_TEXT("invlpga"), FCML_ASM_DIALECT_INSTRUCTION( F_INVLPGA, FCML_AM_ALL ), 0 },
    { FCML_TEXT("invpcid"), FCML_ASM_DIALECT_INSTRUCTION( F_INVPCID, FCML_AM_ALL ), 0 },
    { FCML_TEXT("iret[sf,ow];iretd[sf,od];iretq[sf,oq]"), FCML_ASM_DIALECT_INSTRUCTION( F_IRET, FCML_AM_ALL ), 0 },
    { FCML_TEXT("jcxz[aw];jecxz[ad];jrcxz[aq]"), FCML_ASM_DIALECT_INSTRUCTION( F_JCXZ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("j"), FCML_ASM_DIALECT_INSTRUCTION( F_JCC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("jmp"), FCML_ASM_DIALECT_INSTRUCTION( F_JMP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("kaddb"), FCML_ASM_DIALECT_INSTRUCTION(F_KADDB, FCML_AM_ALL), 0 },
    { FCML_TEXT("kaddw"), FCML_ASM_DIALECT_INSTRUCTION(F_KADDW, FCML_AM_ALL), 0 },
    { FCML_TEXT("kaddd"), FCML_ASM_DIALECT_INSTRUCTION(F_KADDD, FCML_AM_ALL), 0 },
    { FCML_TEXT("kaddq"), FCML_ASM_DIALECT_INSTRUCTION(F_KADDQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("kandb"), FCML_ASM_DIALECT_INSTRUCTION(F_KANDB, FCML_AM_ALL), 0 },
    { FCML_TEXT("kandw"), FCML_ASM_DIALECT_INSTRUCTION(F_KANDW, FCML_AM_ALL), 0 },
    { FCML_TEXT("kandd"), FCML_ASM_DIALECT_INSTRUCTION(F_KANDD, FCML_AM_ALL), 0 },
    { FCML_TEXT("kandq"), FCML_ASM_DIALECT_INSTRUCTION(F_KANDQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("kandnb"), FCML_ASM_DIALECT_INSTRUCTION(F_KANDNB, FCML_AM_ALL), 0 },
    { FCML_TEXT("kandnw"), FCML_ASM_DIALECT_INSTRUCTION(F_KANDNW, FCML_AM_ALL), 0 },
    { FCML_TEXT("kandnd"), FCML_ASM_DIALECT_INSTRUCTION(F_KANDND, FCML_AM_ALL), 0 },
    { FCML_TEXT("kandnq"), FCML_ASM_DIALECT_INSTRUCTION(F_KANDNQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("kmovb"), FCML_ASM_DIALECT_INSTRUCTION(F_KMOVB, FCML_AM_ALL), 0 },
    { FCML_TEXT("kmovw"), FCML_ASM_DIALECT_INSTRUCTION(F_KMOVW, FCML_AM_ALL), 0 },
    { FCML_TEXT("kmovd"), FCML_ASM_DIALECT_INSTRUCTION(F_KMOVD, FCML_AM_ALL), 0 },
    { FCML_TEXT("kmovq"), FCML_ASM_DIALECT_INSTRUCTION(F_KMOVQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("knotb"), FCML_ASM_DIALECT_INSTRUCTION(F_KNOTB, FCML_AM_ALL), 0 },
    { FCML_TEXT("knotw"), FCML_ASM_DIALECT_INSTRUCTION(F_KNOTW, FCML_AM_ALL), 0 },
    { FCML_TEXT("knotd"), FCML_ASM_DIALECT_INSTRUCTION(F_KNOTD, FCML_AM_ALL), 0 },
    { FCML_TEXT("knotq"), FCML_ASM_DIALECT_INSTRUCTION(F_KNOTQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("korb"), FCML_ASM_DIALECT_INSTRUCTION(F_KORB, FCML_AM_ALL), 0 },
    { FCML_TEXT("korw"), FCML_ASM_DIALECT_INSTRUCTION(F_KORW, FCML_AM_ALL), 0 },
    { FCML_TEXT("kord"), FCML_ASM_DIALECT_INSTRUCTION(F_KORD, FCML_AM_ALL), 0 },
    { FCML_TEXT("korq"), FCML_ASM_DIALECT_INSTRUCTION(F_KORQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("kortestb"), FCML_ASM_DIALECT_INSTRUCTION(F_KORTESTB, FCML_AM_ALL), 0 },
    { FCML_TEXT("kortestw"), FCML_ASM_DIALECT_INSTRUCTION(F_KORTESTW, FCML_AM_ALL), 0 },
    { FCML_TEXT("kortestd"), FCML_ASM_DIALECT_INSTRUCTION(F_KORTESTD, FCML_AM_ALL), 0 },
    { FCML_TEXT("kortestq"), FCML_ASM_DIALECT_INSTRUCTION(F_KORTESTQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("kshiftlb"), FCML_ASM_DIALECT_INSTRUCTION(F_KSHIFTLB, FCML_AM_ALL), 0 },
    { FCML_TEXT("kshiftlw"), FCML_ASM_DIALECT_INSTRUCTION(F_KSHIFTLW, FCML_AM_ALL), 0 },
    { FCML_TEXT("kshiftld"), FCML_ASM_DIALECT_INSTRUCTION(F_KSHIFTLD, FCML_AM_ALL), 0 },
    { FCML_TEXT("kshiftlq"), FCML_ASM_DIALECT_INSTRUCTION(F_KSHIFTLQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("kshiftrb"), FCML_ASM_DIALECT_INSTRUCTION(F_KSHIFTRB, FCML_AM_ALL), 0 },
    { FCML_TEXT("kshiftrw"), FCML_ASM_DIALECT_INSTRUCTION(F_KSHIFTRW, FCML_AM_ALL), 0 },
    { FCML_TEXT("kshiftrd"), FCML_ASM_DIALECT_INSTRUCTION(F_KSHIFTRD, FCML_AM_ALL), 0 },
    { FCML_TEXT("kshiftrq"), FCML_ASM_DIALECT_INSTRUCTION(F_KSHIFTRQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("ktestb"), FCML_ASM_DIALECT_INSTRUCTION(F_KTESTB, FCML_AM_ALL), 0 },
    { FCML_TEXT("ktestw"), FCML_ASM_DIALECT_INSTRUCTION(F_KTESTW, FCML_AM_ALL), 0 },
    { FCML_TEXT("ktestd"), FCML_ASM_DIALECT_INSTRUCTION(F_KTESTD, FCML_AM_ALL), 0 },
    { FCML_TEXT("ktestq"), FCML_ASM_DIALECT_INSTRUCTION(F_KTESTQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("kxnorb"), FCML_ASM_DIALECT_INSTRUCTION(F_KXNORB, FCML_AM_ALL), 0 },
    { FCML_TEXT("kxnorw"), FCML_ASM_DIALECT_INSTRUCTION(F_KXNORW, FCML_AM_ALL), 0 },
    { FCML_TEXT("kxnord"), FCML_ASM_DIALECT_INSTRUCTION(F_KXNORD, FCML_AM_ALL), 0 },
    { FCML_TEXT("kxnorq"), FCML_ASM_DIALECT_INSTRUCTION(F_KXNORQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("kxorb"), FCML_ASM_DIALECT_INSTRUCTION(F_KXORB, FCML_AM_ALL), 0 },
    { FCML_TEXT("kxorw"), FCML_ASM_DIALECT_INSTRUCTION(F_KXORW, FCML_AM_ALL), 0 },
    { FCML_TEXT("kxord"), FCML_ASM_DIALECT_INSTRUCTION(F_KXORD, FCML_AM_ALL), 0 },
    { FCML_TEXT("kxorq"), FCML_ASM_DIALECT_INSTRUCTION(F_KXORQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("lar"), FCML_ASM_DIALECT_INSTRUCTION( F_LAR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lahf"), FCML_ASM_DIALECT_INSTRUCTION( F_LAHF, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lddqu"), FCML_ASM_DIALECT_INSTRUCTION( F_LDDQU, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vlddqu"), FCML_ASM_DIALECT_INSTRUCTION( F_VLDDQU, FCML_AM_ALL ), 0 },
    { FCML_TEXT("ldmxcsr"), FCML_ASM_DIALECT_INSTRUCTION( F_LDMXCSR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vldmxcsr"), FCML_ASM_DIALECT_INSTRUCTION( F_VLDMXCSR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lds"), FCML_ASM_DIALECT_INSTRUCTION( F_LDS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lss"), FCML_ASM_DIALECT_INSTRUCTION( F_LSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("les"), FCML_ASM_DIALECT_INSTRUCTION( F_LES, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lfs"), FCML_ASM_DIALECT_INSTRUCTION( F_LFS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lgs"), FCML_ASM_DIALECT_INSTRUCTION( F_LGS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lea"), FCML_ASM_DIALECT_INSTRUCTION( F_LEA, FCML_AM_ALL ), 0 },
    { FCML_TEXT("leave"), FCML_ASM_DIALECT_INSTRUCTION( F_LEAVE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lfence"), FCML_ASM_DIALECT_INSTRUCTION( F_LFENCE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("llwpcb"), FCML_ASM_DIALECT_INSTRUCTION( F_LLWPCB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lgdt"), FCML_ASM_DIALECT_INSTRUCTION( F_LGDT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lidt"), FCML_ASM_DIALECT_INSTRUCTION( F_LIDT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lldt"), FCML_ASM_DIALECT_INSTRUCTION( F_LLDT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lmsw"), FCML_ASM_DIALECT_INSTRUCTION( F_LMSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lods;lodsb[ts]"), FCML_ASM_DIALECT_INSTRUCTION( F_LODS, FCML_AM_RM8 ), 0 },
    { FCML_TEXT("lods;lodsw[ts,ow,a*];lodsd[ts,od,a*];lodsq[ts,oq,a*]"), FCML_ASM_DIALECT_INSTRUCTION( F_LODS, FCML_AM_RMO ), 0 },
    { FCML_TEXT("loop"), FCML_ASM_DIALECT_INSTRUCTION( F_LOOP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("loope;loopz"), FCML_ASM_DIALECT_INSTRUCTION( F_LOOPE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("loopne;loopnz"), FCML_ASM_DIALECT_INSTRUCTION( F_LOOPNE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lwpins"), FCML_ASM_DIALECT_INSTRUCTION( F_LWPINS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lwpval"), FCML_ASM_DIALECT_INSTRUCTION( F_LWPVAL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lsl"), FCML_ASM_DIALECT_INSTRUCTION( F_LSL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("ltr"), FCML_ASM_DIALECT_INSTRUCTION( F_LTR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("lzcnt"), FCML_ASM_DIALECT_INSTRUCTION( F_LZCNT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("maskmovdqu"), FCML_ASM_DIALECT_INSTRUCTION( F_MASKMOVDQU, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmaskmovdqu"), FCML_ASM_DIALECT_INSTRUCTION( F_VMASKMOVDQU, FCML_AM_ALL ), 0 },
    { FCML_TEXT("maskmovq"), FCML_ASM_DIALECT_INSTRUCTION( F_MASKMOVQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmaskmovps"), FCML_ASM_DIALECT_INSTRUCTION( F_VMASKMOVPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmaskmovpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VMASKMOVPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmaskmovd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMASKMOVD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmaskmov"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMASKMOV, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmaskmovq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMASKMOVQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("maxpd"), FCML_ASM_DIALECT_INSTRUCTION( F_MAXPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmaxpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VMAXPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("maxps"), FCML_ASM_DIALECT_INSTRUCTION( F_MAXPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmaxps"), FCML_ASM_DIALECT_INSTRUCTION( F_VMAXPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("maxsd"), FCML_ASM_DIALECT_INSTRUCTION( F_MAXSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmaxsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VMAXSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("maxss"), FCML_ASM_DIALECT_INSTRUCTION( F_MAXSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmaxss"), FCML_ASM_DIALECT_INSTRUCTION( F_VMAXSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("mfence"), FCML_ASM_DIALECT_INSTRUCTION( F_MFENCE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("minpd"), FCML_ASM_DIALECT_INSTRUCTION( F_MINPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vminpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VMINPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("minps"), FCML_ASM_DIALECT_INSTRUCTION( F_MINPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vminps"), FCML_ASM_DIALECT_INSTRUCTION( F_VMINPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("minsd"), FCML_ASM_DIALECT_INSTRUCTION( F_MINSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vminsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VMINSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("minss"), FCML_ASM_DIALECT_INSTRUCTION( F_MINSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vminss"), FCML_ASM_DIALECT_INSTRUCTION( F_VMINSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("monitor[tb]"), FCML_ASM_DIALECT_INSTRUCTION( F_MONITOR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movapd"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVAPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovapd"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVAPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movaps"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVAPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovaps"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVAPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movbe"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVBE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("mov"), FCML_ASM_DIALECT_INSTRUCTION( F_MOV, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movd"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovd"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movq"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovq"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movddup"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVDDUP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovddup"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVDDUP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movdqa"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVDQA, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovdqa"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVDQA, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovdqa32"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVDQA32, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovdqa64"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVDQA64, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movdqu"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVDQU, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovdqu"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVDQU, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovdqu8"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVDQU8, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovdqu16"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVDQU16, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovdqu32"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVDQU32, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovdqu64"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVDQU64, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movdq2q"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVDQ2Q, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movhlps"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVHLPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovhlps"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVHLPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movhpd"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVHPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovhpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVHPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movhps"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVHPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovhps"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVHPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movlhps"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVLHPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovlhps"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVLHPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movlpd"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVLPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovlpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVLPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movlps"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVLPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovlps"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVLPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movmskpd"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVMSKPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovmskpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVMSKPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movmskps"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVMSKPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovmskps"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVMSKPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movntdqa"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVNTDQA, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovntdqa"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVNTDQA, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movntdq"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVNTDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovntdq"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVNTDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movs;movsb[ts]"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVS, FCML_AM_M8_M8 ), 0 },
    { FCML_TEXT("movs;movsw[ts,ow,a*];movsd[ts,od,a*];movsq[ts,oq,a*]"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVS, FCML_AM_MO_MO ), 0 },
    { FCML_TEXT("movnti"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVNTI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movntpd"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVNTPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovntpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVNTPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movntps"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVNTPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovntps"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVNTPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movntsd"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVNTSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movntss"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVNTSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movntq"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVNTQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movq"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movq2dq"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVQ2DQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movsd"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movshdup"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVSHDUP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovshdup"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVSHDUP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movsldup"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVSLDUP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovsldup"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVSLDUP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movss"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovss"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movsx"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVSX, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movsxd"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVSXD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movupd"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVUPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovupd"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVUPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movups"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVUPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmovups"), FCML_ASM_DIALECT_INSTRUCTION( F_VMOVUPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("movzx"), FCML_ASM_DIALECT_INSTRUCTION( F_MOVZX, FCML_AM_ALL ), 0 },
    { FCML_TEXT("mpsadbw"), FCML_ASM_DIALECT_INSTRUCTION( F_MPSADBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmpsadbw"), FCML_ASM_DIALECT_INSTRUCTION( F_VMPSADBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("mul"), FCML_ASM_DIALECT_INSTRUCTION( F_MUL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("mulpd"), FCML_ASM_DIALECT_INSTRUCTION( F_MULPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmulpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VMULPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("mulps"), FCML_ASM_DIALECT_INSTRUCTION( F_MULPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmulps"), FCML_ASM_DIALECT_INSTRUCTION( F_VMULPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("mulsd"), FCML_ASM_DIALECT_INSTRUCTION( F_MULSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmulsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VMULSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("mulss"), FCML_ASM_DIALECT_INSTRUCTION( F_MULSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmulss"), FCML_ASM_DIALECT_INSTRUCTION( F_VMULSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("mwait"), FCML_ASM_DIALECT_INSTRUCTION( F_MWAIT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("neg"), FCML_ASM_DIALECT_INSTRUCTION( F_NEG, FCML_AM_ALL ), 0 },
    { FCML_TEXT("nop"), FCML_ASM_DIALECT_INSTRUCTION( F_NOP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("not"), FCML_ASM_DIALECT_INSTRUCTION( F_NOT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("or"), FCML_ASM_DIALECT_INSTRUCTION( F_OR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("orpd"), FCML_ASM_DIALECT_INSTRUCTION( F_ORPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vorpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VORPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("orps"), FCML_ASM_DIALECT_INSTRUCTION( F_ORPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vorps"), FCML_ASM_DIALECT_INSTRUCTION( F_VORPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("out"), FCML_ASM_DIALECT_INSTRUCTION( F_OUT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("outs;outsb[ts]"), FCML_ASM_DIALECT_INSTRUCTION( F_OUTS, FCML_AM_M8 ), 0 },
    { FCML_TEXT("outs;outsw[ts]"), FCML_ASM_DIALECT_INSTRUCTION( F_OUTS, FCML_AM_M16 ), 0 },
    { FCML_TEXT("outs;outsd[ts]"), FCML_ASM_DIALECT_INSTRUCTION( F_OUTS, FCML_AM_M32 ), 0 },
    { FCML_TEXT("pabsw"), FCML_ASM_DIALECT_INSTRUCTION( F_PABSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pabsb"), FCML_ASM_DIALECT_INSTRUCTION( F_PABSB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pabsd"), FCML_ASM_DIALECT_INSTRUCTION( F_PABSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpabsb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPABSB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpabsw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPABSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpabsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPABSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpabsq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPABSQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpacksswb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPACKSSWB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("packsswb"), FCML_ASM_DIALECT_INSTRUCTION( F_PACKSSWB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpackssdw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPACKSSDW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("packssdw"), FCML_ASM_DIALECT_INSTRUCTION( F_PACKSSDW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("packusdw"), FCML_ASM_DIALECT_INSTRUCTION( F_PACKUSDW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpackusdw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPACKUSDW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("packuswb"), FCML_ASM_DIALECT_INSTRUCTION( F_PACKUSWB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpackuswb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPACKUSWB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpaddw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPADDW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("paddw"), FCML_ASM_DIALECT_INSTRUCTION( F_PADDW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpaddb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPADDB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpaddd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPADDD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("paddb"), FCML_ASM_DIALECT_INSTRUCTION( F_PADDB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("paddd"), FCML_ASM_DIALECT_INSTRUCTION( F_PADDD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpaddsw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPADDSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("paddsb"), FCML_ASM_DIALECT_INSTRUCTION( F_PADDSB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("paddsw"), FCML_ASM_DIALECT_INSTRUCTION( F_PADDSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpaddsb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPADDSB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("paddusw"), FCML_ASM_DIALECT_INSTRUCTION( F_PADDUSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("paddusb"), FCML_ASM_DIALECT_INSTRUCTION( F_PADDUSB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpaddusw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPADDUSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpaddusb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPADDUSB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("paddq"), FCML_ASM_DIALECT_INSTRUCTION( F_PADDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpaddq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPADDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pop"), FCML_ASM_DIALECT_INSTRUCTION( F_POP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("push"), FCML_ASM_DIALECT_INSTRUCTION( F_PUSH, FCML_AM_ALL ), 0 },
    { FCML_TEXT("popa"), FCML_ASM_DIALECT_INSTRUCTION( F_POPA, FCML_AM_ALL ), 0 },
    { FCML_TEXT("popad"), FCML_ASM_DIALECT_INSTRUCTION( F_POPAD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("popf"), FCML_ASM_DIALECT_INSTRUCTION( F_POPF, FCML_AM_ALL ), 0 },
    { FCML_TEXT("popfq"), FCML_ASM_DIALECT_INSTRUCTION( F_POPFQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("popfd"), FCML_ASM_DIALECT_INSTRUCTION( F_POPFD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pusha"), FCML_ASM_DIALECT_INSTRUCTION( F_PUSHA, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pushf"), FCML_ASM_DIALECT_INSTRUCTION( F_PUSHF, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pushad"), FCML_ASM_DIALECT_INSTRUCTION( F_PUSHAD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pushfq"), FCML_ASM_DIALECT_INSTRUCTION( F_PUSHFQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pushfd"), FCML_ASM_DIALECT_INSTRUCTION( F_PUSHFD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pavgusb[Sbf];pf2id[S1d];pfacc[Sae];pfadd[S9e];pfcmpeq[Sb0];pfcmpge[S90];pfcmpgt[Sa0];pfmax[Sa4];pfmin[S94];pfmul[Sb4];pfrcp[S96];pfrcpit1[Sa6];pfrcpit2[Sb6];pfrsqit1[Sa7];pfrsqrt[S97];pfsub[S9a];pfsubr[Saa];pi2fd[S0d];pmulhrw[Sb7];pf2iw[S1c];pfnacc[S8a];pfpnacc[S8e];pi2fw[S0c];pswapd[Sbb]"), FCML_ASM_DIALECT_INSTRUCTION( FCML_MULTI_INSTRUCTION( FCML_MI_AMD3DNOW ), FCML_AM_ALL ), 0 },
    { FCML_TEXT("palignr"), FCML_ASM_DIALECT_INSTRUCTION( F_PALIGNR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpalignr"), FCML_ASM_DIALECT_INSTRUCTION( F_VPALIGNR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pand"), FCML_ASM_DIALECT_INSTRUCTION( F_PAND, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpand"), FCML_ASM_DIALECT_INSTRUCTION( F_VPAND, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpandd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPANDD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpandq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPANDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pandn"), FCML_ASM_DIALECT_INSTRUCTION( F_PANDN, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpandn"), FCML_ASM_DIALECT_INSTRUCTION( F_VPANDN, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpandnd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPANDND, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpandnq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPANDNQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pause"), FCML_ASM_DIALECT_INSTRUCTION( F_PAUSE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pavgw"), FCML_ASM_DIALECT_INSTRUCTION( F_PAVGW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pavgb"), FCML_ASM_DIALECT_INSTRUCTION( F_PAVGB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpavgw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPAVGW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpavgb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPAVGB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pblendvb"), FCML_ASM_DIALECT_INSTRUCTION( F_PBLENDVB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpblendvb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPBLENDVB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pblendw"), FCML_ASM_DIALECT_INSTRUCTION( F_PBLENDW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpblendw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPBLENDW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpblendd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPBLENDD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pclmulqdq"), FCML_ASM_DIALECT_INSTRUCTION( F_PCLMULQDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpclmulqdq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCLMULQDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pcmpeqw"), FCML_ASM_DIALECT_INSTRUCTION( F_PCMPEQW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pcmpeqb"), FCML_ASM_DIALECT_INSTRUCTION( F_PCMPEQB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pcmpeqd"), FCML_ASM_DIALECT_INSTRUCTION( F_PCMPEQD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcmpeqd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCMPEQD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcmpeqw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCMPEQW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcmpeqb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCMPEQB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pcmpeqq"), FCML_ASM_DIALECT_INSTRUCTION( F_PCMPEQQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcmpeqq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCMPEQQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pcmpestri"), FCML_ASM_DIALECT_INSTRUCTION( F_PCMPESTRI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcmpestri"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCMPESTRI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pcmpestrm"), FCML_ASM_DIALECT_INSTRUCTION( F_PCMPESTRM, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcmpestrm"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCMPESTRM, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pcmpgtw"), FCML_ASM_DIALECT_INSTRUCTION( F_PCMPGTW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pcmpgtd"), FCML_ASM_DIALECT_INSTRUCTION( F_PCMPGTD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pcmpgtb"), FCML_ASM_DIALECT_INSTRUCTION( F_PCMPGTB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcmpgtw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCMPGTW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcmpgtd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCMPGTD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcmpgtb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCMPGTB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pcmpgtq"), FCML_ASM_DIALECT_INSTRUCTION( F_PCMPGTQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcmpgtq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCMPGTQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pcmpistri"), FCML_ASM_DIALECT_INSTRUCTION( F_PCMPISTRI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcmpistri"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCMPISTRI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pcmpistrm"), FCML_ASM_DIALECT_INSTRUCTION( F_PCMPISTRM, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcmpistrm"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCMPISTRM, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpextrb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPEXTRB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpextrq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPEXTRQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pextrq"), FCML_ASM_DIALECT_INSTRUCTION( F_PEXTRQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pextrb"), FCML_ASM_DIALECT_INSTRUCTION( F_PEXTRB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pextrd"), FCML_ASM_DIALECT_INSTRUCTION( F_PEXTRD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpextrd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPEXTRD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pextrw"), FCML_ASM_DIALECT_INSTRUCTION( F_PEXTRW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpextrw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPEXTRW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphaddw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHADDW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphaddd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHADDD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("phaddd"), FCML_ASM_DIALECT_INSTRUCTION( F_PHADDD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("phaddw"), FCML_ASM_DIALECT_INSTRUCTION( F_PHADDW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("phaddsw"), FCML_ASM_DIALECT_INSTRUCTION( F_PHADDSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphaddsw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHADDSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("phminposuw"), FCML_ASM_DIALECT_INSTRUCTION( F_PHMINPOSUW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphminposuw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHMINPOSUW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("phsubd"), FCML_ASM_DIALECT_INSTRUCTION( F_PHSUBD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("phsubw"), FCML_ASM_DIALECT_INSTRUCTION( F_PHSUBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphsubd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHSUBD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphsubw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHSUBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("phsubsw"), FCML_ASM_DIALECT_INSTRUCTION( F_PHSUBSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphsubsw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHSUBSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pinsrd"), FCML_ASM_DIALECT_INSTRUCTION( F_PINSRD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpinsrq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPINSRQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pinsrq"), FCML_ASM_DIALECT_INSTRUCTION( F_PINSRQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pinsrb"), FCML_ASM_DIALECT_INSTRUCTION( F_PINSRB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpinsrd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPINSRD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpinsrb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPINSRB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pinsrw"), FCML_ASM_DIALECT_INSTRUCTION( F_PINSRW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpinsrw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPINSRW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmaddubsw"), FCML_ASM_DIALECT_INSTRUCTION( F_PMADDUBSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmaddubsw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMADDUBSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmaddwd"), FCML_ASM_DIALECT_INSTRUCTION( F_PMADDWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmaddwd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMADDWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmaxsb"), FCML_ASM_DIALECT_INSTRUCTION( F_PMAXSB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmaxsb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMAXSB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmaxsd"), FCML_ASM_DIALECT_INSTRUCTION( F_PMAXSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmaxsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMAXSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmaxsq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMAXSQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmaxsw"), FCML_ASM_DIALECT_INSTRUCTION( F_PMAXSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmaxsw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMAXSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmaxub"), FCML_ASM_DIALECT_INSTRUCTION( F_PMAXUB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmaxub"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMAXUB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmaxud"), FCML_ASM_DIALECT_INSTRUCTION( F_PMAXUD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmaxud"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMAXUD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmaxuq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMAXUQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmaxuw"), FCML_ASM_DIALECT_INSTRUCTION( F_PMAXUW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmaxuw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMAXUW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pminsb"), FCML_ASM_DIALECT_INSTRUCTION( F_PMINSB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpminsb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMINSB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pminsd"), FCML_ASM_DIALECT_INSTRUCTION( F_PMINSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpminsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMINSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpminsq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMINSQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pminsw"), FCML_ASM_DIALECT_INSTRUCTION( F_PMINSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpminsw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMINSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pminuw"), FCML_ASM_DIALECT_INSTRUCTION( F_PMINUW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpminuw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMINUW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pminub"), FCML_ASM_DIALECT_INSTRUCTION( F_PMINUB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpminub"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMINUB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pminud"), FCML_ASM_DIALECT_INSTRUCTION( F_PMINUD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpminud"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMINUD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpminuq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMINUQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmovmskb"), FCML_ASM_DIALECT_INSTRUCTION( F_PMOVMSKB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmovmskb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMOVMSKB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmovsxbq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMOVSXBQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmovsxbw"), FCML_ASM_DIALECT_INSTRUCTION( F_PMOVSXBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmovsxwq"), FCML_ASM_DIALECT_INSTRUCTION( F_PMOVSXWQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmovsxwq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMOVSXWQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmovsxwd"), FCML_ASM_DIALECT_INSTRUCTION( F_PMOVSXWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmovsxbd"), FCML_ASM_DIALECT_INSTRUCTION( F_PMOVSXBD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmovsxdq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMOVSXDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmovsxwd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMOVSXWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmovsxbq"), FCML_ASM_DIALECT_INSTRUCTION( F_PMOVSXBQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmovsxbw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMOVSXBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmovsxdq"), FCML_ASM_DIALECT_INSTRUCTION( F_PMOVSXDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmovsxbd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMOVSXBD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmovzxwd"), FCML_ASM_DIALECT_INSTRUCTION( F_PMOVZXWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmovzxdq"), FCML_ASM_DIALECT_INSTRUCTION( F_PMOVZXDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmovzxdq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMOVZXDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmovzxwq"), FCML_ASM_DIALECT_INSTRUCTION( F_PMOVZXWQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmovzxbq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMOVZXBQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmovzxbq"), FCML_ASM_DIALECT_INSTRUCTION( F_PMOVZXBQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmovzxwd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMOVZXWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmovzxbd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMOVZXBD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmovzxwq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMOVZXWQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmovzxbd"), FCML_ASM_DIALECT_INSTRUCTION( F_PMOVZXBD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmovzxbw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMOVZXBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmovzxbw"), FCML_ASM_DIALECT_INSTRUCTION( F_PMOVZXBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmuldq"), FCML_ASM_DIALECT_INSTRUCTION( F_PMULDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmulhrsw"), FCML_ASM_DIALECT_INSTRUCTION( F_PMULHRSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmulhuw"), FCML_ASM_DIALECT_INSTRUCTION( F_PMULHUW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmuldq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMULDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmulhrsw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMULHRSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmulhuw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMULHUW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmulhw"), FCML_ASM_DIALECT_INSTRUCTION( F_PMULHW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmulhw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMULHW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmuludq"), FCML_ASM_DIALECT_INSTRUCTION( F_PMULUDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmuludq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMULUDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmullw"), FCML_ASM_DIALECT_INSTRUCTION( F_PMULLW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pmulld"), FCML_ASM_DIALECT_INSTRUCTION( F_PMULLD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmulld"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMULLD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmullq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMULLQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmullw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMULLW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("popcnt"), FCML_ASM_DIALECT_INSTRUCTION( F_POPCNT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("por"), FCML_ASM_DIALECT_INSTRUCTION( F_POR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpor"), FCML_ASM_DIALECT_INSTRUCTION( F_VPOR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpord"), FCML_ASM_DIALECT_INSTRUCTION(F_VPORD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vporq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPORQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("prefetcht2"), FCML_ASM_DIALECT_INSTRUCTION( F_PREFETCHT2, FCML_AM_ALL ), 0 },
    { FCML_TEXT("prefetchw"), FCML_ASM_DIALECT_INSTRUCTION( F_PREFETCHW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("prefetcht1"), FCML_ASM_DIALECT_INSTRUCTION( F_PREFETCHT1, FCML_AM_ALL ), 0 },
    { FCML_TEXT("prefetchnta"), FCML_ASM_DIALECT_INSTRUCTION( F_PREFETCHNTA, FCML_AM_ALL ), 0 },
    { FCML_TEXT("prefetcht0"), FCML_ASM_DIALECT_INSTRUCTION( F_PREFETCHT0, FCML_AM_ALL ), 0 },
    { FCML_TEXT("prefetchwt1"), FCML_ASM_DIALECT_INSTRUCTION(F_PREFETCHWT1, FCML_AM_ALL), 0 },
    { FCML_TEXT("psadbw"), FCML_ASM_DIALECT_INSTRUCTION( F_PSADBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsadbw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSADBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pshufb"), FCML_ASM_DIALECT_INSTRUCTION( F_PSHUFB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pshufd"), FCML_ASM_DIALECT_INSTRUCTION( F_PSHUFD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pshufhw"), FCML_ASM_DIALECT_INSTRUCTION( F_PSHUFHW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpshufd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSHUFD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpshufb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSHUFB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pshuflw"), FCML_ASM_DIALECT_INSTRUCTION( F_PSHUFLW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pshufw"), FCML_ASM_DIALECT_INSTRUCTION( F_PSHUFW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpshuflw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSHUFLW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpshufhw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSHUFHW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsignb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSIGNB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsignd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSIGND, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psignw"), FCML_ASM_DIALECT_INSTRUCTION( F_PSIGNW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psignb"), FCML_ASM_DIALECT_INSTRUCTION( F_PSIGNB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsignw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSIGNW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psignd"), FCML_ASM_DIALECT_INSTRUCTION( F_PSIGND, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pslldq"), FCML_ASM_DIALECT_INSTRUCTION( F_PSLLDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpslldq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSLLDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psllq"), FCML_ASM_DIALECT_INSTRUCTION( F_PSLLQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pslld"), FCML_ASM_DIALECT_INSTRUCTION( F_PSLLD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsllw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSLLW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsllq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSLLQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psllw"), FCML_ASM_DIALECT_INSTRUCTION( F_PSLLW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpslld"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSLLD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsraw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSRAW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psrad"), FCML_ASM_DIALECT_INSTRUCTION( F_PSRAD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psraw"), FCML_ASM_DIALECT_INSTRUCTION( F_PSRAW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsrad"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSRAD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsraq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSRAQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("psrldq"), FCML_ASM_DIALECT_INSTRUCTION( F_PSRLDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsrldq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSRLDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsrlq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSRLQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psrlq"), FCML_ASM_DIALECT_INSTRUCTION( F_PSRLQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psrld"), FCML_ASM_DIALECT_INSTRUCTION( F_PSRLD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psrlw"), FCML_ASM_DIALECT_INSTRUCTION( F_PSRLW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsrld"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSRLD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsrlw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSRLW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsubd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSUBD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psubd"), FCML_ASM_DIALECT_INSTRUCTION( F_PSUBD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psubw"), FCML_ASM_DIALECT_INSTRUCTION( F_PSUBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsubb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSUBB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsubq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSUBQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psubb"), FCML_ASM_DIALECT_INSTRUCTION( F_PSUBB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsubw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSUBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psubq"), FCML_ASM_DIALECT_INSTRUCTION( F_PSUBQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psubsb"), FCML_ASM_DIALECT_INSTRUCTION( F_PSUBSB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsubsw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSUBSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsubsb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSUBSB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psubsw"), FCML_ASM_DIALECT_INSTRUCTION( F_PSUBSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsubusw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSUBUSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsubusb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSUBUSB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psubusb"), FCML_ASM_DIALECT_INSTRUCTION( F_PSUBUSB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("psubusw"), FCML_ASM_DIALECT_INSTRUCTION( F_PSUBUSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vptest"), FCML_ASM_DIALECT_INSTRUCTION( F_VPTEST, FCML_AM_ALL ), 0 },
    { FCML_TEXT("ptest"), FCML_ASM_DIALECT_INSTRUCTION( F_PTEST, FCML_AM_ALL ), 0 },
    { FCML_TEXT("punpcklbw"), FCML_ASM_DIALECT_INSTRUCTION( F_PUNPCKLBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("punpcklqdq"), FCML_ASM_DIALECT_INSTRUCTION( F_PUNPCKLQDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpunpcklwd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPUNPCKLWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpunpcklqdq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPUNPCKLQDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpunpcklbw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPUNPCKLBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("punpcklwd"), FCML_ASM_DIALECT_INSTRUCTION( F_PUNPCKLWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("punpckldq"), FCML_ASM_DIALECT_INSTRUCTION( F_PUNPCKLDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpunpckldq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPUNPCKLDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpunpckhwd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPUNPCKHWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("punpckhdq"), FCML_ASM_DIALECT_INSTRUCTION( F_PUNPCKHDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("punpckhwd"), FCML_ASM_DIALECT_INSTRUCTION( F_PUNPCKHWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("punpckhqdq"), FCML_ASM_DIALECT_INSTRUCTION( F_PUNPCKHQDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpunpckhqdq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPUNPCKHQDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpunpckhbw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPUNPCKHBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("punpckhbw"), FCML_ASM_DIALECT_INSTRUCTION( F_PUNPCKHBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpunpckhdq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPUNPCKHDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pxor"), FCML_ASM_DIALECT_INSTRUCTION( F_PXOR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpxor"), FCML_ASM_DIALECT_INSTRUCTION( F_VPXOR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpxord"), FCML_ASM_DIALECT_INSTRUCTION( F_VPXORD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpxorq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPXORQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("prefetch"), FCML_ASM_DIALECT_INSTRUCTION( F_PREFETCH, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rcl"), FCML_ASM_DIALECT_INSTRUCTION( F_RCL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rcr"), FCML_ASM_DIALECT_INSTRUCTION( F_RCR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rol"), FCML_ASM_DIALECT_INSTRUCTION( F_ROL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("ror"), FCML_ASM_DIALECT_INSTRUCTION( F_ROR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("ret"), FCML_ASM_DIALECT_INSTRUCTION( F_RET, FCML_AM_ALL ), 0 },
    { FCML_TEXT("retf"), FCML_ASM_DIALECT_INSTRUCTION( F_RETF, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rcpps"), FCML_ASM_DIALECT_INSTRUCTION( F_RCPPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vrcpps"), FCML_ASM_DIALECT_INSTRUCTION( F_VRCPPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rcpss"), FCML_ASM_DIALECT_INSTRUCTION( F_RCPSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vrcpss"), FCML_ASM_DIALECT_INSTRUCTION( F_VRCPSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rdfsbase"), FCML_ASM_DIALECT_INSTRUCTION( F_RDFSBASE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rdgsbase"), FCML_ASM_DIALECT_INSTRUCTION( F_RDGSBASE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rdrand"), FCML_ASM_DIALECT_INSTRUCTION( F_RDRAND, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rdtscp"), FCML_ASM_DIALECT_INSTRUCTION( F_RDTSCP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rdtsc"), FCML_ASM_DIALECT_INSTRUCTION( F_RDTSC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rdpmc"), FCML_ASM_DIALECT_INSTRUCTION( F_RDPMC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rdmsr"), FCML_ASM_DIALECT_INSTRUCTION( F_RDMSR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("roundpd"), FCML_ASM_DIALECT_INSTRUCTION( F_ROUNDPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vroundpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VROUNDPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("roundps"), FCML_ASM_DIALECT_INSTRUCTION( F_ROUNDPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vroundps"), FCML_ASM_DIALECT_INSTRUCTION( F_VROUNDPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("roundsd"), FCML_ASM_DIALECT_INSTRUCTION( F_ROUNDSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vroundsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VROUNDSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("roundss"), FCML_ASM_DIALECT_INSTRUCTION( F_ROUNDSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vroundss"), FCML_ASM_DIALECT_INSTRUCTION( F_VROUNDSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rsm"), FCML_ASM_DIALECT_INSTRUCTION( F_RSM, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rsqrtps"), FCML_ASM_DIALECT_INSTRUCTION( F_RSQRTPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vrsqrtps"), FCML_ASM_DIALECT_INSTRUCTION( F_VRSQRTPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rsqrtss"), FCML_ASM_DIALECT_INSTRUCTION( F_RSQRTSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vrsqrtss"), FCML_ASM_DIALECT_INSTRUCTION( F_VRSQRTSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sahf"), FCML_ASM_DIALECT_INSTRUCTION( F_SAHF, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sar"), FCML_ASM_DIALECT_INSTRUCTION( F_SAR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("shl;sal"), FCML_ASM_DIALECT_INSTRUCTION( F_SHL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("shr"), FCML_ASM_DIALECT_INSTRUCTION( F_SHR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sbb"), FCML_ASM_DIALECT_INSTRUCTION( F_SBB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("scas;scasb[ts]"), FCML_ASM_DIALECT_INSTRUCTION( F_SCAS, FCML_AM_RM8 ), 0 },
    { FCML_TEXT("scas;scasw[ts,ow,a*];scasd[ts,od,a*];scasq[ts,oq,a*]"), FCML_ASM_DIALECT_INSTRUCTION( F_SCAS, FCML_AM_RMO ), 0 },
    { FCML_TEXT("set"), FCML_ASM_DIALECT_INSTRUCTION( F_SET, FCML_AM_ALL ), 0 },
    { FCML_TEXT("stos;stosb[ts]"), FCML_ASM_DIALECT_INSTRUCTION( F_STOS, FCML_AM_RM8 ), 0 },
    { FCML_TEXT("stos;stosw[ts,ow,a*];stosd[ts,od,a*];stosq[ts,oq,a*]"), FCML_ASM_DIALECT_INSTRUCTION( F_STOS, FCML_AM_RMO ), 0 },
    { FCML_TEXT("sub"), FCML_ASM_DIALECT_INSTRUCTION( F_SUB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sfence"), FCML_ASM_DIALECT_INSTRUCTION( F_SFENCE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sgdt"), FCML_ASM_DIALECT_INSTRUCTION( F_SGDT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("shld"), FCML_ASM_DIALECT_INSTRUCTION( F_SHLD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("shrd"), FCML_ASM_DIALECT_INSTRUCTION( F_SHRD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("skinit"), FCML_ASM_DIALECT_INSTRUCTION( F_SKINIT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("slwpcb"), FCML_ASM_DIALECT_INSTRUCTION( F_SLWPCB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("shufpd"), FCML_ASM_DIALECT_INSTRUCTION( F_SHUFPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vshufpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VSHUFPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("shufps"), FCML_ASM_DIALECT_INSTRUCTION( F_SHUFPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vshufps"), FCML_ASM_DIALECT_INSTRUCTION( F_VSHUFPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sidt"), FCML_ASM_DIALECT_INSTRUCTION( F_SIDT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sldt"), FCML_ASM_DIALECT_INSTRUCTION( F_SLDT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("smsw"), FCML_ASM_DIALECT_INSTRUCTION( F_SMSW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sqrtpd"), FCML_ASM_DIALECT_INSTRUCTION( F_SQRTPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vsqrtpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VSQRTPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sqrtps"), FCML_ASM_DIALECT_INSTRUCTION( F_SQRTPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vsqrtps"), FCML_ASM_DIALECT_INSTRUCTION( F_VSQRTPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sqrtsd"), FCML_ASM_DIALECT_INSTRUCTION( F_SQRTSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vsqrtsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VSQRTSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sqrtss"), FCML_ASM_DIALECT_INSTRUCTION( F_SQRTSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vsqrtss"), FCML_ASM_DIALECT_INSTRUCTION( F_VSQRTSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("stc"), FCML_ASM_DIALECT_INSTRUCTION( F_STC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("std"), FCML_ASM_DIALECT_INSTRUCTION( F_STD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("stgi"), FCML_ASM_DIALECT_INSTRUCTION( F_STGI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sti"), FCML_ASM_DIALECT_INSTRUCTION( F_STI, FCML_AM_ALL ), 0 },
    { FCML_TEXT("stmxcsr"), FCML_ASM_DIALECT_INSTRUCTION( F_STMXCSR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vstmxcsr"), FCML_ASM_DIALECT_INSTRUCTION( F_VSTMXCSR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("str"), FCML_ASM_DIALECT_INSTRUCTION( F_STR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("subpd"), FCML_ASM_DIALECT_INSTRUCTION( F_SUBPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vsubpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VSUBPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("subps"), FCML_ASM_DIALECT_INSTRUCTION( F_SUBPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vsubps"), FCML_ASM_DIALECT_INSTRUCTION( F_VSUBPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("subsd"), FCML_ASM_DIALECT_INSTRUCTION( F_SUBSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vsubsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VSUBSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("subss"), FCML_ASM_DIALECT_INSTRUCTION( F_SUBSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vsubss"), FCML_ASM_DIALECT_INSTRUCTION( F_VSUBSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("swapgs"), FCML_ASM_DIALECT_INSTRUCTION( F_SWAPGS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("syscall"), FCML_ASM_DIALECT_INSTRUCTION( F_SYSCALL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sysenter"), FCML_ASM_DIALECT_INSTRUCTION( F_SYSENTER, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sysexit"), FCML_ASM_DIALECT_INSTRUCTION( F_SYSEXIT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sysret"), FCML_ASM_DIALECT_INSTRUCTION( F_SYSRET, FCML_AM_ALL ), 0 },
    { FCML_TEXT("test"), FCML_ASM_DIALECT_INSTRUCTION( F_TEST, FCML_AM_ALL ), 0 },
    { FCML_TEXT("t1mskc"), FCML_ASM_DIALECT_INSTRUCTION( F_T1MSKC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("ucomisd"), FCML_ASM_DIALECT_INSTRUCTION( F_UCOMISD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vucomisd"), FCML_ASM_DIALECT_INSTRUCTION( F_VUCOMISD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("ucomiss"), FCML_ASM_DIALECT_INSTRUCTION( F_UCOMISS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vucomiss"), FCML_ASM_DIALECT_INSTRUCTION( F_VUCOMISS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("ud2"), FCML_ASM_DIALECT_INSTRUCTION( F_UD2, FCML_AM_ALL ), 0 },
    { FCML_TEXT("unpckhpd"), FCML_ASM_DIALECT_INSTRUCTION( F_UNPCKHPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vunpckhpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VUNPCKHPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("unpckhps"), FCML_ASM_DIALECT_INSTRUCTION( F_UNPCKHPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vunpckhps"), FCML_ASM_DIALECT_INSTRUCTION( F_VUNPCKHPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("unpcklpd"), FCML_ASM_DIALECT_INSTRUCTION( F_UNPCKLPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vunpcklpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VUNPCKLPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("unpcklps"), FCML_ASM_DIALECT_INSTRUCTION( F_UNPCKLPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vunpcklps"), FCML_ASM_DIALECT_INSTRUCTION( F_VUNPCKLPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmload"), FCML_ASM_DIALECT_INSTRUCTION( F_VMLOAD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmrun"), FCML_ASM_DIALECT_INSTRUCTION( F_VMRUN, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmsave"), FCML_ASM_DIALECT_INSTRUCTION( F_VMSAVE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfrczpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFRCZPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfrczps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFRCZPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfrczsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFRCZSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfrczss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFRCZSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcmov"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCMOV, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpermil2pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPERMIL2PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpermil2ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VPERMIL2PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphaddbd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHADDBD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphaddbw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHADDBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphaddbq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHADDBQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphadddq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHADDDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphaddubd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHADDUBD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphaddubq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHADDUBQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphaddubw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHADDUBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphaddudq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHADDUDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphadduwd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHADDUWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphadduwq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHADDUWQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphaddwd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHADDWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphaddwq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHADDWQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphsubbw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHSUBBW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphsubdq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHSUBDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphsubdq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHSUBDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vphsubwd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPHSUBWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmacsdd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMACSDD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmacsdqh"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMACSDQH, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmacsdql"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMACSDQL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmacssdd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMACSSDD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmacssdqh"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMACSSDQH, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmacssdql"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMACSSDQL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmacsswd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMACSSWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmacssww"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMACSSWW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmacswd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMACSWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmacsww"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMACSWW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmadcsswd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMADCSSWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpmadcswd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPMADCSWD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpperm"), FCML_ASM_DIALECT_INSTRUCTION( F_VPPERM, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vprotd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPROTD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vprotb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPROTB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vprotq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPROTQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vprotw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPROTW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpshab"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSHAB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpshad"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSHAD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpshaq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSHAQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpshaw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSHAW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpshlb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSHLB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpshld"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSHLD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpshlq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSHLQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpshlw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSHLW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmadd213pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADD213PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmaddpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADDPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmadd132pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADD132PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmadd231pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADD231PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmaddps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADDPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmadd231ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADD231PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmadd132ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADD132PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmadd213ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADD213PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmadd132sd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADD132SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmadd213sd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADD213SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmaddsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADDSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmadd231sd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADD231SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmadd132ss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADD132SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmadd213ss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADD213SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmaddss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADDSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmadd231ss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADD231SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmaddsub132pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADDSUB132PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmaddsub213pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADDSUB213PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmaddsubpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADDSUBPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmaddsub231pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADDSUB231PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmaddsub231ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADDSUB231PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmaddsubps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADDSUBPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmaddsub132ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADDSUB132PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmaddsub213ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMADDSUB213PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsubaddpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUBADDPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsubadd213pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUBADD213PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsubadd132pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUBADD132PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsubadd231pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUBADD231PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsubaddps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUBADDPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsubadd213ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUBADD213PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsubadd132ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUBADD132PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsubadd231ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUBADD231PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsub213pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUB213PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsubpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUBPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsub132pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUB132PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsub231pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUB231PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsub213ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUB213PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsubps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUBPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsub132ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUB132PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsub231ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUB231PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsubsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUBSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsub231sd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUB231SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsub132sd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUB132SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsub213sd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUB213SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsub231ss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUB231SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsub213ss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUB213SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsub132ss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUB132SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfmsubss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFMSUBSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmadd231pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADD231PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmaddpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADDPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmadd132pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADD132PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmadd213pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADD213PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmadd231ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADD231PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmadd132ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADD132PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmadd213ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADD213PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmaddps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADDPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmadd213sd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADD213SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmaddsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADDSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmadd231sd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADD231SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmadd132sd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADD132SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmadd213ss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADD213SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmaddss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADDSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmadd231ss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADD231SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmadd132ss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMADD132SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsub132pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUB132PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsub213pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUB213PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsub231pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUB231PD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsubpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUBPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsubps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUBPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsub213ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUB213PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsub132ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUB132PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsub231ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUB231PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsubsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUBSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsub231sd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUB231SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsub213sd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUB213SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsub132sd"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUB132SD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsubss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUBSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsub132ss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUB132SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsub213ss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUB213SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfnmsub231ss"), FCML_ASM_DIALECT_INSTRUCTION( F_VFNMSUB231SS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vfpclasspd"), FCML_ASM_DIALECT_INSTRUCTION(F_VFPCLASSPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vfpclassps"), FCML_ASM_DIALECT_INSTRUCTION(F_VFPCLASSPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vfpclasssd"), FCML_ASM_DIALECT_INSTRUCTION(F_VFPCLASSSD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vfpclassss"), FCML_ASM_DIALECT_INSTRUCTION(F_VFPCLASSSS, FCML_AM_ALL), 0 },
    { FCML_TEXT("bextr"), FCML_ASM_DIALECT_INSTRUCTION( F_BEXTR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpbroadcastw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPBROADCASTW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpbroadcastb"), FCML_ASM_DIALECT_INSTRUCTION( F_VPBROADCASTB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpbroadcastd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPBROADCASTD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpbroadcastq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPBROADCASTQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vbroadcasti32x2"), FCML_ASM_DIALECT_INSTRUCTION(F_VBROADCASTI32X2, FCML_AM_ALL), 0 },
    { FCML_TEXT("vbroadcasti32x4"), FCML_ASM_DIALECT_INSTRUCTION(F_VBROADCASTI32X4, FCML_AM_ALL), 0 },
    { FCML_TEXT("vbroadcasti64x2"), FCML_ASM_DIALECT_INSTRUCTION(F_VBROADCASTI64X2, FCML_AM_ALL), 0 },
    { FCML_TEXT("vbroadcasti32x8"), FCML_ASM_DIALECT_INSTRUCTION(F_VBROADCASTI32X8, FCML_AM_ALL), 0 },
    { FCML_TEXT("vbroadcasti64x4"), FCML_ASM_DIALECT_INSTRUCTION(F_VBROADCASTI64X4, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpbroadcastmb2q"), FCML_ASM_DIALECT_INSTRUCTION(F_VPBROADCASTMB2Q, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpbroadcastmw2d"), FCML_ASM_DIALECT_INSTRUCTION(F_VPBROADCASTMW2D, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpcmpb"), FCML_ASM_DIALECT_INSTRUCTION(F_VPCMPB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpcmpub"), FCML_ASM_DIALECT_INSTRUCTION(F_VPCMPUB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpcmpw"), FCML_ASM_DIALECT_INSTRUCTION(F_VPCMPW, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpcmpuw"), FCML_ASM_DIALECT_INSTRUCTION(F_VPCMPUW, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpcmpd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPCMPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpcmpud"), FCML_ASM_DIALECT_INSTRUCTION(F_VPCMPUD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpcmpq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPCMPQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpcmpuq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPCMPUQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcompresspd"), FCML_ASM_DIALECT_INSTRUCTION(F_VCOMPRESSPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcompressps"), FCML_ASM_DIALECT_INSTRUCTION(F_VCOMPRESSPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpcompressd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPCOMPRESSD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpcompressq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPCOMPRESSQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtpd2qq"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTPD2QQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvttps2qq"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTTPS2QQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvttps2uqq"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTTPS2UQQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtpd2udq"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTPD2UDQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvttpd2uqq"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTTPD2UQQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvttps2udq"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTTPS2UDQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtpd2uqq"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTPD2UQQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vmptrld"), FCML_ASM_DIALECT_INSTRUCTION( F_VMPTRLD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmptrst"), FCML_ASM_DIALECT_INSTRUCTION( F_VMPTRST, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmclear"), FCML_ASM_DIALECT_INSTRUCTION( F_VMCLEAR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmread"), FCML_ASM_DIALECT_INSTRUCTION( F_VMREAD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmwrite"), FCML_ASM_DIALECT_INSTRUCTION( F_VMWRITE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmlaunch"), FCML_ASM_DIALECT_INSTRUCTION( F_VMLAUNCH, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmresume"), FCML_ASM_DIALECT_INSTRUCTION( F_VMRESUME, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmxoff"), FCML_ASM_DIALECT_INSTRUCTION( F_VMXOFF, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmxon"), FCML_ASM_DIALECT_INSTRUCTION( F_VMXON, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmcall"), FCML_ASM_DIALECT_INSTRUCTION( F_VMCALL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmfunc"), FCML_ASM_DIALECT_INSTRUCTION( F_VMFUNC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("valignd"), FCML_ASM_DIALECT_INSTRUCTION(F_VALIGND, FCML_AM_ALL), 0 },
    { FCML_TEXT("valignq"), FCML_ASM_DIALECT_INSTRUCTION(F_VALIGNQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vblendmpd"), FCML_ASM_DIALECT_INSTRUCTION(F_VBLENDMPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vblendmps"), FCML_ASM_DIALECT_INSTRUCTION(F_VBLENDMPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vbroadcastsd"), FCML_ASM_DIALECT_INSTRUCTION( F_VBROADCASTSD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vbroadcastss"), FCML_ASM_DIALECT_INSTRUCTION( F_VBROADCASTSS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vbroadcasti128"), FCML_ASM_DIALECT_INSTRUCTION( F_VBROADCASTI128, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vbroadcastf128"), FCML_ASM_DIALECT_INSTRUCTION( F_VBROADCASTF128, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vbroadcastf32x2"), FCML_ASM_DIALECT_INSTRUCTION(F_VBROADCASTF32X2, FCML_AM_ALL), 0 },
    { FCML_TEXT("vbroadcastf32x4"), FCML_ASM_DIALECT_INSTRUCTION(F_VBROADCASTF32X4, FCML_AM_ALL), 0 },
    { FCML_TEXT("vbroadcastf32x8"), FCML_ASM_DIALECT_INSTRUCTION(F_VBROADCASTF32X8, FCML_AM_ALL), 0 },
    { FCML_TEXT("vbroadcastf64x2"), FCML_ASM_DIALECT_INSTRUCTION(F_VBROADCASTF64X2, FCML_AM_ALL), 0 },
    { FCML_TEXT("vbroadcastf64x4"), FCML_ASM_DIALECT_INSTRUCTION(F_VBROADCASTF64X4, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtph2ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTPH2PS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvtps2ph"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTPS2PH, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vcvtps2udq"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTPS2UDQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtps2uqq"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTPS2UQQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtps2qq"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTPS2QQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtqq2pd"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTQQ2PD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtqq2ps"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTQQ2PS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtsd2usi"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTSD2USI, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtss2usi"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTSS2USI, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvttsd2usi"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTTSD2USI, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvttss2usi"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTTSS2USI, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvttpd2qq"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTTPD2QQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvttpd2udq"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTTPD2UDQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtudq2pd"), FCML_ASM_DIALECT_INSTRUCTION(F_VCVTUDQ2PD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtuqq2ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTUQQ2PS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtudq2ps"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTUDQ2PS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtuqq2pd"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTUQQ2PD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtusi2sd"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTUSI2SD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vcvtusi2ss"), FCML_ASM_DIALECT_INSTRUCTION( F_VCVTUSI2SS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vdbpsadbw"), FCML_ASM_DIALECT_INSTRUCTION( F_VDBPSADBW, FCML_AM_ALL), 0 },
    { FCML_TEXT("vexpandpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VEXPANDPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vexpandps"), FCML_ASM_DIALECT_INSTRUCTION( F_VEXPANDPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("verr"), FCML_ASM_DIALECT_INSTRUCTION( F_VERR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("verw"), FCML_ASM_DIALECT_INSTRUCTION( F_VERW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vmmcall"), FCML_ASM_DIALECT_INSTRUCTION( F_VMMCALL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpermilpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPERMILPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpermilps"), FCML_ASM_DIALECT_INSTRUCTION( F_VPERMILPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vperm2f128"), FCML_ASM_DIALECT_INSTRUCTION( F_VPERM2F128, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vperm2i128"), FCML_ASM_DIALECT_INSTRUCTION( F_VPERM2I128, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpermi2w"), FCML_ASM_DIALECT_INSTRUCTION(F_VPERMI2W, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpermi2d"), FCML_ASM_DIALECT_INSTRUCTION(F_VPERMI2D, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpermi2q"), FCML_ASM_DIALECT_INSTRUCTION(F_VPERMI2Q, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpermi2ps"), FCML_ASM_DIALECT_INSTRUCTION(F_VPERMI2PS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpermi2pd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPERMI2PD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpermt2b"), FCML_ASM_DIALECT_INSTRUCTION(F_VPERMT2B, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpermt2w"), FCML_ASM_DIALECT_INSTRUCTION(F_VPERMT2W, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpermt2d"), FCML_ASM_DIALECT_INSTRUCTION(F_VPERMT2D, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpermt2q"), FCML_ASM_DIALECT_INSTRUCTION(F_VPERMT2Q, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpermt2ps"), FCML_ASM_DIALECT_INSTRUCTION(F_VPERMT2PS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpermt2pd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPERMT2PD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpexpandd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPEXPANDD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpexpandq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPEXPANDQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vplzcntd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPLZCNTD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vplzcntq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPLZCNTQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovb2m"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVB2M, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovw2m"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVW2M, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovd2m"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVD2M, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovq2m"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVQ2M, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovm2b"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVM2B, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovm2w"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVM2W, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovm2d"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVM2D, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovm2q"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVM2Q, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovdb"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVDB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovsdb"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVSDB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovusdb"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVUSDB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovdw"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVDW, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovsdw"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVSDW, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovusdw"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVUSDW, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovqb"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVQB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovsqb"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVSQB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovusqb"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVUSQB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovqd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVQD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovsqd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVSQD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovusqd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVUSQD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovqw"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVQW, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovsqw"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVSQW, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovusqw"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVUSQW, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovwb"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVWB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovswb"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVSWB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmovuswb"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMOVUSWB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmultishiftqb"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMULTISHIFTQB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vprolvd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPROLVD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vprolvq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPROLVQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vprold"), FCML_ASM_DIALECT_INSTRUCTION(F_VPROLD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vprolq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPROLQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vprorvd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPRORVD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vprorvq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPRORVQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vprord"), FCML_ASM_DIALECT_INSTRUCTION(F_VPRORD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vprorq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPRORQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpscatterdd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPSCATTERDD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpscatterdq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPSCATTERDQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpscatterqd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPSCATTERQD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpscatterqq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPSCATTERQQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpsllvw"), FCML_ASM_DIALECT_INSTRUCTION(F_VPSLLVW, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpsllvd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPSLLVD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpsllvq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPSLLVQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmadd52huq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMADD52HUQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpmadd52luq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPMADD52LUQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vextracti128"), FCML_ASM_DIALECT_INSTRUCTION( F_VEXTRACTI128, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vinserti128"), FCML_ASM_DIALECT_INSTRUCTION( F_VINSERTI128, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsravw"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSRAVW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsravd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSRAVD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsravq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSRAVQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpermd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPERMD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpermw"), FCML_ASM_DIALECT_INSTRUCTION(F_VPERMW, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpermi2b"), FCML_ASM_DIALECT_INSTRUCTION(F_VPERMI2B, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpermb"), FCML_ASM_DIALECT_INSTRUCTION(F_VPERMB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpternlogd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPTERNLOGD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpternlogq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPTERNLOGQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vptestmb"), FCML_ASM_DIALECT_INSTRUCTION(F_VPTESTMB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vptestmw"), FCML_ASM_DIALECT_INSTRUCTION(F_VPTESTMW, FCML_AM_ALL), 0 },
    { FCML_TEXT("vptestmd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPTESTMD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vptestmq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPTESTMQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vptestnmb"), FCML_ASM_DIALECT_INSTRUCTION(F_VPTESTNMB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vptestnmw"), FCML_ASM_DIALECT_INSTRUCTION(F_VPTESTNMW, FCML_AM_ALL), 0 },
    { FCML_TEXT("vptestnmd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPTESTNMD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vptestnmq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPTESTNMQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrangepd"), FCML_ASM_DIALECT_INSTRUCTION(F_VRANGEPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrangeps"), FCML_ASM_DIALECT_INSTRUCTION(F_VRANGEPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrangesd"), FCML_ASM_DIALECT_INSTRUCTION(F_VRANGESD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrangess"), FCML_ASM_DIALECT_INSTRUCTION(F_VRANGESS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrcp14pd"), FCML_ASM_DIALECT_INSTRUCTION(F_VRCP14PD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrcp14ps"), FCML_ASM_DIALECT_INSTRUCTION(F_VRCP14PS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrcp14sd"), FCML_ASM_DIALECT_INSTRUCTION(F_VRCP14SD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrcp14ss"), FCML_ASM_DIALECT_INSTRUCTION(F_VRCP14SS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vreducepd"), FCML_ASM_DIALECT_INSTRUCTION(F_VREDUCEPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vreduceps"), FCML_ASM_DIALECT_INSTRUCTION(F_VREDUCEPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vreducesd"), FCML_ASM_DIALECT_INSTRUCTION(F_VREDUCESD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vreducess"), FCML_ASM_DIALECT_INSTRUCTION(F_VREDUCESS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrndscalepd"), FCML_ASM_DIALECT_INSTRUCTION(F_VRNDSCALEPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrndscaleps"), FCML_ASM_DIALECT_INSTRUCTION(F_VRNDSCALEPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrndscalesd"), FCML_ASM_DIALECT_INSTRUCTION(F_VRNDSCALESD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrndscaless"), FCML_ASM_DIALECT_INSTRUCTION(F_VRNDSCALESS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrsqrt14pd"), FCML_ASM_DIALECT_INSTRUCTION(F_VRSQRT14PD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrsqrt14ps"), FCML_ASM_DIALECT_INSTRUCTION(F_VRSQRT14PS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrsqrt14sd"), FCML_ASM_DIALECT_INSTRUCTION(F_VRSQRT14SD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrsqrt14ss"), FCML_ASM_DIALECT_INSTRUCTION(F_VRSQRT14SS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscalefpd"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCALEFPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscalefps"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCALEFPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscalefsd"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCALEFSD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscalefss"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCALEFSS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscatterdps"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCATTERDPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscatterdpd"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCATTERDPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscatterqps"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCATTERQPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscatterqpd"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCATTERQPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vshuff32x4"), FCML_ASM_DIALECT_INSTRUCTION(F_VSHUFF32X4, FCML_AM_ALL), 0 },
    { FCML_TEXT("vshuff64x2"), FCML_ASM_DIALECT_INSTRUCTION(F_VSHUFF64X2, FCML_AM_ALL), 0 },
    { FCML_TEXT("vshufi32x4"), FCML_ASM_DIALECT_INSTRUCTION(F_VSHUFI32X4, FCML_AM_ALL), 0 },
    { FCML_TEXT("vshufi64x2"), FCML_ASM_DIALECT_INSTRUCTION(F_VSHUFI64X2, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpsrlvw"), FCML_ASM_DIALECT_INSTRUCTION(F_VPSRLVW, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpsrlvd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSRLVD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpsrlvq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPSRLVQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpermpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPERMPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpermq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPERMQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpermps"), FCML_ASM_DIALECT_INSTRUCTION( F_VPERMPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vtestps"), FCML_ASM_DIALECT_INSTRUCTION( F_VTESTPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vtestpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VTESTPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vgatherdpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VGATHERDPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vgatherqpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VGATHERQPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vgatherdps"), FCML_ASM_DIALECT_INSTRUCTION( F_VGATHERDPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vgatherqps"), FCML_ASM_DIALECT_INSTRUCTION( F_VGATHERQPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpgatherdd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPGATHERDD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpgatherqd"), FCML_ASM_DIALECT_INSTRUCTION( F_VPGATHERQD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpgatherdq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPGATHERDQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpgatherqq"), FCML_ASM_DIALECT_INSTRUCTION( F_VPGATHERQQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vgetexppd"), FCML_ASM_DIALECT_INSTRUCTION(F_VGETEXPPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vgetexpps"), FCML_ASM_DIALECT_INSTRUCTION(F_VGETEXPPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vgetexpsd"), FCML_ASM_DIALECT_INSTRUCTION(F_VGETEXPSD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vgetexpss"), FCML_ASM_DIALECT_INSTRUCTION(F_VGETEXPSS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vgetmantpd"), FCML_ASM_DIALECT_INSTRUCTION(F_VGETMANTPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vgetmantps"), FCML_ASM_DIALECT_INSTRUCTION(F_VGETMANTPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vgetmantsd"), FCML_ASM_DIALECT_INSTRUCTION(F_VGETMANTSD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vgetmantss"), FCML_ASM_DIALECT_INSTRUCTION(F_VGETMANTSS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vinsertf32x4"), FCML_ASM_DIALECT_INSTRUCTION(F_VINSERTF32X4, FCML_AM_ALL), 0 },
    { FCML_TEXT("vinsertf64x2"), FCML_ASM_DIALECT_INSTRUCTION(F_VINSERTF64X2, FCML_AM_ALL), 0 },
    { FCML_TEXT("vinsertf32x8"), FCML_ASM_DIALECT_INSTRUCTION(F_VINSERTF32X8, FCML_AM_ALL), 0 },
    { FCML_TEXT("vinsertf64x4"), FCML_ASM_DIALECT_INSTRUCTION(F_VINSERTF64X4, FCML_AM_ALL), 0 },
    { FCML_TEXT("vinserti32x4"), FCML_ASM_DIALECT_INSTRUCTION(F_VINSERTI32X4, FCML_AM_ALL), 0 },
    { FCML_TEXT("vinserti64x2"), FCML_ASM_DIALECT_INSTRUCTION(F_VINSERTI64X2, FCML_AM_ALL), 0 },
    { FCML_TEXT("vinserti32x8"), FCML_ASM_DIALECT_INSTRUCTION(F_VINSERTI32X8, FCML_AM_ALL), 0 },
    { FCML_TEXT("vinserti64x4"), FCML_ASM_DIALECT_INSTRUCTION(F_VINSERTI64X4, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpblendmb"), FCML_ASM_DIALECT_INSTRUCTION(F_VPBLENDMB, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpblendmw"), FCML_ASM_DIALECT_INSTRUCTION(F_VPBLENDMW, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpblendmd"), FCML_ASM_DIALECT_INSTRUCTION(F_VPBLENDMD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vpblendmq"), FCML_ASM_DIALECT_INSTRUCTION(F_VPBLENDMQ, FCML_AM_ALL), 0 },
    { FCML_TEXT("vzeroall"), FCML_ASM_DIALECT_INSTRUCTION( F_VZEROALL, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vzeroupper"), FCML_ASM_DIALECT_INSTRUCTION( F_VZEROUPPER, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcomb;vpcomltb[p00];vpcomleb[p01];vpcomgtb[p02];vpcomgeb[p03];vpcomeqb[p04];vpcomneqb[p05];vpcomfalseb[p06];vpcomtrueb[p07]"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCOMB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcomw;vpcomltw[p00];vpcomlew[p01];vpcomgtw[p02];vpcomgew[p03];vpcomeqw[p04];vpcomneqw[p05];vpcomfalsew[p06];vpcomtruew[p07]"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCOMW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcomd;vpcomltd[p00];vpcomled[p01];vpcomgtd[p02];vpcomged[p03];vpcomeqd[p04];vpcomneqd[p05];vpcomfalsed[p06];vpcomtrued[p07]"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCOMD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcomq;vpcomltq[p00];vpcomleq[p01];vpcomgtq[p02];vpcomgeq[p03];vpcomeqq[p04];vpcomneqq[p05];vpcomfalseq[p06];vpcomtrueq[p07]"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCOMQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcomub;vpcomltub[p00];vpcomleub[p01];vpcomgtub[p02];vpcomgeub[p03];vpcomequb[p04];vpcomnequb[p05];vpcomfalseub[p06];vpcomtrueub[p07]"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCOMUB, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcomuw;vpcomltuw[p00];vpcomleuw[p01];vpcomgtuw[p02];vpcomgeuw[p03];vpcomequw[p04];vpcomnequw[p05];vpcomfalseuw[p06];vpcomtrueuw[p07]"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCOMUW, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcomud;vpcomltud[p00];vpcomleud[p01];vpcomgtud[p02];vpcomgeud[p03];vpcomequd[p04];vpcomnequd[p05];vpcomfalseud[p06];vpcomtrueud[p07]"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCOMUD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vpcomuq;vpcomltuq[p00];vpcomleuq[p01];vpcomgtuq[p02];vpcomgeuq[p03];vpcomequq[p04];vpcomnequq[p05];vpcomfalseuq[p06];vpcomtrueuq[p07]"), FCML_ASM_DIALECT_INSTRUCTION( F_VPCOMUQ, FCML_AM_ALL ), 0 },
    { FCML_TEXT("wait;fwait"), FCML_ASM_DIALECT_INSTRUCTION( F_WAIT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("wbinvd"), FCML_ASM_DIALECT_INSTRUCTION( F_WBINVD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("wrfsbase"), FCML_ASM_DIALECT_INSTRUCTION( F_WRFSBASE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("wrgsbase"), FCML_ASM_DIALECT_INSTRUCTION( F_WRGSBASE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("wrmsr"), FCML_ASM_DIALECT_INSTRUCTION( F_WRMSR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xlat;xlatb[ts]"), FCML_ASM_DIALECT_INSTRUCTION( F_XLAT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xor"), FCML_ASM_DIALECT_INSTRUCTION( F_XOR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xadd"), FCML_ASM_DIALECT_INSTRUCTION( F_XADD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xchg"), FCML_ASM_DIALECT_INSTRUCTION( F_XCHG, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xgetbv"), FCML_ASM_DIALECT_INSTRUCTION( F_XGETBV, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xorpd"), FCML_ASM_DIALECT_INSTRUCTION( F_XORPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vxorpd"), FCML_ASM_DIALECT_INSTRUCTION( F_VXORPD, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xorps"), FCML_ASM_DIALECT_INSTRUCTION( F_XORPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("vxorps"), FCML_ASM_DIALECT_INSTRUCTION( F_VXORPS, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xrstor"), FCML_ASM_DIALECT_INSTRUCTION( F_XRSTOR, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xrstor64"), FCML_ASM_DIALECT_INSTRUCTION( F_XRSTOR64, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xsave"), FCML_ASM_DIALECT_INSTRUCTION( F_XSAVE, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xsave64"), FCML_ASM_DIALECT_INSTRUCTION( F_XSAVE64, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xsaveopt"), FCML_ASM_DIALECT_INSTRUCTION( F_XSAVEOPT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xsaveopt64"), FCML_ASM_DIALECT_INSTRUCTION( F_XSAVEOPT64, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xsetbv"), FCML_ASM_DIALECT_INSTRUCTION( F_XSETBV, FCML_AM_ALL ), 0 },
    { FCML_TEXT("mulx"), FCML_ASM_DIALECT_INSTRUCTION( F_MULX, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pdep"), FCML_ASM_DIALECT_INSTRUCTION( F_PDEP, FCML_AM_ALL ), 0 },
    { FCML_TEXT("pext"), FCML_ASM_DIALECT_INSTRUCTION( F_PEXT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rorx"), FCML_ASM_DIALECT_INSTRUCTION( F_RORX, FCML_AM_ALL ), 0 },
    { FCML_TEXT("shlx"), FCML_ASM_DIALECT_INSTRUCTION( F_SHLX, FCML_AM_ALL ), 0 },
    { FCML_TEXT("shrx"), FCML_ASM_DIALECT_INSTRUCTION( F_SHRX, FCML_AM_ALL ), 0 },
    { FCML_TEXT("sarx"), FCML_ASM_DIALECT_INSTRUCTION( F_SARX, FCML_AM_ALL ), 0 },
    { FCML_TEXT("tzcnt"), FCML_ASM_DIALECT_INSTRUCTION( F_TZCNT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("tzmsk"), FCML_ASM_DIALECT_INSTRUCTION( F_TZMSK, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xabort"), FCML_ASM_DIALECT_INSTRUCTION( F_XABORT, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xbegin"), FCML_ASM_DIALECT_INSTRUCTION( F_XBEGIN, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xend"), FCML_ASM_DIALECT_INSTRUCTION( F_XEND, FCML_AM_ALL ), 0 },
    { FCML_TEXT("xtest"), FCML_ASM_DIALECT_INSTRUCTION( F_XTEST, FCML_AM_ALL ), 0 },
    { FCML_TEXT("rdseed"), FCML_ASM_DIALECT_INSTRUCTION( F_RDSEED, FCML_AM_ALL ), 0 },
    { FCML_TEXT("clac"), FCML_ASM_DIALECT_INSTRUCTION( F_CLAC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("stac"), FCML_ASM_DIALECT_INSTRUCTION( F_STAC, FCML_AM_ALL ), 0 },
    { FCML_TEXT("v4fmaddps"), FCML_ASM_DIALECT_INSTRUCTION(F_V4FMADDPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("v4fnmaddps"), FCML_ASM_DIALECT_INSTRUCTION(F_V4FNMADDPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("v4fmaddss"), FCML_ASM_DIALECT_INSTRUCTION(F_V4FMADDSS, FCML_AM_ALL), 0 },
    { FCML_TEXT("v4fnmaddss"), FCML_ASM_DIALECT_INSTRUCTION(F_V4FNMADDSS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vexp2pd"), FCML_ASM_DIALECT_INSTRUCTION(F_VEXP2PD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vexp2ps"), FCML_ASM_DIALECT_INSTRUCTION(F_VEXP2PS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vgatherpf0dps"), FCML_ASM_DIALECT_INSTRUCTION(F_VGATHERPF0DPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vgatherpf0qps"), FCML_ASM_DIALECT_INSTRUCTION(F_VGATHERPF0QPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vgatherpf0dpd"), FCML_ASM_DIALECT_INSTRUCTION(F_VGATHERPF0DPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vgatherpf0qpd"), FCML_ASM_DIALECT_INSTRUCTION(F_VGATHERPF0QPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vgatherpf1dps"), FCML_ASM_DIALECT_INSTRUCTION(F_VGATHERPF1DPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vgatherpf1qps"), FCML_ASM_DIALECT_INSTRUCTION(F_VGATHERPF1QPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vgatherpf1dpd"), FCML_ASM_DIALECT_INSTRUCTION(F_VGATHERPF1DPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vgatherpf1qpd"), FCML_ASM_DIALECT_INSTRUCTION(F_VGATHERPF1QPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vp4dpwssds"), FCML_ASM_DIALECT_INSTRUCTION(F_VP4DPWSSDS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vp4dpwssd"), FCML_ASM_DIALECT_INSTRUCTION(F_VP4DPWSSD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrcp28pd"), FCML_ASM_DIALECT_INSTRUCTION(F_VRCP28PD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrcp28sd"), FCML_ASM_DIALECT_INSTRUCTION(F_VRCP28SD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrcp28ps"), FCML_ASM_DIALECT_INSTRUCTION(F_VRCP28PS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrcp28ss"), FCML_ASM_DIALECT_INSTRUCTION(F_VRCP28SS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrsqrt28pd"), FCML_ASM_DIALECT_INSTRUCTION(F_VRSQRT28PD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrsqrt28sd"), FCML_ASM_DIALECT_INSTRUCTION(F_VRSQRT28SD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrsqrt28ps"), FCML_ASM_DIALECT_INSTRUCTION(F_VRSQRT28PS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vrsqrt28ss"), FCML_ASM_DIALECT_INSTRUCTION(F_VRSQRT28SS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscatterpf0dps"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCATTERPF0DPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscatterpf0qps"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCATTERPF0QPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscatterpf0dpd"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCATTERPF0DPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscatterpf0qpd"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCATTERPF0QPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscatterpf1dps"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCATTERPF1DPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscatterpf1qps"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCATTERPF1QPS, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscatterpf1dpd"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCATTERPF1DPD, FCML_AM_ALL), 0 },
    { FCML_TEXT("vscatterpf1qpd"), FCML_ASM_DIALECT_INSTRUCTION(F_VSCATTERPF1QPD, FCML_AM_ALL), 0 },
    { NULL, 0, 0 }
};

/* *********************/
/* * END OF MNEMONICS **/
/* *********************/

fcml_ceh_error fcml_ifn_asm_dialect_get_register_intel(
        const fcml_st_register *reg, fcml_string buffer, fcml_int buffer_length,
        fcml_bool is_rex ) {
    fcml_ceh_error error = FCML_CEH_GEC_NO_ERROR;
    fcml_string printable_reg;

    error = fcml_fn_cmn_dialect_get_register( reg, &printable_reg, is_rex );
    if ( error ) {
        return error;
    }

    fcml_fn_env_str_strncpy( buffer, printable_reg, buffer_length );

    return error;
}

fcml_ceh_error fcml_ifn_asm_dialect_get_parsed_mnemonics_intel(
        const fcml_st_dialect *dialect,
        fcml_st_def_instruction_desc *instruction,
        fcml_st_def_addr_mode_desc *addr_mode,
        fcml_st_mp_mnemonic_set **mnemonics) {

    fcml_string mnemonic_pattern = NULL;

    fcml_uint32_t keys[] = { FCML_ASM_DIALECT_INSTRUCTION(
            instruction->instruction, addr_mode->addr_mode ),
            FCML_ASM_DIALECT_INSTRUCTION(
                    instruction->instruction, FCML_AM_ALL) };

    fcml_st_dialect_context_int *dialect_context =
            (fcml_st_dialect_context_int*) dialect;

    int i;
    for (i = 0; i < sizeof( keys ) / sizeof(fcml_uint32_t) &&
        !mnemonic_pattern; i++) {
        fcml_st_dialect_mnemonic *dialect_mnemonic =
                (fcml_st_dialect_mnemonic*)
                fcml_fn_coll_map_get( dialect_context->dialect_mnemonics_lookup,
                &( keys[i] ) );
        if (dialect_mnemonic) {
            mnemonic_pattern = dialect_mnemonic->mnemonic;
        }
    }

    if (!mnemonic_pattern) {
        /* Choose best mnemonic for instruction.*/
        mnemonic_pattern = instruction->mnemonic;
    }

    return fcml_fn_mp_parse_mnemonics(mnemonic_pattern, mnemonics);
}

/**
 * Gets mnemonics for given addressing mode. This method is used by the
 * assembler in order to get all mnemonics that have to be supported for
 * given addressing mode. Bear in mind that there are addressing
 * modes/instruction forms which have more than one mnemonics available.
 */
fcml_ceh_error fcml_ifn_asm_dialect_get_mnemonic_intel(
        const fcml_st_dialect *dialect,
        fcml_st_def_instruction_desc *instruction,
        fcml_st_def_addr_mode_desc *addr_mode, fcml_st_condition *condition,
        fcml_st_mp_mnemonic **mnemonics, int *mnemonics_counter) {

    fcml_ceh_error error = FCML_CEH_GEC_NO_ERROR;

    fcml_st_mp_mnemonic_set *mnemonic_set;

    error = fcml_ifn_asm_dialect_get_parsed_mnemonics_intel(
            dialect, instruction, addr_mode, &mnemonic_set);
    if ( !error ) {

        error = fcml_fn_cmn_dialect_get_mnemonic(dialect, mnemonic_set,
                mnemonics, condition, mnemonics_counter);

        fcml_fn_mp_free_mnemonics( mnemonic_set );

    }

    return error;
}

fcml_ceh_error fcml_ifn_asm_dialect_assembler_preprocessor_intel(
        const fcml_st_assembler_conf *configuration,
        const fcml_st_dialect *dialect, fcml_st_instruction *instrunction,
        fcml_st_def_addr_mode_desc *addr_mode_desc,
        fcml_en_instruction instruction_code, fcml_st_mp_mnemonic *mnemonic,
        fcml_bool *has_been_changed) {

    fcml_ceh_error error = FCML_CEH_GEC_NO_ERROR;

    fcml_bool changed = FCML_FALSE;

    if (mnemonic) {

        /*
         * In case of Intel dialect, offsets encoded as effective addresses of
         * type OFFSET are always treated as indirect pointers. It means that
         * every time you encode offset as effective address of FCML_AF_OFFSET
         * type it'll be encoded as an indirect pointer. This rule is used to
         * make Intel parser, where the immediate operands are treated as
         * direct pointers and offsets are always interpreted as indirect ones,
         * works as expected.
         */

        /* JMP and CALL needs hint FCML_HINT_INDIRECT_POINTER explicitly set if
         * absolute offsets are used instead of immediate values. It has to be
         * done in order to make a difference between operands encoded as
         * absolute offsets, because without hints they would be assembled to
         * indirect and direct branches.
         */
        if ((instruction_code == F_JMP || instruction_code == F_CALL) &&
                instrunction->operands_count == 1 &&
                instrunction->operands[0].type == FCML_OT_ADDRESS &&
                instrunction->operands[0].address.address_form ==
                        FCML_AF_OFFSET ) {

            if ( !( instrunction->hints & ( FCML_HINT_DIRECT_POINTER |
                    FCML_HINT_FAR_POINTER ) ) ) {
                instrunction->hints |= FCML_HINT_INDIRECT_POINTER;
                changed = FCML_TRUE;
            }

            if ( !( instrunction->hints & FCML_HINT_FAR_POINTER ) ) {
                instrunction->hints |= FCML_HINT_NEAR_POINTER;
                changed = FCML_TRUE;
            }

        }

        if ( has_been_changed ) {
            *has_been_changed = changed;
        }

    }

    return error;
}

fcml_string fcml_fnp_asm_dialect_get_pseudo_operation_mnemonic_intel(
        fcml_en_pseudo_operations pseudo_operation) {
    fcml_string mnemonic = NULL;
    switch ( pseudo_operation ) {
    case FP_DB:
        mnemonic = fcml_fn_env_str_strdup( FCML_TEXT( "db" ) );
        break;
    default:
        break;
    }
    return mnemonic;
}

fcml_st_dialect_pseudpo_operation_mnemonic
fcml_iarr_dialect_pseudpo_operation_mnemonic_intel[] = {
        { "db", FP_DB }, { NULL, FP_NO_PSEUDO_OP }
};

fcml_st_dialect_pseudpo_operation_mnemonic *
fcml_ifn_asm_get_pseudo_operation_mnemonics_intel( void ) {
    return &fcml_iarr_dialect_pseudpo_operation_mnemonic_intel[0];
}

fcml_ceh_error LIB_CALL fcml_fn_dialect_init_intel(fcml_uint32_t config_flags,
        fcml_st_dialect **dialect) {

    fcml_ceh_error error = FCML_CEH_GEC_NO_ERROR;

    fcml_st_dialect_context_int *dialect_context_intel = NULL;

    error = fcml_fn_asm_dialect_alloc_mnemonic_lookup(&dialect_context_intel,
            fcml_arr_dialect_intel_mnemonics,
            sizeof( fcml_arr_dialect_intel_mnemonics ) /
            sizeof(fcml_st_dialect_mnemonic));
    if (error) {
        fcml_fn_env_memory_free(dialect_context_intel);
        return error;
    }

    /* Prepares dialect instance.*/
    dialect_context_intel->get_mnemonic =
            &fcml_ifn_asm_dialect_get_mnemonic_intel;
    dialect_context_intel->get_parsed_mnemonics =
            &fcml_ifn_asm_dialect_get_parsed_mnemonics_intel;
    dialect_context_intel->render_mnemonic =
            &fcml_fn_cmn_dialect_render_mnemonic;
    dialect_context_intel->get_pseudo_operation_mnemonics =
            &fcml_ifn_asm_get_pseudo_operation_mnemonics_intel;
    dialect_context_intel->get_pseudo_operation_mnemonic =
            &fcml_fnp_asm_dialect_get_pseudo_operation_mnemonic_intel;
    dialect_context_intel->free_mnemonic =
            &fcml_fn_asm_dialect_free_mnemonic;
    dialect_context_intel->instruction_renderer =
            &fcml_fn_rend_render_instruction_intel;
    dialect_context_intel->instruction_parser =
            &fcml_fn_intel_parse_instruction_to_ast;
    dialect_context_intel->get_register =
            &fcml_ifn_asm_dialect_get_register_intel;
    dialect_context_intel->free_dialect = &fcml_fn_cmn_dialect_free;
    dialect_context_intel->assembler_preprocessor =
            &fcml_ifn_asm_dialect_assembler_preprocessor_intel;
    dialect_context_intel->disassembler_postprocessor = NULL;

    *dialect = (fcml_st_dialect*) dialect_context_intel;

    return error;

}
