/* $Id: Suspend.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Suspend: suspend the current process (intermediate opcode)
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SUSPEND_HPP_INCLUDED
#define __SUSPEND_HPP_INCLUDED

#include "intermediate/opcodes/OpCode.hpp"

namespace intermediate {

//! suspend the current process
/** This class will signal the kernel/scheduler to suspend the current 
 *  process.
 *
 *  Read Operands: None
 *  Write Operands: None
 *
 *  Operation: Suspend the current process until a wakeup condition 
 *             occurs. If no condition was registered to the scheduler
 *             beforehand, the process will suspend indefinitely.
 */
class Suspend : public OpCode {
public:
	//! c'tor
	Suspend() {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}
};

} /* namespace intermediate */

#endif /* __SUSPEND_HPP_INCLUDED */
