\name{assetsSim}


\alias{assetsSim}


\title{Simulating Multivariate Asset Sets}


\description{
  
    Simulates multivariate artificial data sets of assets, 
    from a multivariate normal, skew normal, or (skew) 
    Student-t distribution. 
  
}
    

\usage{
assetsSim(n, dim = 2, model = list(mu = rep(0, dim), Omega = diag(dim), 
    alpha = rep(0, dim), df = Inf), assetNames = NULL) 
}


\arguments{
  
    \item{n}{
        integer value, the number of data records to be simulated. 
        }
    \item{dim}{
        integer value, the dimension (number of columns) of the assets 
        set.
        }
   \item{model}{
        a list of model parameters: \cr
        \code{mu} a vector of mean values, one for each asset series, \cr
        \code{Omega} the covariance matrix of assets, \cr
        \code{alpha} the skewness vector, and \cr
        \code{df} the number of degrees of freedom which is a measure for
            the fatness of the tails (excess kurtosis). \cr
        For a symmetric distribution \code{alpha} is a vector of zeros.
        For the normal distributions \code{df} is not used and set to 
        infinity, \code{Inf}. Note that all assets have the same value 
        for \code{df}.
        }   
    \item{assetNames}{
        [assetsSim] - \cr
        a vector of character strings of length \code{dim} allowing
        for modifying the names of the individual assets.
        }
        
}


\value{
  
    
    \code{assetsSim()} 
    \cr
    returns a data.frame of simulated assets.

}


\references{

Azzalini A. (1985);
    \emph{A Class of Distributions Which Includes the Normal Ones},
    Scandinavian Journal of Statistics 12, 171--178. 

Azzalini A. (1986);
    \emph{Further Results on a Class of Distributions Which Includes 
        the Normal Ones},
    Statistica 46, 199--208. 

Azzalini A., Dalla Valle A. (1996);
    \emph{The Multivariate Skew-normal Distribution},
    Biometrika 83, 715--726. 

Azzalini A., Capitanio A. (1999);
    \emph{Statistical Applications of the Multivariate Skew-normal 
        Distribution},
    Journal Roy. Statist. Soc. B61, 579--602. 

Azzalini A., Capitanio A. (2003);
    \emph{Distributions Generated by Perturbation of Symmetry with 
        Emphasis on a Multivariate Skew-t Distribution},
    Journal Roy. Statist. Soc. B65, 367--389. 
  
Genz A., Bretz F. (1999);
    \emph{Numerical Computation of Multivariate t-Probabilities
        with Application to Power Calculation of Multiple Contrasts}, 
    Journal of Statistical Computation and Simulation 63, 361--378.

Genz A. (1992);
    \emph{Numerical Computation of Multivariate Normal Probabilities},
    Journal of Computational and Graphical Statistics 1, 141--149.
    
Genz A. (1993); 
    \emph{Comparison of Methods for the Computation of Multivariate
        Normal Probabilities},
    Computing Science and Statistics 25, 400--405.
    
Hothorn T., Bretz F., Genz A. (2001);
    \emph{On Multivariate t and Gauss Probabilities in R},
    R News 1/2, 27--29.
    
Wuertz, D., Chalabi, Y., Chen W., Ellis A. (2009);
    \emph{Portfolio Optimization with R/Rmetrics}, 
    Rmetrics eBook, Rmetrics Association and Finance Online, Zurich.

}


\seealso{

    \code{MultivariateDistribution}.

}


\author{

    Adelchi Azzalini for R's \code{sn} package, \cr
    Torsten Hothorn for R's \code{mtvnorm} package, \cr
    Diethelm Wuertz for the Rmetrics port.
    
}


\examples{

## LPP -
   # Percentual Returns:
   LPP = 100 * as.timeSeries(data(LPP2005REC))[, 1:3]
   colnames(LPP)
   
## assetsFit -
   # Fit a Skew-Student-t Distribution:
   fit = assetsFit(LPP)
   print(fit)
   # Show Model Slot:
   print(fit@model)
   
## assetsSim -
   # Simulate set with same statistical properties:
   set.seed(1953)
   lppSim = assetsSim(n = nrow(LPP), dim = ncol(LPP), model = fit@model)
   colnames(lppSim) <- colnames(LPP)
   rownames(lppSim) <- rownames(LPP)
   head(lppSim)
   head(as.timeSeries(lppSim))
}


\keyword{models}

