/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import java.util.Hashtable;
import java.util.Vector;

public class SequenceFeature {
    public int begin;
    public int end;
    public float score;
    public String type;
    public String description;
    public Hashtable otherDetails;
    public Vector links;
    public String featureGroup;

    public SequenceFeature() {
    }

    public SequenceFeature(SequenceFeature cpy) {
        if (cpy != null) {
            this.begin = cpy.begin;
            this.end = cpy.end;
            this.score = cpy.score;
            if (cpy.type != null) {
                this.type = new String(cpy.type);
            }
            if (cpy.description != null) {
                this.description = new String(cpy.description);
            }
            if (cpy.featureGroup != null) {
                this.featureGroup = new String(cpy.featureGroup);
            }
            if (cpy.otherDetails != null) {
                try {
                    this.otherDetails = (Hashtable)cpy.otherDetails.clone();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (cpy.links != null && cpy.links.size() > 0) {
                this.links = new Vector();
                int iSize = cpy.links.size();
                for (int i = 0; i < iSize; ++i) {
                    this.links.addElement(cpy.links.elementAt(i));
                }
            }
        }
    }

    public SequenceFeature(String type, String desc, String status, int begin, int end, String featureGroup) {
        this.type = type;
        this.description = desc;
        this.setValue("status", status);
        this.begin = begin;
        this.end = end;
        this.featureGroup = featureGroup;
    }

    public SequenceFeature(String type, String desc, int begin, int end, float score, String featureGroup) {
        this.type = type;
        this.description = desc;
        this.begin = begin;
        this.end = end;
        this.score = score;
        this.featureGroup = featureGroup;
    }

    public boolean equals(SequenceFeature sf) {
        if (this.begin != sf.begin || this.end != sf.end || this.score != sf.score) {
            return false;
        }
        return (this.type + this.description + this.featureGroup).equals(sf.type + sf.description + sf.featureGroup);
    }

    public int getBegin() {
        return this.begin;
    }

    public void setBegin(int start) {
        this.begin = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getFeatureGroup() {
        return this.featureGroup;
    }

    public void setFeatureGroup(String featureGroup) {
        this.featureGroup = featureGroup;
    }

    public void addLink(String labelLink) {
        if (this.links == null) {
            this.links = new Vector();
        }
        this.links.insertElementAt(labelLink, 0);
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float value) {
        this.score = value;
    }

    public Object getValue(String key) {
        if (this.otherDetails == null) {
            return null;
        }
        return this.otherDetails.get(key);
    }

    public void setValue(String key, Object value) {
        if (value != null) {
            if (this.otherDetails == null) {
                this.otherDetails = new Hashtable();
            }
            this.otherDetails.put(key, value);
        }
    }

    public void setStatus(String status) {
        this.setValue("status", status);
    }

    public String getStatus() {
        String stat;
        if (this.otherDetails != null && (stat = (String)this.otherDetails.get("status")) != null) {
            return new String(stat);
        }
        return null;
    }

    public void setPosition(int pos) {
        this.begin = pos;
        this.end = pos;
    }

    public int getPosition() {
        return this.begin;
    }
}

