/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __oscilloscope
#define __oscilloscope

#include "box.h"
#include "ui.h"

struct oscilloscope : ui {

  static const int MAX_SAMPLES = 512;

  int num_samples;

  void add_samples (float* outl, float* outr, int n);

  struct sample_t {
    static float lmin, lmax; // current min/max of left channel
    static float rmin, rmax; // current min/max of right channel
    float left, right; // stereo pair
    sample_t () {left = right = 0;}
  } samples [MAX_SAMPLES];

  int paused;
  int visible;
  void toggle_pause ();
  void toggle_visible ();

  int viewr;
  int addr;

  oscilloscope ();
  ~oscilloscope ();
  bool load_last ();
  bool save_last ();

  box<int> win, pick_win;
  float* vertex_array;
  float* color_array;
  float lr, lg, lb;
  float rr, rg, rb;
  int leftx, rightx, endx, base, ndraw;
  void calc_draw_params ();

  void draw ();

  bool handle_input ();

};
#endif
