"""Backends to communicate with."""
from .mprm import Mprm

MESSAGE_TYPES = {
    "devolo.BinarySensor": "_binary_sensor",
    "devolo.BinarySwitch": "_binary_switch",
    "devolo.Blinds": "_multi_level_switch",
    "devolo.DevicesPage": "_inspect_devices",
    "devolo.DewpointSensor": "_multi_level_sensor",
    "devolo.Dimmer": "_multi_level_switch",
    "devolo.Grouping": "_grouping",
    "devolo.HumidityBarValue": "_humidity_bar",
    "devolo.HumidityBarZone": "_humidity_bar",
    "devolo.mprm.gw.GatewayAccessibilityFI": "_gateway_accessible",
    "devolo.Meter": "_meter",
    "devolo.MildewSensor": "_binary_sensor",
    "devolo.MultiLevelSensor": "_multi_level_sensor",
    "devolo.MultiLevelSwitch": "_multi_level_switch",
    "devolo.RemoteControl": "_remote_control",
    "devolo.SirenMultiLevelSwitch": "_multi_level_switch",
    "devolo.ShutterMovementFI": "_binary_sensor",
    "devolo.ValveTemperatureSensor": "_multi_level_sensor",
    "devolo.VoltageMultiLevelSensor": "_multi_level_sensor",
    "devolo.WarningBinaryFI": "_binary_sensor",
    "hdm": "_device_state",
    "acs.hdm": "_automatic_calibration",
    "bas.hdm": "_binary_async",
    "bss.hdm": "_binary_sync",
    "cps.hdm": "_parameter",
    "gds.hdm": "_general_device",
    "lis.hdm": "_led",
    "mas.hdm": "_multilevel_async",
    "mss.hdm": "_multilevel_sync",
    "ps.hdm": "_protection",
    "stmss.hdm": "_multilevel_sync",
    "sts.hdm": "_switch_type",
    "trs.hdm": "_temperature_report",
    "vfs.hdm": "_led",
}

__all__ = ["MESSAGE_TYPES", "Mprm"]
