/*
    Copyright (C) 2008-2010 Stefan Haller

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <config.h>
#include <glib.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-bindings.h>
#include "dbus-services.h"
#include "dbus-server.h"
#include "../desktopnova-daemon/desktopnova-daemon.h"
#include "dbus-server-bindings.h"

#ifdef USE_DBUS

/* g_debug prints PID, but the output in our test-case must be static */
#ifdef DBUS_TEST_SERVER
#undef g_debug
#define g_debug g_message
#endif

DBusGConnection * dbus_connection = NULL;
DBusServer * dbus_server = NULL;

static guint signals[LAST_SIGNAL] = { 0 };

G_DEFINE_TYPE(DBusServer, dbus_server, G_TYPE_OBJECT);

void init_dbus()
{
	GError * error = NULL;

	dbus_connection = dbus_g_bus_get(DBUS_BUS_SESSION, &error);
	if (dbus_connection == NULL)
	{
		g_warning("Unable to connect to dbus: %s", error->message);
		g_error_free (error);
		return;
	}

	dbus_server = g_object_new(dbus_server_get_type(), NULL);
}

void dbus_server_class_init(DBusServerClass * klass)
{
	signals[SIGNAL_CHANGED] =
		g_signal_new ("changed",
		              G_OBJECT_CLASS_TYPE(klass),
		              G_SIGNAL_RUN_LAST,
		              0,
		              NULL, NULL,
		              g_cclosure_marshal_VOID__VOID,
		              G_TYPE_NONE,
		              1, G_TYPE_STRING);
}

void dbus_server_init(DBusServer * self)
{
	GError * error = NULL;
	DBusGProxy * driver_proxy;
	guint request_ret;


	dbus_g_object_type_install_info(dbus_server_get_type(),
	                                &dbus_glib_server_object_info);

	dbus_g_connection_register_g_object(dbus_connection,
	                                    DESKTOPNOVA_DBUS_PATH, G_OBJECT(self));

	driver_proxy = dbus_g_proxy_new_for_name(dbus_connection,
	                                         DBUS_SERVICE_DBUS, DBUS_PATH_DBUS,
	                                         DBUS_INTERFACE_DBUS);

	if (!org_freedesktop_DBus_request_name(driver_proxy,
	    DESKTOPNOVA_DBUS_SERVICE, 0, &request_ret, &error))
	{
		g_warning("Unable to register service: %s", error->message);
		g_error_free(error);
	}

	g_object_unref (driver_proxy);

}

gboolean dbus_server_next(DBusServer * self, GError ** error)
{
	#if DEBUG || DBUS_TEST_SERVER
	g_debug("Method-Call: dbus_server_next");
	#endif

	#ifndef DBUS_TEST_SERVER
	next_wallpaper();
	#endif
	return TRUE;
}

gboolean dbus_server_previous(DBusServer * self, GError ** error)
{
	#if DEBUG || DBUS_TEST_SERVER
	g_debug("Method-Call: dbus_server_previous");
	#endif

	#ifndef DBUS_TEST_SERVER
	previous_wallpaper();
	#endif
	return TRUE;
}

void emit_changed(const gchar * filename)
{
	g_signal_emit(dbus_server, signals[SIGNAL_CHANGED], 0, filename);
}

#endif
