/*
  DB Mixer
  ========
  Description: 
    a DJ Mixer style GUI interface to the DBMix system.

	Copyright (c) 1999, 2000 Robert Michael S Dean

	Author: Robert Michael S Dean
	Version: 1.0


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <limits.h>
#include <fcntl.h>
#include <signal.h>
#include <gtk/gtk.h>

#include "dbmixer.h"
#include <dbdebug.h>

extern int standalone_flag;

extern int debug_level;
extern GtkWidget* window;

static gint standalone_cleanup(GtkWidget* window, GdkEventAny* e, gpointer data)
{
	Debug("Got delete_event... calling cleanup()...");
	cleanup();

	return TRUE;
}


int main( int argc, char *argv[] )
{
	debug_level = 0;

#ifdef DBMIX_DEBUG
	debug_level = 1;
	printf("Debugging is on.\n");
#else
	debug_level = 0;
#endif	

    gtk_init(&argc, &argv);

	init();

	gtk_signal_connect(GTK_OBJECT(window),"delete_event",
					   GTK_SIGNAL_FUNC(standalone_cleanup),NULL);

	standalone_flag = 1;

	gtk_main();

	return(0);
}
