# Lenovo M920 Tiny

This page describes how to run coreboot on Lenovo M920 Tiny (M920q, M920x).

## Technology

```{eval-rst}
+------------+---------------------------------------------------------------+
| CPU        | Intel Core 8th Gen  or 9th Gen (Coffee Lake (Refresh))        |
+------------+---------------------------------------------------------------+
| DRAM       | 2 SO-DIMM slots, DDR4-2400/2666                               |
+------------+---------------------------------------------------------------+
| Chipset    | Intel Q370                                                    |
+------------+---------------------------------------------------------------+
| Super I/O  | NCT6686D-L                                                    |
+------------+---------------------------------------------------------------+
| TPM        | Infineon SLB 9670VQ2.0                                        |
+------------+---------------------------------------------------------------+
| Boot       | USB, SATA (on-board SATA1 port, M.2 ports), NVMe              |
+------------+---------------------------------------------------------------+
| Power      | 65-135 W power adapter                                        |
+------------+---------------------------------------------------------------+
```

More specifications on [Lenovo M920 Tiny specifications].

## Flashing coreboot

```{eval-rst}
+---------------------+--------------------------+
| Type                | Value                    |
+=====================+==========================+
| Socketed flash      | no                       |
+---------------------+--------------------------+
| Model               | W25Q128JV + W25Q64JV     |
+---------------------+--------------------------+
| Size                | 16 + 8 MiB               |
+---------------------+--------------------------+
| Package             | SOIC-8 + SOIC-8          |
+---------------------+--------------------------+
| Write protection    | chipset PRR              |
+---------------------+--------------------------+
| Dual BIOS feature   | no                       |
+---------------------+--------------------------+
| Internal flashing   | after flashing coreboot  |
+---------------------+--------------------------+
```

### Internal programming

The SPI flash can be accessed using [flashrom].

    flashrom -p internal -N -w coreboot.rom --ifd -i bios

Internal programming can be used after the coreboot has been flashed externally
for the first time. Internal programming when migrating from original UEFI
firmware **has not been tested**.

### External programming

The external access to flash chip is available through standard SOP-8 clip. The
voltage of both SPI chips is 3.3V.

It is recommended to flash firmware without supplying power from power adapter.

The resulting coreboot.rom file must be split into two binaries, one for each
flash chip:

    dd if=build/coreboot.rom of=build/coreboot_flash_1.rom bs=16M count=1
    dd if=build/coreboot.rom of=build/coreboot_flash_2.rom bs=8M skip=2

The flash chips are marked on the mainboard as BIOS1 and BIOS2 respectively.
They can be flashed with following commands:

    flashrom -p ch341a_spi -w build/coreboot_flash_1.rom
    flashrom -p ch341a_spi -w build/coreboot_flash_2.rom -c "W25Q64JV-.Q"

## Known issues

- front audio jacks do not work

## Working

Tested with edk2 payload (mrchromebox) and Ubuntu 22.04 (Linux 6.2.0):

- Serial adapter from daughter board (COM1 connector)
- USB 3.0 and 2.0 rear and front ports (edk2 and Linux 6.2.0)
- USB-C port (charging, data)
- Gigabit Ethernet
- SATA
- internal speaker
- TPM2.0
- WiFi slot
- HDMI
- NVMe
- PCIe x8 port
  - PCIe x8 tested using BA7H70 Rev 1.2 riser and Intel X540-T2 10G dual 10GbE card
  - another riser with PCIe x4 connector remains untested - please modify this
    page if you do test it!

[flashrom]: https://flashrom.org/Flashrom
[Lenovo M920 Tiny specifications]: https://psref.lenovo.com/syspool/Sys/PDF/ThinkCentre/ThinkCentre_M920_Tiny/ThinkCentre_M920_Tiny_Spec.PDF
