# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-

"""Tests for PageUpdate"""

from autopilot.matchers import Eventually
from testtools.matchers import Equals

import click_update_manager


class PageUpdateTestCase(click_update_manager.ClickUpdateManagerTestCase):
    """Page Update Tests."""

    def test_loading_disappear(self):
        """Check the loading indicator disappears"""

        loading = self.main_view.select_single(objectName="loadingIndicator")
        self.assertThat(loading.visible, Eventually(Equals(False)))

    def test_check_again(self):
        """Check the loading indicator disappears"""

        loading = self.main_view.select_single(objectName="loadingIndicator")
        self.assertThat(loading.visible, Eventually(Equals(False)))
        retry_button = self.main_view.select_single(objectName="retryButton")
        self.pointing_device.click_object(retry_button)
        self.assertThat(loading.visible, Eventually(Equals(True)))
        self.assertThat(loading.visible, Eventually(Equals(False)))
