#
# This file shows how to create a custom value dump systems.
#
# A dumper is a function that writes the dump to a file.
#

def dump_plain(cfget, outfd, paths):
    """
    Dump values as "key: value"
    """
    for key, value in cfget.iteritems(paths):
        print >>outfd, "%s: %s" % (key, value)

def init(db):
    """
    This function is called by cfget when it loads this file as a plugin.

    The parameter 'db' is the main cfget engine, to which we can attach
    parsers, template engines and dump functions.
    """

    # Add the new dump engine. The name is used in --dump=NAME
    db.add_dumper("plain", dump_plain)
