/*
Copyright (C) 2003-2004 Douglas Thain and the University of Wisconsin
Copyright (C) 2005- The University of Notre Dame
This software is distributed under the GNU General Public License.
See the file COPYING for details.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

char *findformat(char *type)
{
	if(!strcmp(type, "char")) {
		return "hh";
	} else if(!strcmp(type, "short")) {
		return "h";
	} else if(!strcmp(type, "int")) {
		return "";
	} else if(!strcmp(type, "long long")) {
		return "ll";
	} else if(!strcmp(type, "long")) {
		return "l";
	} else {
		fprintf(stderr, "*** I don't understand type %s!\n", type);
		abort();
		return 0;
	}
}

char *findtype(int size)
{
	if(size == 8 * sizeof(char)) {
		return "char";
	} else if(size == 8 * sizeof(short)) {
		return "short";
	} else if(size == 8 * sizeof(int)) {
		return "int";
	} else if(size == 8 * sizeof(long long)) {
		return "long long";
	} else if(size == 8 * sizeof(long)) {
		return "long";
	} else {
		fprintf(stderr, "*** this machine has no type matching %d bits!\n", size);
		abort();
		return 0;
	}
}


int main(int argc, char *argv[])
{
	printf("/* This file is automatically generated. */\n");
	printf("#ifndef INT_SIZES_H\n");
	printf("#define INT_SIZES_H\n");
	printf("\n");
	printf("#define INT8_T %s\n", findtype(8));
	printf("#define INT16_T %s\n", findtype(16));
	printf("#define INT32_T %s\n", findtype(32));
	printf("#define INT64_T %s\n", findtype(64));
	printf("#define PTRINT_T %s\n", findtype(sizeof(char *) * 8));
	printf("\n");
	printf("#define INT8_FORMAT \"%%%sd\"\n", findformat(findtype(8)));
	printf("#define INT16_FORMAT \"%%%sd\"\n", findformat(findtype(16)));
	printf("#define INT32_FORMAT \"%%%sd\"\n", findformat(findtype(32)));
	printf("#define INT64_FORMAT \"%%%sd\"\n", findformat(findtype(64)));
	printf("#define PTR_FORMAT \"%%%sx\"\n", findformat(findtype(sizeof(char *) * 8)));
	printf("\n");
	printf("#define UINT8_T unsigned %s\n", findtype(8));
	printf("#define UINT16_T unsigned %s\n", findtype(16));
	printf("#define UINT32_T unsigned %s\n", findtype(32));
	printf("#define UINT64_T unsigned %s\n", findtype(64));
	printf("#define UPTRINT_T unsigned %s\n", findtype(sizeof(char *) * 8));
	printf("\n");
	printf("#define UINT8_FORMAT \"%%%su\"\n", findformat(findtype(8)));
	printf("#define UINT16_FORMAT \"%%%su\"\n", findformat(findtype(16)));
	printf("#define UINT32_FORMAT \"%%%su\"\n", findformat(findtype(32)));
	printf("#define UINT64_FORMAT \"%%%su\"\n", findformat(findtype(64)));
	printf("#define UPTR_FORMAT \"%%%sx\"\n", findformat(findtype(sizeof(char *) * 8)));
	printf("#endif\n");
	return 0;
}

/* vim: set noexpandtab tabstop=4: */
