#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <iostream>

#include "./canlxx.h"

int main(void) {

  AuthN::Context ctx(AuthN::Context::ClientMinimalContext);//EmptyContext);
  if((bool)ctx) {
    std::cout<<"Cert: "<<ctx.GetCertPath()<<std::endl;
    std::cout<<"Key: "<<ctx.GetKeyPath()<<std::endl;
    std::cout<<"CA: "<<ctx.GetCAPath()<<std::endl;

    AuthN::CACredentialsRequest cacredreq(ctx);
    int keybits = 1024;
    cacredreq.MakeKeys(keybits);
    std::string conf_file = "./openssl.cnf";
    if(cacredreq.MakeRequest() != AuthN::Status(0)) { std::cout<<"Failed to make CA cert request"<<std::endl; }
    else { 
      std::cout<<"Succeeded to make cert request"<<std::endl; 
      std::string str;
      cacredreq.GetRequest(str);
      std::cout<<str<<std::endl;
      
      //Sign a CA certificate
      AuthN::Context ctx1(AuthN::Context::EmptyContext);
      AuthN::Credentials cred(ctx1);
      AuthN::Credentials out(ctx1);
      cacredreq.SetValidFrom(time(NULL));
      cacredreq.SetValidTill(time(NULL) + 3600*24*365);
      AuthN::Status stat = cred.Sign(cacredreq, out, conf_file);
      if(stat != AuthN::Status(0)) std::cout<<"Failed to sign a CA certificate"<<std::endl;

      std::string ca_str;
      cred.GetCertificate(ca_str);
      std::cout<<ca_str<<std::endl;

      std::string out_str;
      out.GetCertificate(out_str);
      std::cout<<out_str<<std::endl;

      //Sign an EEC certificate, using the CA just generated
      AuthN::CredentialsRequest eecreq(ctx);
      eecreq.MakeKeys(keybits);
      if(eecreq.MakeRequest() != AuthN::Status(0)) { std::cout<<"Failed to make cert request"<<std::endl; }

      std::string priv_str;
      cred.GetPrivateKey(priv_str, false);
      std::cout<<"private key of CA"<<priv_str<<std::endl;

      AuthN::Credentials eec(ctx1);
      eecreq.SetValidFrom(time(NULL));
      eecreq.SetValidTill(time(NULL) + 3600*12);
      stat = cred.Sign(eecreq, eec, conf_file);
      if(stat != AuthN::Status(0)) std::cout<<"Failed to sign an EEC certificate"<<std::endl;

      std::string eec_str;
      eec.GetCertificate(eec_str);
      std::cout<<eec_str<<std::endl;

      //Sign a proxy certificate, using the EEC certiticate just generated
      AuthN::ProxyCredentialsRequest proxyreq(ctx);
      proxyreq.MakeKeys(keybits);
      if(proxyreq.MakeRequest() != AuthN::Status(0)) { std::cout<<"Failed to make proxy cert request"<<std::endl; }
      AuthN::Credentials::Extension policy;
      policy.value = "my test proxy policy my test proxy policy";
      proxyreq.SetPolicy(policy);

      std::string eec_priv_str;
      eec.GetPrivateKey(eec_priv_str, false);
      std::cout<<"private key of EEC"<<eec_priv_str<<std::endl;

      std::string proxy_req_str;
      proxyreq.GetRequest(proxy_req_str);
      std::cout<<"Proxy cert request: "<<proxy_req_str<<std::endl;

      AuthN::Credentials proxy(ctx1);
      proxyreq.SetValidFrom(time(NULL));
      proxyreq.SetValidTill(time(NULL) + 3600*12);
      stat = eec.Sign(proxyreq, proxy, conf_file);
      if(stat != AuthN::Status(0)) std::cout<<"Failed to sign an proxy certificate"<<std::endl;

      std::string proxy_str;
      proxy.GetCertificate(proxy_str);
      std::cout<<proxy_str<<std::endl;

    }

  }
  return 0;
}
