//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/RegionOfInterestView.h
//! @brief     Defines RegionOfInterestView class
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_MASK_REGIONOFINTERESTVIEW_H
#define BORNAGAIN_GUI_VIEW_MASK_REGIONOFINTERESTVIEW_H

#include "GUI/View/Mask/RectangleView.h"

class RegionOfInterestItem;

//! The RegionOfInterest class represent view of RegionOfInterestItem on graphics scene.

class RegionOfInterestView : public RectangleView {
    Q_OBJECT

public:
    int type() const override { return MaskEditorHelper::REGIONOFINTEREST; }

    explicit RegionOfInterestView(RegionOfInterestItem* item);

    QRectF boundingRect() const override;

protected slots:
    void update_view() override;

protected:
    void paint(QPainter* painter, const QStyleOptionGraphicsItem*, QWidget*) override;
};

#endif // BORNAGAIN_GUI_VIEW_MASK_REGIONOFINTERESTVIEW_H
