//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Import/RealDataPresenter.cpp
//! @brief     Implements class RealDataPresenter
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Import/RealDataPresenter.h"
#include "Base/Util/Assert.h"
#include "GUI/View/Import/RealDataMaskWidget.h"
#include "GUI/View/Plot2D/IntensityDataWidget.h"
#include "GUI/View/PlotSpecular/SpecularDataWidget.h"
#include "GUI/View/Projection/IntensityDataProjectionsWidget.h"

RealDataPresenter::RealDataPresenter(QWidget* parent)
    : ItemComboWidget(parent)
{
    registerWidget("Heat Map", create_new<IntensityDataWidget>);
    registerWidget("Projections", create_new<IntensityDataProjectionsWidget>);
    registerWidget("Mask Editor", create_new<RealDataMaskWidget>);
    registerWidget("Reflectometry (Graph only)", create_new<SpecularDataWidget>);
}

QString RealDataPresenter::itemPresentation() const
{
    if (!realItem())
        return ItemComboWidget::selectedPresentation();

    if (realItem()->presentationType().isEmpty())
        return ItemComboWidget::itemPresentation();

    return realItem()->presentationType();
}

void RealDataPresenter::setPresentation(const QString& presentationType)
{
    ItemComboWidget::setPresentation(presentationType);
    if (realItem() && !presentationType.isEmpty())
        realItem()->setPresentationType(presentationType);
}

QStringList RealDataPresenter::activePresentationList() const
{
    ASSERT(realItem());

    QStringList result;
    if (realItem()->isIntensityData())
        result << "Heat Map"
               << "Projections"
               << "Mask Editor";
    else if (realItem()->isSpecularData()) {
        result << "Reflectometry (Graph only)";
    } else
        ASSERT(false);
    return result;
}
