#line 2 "beancount/parser/lexer.c"

/* Includes. */
#include <math.h>
#include <stdlib.h>

#include "parser.h"
#include "grammar.h"

/* Build and accumulate an error on the builder object. */
void build_lexer_error(const char* string, size_t length);

/* Build and accumulate an error on the builder object using the current
 * exception state. */
void build_lexer_error_from_exception(void);

/* Callback call site with error handling. */
#define BUILD_LEX(method_name, format, ...)                                             \
    yylval->pyobj = PyObject_CallMethod(builder, method_name, format, __VA_ARGS__);     \
    /* Handle a Python exception raised by the handler {3cfb2739349a} */                \
    if (yylval->pyobj == NULL) {                                                        \
       build_lexer_error_from_exception();                                              \
       return LEX_ERROR;                                                                \
    }                                                                                   \
    /* Lexer builder methods should never return None, check for it. */                 \
    else if (yylval->pyobj == Py_None) {                                                \
        Py_DECREF(Py_None);                                                             \
        build_lexer_error("Unexpected None result from lexer", 34);                     \
        return LEX_ERROR;                                                               \
    }

/* Initialization/finalization methods. These are separate from the yylex_init()
 * and yylex_destroy() and they call them. */
void yylex_initialize(const char* filename, const char* encoding);
void yylex_finalize(void);

/* Global declarations; defined below. */
extern int yy_eof_times;
extern const char* yy_filename;
extern int yycolumn;
extern const char* yy_encoding;

/* String buffer statics. */
extern size_t strbuf_size; /* Current buffer size (not including final nul). */
extern char* strbuf;       /* Current buffer head. */
extern char* strbuf_end;   /* Current buffer sentinel (points to the final nul). */
extern char* strbuf_ptr;   /* Current insertion point in buffer. */
void strbuf_realloc(size_t num_new_chars);

/* Handle detecting the beginning of line. */
extern int yy_line_tokens; /* Number of tokens since the bol. */

#define YY_USER_ACTION  {                               \
    yy_line_tokens++;                                   \
    yylloc->first_line = yylloc->last_line = yylineno;  \
    yylloc->first_column = yycolumn;                    \
    yylloc->last_column = yycolumn+yyleng-1;            \
    yycolumn += yyleng;                                 \
  }

/* Skip the rest of the input line. */
int yy_skip_line(void);

/* Utility functions. */
int strtonl(const char* buf, size_t nchars);

/* Append characters to the static string buffer and verify. */
#define SAFE_COPY_CHAR(value)                    \
	if (strbuf_ptr >= strbuf_end) {         \
            strbuf_realloc(1);                  \
	}                                       \
        *strbuf_ptr++ = value;

#line 75 "beancount/parser/lexer.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yyget_lval
#define yyget_lval_ALREADY_DEFINED
#else
#define yyget_lval yyget_lval
#endif

#ifdef yyset_lval
#define yyset_lval_ALREADY_DEFINED
#else
#define yyset_lval yyset_lval
#endif

#ifdef yyget_lloc
#define yyget_lloc_ALREADY_DEFINED
#else
#define yyget_lloc yyget_lloc
#endif

#ifdef yyset_lloc
#define yyset_lloc_ALREADY_DEFINED
#else
#define yyset_lloc yyset_lloc
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex.
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define yywrap() (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 62
#define YY_END_OF_BUFFER 63
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[348] =
    {   0,
        0,    0,    0,    0,    0,    0,   63,   60,    2,    1,
       21,   47,   17,   15,   16,   18,   12,   10,   13,   14,
       56,   19,   20,    5,   60,   21,   60,   60,   21,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,    8,    3,    9,   11,   60,   60,   60,   60,   60,
       60,   60,   60,   61,   62,   55,   48,   62,    2,   57,
        0,   56,   56,   20,   20,    4,    0,    0,   46,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   46,
       46,   46,   58,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        6,    7,    0,    0,    0,    0,    0,    0,    0,    0,
       61,   55,   54,   52,   53,   49,   51,   50,   56,   56,
       56,    0,   46,    0,   46,   45,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,   46,   46,   46,   59,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   27,    0,    0,    0,    0,
        0,   22,    0,    0,    0,   56,    0,   46,    0,   46,
       45,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   46,
       43,   41,    0,    0,    0,    0,    0,    0,    0,   32,

       24,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       56,    0,   46,    0,   46,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   42,    0,   25,    0,
        0,    0,   28,    0,    0,    0,    0,    0,   31,    0,
        0,   29,    0,    0,   46,    0,   46,    0,    0,    0,
       45,    0,    0,   30,    0,    0,   38,   39,    0,   35,
        0,    0,    0,    0,   46,    0,   46,   45,   23,    0,
        0,   40,   37,    0,   34,   44,    0,   46,    0,   46,
        0,   33,   36,    0,   46,    0,   46,   26,    0,   46,
        0,   46,    0,   46,    0,   46,    0,   46,    0,   46,

        0,   46,    0,   46,    0,   46,    0,   46,    0,   46,
        0,   46,    0,   46,    0,   46,    0,   46,    0,   46,
        0,   46,    0,   46,    0,   46,    0,   46,    0,   46,
        0,   46,    0,   46,    0,   46,    0,   46,    0,   46,
        0,   46,    0,   46,   46,   46,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    1,    4,    4,    7,    8,
        9,   10,   11,   12,   13,   14,   15,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   17,   18,    1,
        1,    1,    4,   19,   20,   21,   22,   21,   23,   24,
       21,   21,   21,   21,   21,   25,   22,   26,   21,   22,
       21,   27,   28,   29,   30,   21,   21,   21,   21,   21,
        1,   31,    1,   32,   33,    1,   34,   35,   36,   37,

       38,   39,   40,   41,   42,   43,   43,   44,   45,   46,
       47,   48,   49,   50,   51,   52,   53,   54,   43,   55,
       56,   43,   57,   58,   59,   60,    1,   61,   61,   61,
       61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   61,   61,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   63,
       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
       63,    1,    1,   64,   64,   64,   64,   64,   64,   64,

       64,   64,   64,   64,   64,   64,   64,   64,   64,   64,
       64,   64,   64,   64,   64,   64,   64,   64,   64,   64,
       64,   64,   64,   65,   66,   66,   66,   66,   66,   66,
       66,   66,   66,   66,   66,   66,   67,   68,   68,   69,
       70,   70,   70,   71,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[72] =
    {   0,
        1,    2,    3,    1,    4,    1,    5,    1,    1,    1,
        1,    1,    6,    7,    8,    9,   10,    1,    1,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        4,    1,   11,   12,   12,   12,   12,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   12,   12,   12,
       12,   12,   12,   12,   12,   12,    1,    1,    1,    1,
        1,    1,    1,   13,   13,   13,   13,   13,   13,   13,
       13
    } ;

static const flex_int16_t yy_base[381] =
    {   0,
        0,    0,   70,   72,   71,   72,  804, 1521,  800, 1521,
     1521, 1521,    0, 1521, 1521, 1521, 1521, 1521, 1521, 1521,
       66, 1521,  778,  772,   97,    0,  770,  759,  761,    0,
        0,  753,   37,  737,  729,  736,  734,  732,   45,  719,
      715,  697, 1521,  694, 1521,   24,  689,   38,   32,   44,
       34,   93,  689,    0, 1521,    0, 1521,  134,  743,    0,
       96,  728,  158,    0,  725, 1521,  164,  191,    0,  123,
      218,   96,  664,  120,   54,  138,   66,  147,  665,  700,
      698,  688,    0,  700,  158,  159,  178,  179,  143,   71,
      186,  209,  211,  216,  212,  210,  218,  219,  233,  220,

     1521, 1521,    0,  193,  206,  211,  214,  217,  220,  223,
        0,    0, 1521, 1521, 1521, 1521, 1521, 1521,  275,  700,
      276,  286,  288,  315,    0,  240,  235,  636,  251,  254,
      262,  255,  271,  635,  288,  291,  294,  297,  300,  303,
      306,  665,  667,  666, 1521,  286,  329,  330,  242,  353,
      354,  355,  356,  357,  359,  669,  362,  360,  361,  366,
      364,  667,  323,  326,  329,  403,  397,  413,  440,    0,
      411,  360,  620,  370,  265,  373,  333,  376,  621,  379,
      382,  387,  396,  422,  425,  428,  431,  434,  437,  653,
        0,    0,  455,  391,  408,  457,  407,  454,  485,  658,

      652,  486,  488,  490,  491,  493,  492,  494,    0,  606,
      500,  510,  513,  544,    0,  473,  478,  486,  491,  500,
      517,  520,  523,  526,  529,    0,    0,  539,  600,  376,
      559,  504,  597,  576,  577,  578,  579,  505,  595,  580,
      581,  542,  586,  593,  596,  625,    0,  558,  572,  581,
        0,  599,  588,  512,  594,  619,  502,  501,  591,  434,
      610,  515,  393,  652,  654,  681,    0,    0,  381,  611,
      639,  365,  313,  643,  247,  246,  657,  665,  708,    0,
      656,  235,  168,  667,  706,  735,    0,   74,  733,  760,
      787,    0,  762,  764,  814,    0,  772,  785,  841,    0,

      812,  839,  868,    0,  866,  893,  920,    0,  895,  897,
      947,    0,  905,  918,  974,    0,  945,  972, 1001,    0,
      999, 1026, 1053,    0, 1028, 1030, 1080,    0, 1038, 1051,
     1107,    0, 1078, 1105, 1134,    0, 1132, 1159, 1186,    0,
        0,    0, 1213,    0, 1521, 1231, 1521, 1261, 1274, 1282,
     1294, 1302, 1309, 1321, 1334, 1347, 1356, 1359, 1368, 1374,
     1383, 1390, 1397, 1404, 1411, 1418, 1425, 1432, 1439, 1446,
     1453, 1460, 1467, 1474, 1481, 1488, 1495, 1502, 1509,   74
    } ;

static const flex_int16_t yy_def[381] =
    {   0,
      347,    1,  348,  348,  349,  349,  347,  347,  347,  347,
      347,  347,  350,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  351,  347,  347,   25,   25,   25,   25,  352,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  354,  347,  355,  347,  356,  347,  350,
      347,  347,  347,  351,  351,  347,  357,   25,   68,  358,
       68,  347,  347,  347,  347,  347,  347,  347,  347,   68,
       68,   68,  352,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,

      347,  347,   71,  347,  347,  347,  347,  347,  347,  347,
      354,  355,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  359,  359,   71,  124,  360,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  124,  124,  124,  347,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  347,  347,  347,  347,  361,  361,  124,  169,
      360,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  169,
      169,  169,  353,  353,  353,  353,  353,  353,  353,  353,

      353,  353,  353,  353,  353,  353,  353,  353,   71,  347,
      347,  362,  362,   71,  214,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,   71,  214,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  347,  363,  363,  214,  246,  347,  347,  347,
      171,  353,  353,  353,  353,  353,  353,  353,  353,  353,
      353,  353,  347,  364,  364,  246,  266,  171,  353,  353,
      353,  353,  353,  353,  353,  347,  365,  365,  266,  279,
      353,  353,  353,  366,  366,  279,  286,  353,  367,  367,
      286,  291,  368,  368,  291,  295,  369,  369,  295,  299,

      370,  370,  299,  303,  371,  371,  303,  307,  372,  372,
      307,  311,  373,  373,  311,  315,  374,  374,  315,  319,
      375,  375,  319,  323,  376,  376,  323,  327,  377,  377,
      327,  331,  378,  378,  331,  335,  379,  379,  335,  339,
      380,  380,  339,  343,  347,  343,    0,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347
    } ;

static const flex_int16_t yy_nxt[1593] =
    {   0,
        8,    9,   10,   11,   12,   13,    8,   14,   15,   16,
       17,   18,   19,    8,   20,   21,   22,   23,   24,   25,
       25,   26,   25,   27,   25,   28,   26,   26,   29,   26,
        8,   30,    8,   31,   32,   33,   34,   35,   31,   31,
       31,   36,   31,   31,   31,   37,   38,   39,   40,   31,
       31,   41,   31,   31,   31,   31,   42,   43,   44,   45,
        8,    8,    8,   46,   47,   48,   49,   50,   51,   52,
       53,   55,   55,   55,   55,   57,   57,   61,   94,   62,
       86,   63,  345,   87,  103,  103,  103,  145,   95,   88,
      145,   96,  106,  106,   97,  108,  108,   98,  105,  105,

      105,   58,   58,   67,  107,  107,  107,   61,  151,   68,
       67,  119,   69,   70,  137,  137,   69,   69,   69,   69,
       69,   69,   69,   69,   69,   69,   69,  139,  139,   67,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,  109,  109,  109,   71,   71,   71,  145,
       72,   73,   74,   75,   76,   77,   78,   79,  114,   61,
      122,   62,  115,  121,  145,  145,  122,  122,  150,  116,
      136,  136,  136,  117,  145,  118,  127,  128,  129,  130,
      131,  132,  133,  134,  145,  145,  122,  122,  138,  138,

      138,  146,  145,  124,  122,  147,  125,  140,  140,  140,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  152,  148,  122,  347,  145,  145,  145,  145,  149,
       71,  347,  145,   71,  145,  145,  145,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,  154,  145,
      347,  145,  156,  103,  103,  103,   70,  158,  145,  159,
      153,  276,  155,  145,  157,  162,  103,  103,  103,  160,
      161,  103,  103,  103,  103,  103,  103,  163,  163,  163,
      164,  164,  164,  165,  165,  165,   61,   61,   62,   62,
      119,  166,  167,  196,  167,  126,  126,  126,  167,  167,

      167,  167,  145,  172,  173,  174,  175,  176,  177,  178,
      179,  181,  181,  181,  182,  182,  184,  184,  167,  193,
      167,  167,  183,  183,  183,  218,  218,  169,  167,  145,
      170,  185,  185,  185,  170,  170,  170,  170,  170,  170,
      170,  170,  170,  170,  170,  145,  145,  167,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
      187,  187,  187,  188,  188,  188,  189,  189,  189,  145,
      145,  145,  145,  145,  195,  145,  145,  145,  145,  194,
      145,  145,  145,  209,  209,  209,  209,  209,  209,  209,
      209,  209,  145,  200,  220,  220,  206,  145,  199,  198,

      202,  203,  201,  212,  204,  197,  207,  145,  276,  212,
      212,  205,  253,  208,   61,  210,   62,  210,  211,  212,
      171,  171,  171,  145,  145,  212,  212,   70,  229,  212,
      217,  217,  217,  219,  219,  219,  221,  221,  221,  126,
      126,  126,  126,  126,  126,  212,  212,  126,  126,  126,
      145,  232,  214,  212,  230,  215,  126,  126,  126,  215,
      215,  215,  215,  215,  215,  215,  215,  215,  215,  215,
      145,  145,  212,  145,  172,  173,  174,  175,  176,  177,
      178,  179,  223,  223,  223,  224,  224,  224,  225,  225,
      225,  226,  226,  226,  226,  226,  226,  226,  226,  226,

      228,  145,  145,  231,  145,  233,  145,  145,  145,  145,
      145,   61,  210,   62,  210,  211,  244,  145,  145,  244,
      145,  145,  244,  244,  238,  244,  244,  237,  145,  236,
      239,  145,  235,  171,  171,  171,  240,  234,  171,  171,
      171,  255,  244,  241,  260,  244,  171,  171,  171,  242,
      244,  171,  171,  171,  275,  145,  246,  244,  145,  247,
      248,  248,  248,  247,  247,  247,  247,  247,  247,  247,
      247,  247,  247,  247,  252,  145,  244,  249,  249,  249,
      250,  250,  250,  251,  251,  251,  251,  251,  251,  251,
      251,  251,  145,  145,  145,  145,  145,  145,  263,  264,

      263,  243,  264,  254,  145,  264,  264,  145,  264,  264,
      145,  145,  256,  145,  262,  145,  145,  261,  268,  268,
      268,  243,  257,  258,  273,  264,  145,  145,  264,  270,
      259,  264,  268,  268,  268,  145,  269,  266,  264,  271,
      267,  268,  268,  268,  267,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  145,  272,  264,  277,  145,
      277,  274,  281,  284,  277,  277,  277,  277,  145,  284,
      284,  284,  145,  289,  145,  227,  283,  284,  284,  289,
      289,  222,  216,  145,  277,  145,  277,  277,  192,  284,
      282,  191,  190,  279,  277,  186,  280,  284,  180,  289,

      280,  280,  280,  280,  280,  280,  280,  280,  280,  280,
      280,  288,  289,  277,  284,  120,  145,  144,  289,  289,
      286,  284,  143,  287,  142,  141,  135,  287,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  289,  293,
      284,  289,   65,  120,   59,  293,  293,  291,  289,  110,
      292,  104,  102,  101,  292,  292,  292,  292,  292,  292,
      292,  292,  292,  292,  292,  293,  293,  289,  297,  100,
      297,   99,  293,  293,  297,  297,  297,  297,  301,   93,
       92,   91,   90,   89,  301,  301,   85,   82,   81,   80,
       66,  301,  293,  293,  297,   65,  297,  301,  301,  295,

      293,   59,  296,  347,  301,  347,  296,  296,  296,  296,
      296,  296,  296,  296,  296,  296,  296,  301,  305,  293,
      297,  347,  347,  347,  305,  305,  299,  297,  347,  300,
      347,  347,  347,  300,  300,  300,  300,  300,  300,  300,
      300,  300,  300,  300,  305,  305,  297,  301,  347,  347,
      347,  305,  305,  303,  301,  347,  304,  347,  347,  347,
      304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
      304,  305,  309,  301,  305,  347,  347,  347,  309,  309,
      307,  305,  347,  308,  347,  347,  347,  308,  308,  308,
      308,  308,  308,  308,  308,  308,  308,  308,  309,  309,

      305,  313,  347,  313,  347,  309,  309,  313,  313,  313,
      313,  317,  347,  347,  347,  347,  347,  317,  317,  347,
      347,  347,  347,  347,  317,  309,  309,  313,  347,  313,
      317,  317,  311,  309,  347,  312,  347,  317,  347,  312,
      312,  312,  312,  312,  312,  312,  312,  312,  312,  312,
      317,  321,  309,  313,  347,  347,  347,  321,  321,  315,
      313,  347,  316,  347,  347,  347,  316,  316,  316,  316,
      316,  316,  316,  316,  316,  316,  316,  321,  321,  313,
      317,  347,  347,  347,  321,  321,  319,  317,  347,  320,
      347,  347,  347,  320,  320,  320,  320,  320,  320,  320,

      320,  320,  320,  320,  321,  325,  317,  321,  347,  347,
      347,  325,  325,  323,  321,  347,  324,  347,  347,  347,
      324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
      324,  325,  325,  321,  329,  347,  329,  347,  325,  325,
      329,  329,  329,  329,  333,  347,  347,  347,  347,  347,
      333,  333,  347,  347,  347,  347,  347,  333,  325,  325,
      329,  347,  329,  333,  333,  327,  325,  347,  328,  347,
      333,  347,  328,  328,  328,  328,  328,  328,  328,  328,
      328,  328,  328,  333,  337,  325,  329,  347,  347,  347,
      337,  337,  331,  329,  347,  332,  347,  347,  347,  332,

      332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
      337,  337,  329,  333,  347,  347,  347,  337,  337,  335,
      333,  347,  336,  347,  347,  347,  336,  336,  336,  336,
      336,  336,  336,  336,  336,  336,  336,  337,  341,  333,
      337,  347,  347,  347,  341,  341,  339,  337,  347,  340,
      347,  347,  347,  340,  340,  340,  340,  340,  340,  340,
      340,  340,  340,  340,  341,  341,  337,  347,  347,  347,
      347,  341,  341,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  341,  341,  347,  347,  347,  347,  347,  343,  341,

      347,  344,  347,  347,  347,  344,  344,  344,  344,  344,
      344,  344,  344,  344,  344,  344,  347,  347,  341,  347,
      347,  347,  347,  347,  347,   71,  347,  347,  346,  347,
      347,  347,  346,  346,  346,  346,  346,  346,  346,  346,
      346,  346,  346,  347,  347,  347,   71,  347,  347,  347,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   54,   54,   54,   54,   54,   54,   54,   54,   54,
       54,   54,   54,   54,   56,   56,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   60,   60,   60,
       60,  347,   60,   60,   64,   64,  347,   64,   64,   64,

       64,   64,   64,   64,   64,   64,   64,   83,   83,   83,
       83,  347,   83,   83,   84,  347,  347,   84,  347,   84,
       84,  111,  347,  347,  111,  111,  111,  111,  111,  111,
      111,  111,  111,  111,  112,  112,  112,  347,  112,  112,
      112,  112,  112,  112,  112,  112,  112,  113,  113,  113,
      113,  113,  113,  113,  113,  113,  113,  113,  113,  113,
      123,  123,  123,  347,  123,  347,  123,  126,  347,  347,
      347,  126,  168,  168,  168,  347,  168,  347,  168,  171,
      347,  347,  171,  171,  347,  171,  171,  213,  213,  213,
      347,  213,  347,  213,  245,  245,  245,  347,  245,  347,

      245,  265,  265,  265,  347,  265,  347,  265,  278,  278,
      278,  347,  278,  347,  278,  285,  285,  285,  347,  285,
      347,  285,  290,  290,  290,  347,  290,  347,  290,  294,
      294,  294,  347,  294,  347,  294,  298,  298,  298,  347,
      298,  347,  298,  302,  302,  302,  347,  302,  347,  302,
      306,  306,  306,  347,  306,  347,  306,  310,  310,  310,
      347,  310,  347,  310,  314,  314,  314,  347,  314,  347,
      314,  318,  318,  318,  347,  318,  347,  318,  322,  322,
      322,  347,  322,  347,  322,  326,  326,  326,  347,  326,
      347,  326,  330,  330,  330,  347,  330,  347,  330,  334,

      334,  334,  347,  334,  347,  334,  338,  338,  338,  347,
      338,  347,  338,  342,  342,  342,  347,  342,  347,  342,
        7,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347

    } ;

static const flex_int16_t yy_chk[1593] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    3,    3,    4,    4,    5,    6,   21,   39,   21,
       33,   21,  380,   33,   46,   46,   46,   90,   39,   33,
      288,   39,   49,   49,   39,   51,   51,   39,   48,   48,

       48,    5,    6,   25,   50,   50,   50,   61,   90,   25,
       25,   61,   25,   25,   75,   75,   25,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   77,   77,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   25,   52,   52,   52,   72,   72,   72,   89,
       25,   25,   25,   25,   25,   25,   25,   25,   58,   63,
       67,   63,   58,   63,   85,   86,   67,   67,   89,   58,
       74,   74,   74,   58,  283,   58,   70,   70,   70,   70,
       70,   70,   70,   70,   87,   88,   67,   68,   76,   76,

       76,   85,   91,   68,   68,   86,   68,   78,   78,   78,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   91,   87,   68,   71,   92,   96,   93,   95,   88,
       71,   71,   94,   71,   97,   98,  100,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   93,   99,
       71,  282,   94,  104,  104,  104,  126,   96,  149,   97,
       92,  276,   93,  275,   95,  100,  105,  105,  105,   98,
       99,  106,  106,  106,  107,  107,  107,  108,  108,  108,
      109,  109,  109,  110,  110,  110,  119,  121,  119,  121,
      119,  121,  122,  149,  123,  127,  127,  127,  122,  122,

      123,  123,  146,  126,  126,  126,  126,  126,  126,  126,
      126,  129,  129,  129,  130,  130,  132,  132,  122,  146,
      123,  124,  131,  131,  131,  175,  175,  124,  124,  273,
      124,  133,  133,  133,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  147,  148,  124,  135,  135,
      135,  136,  136,  136,  137,  137,  137,  138,  138,  138,
      139,  139,  139,  140,  140,  140,  141,  141,  141,  150,
      151,  152,  153,  154,  148,  155,  158,  159,  157,  147,
      161,  272,  160,  163,  163,  163,  164,  164,  164,  165,
      165,  165,  230,  153,  177,  177,  159,  269,  152,  151,

      155,  157,  154,  167,  158,  150,  160,  194,  263,  167,
      167,  158,  230,  161,  166,  166,  166,  166,  166,  168,
      172,  172,  172,  197,  195,  168,  168,  171,  194,  167,
      174,  174,  174,  176,  176,  176,  178,  178,  178,  180,
      180,  180,  181,  181,  181,  168,  169,  182,  182,  182,
      260,  197,  169,  169,  195,  169,  183,  183,  183,  169,
      169,  169,  169,  169,  169,  169,  169,  169,  169,  169,
      198,  193,  169,  196,  171,  171,  171,  171,  171,  171,
      171,  171,  184,  184,  184,  185,  185,  185,  186,  186,
      186,  187,  187,  187,  188,  188,  188,  189,  189,  189,

      193,  199,  202,  196,  203,  198,  204,  205,  207,  206,
      208,  211,  211,  211,  211,  211,  212,  258,  257,  213,
      232,  238,  212,  212,  205,  213,  213,  204,  254,  203,
      206,  262,  202,  216,  216,  216,  207,  199,  217,  217,
      217,  232,  212,  207,  238,  213,  218,  218,  218,  208,
      214,  219,  219,  219,  262,  228,  214,  214,  242,  214,
      220,  220,  220,  214,  214,  214,  214,  214,  214,  214,
      214,  214,  214,  214,  228,  231,  214,  221,  221,  221,
      222,  222,  222,  223,  223,  223,  224,  224,  224,  225,
      225,  225,  234,  235,  236,  237,  240,  241,  243,  244,

      243,  243,  245,  231,  253,  244,  244,  259,  245,  245,
      255,  239,  234,  233,  241,  252,  229,  240,  248,  248,
      248,  210,  235,  236,  259,  244,  261,  270,  245,  253,
      237,  246,  249,  249,  249,  256,  252,  246,  246,  255,
      246,  250,  250,  250,  246,  246,  246,  246,  246,  246,
      246,  246,  246,  246,  246,  271,  256,  246,  264,  274,
      265,  261,  270,  277,  264,  264,  265,  265,  201,  277,
      277,  278,  281,  284,  200,  190,  274,  278,  278,  284,
      284,  179,  173,  162,  264,  156,  265,  266,  144,  277,
      271,  143,  142,  266,  266,  134,  266,  278,  128,  284,

      266,  266,  266,  266,  266,  266,  266,  266,  266,  266,
      266,  281,  285,  266,  279,  120,   84,   82,  285,  285,
      279,  279,   81,  279,   80,   79,   73,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  285,  289,
      279,  286,   65,   62,   59,  289,  289,  286,  286,   53,
      286,   47,   44,   42,  286,  286,  286,  286,  286,  286,
      286,  286,  286,  286,  286,  289,  290,  286,  293,   41,
      294,   40,  290,  290,  293,  293,  294,  294,  297,   38,
       37,   36,   35,   34,  297,  297,   32,   29,   28,   27,
       24,  298,  290,  291,  293,   23,  294,  298,  298,  291,

      291,    9,  291,    7,  297,    0,  291,  291,  291,  291,
      291,  291,  291,  291,  291,  291,  291,  298,  301,  291,
      295,    0,    0,    0,  301,  301,  295,  295,    0,  295,
        0,    0,    0,  295,  295,  295,  295,  295,  295,  295,
      295,  295,  295,  295,  301,  302,  295,  299,    0,    0,
        0,  302,  302,  299,  299,    0,  299,    0,    0,    0,
      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  302,  305,  299,  303,    0,    0,    0,  305,  305,
      303,  303,    0,  303,    0,    0,    0,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  305,  306,

      303,  309,    0,  310,    0,  306,  306,  309,  309,  310,
      310,  313,    0,    0,    0,    0,    0,  313,  313,    0,
        0,    0,    0,    0,  314,  306,  307,  309,    0,  310,
      314,  314,  307,  307,    0,  307,    0,  313,    0,  307,
      307,  307,  307,  307,  307,  307,  307,  307,  307,  307,
      314,  317,  307,  311,    0,    0,    0,  317,  317,  311,
      311,    0,  311,    0,    0,    0,  311,  311,  311,  311,
      311,  311,  311,  311,  311,  311,  311,  317,  318,  311,
      315,    0,    0,    0,  318,  318,  315,  315,    0,  315,
        0,    0,    0,  315,  315,  315,  315,  315,  315,  315,

      315,  315,  315,  315,  318,  321,  315,  319,    0,    0,
        0,  321,  321,  319,  319,    0,  319,    0,    0,    0,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  321,  322,  319,  325,    0,  326,    0,  322,  322,
      325,  325,  326,  326,  329,    0,    0,    0,    0,    0,
      329,  329,    0,    0,    0,    0,    0,  330,  322,  323,
      325,    0,  326,  330,  330,  323,  323,    0,  323,    0,
      329,    0,  323,  323,  323,  323,  323,  323,  323,  323,
      323,  323,  323,  330,  333,  323,  327,    0,    0,    0,
      333,  333,  327,  327,    0,  327,    0,    0,    0,  327,

      327,  327,  327,  327,  327,  327,  327,  327,  327,  327,
      333,  334,  327,  331,    0,    0,    0,  334,  334,  331,
      331,    0,  331,    0,    0,    0,  331,  331,  331,  331,
      331,  331,  331,  331,  331,  331,  331,  334,  337,  331,
      335,    0,    0,    0,  337,  337,  335,  335,    0,  335,
        0,    0,    0,  335,  335,  335,  335,  335,  335,  335,
      335,  335,  335,  335,  337,  338,  335,    0,    0,    0,
        0,  338,  338,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  338,  339,    0,    0,    0,    0,    0,  339,  339,

        0,  339,    0,    0,    0,  339,  339,  339,  339,  339,
      339,  339,  339,  339,  339,  339,    0,    0,  339,  343,
        0,    0,    0,    0,    0,  343,  343,    0,  343,    0,
        0,    0,  343,  343,  343,  343,  343,  343,  343,  343,
      343,  343,  343,    0,    0,  343,  346,    0,    0,    0,
      346,  346,  346,  346,  346,  346,  346,  346,  346,  346,
      346,  348,  348,  348,  348,  348,  348,  348,  348,  348,
      348,  348,  348,  348,  349,  349,  349,  349,  349,  349,
      349,  349,  349,  349,  349,  349,  349,  350,  350,  350,
      350,    0,  350,  350,  351,  351,    0,  351,  351,  351,

      351,  351,  351,  351,  351,  351,  351,  352,  352,  352,
      352,    0,  352,  352,  353,    0,    0,  353,    0,  353,
      353,  354,    0,    0,  354,  354,  354,  354,  354,  354,
      354,  354,  354,  354,  355,  355,  355,    0,  355,  355,
      355,  355,  355,  355,  355,  355,  355,  356,  356,  356,
      356,  356,  356,  356,  356,  356,  356,  356,  356,  356,
      357,  357,  357,    0,  357,    0,  357,  358,    0,    0,
        0,  358,  359,  359,  359,    0,  359,    0,  359,  360,
        0,    0,  360,  360,    0,  360,  360,  361,  361,  361,
        0,  361,    0,  361,  362,  362,  362,    0,  362,    0,

      362,  363,  363,  363,    0,  363,    0,  363,  364,  364,
      364,    0,  364,    0,  364,  365,  365,  365,    0,  365,
        0,  365,  366,  366,  366,    0,  366,    0,  366,  367,
      367,  367,    0,  367,    0,  367,  368,  368,  368,    0,
      368,    0,  368,  369,  369,  369,    0,  369,    0,  369,
      370,  370,  370,    0,  370,    0,  370,  371,  371,  371,
        0,  371,    0,  371,  372,  372,  372,    0,  372,    0,
      372,  373,  373,  373,    0,  373,    0,  373,  374,  374,
      374,    0,  374,    0,  374,  375,  375,  375,    0,  375,
        0,  375,  376,  376,  376,    0,  376,    0,  376,  377,

      377,  377,    0,  377,    0,  377,  378,  378,  378,    0,
      378,    0,  378,  379,  379,  379,    0,  379,    0,  379,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
      347,  347

    } ;

/* Table of booleans, true if rule could match eol. */
static const flex_int32_t yy_rule_can_match_eol[63] =
    {   0,
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 
    0, 0, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "beancount/parser/lexer.l"
/* -*- mode: c -*- */
/* A flex lexer for Beancount. */
/*--------------------------------------------------------------------------------------*/
/* Definitions */
/* Options */
/* %option nodefault */
/* %option reentrant */
/* %option debug */
/* %option stack */
/* %option 8bit */
/* Top Code. */

/* A start condition for chomping an invalid token. */

/* Exclusive start condition for parsing escape sequences in string literals. */

/*--------------------------------------------------------------------------------------*/
/* Rules */
#line 1059 "beancount/parser/lexer.c"

#define INITIAL 0
#define INVALID 1
#define STRLIT 2

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

YYSTYPE * yyget_lval ( void );

void yyset_lval ( YYSTYPE * yylval_param  );

       YYLTYPE *yyget_lloc ( void );
    
        void yyset_lloc ( YYLTYPE * yylloc_param  );
    
/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param );

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param )
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
        YYSTYPE * yylval;
    
        YYLTYPE * yylloc;
    
    yylval = yylval_param;

    yylloc = yylloc_param;

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 128 "beancount/parser/lexer.l"



#line 132 "beancount/parser/lexer.l"
 /* Newlines are output as explicit tokens, because lines matter in the syntax. */
#line 1302 "beancount/parser/lexer.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 348 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 347 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					
    yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 133 "beancount/parser/lexer.l"
{
    yy_line_tokens = 0;
    yycolumn = 1;
    return EOL;
}
	YY_BREAK
/* Ignore whitespace, except when found at the beginning of a line
    and followed by a regular character. This is how we detect an
    initial indent and thus group postings and comments together in
    the grammar. */
case 2:
YY_RULE_SETUP
#line 143 "beancount/parser/lexer.l"
{
    if ( yy_line_tokens == 1 ) {
        /* If the next character completes the line, skip it. */
        if ( yy_hold_char == '\n' ||
             yy_hold_char == '\r' ||
             yy_hold_char == '\0' ) {
            return SKIPPED;
        }
        else {
            return INDENT;
        }
    }
}
	YY_BREAK
/* Characters with special meanings have their own tokens. */
case 3:
YY_RULE_SETUP
#line 158 "beancount/parser/lexer.l"
{ return PIPE; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 159 "beancount/parser/lexer.l"
{ return ATAT; }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 160 "beancount/parser/lexer.l"
{ return AT; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 161 "beancount/parser/lexer.l"
{ return LCURLCURL; }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 162 "beancount/parser/lexer.l"
{ return RCURLCURL; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 163 "beancount/parser/lexer.l"
{ return LCURL; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 164 "beancount/parser/lexer.l"
{ return RCURL; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 165 "beancount/parser/lexer.l"
{ return COMMA; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 166 "beancount/parser/lexer.l"
{ return TILDE; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 167 "beancount/parser/lexer.l"
{ return PLUS; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 168 "beancount/parser/lexer.l"
{ return MINUS; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 169 "beancount/parser/lexer.l"
{ return SLASH; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 170 "beancount/parser/lexer.l"
{ return LPAREN; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 171 "beancount/parser/lexer.l"
{ return RPAREN; }
	YY_BREAK
/* Special handling for characters beginning a line to be ignored.
  * I'd like to improve how this is handled. Needs own lexer, really. */
case 17:
YY_RULE_SETUP
#line 175 "beancount/parser/lexer.l"
{
    if ( yy_line_tokens != 1 ) {
        return HASH;
    }
    else {
        /* Allow org-mode titles. */
        yy_skip_line();
        return SKIPPED;
    }
}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 186 "beancount/parser/lexer.l"
{
    if ( yy_line_tokens != 1 ) {
        return ASTERISK;
    }
    else {
        /* Allow org-mode titles. */
        yy_skip_line();
        return SKIPPED;
    }
}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 197 "beancount/parser/lexer.l"
{
  if (yy_line_tokens != 1) {
    return COLON;
  }
  else {
    /* Allow org-mode drawers. */
    yy_skip_line();
    return SKIPPED;
  }
}
	YY_BREAK
/* Skip commented output (but not the accompanying newline). */
case 20:
YY_RULE_SETUP
#line 209 "beancount/parser/lexer.l"
{
    /* yy_skip_line(); */
    return COMMENT;
}
	YY_BREAK
/* Special characters which may be used in-lieu of a 'txn' keyword in a
    transaction declaration output as a token. Other lines are just skipped.
    This allows us to use org-mode or other separators in the input syntax.

    Note: You need to make sure to include all the values from
    beancount.core.flags, in order for round-trips between text and entries to
    be possible. {5307d8fa1e7b}
    */
case 21:
YY_RULE_SETUP
#line 222 "beancount/parser/lexer.l"
{
    if ( yy_line_tokens != 1 ) {
        yylval->character = yytext[0];
        return FLAG;
    }
    else {
        yy_skip_line();
        return SKIPPED;
    }
}
	YY_BREAK
/* Keywords. */
case 22:
YY_RULE_SETUP
#line 234 "beancount/parser/lexer.l"
{ return TXN; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 235 "beancount/parser/lexer.l"
{ return BALANCE; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 236 "beancount/parser/lexer.l"
{ return OPEN; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 237 "beancount/parser/lexer.l"
{ return CLOSE; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 238 "beancount/parser/lexer.l"
{ return COMMODITY; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 239 "beancount/parser/lexer.l"
{ return PAD; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 240 "beancount/parser/lexer.l"
{ return EVENT; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 241 "beancount/parser/lexer.l"
{ return QUERY; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 242 "beancount/parser/lexer.l"
{ return CUSTOM; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 243 "beancount/parser/lexer.l"
{ return PRICE; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 244 "beancount/parser/lexer.l"
{ return NOTE; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 245 "beancount/parser/lexer.l"
{ return DOCUMENT; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 246 "beancount/parser/lexer.l"
{ return PUSHTAG; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 247 "beancount/parser/lexer.l"
{ return POPTAG; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 248 "beancount/parser/lexer.l"
{ return PUSHMETA; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 249 "beancount/parser/lexer.l"
{ return POPMETA; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 250 "beancount/parser/lexer.l"
{ return OPTION; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 251 "beancount/parser/lexer.l"
{ return PLUGIN; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 252 "beancount/parser/lexer.l"
{ return INCLUDE; }
	YY_BREAK
/* Boolean values. */
case 41:
YY_RULE_SETUP
#line 255 "beancount/parser/lexer.l"
{
    yylval->pyobj = Py_True;
    Py_INCREF(Py_True);
    return BOOL;
}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 261 "beancount/parser/lexer.l"
{
    yylval->pyobj = Py_False;
    Py_INCREF(Py_False);
    return BOOL;
}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 267 "beancount/parser/lexer.l"
{
    yylval->pyobj = Py_None;
    Py_INCREF(Py_None);
    return NONE;
}
	YY_BREAK
/* Dates. */
case 44:
YY_RULE_SETUP
#line 274 "beancount/parser/lexer.l"
{
    const char* year_str;
    const char* month_str;
    const char* day_str;
    int year, month, day;

    /* Parse the numbers. */
    year_str = yytext;
    month_str = strpbrk(year_str, "-/");
    year = strtonl(year_str, month_str - year_str);
    month_str++;
    day_str = strpbrk(month_str, "-/");
    month = strtonl(month_str, day_str - month_str);
    day_str++;
    day = strtonl(day_str, yytext + yyleng - day_str);

    /* Attempt to create the date. */
    BUILD_LEX("DATE", "iii", year, month, day);
    return DATE;
}
	YY_BREAK
/* Account names. */
case 45:
YY_RULE_SETUP
#line 296 "beancount/parser/lexer.l"
{
    BUILD_LEX("ACCOUNT", "s", yytext);
    return ACCOUNT;
}
	YY_BREAK
/* Currencies. These are defined as uppercase only in order to disambiguate the
  * syntax. This is kept in sync with beancount.core.amount.CURRENCY_RE. */
case 46:
YY_RULE_SETUP
#line 303 "beancount/parser/lexer.l"
{
    BUILD_LEX("CURRENCY", "s", yytext);
    return CURRENCY;
}
	YY_BREAK
/* String literals. */
/* Note that we use an exclusive start condition.
    See section "Start Conditions" in the GNU Flex manual. */
case 47:
YY_RULE_SETUP
#line 311 "beancount/parser/lexer.l"
{
    strbuf_ptr = strbuf;
    BEGIN(STRLIT);
}
	YY_BREAK

/* Saw closing quote - all done. */
case 48:
YY_RULE_SETUP
#line 319 "beancount/parser/lexer.l"
{
        BEGIN(INITIAL);
        *strbuf_ptr = '\0';
        PyObject* unicode_str = PyUnicode_Decode(strbuf, strbuf_ptr - strbuf,
                                                 yy_encoding, "ignore");
        if ( unicode_str == NULL ) {
            build_lexer_error_from_exception();
            yylval->pyobj = Py_None;
            Py_INCREF(Py_None);
            return LEX_ERROR;
        }
        BUILD_LEX("STRING", "O", unicode_str);
        Py_DECREF(unicode_str);
        strbuf_ptr = NULL;
        return STRING;
    }
	YY_BREAK
/* Escape sequences. */
case 49:
YY_RULE_SETUP
#line 337 "beancount/parser/lexer.l"
SAFE_COPY_CHAR('\n');
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 338 "beancount/parser/lexer.l"
SAFE_COPY_CHAR('\t');
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 339 "beancount/parser/lexer.l"
SAFE_COPY_CHAR('\r');
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 340 "beancount/parser/lexer.l"
SAFE_COPY_CHAR('\b');
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 341 "beancount/parser/lexer.l"
SAFE_COPY_CHAR('\f');
	YY_BREAK
case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
#line 342 "beancount/parser/lexer.l"
SAFE_COPY_CHAR(yytext[1]);
	YY_BREAK
/* All other characters. */
case 55:
/* rule 55 can match eol */
YY_RULE_SETUP
#line 345 "beancount/parser/lexer.l"
{
        if ( yyleng > (strbuf_end - strbuf_ptr) ) {
            strbuf_realloc(yyleng);
        }
        ssize_t i;
        for (i = 0; i < yyleng; ++i) {
            *strbuf_ptr++ = yytext[i];
        }
    }
	YY_BREAK

/* Numbers */
case 56:
YY_RULE_SETUP
#line 357 "beancount/parser/lexer.l"
{
    BUILD_LEX("NUMBER", "s", yytext);
    return NUMBER;
}
	YY_BREAK
/* Tags */
case 57:
YY_RULE_SETUP
#line 363 "beancount/parser/lexer.l"
{
    BUILD_LEX("TAG", "s", &(yytext[1]));
    return TAG;
}
	YY_BREAK
/* Links */
case 58:
YY_RULE_SETUP
#line 369 "beancount/parser/lexer.l"
{
    BUILD_LEX("LINK", "s", &(yytext[1]));
    return LINK;
}
	YY_BREAK
/* Key */
case 59:
YY_RULE_SETUP
#line 375 "beancount/parser/lexer.l"
{
    BUILD_LEX("KEY", "s#", yytext, (Py_ssize_t)(yyleng-1));
    unput(':');
    return KEY;
}
	YY_BREAK
/* Default rule. {bf253a29a820} */
case 60:
YY_RULE_SETUP
#line 382 "beancount/parser/lexer.l"
{
    unput(*yytext);
    BEGIN(INVALID);
}
	YY_BREAK
/* Fake an EOL at the end of file, to ensure that files without a final newline
  * will process postings right. */
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(INVALID):
case YY_STATE_EOF(STRLIT):
#line 389 "beancount/parser/lexer.l"
{
  if ( yy_eof_times == 0 ) {
    yy_eof_times = 1;
    yylloc->first_line = yylineno;
    return EOL;
  }
  return 0;
}
	YY_BREAK
/* Note: We use a subparser here because if we set a default rule to chomp this
    pattern, it would take precedence over valid rules if the matched text is
    longer and thus would break the lexer. Writing our own lexer would fix
    this and more. {bba169a1d35a} */
case 61:
YY_RULE_SETUP
#line 402 "beancount/parser/lexer.l"
{
    char buffer[256];
    size_t length = snprintf(buffer, 256, "Invalid token: '%s'", yytext);
    build_lexer_error(buffer, length);
    BEGIN(INITIAL);
    return LEX_ERROR;
}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 411 "beancount/parser/lexer.l"
ECHO;
	YY_BREAK
#line 1872 "beancount/parser/lexer.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 348 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 348 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 347);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --yylineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		
    yylineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    /* We do not touch yylineno unless the option is enabled. */
    yylineno =  1;
    
    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 411 "beancount/parser/lexer.l"

/*--------------------------------------------------------------------------------------*/
/* User Code */


/* Note: All these globals should be moved to an yylex_extra */

/* The number of times EOF has been hit. This is used to synthesize an EOL at
 * the end of the file. */
int yy_eof_times = 0;

/* The filename being tokenized. */
const char* yy_filename = 0;

/* Number of tokens since the beginning of the line. */
int yy_line_tokens = 0;

/* The current column we're tokenizing at. */
int yycolumn = 1;

/* The encoding to use for converting strings. */
const char* yy_encoding = NULL;

/* A buffer for parsing string literals. It is reused and its size is dynamically allocated. */
size_t strbuf_size = 0;
char* strbuf = NULL;
char* strbuf_end;
char* strbuf_ptr;

/* Initialize the globals before running the lexer. */
void yylex_initialize(const char* filename, const char* encoding)
{
    assert(filename != NULL);
    yy_eof_times = 0;
    yy_filename = filename;
    yy_line_tokens = 0;
    yycolumn = 1;
    if ( encoding == 0 ) {
        yy_encoding = "utf8";
    }
    else {
        yy_encoding = encoding;
    }

    /* Start with a decent small buffer. */
    strbuf_size = 1024;
    strbuf = realloc(strbuf, strbuf_size + 1);
    strbuf_end = strbuf + strbuf_size - 1;
    strbuf_ptr = NULL;

    /* Note: If we used a reentrant parser, this routine should eventually call
     * yylex_init(). */
}

/* Finalize the globals before running the lexer. */
void yylex_finalize(void)
{
    yy_filename = NULL;

    /* Finalize our reading buffer. */
    if ( strbuf != NULL ) {
        free(strbuf);
        strbuf = NULL;
    }

    /* Call the yylex finalization routine. */
    yylex_destroy();
}


/* Reallocate the buffer to accomodate some new characters. */
void strbuf_realloc(size_t num_new_chars)
{
    assert(strbuf_ptr != NULL);
    size_t cur_size = strbuf_ptr - strbuf;
    size_t new_size = cur_size + num_new_chars;
    while ( strbuf_size < new_size ) {
        strbuf_size <<= 1;
    }
    strbuf = realloc(strbuf, strbuf_size + 1);
    strbuf_ptr = strbuf + cur_size;
    strbuf_end = strbuf + strbuf_size - 1;
}




#define LEXEOF 0

int yy_skip_line()
{
    int num_chars = 0;
    for ( ;; ) {
        int c = input();
        num_chars++;
        if ( c == LEXEOF || c == -1 ) {
            break;
        }
        if ( c == '\n' ) {
            unput(c);
            num_chars--;
            break;
        }
    }
    return num_chars;
}

/* Convert an integer string to a number. */
int strtonl(const char* buf, size_t nchars)
{
    int result = 0;
    size_t i;
    for ( i = 0; i < nchars; ++i ) {
        result *= 10;
        result += (buf[i] - '0');
    }
    return result;
}

/* Build and accumulate an error on the builder object. */
void build_lexer_error(const char* string, size_t length)
{
    TRACE_ERROR("Invalid Token");

    /* Build and accumulate a new error object. {27d1d459c5cd} */
    PyObject* rv = PyObject_CallMethod(builder, "build_lexer_error",
                                       "s#", string, (Py_ssize_t)length);
    if (rv == NULL) {
        PyErr_SetString(PyExc_RuntimeError,
                        "Internal error: Building exception from default rule");
    }
    Py_XDECREF(rv);
}

void build_lexer_error_from_exception()
{
    TRACE_ERROR("Lexer Builder Exception");

    /* Get the exception context. */
    PyObject* ptype = NULL;
    PyObject* pvalue = NULL;
    PyObject* ptraceback = NULL;
    PyErr_Fetch(&ptype, &pvalue, &ptraceback);
    PyErr_NormalizeException(&ptype, &pvalue, &ptraceback);

    /* Clear the exception. */
    PyErr_Clear();

    if (pvalue != NULL) {
        /* Build and accumulate a new error object. {27d1d459c5cd} */
        PyObject* rv = PyObject_CallMethod(builder, "build_lexer_error",
                                           "OO", pvalue, ptype);
        Py_XDECREF(ptype);
        Py_XDECREF(pvalue);
        Py_XDECREF(ptraceback);

        if (rv == NULL) {
            PyErr_SetString(PyExc_RuntimeError,
                            "Internal error: While building exception");
        }
    }
    else {
        PyErr_SetString(PyExc_RuntimeError,
                        "Internal error: No exception");
    }
}

