/* piw-malloc.h -
 *
 * author(s): Tom Lord
 ****************************************************************
 * Copyright (C) 1998 UUNET Technologies, Inc.
 *
 * See the file "COPYING.PIW" for further information
 * about the copyright status of this work.
 */


#ifndef INCLUDE__PIW__PIW_MALLOC_H
#define INCLUDE__PIW__PIW_MALLOC_H

#include "hackerlab/machine/types.h"
#include "hackerlab/bitsets/bitset.h"
#include "hackerlab/piw-malloc/errno.h"
#include "hackerlab/piw-malloc/piw-variables.h"



extern void * piw_malloc_heap_start;
extern void * piw_malloc_heap_end;

enum piw_tags_constants
{
  piw_bytes_per_tag_bit = sizeof (long)
};

extern bitset piw_malloc_arena_tags;
extern void * piw_tagged_heap_start;
extern void * piw_tagged_heap_end;

extern void * piw_watchpt0_start;
extern void * piw_watchpt0_end;
extern void * piw_watchpt1_start;
extern void * piw_watchpt1_end;


/* automatically generated __STDC__ prototypes */
extern void * piw_malloc (int * errn, long n_bytes);
extern void * piw_realloc (int * errn, void * ublock, long n_bytes);
extern int piw_free (int * errn, void * ublock);
extern long piw_allocation_size (int * errn, void * ublock);
extern void * piw_malloc_returns (void * block);
extern void * piw_realloc_returns (void * block);
extern void piw_bogus_free_breakpoint (void * block);
extern void piw_bogus_realloc_breakpoint (void * block);
extern void piw_corrupted_padding_breakpoint (void * block,
					      t_uchar * location);
extern void piw_corrupted_fill_breakpoint (void * block,
					   t_uchar * location);
extern void piw_mark_writable (void * memory, long extent);
extern void piw_mark_unreadable (void * memory, long extent);
extern void * piw_write_barrier_breakpoint (void * addr, int length);
extern int piw_malloc_sanity_check ();
extern void piw_sanity_check_breakpoint (char * msg);
#endif  /* INCLUDE__PIW__PIW_MALLOC_H */
