/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect;

import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.reflect.BranchInstruction;
import net.sf.jiapi.reflect.Instruction;
import net.sf.jiapi.reflect.InstructionList;
import net.sf.jiapi.reflect.JiapiClass;
import net.sf.jiapi.reflect.JiapiMethod;
import net.sf.jiapi.reflect.LVTEntry;
import net.sf.jiapi.reflect.Signature;
import net.sf.jiapi.reflect.SwitchInstruction;
import net.sf.jiapi.reflect.TypeHelper;
import net.sf.jiapi.reflect.instruction.ReturnInstruction;

public class BasicBlock {
    private final InstructionList il;
    private final int startIdx;
    private final int endIdx;
    private boolean isFirstBasicBlock = false;

    BasicBlock(InstructionList il, int startIdx, int endIdx) {
        this.il = il;
        this.startIdx = startIdx;
        this.endIdx = endIdx;
    }

    public int getId() {
        return this.startIdx;
    }

    public InstructionList getInstructionList() {
        return this.il.createView(this.startIdx, this.endIdx + 1);
    }

    public Instruction getFirstInstruction() {
        return this.il.get(this.startIdx);
    }

    public Instruction getLastInstruction() {
        return this.il.get(this.endIdx);
    }

    public Instruction getNextInstruction() {
        BranchInstruction bIns;
        Instruction ins = this.getLastInstruction();
        if (ins instanceof BranchInstruction ? (bIns = (BranchInstruction)ins).isConditional() : !(ins instanceof SwitchInstruction) && !(ins instanceof ReturnInstruction)) {
            return this.il.get(this.endIdx + 1);
        }
        return null;
    }

    public List<LVTEntry> getLocalVariables() {
        LinkedList<LVTEntry> lvList = new LinkedList<LVTEntry>();
        if (this.isFirstBasicBlock) {
            JiapiMethod jm = this.il.getDeclaringMethod();
            lvList.addAll(this.getLocalVariables(jm));
        }
        block52: for (int i = this.startIdx; i < this.endIdx; ++i) {
            Instruction ins = this.il.get(i);
            switch (ins.getOpcode()) {
                case 21: {
                    lvList.add(new LVTEntry(ins.getBytes()[1], "I", ins, this.il));
                    continue block52;
                }
                case 26: {
                    lvList.add(new LVTEntry(0, "I", ins, this.il));
                    continue block52;
                }
                case 27: {
                    lvList.add(new LVTEntry(1, "I", ins, this.il));
                    continue block52;
                }
                case 28: {
                    lvList.add(new LVTEntry(2, "I", ins, this.il));
                    continue block52;
                }
                case 29: {
                    lvList.add(new LVTEntry(3, "I", ins, this.il));
                    continue block52;
                }
                case 54: {
                    lvList.add(new LVTEntry(ins.getBytes()[1], "I", ins, this.il));
                    continue block52;
                }
                case 59: {
                    lvList.add(new LVTEntry(0, "I", ins, this.il));
                    continue block52;
                }
                case 60: {
                    lvList.add(new LVTEntry(1, "I", ins, this.il));
                    continue block52;
                }
                case 61: {
                    lvList.add(new LVTEntry(2, "I", ins, this.il));
                    continue block52;
                }
                case 62: {
                    lvList.add(new LVTEntry(3, "I", ins, this.il));
                    continue block52;
                }
                case 22: {
                    lvList.add(new LVTEntry(ins.getBytes()[1], "J", ins, this.il));
                    continue block52;
                }
                case 30: {
                    lvList.add(new LVTEntry(0, "J", ins, this.il));
                    continue block52;
                }
                case 31: {
                    lvList.add(new LVTEntry(1, "J", ins, this.il));
                    continue block52;
                }
                case 32: {
                    lvList.add(new LVTEntry(2, "J", ins, this.il));
                    continue block52;
                }
                case 33: {
                    lvList.add(new LVTEntry(3, "J", ins, this.il));
                    continue block52;
                }
                case 55: {
                    lvList.add(new LVTEntry(ins.getBytes()[1], "J", ins, this.il));
                    continue block52;
                }
                case 63: {
                    lvList.add(new LVTEntry(0, "J", ins, this.il));
                    continue block52;
                }
                case 64: {
                    lvList.add(new LVTEntry(1, "J", ins, this.il));
                    continue block52;
                }
                case 65: {
                    lvList.add(new LVTEntry(2, "J", ins, this.il));
                    continue block52;
                }
                case 66: {
                    lvList.add(new LVTEntry(3, "J", ins, this.il));
                    continue block52;
                }
                case 23: {
                    lvList.add(new LVTEntry(ins.getBytes()[1], "F", ins, this.il));
                    continue block52;
                }
                case 34: {
                    lvList.add(new LVTEntry(0, "F", ins, this.il));
                    continue block52;
                }
                case 35: {
                    lvList.add(new LVTEntry(1, "F", ins, this.il));
                    continue block52;
                }
                case 36: {
                    lvList.add(new LVTEntry(2, "F", ins, this.il));
                    continue block52;
                }
                case 37: {
                    lvList.add(new LVTEntry(3, "F", ins, this.il));
                    continue block52;
                }
                case 56: {
                    lvList.add(new LVTEntry(ins.getBytes()[1], "F", ins, this.il));
                    continue block52;
                }
                case 67: {
                    lvList.add(new LVTEntry(0, "F", ins, this.il));
                    continue block52;
                }
                case 68: {
                    lvList.add(new LVTEntry(1, "F", ins, this.il));
                    continue block52;
                }
                case 69: {
                    lvList.add(new LVTEntry(2, "F", ins, this.il));
                    continue block52;
                }
                case 70: {
                    lvList.add(new LVTEntry(3, "F", ins, this.il));
                    continue block52;
                }
                case 24: {
                    lvList.add(new LVTEntry(ins.getBytes()[1], "D", ins, this.il));
                    continue block52;
                }
                case 38: {
                    lvList.add(new LVTEntry(0, "D", ins, this.il));
                    continue block52;
                }
                case 39: {
                    lvList.add(new LVTEntry(1, "D", ins, this.il));
                    continue block52;
                }
                case 40: {
                    lvList.add(new LVTEntry(2, "D", ins, this.il));
                    continue block52;
                }
                case 41: {
                    lvList.add(new LVTEntry(3, "D", ins, this.il));
                    continue block52;
                }
                case 57: {
                    lvList.add(new LVTEntry(ins.getBytes()[1], "D", ins, this.il));
                    continue block52;
                }
                case 71: {
                    lvList.add(new LVTEntry(0, "D", ins, this.il));
                    continue block52;
                }
                case 72: {
                    lvList.add(new LVTEntry(1, "D", ins, this.il));
                    continue block52;
                }
                case 73: {
                    lvList.add(new LVTEntry(2, "D", ins, this.il));
                    continue block52;
                }
                case 74: {
                    lvList.add(new LVTEntry(3, "D", ins, this.il));
                    continue block52;
                }
                case 25: {
                    lvList.add(new LVTEntry(ins.getBytes()[1], "L", ins, this.il));
                    continue block52;
                }
                case 42: {
                    lvList.add(new LVTEntry(0, "L", ins, this.il));
                    continue block52;
                }
                case 43: {
                    lvList.add(new LVTEntry(1, "L", ins, this.il));
                    continue block52;
                }
                case 44: {
                    lvList.add(new LVTEntry(2, "L", ins, this.il));
                    continue block52;
                }
                case 45: {
                    lvList.add(new LVTEntry(3, "L", ins, this.il));
                    continue block52;
                }
                case 58: {
                    lvList.add(new LVTEntry(ins.getBytes()[1], "L", ins, this.il));
                    continue block52;
                }
                case 75: {
                    lvList.add(new LVTEntry(0, "L", ins, this.il));
                    continue block52;
                }
                case 76: {
                    lvList.add(new LVTEntry(1, "L", ins, this.il));
                    continue block52;
                }
                case 77: {
                    lvList.add(new LVTEntry(2, "L", ins, this.il));
                    continue block52;
                }
                case 78: {
                    lvList.add(new LVTEntry(3, "L", ins, this.il));
                }
            }
        }
        return lvList;
    }

    private List<LVTEntry> getLocalVariables(JiapiMethod jm) {
        LinkedList<LVTEntry> ll = new LinkedList<LVTEntry>();
        int idx = 0;
        if (!Modifier.isStatic(jm.getModifiers())) {
            JiapiClass jc = jm.getDeclaringClass();
            LVTEntry lv = new LVTEntry(idx++, TypeHelper.typeToDescriptor(jc.getName()), this.il.get(0), this.il);
            ll.add(lv);
        }
        Signature signature = jm.getSignature();
        String[] parameters = signature.getParameterDescriptors();
        for (int i = 0; i < parameters.length; ++i) {
            ll.add(new LVTEntry(idx++, parameters[i], this.il.get(0), this.il));
        }
        return ll;
    }

    void markAsFirstBasicBlock() {
        this.isFirstBasicBlock = true;
    }

    public String toString() {
        return "BasicBlock(" + this.startIdx + "): \n" + this.getInstructionList() + this.getLocalVariables();
    }
}

