/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:52:53 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.EntropyAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class EntropyAlgorithm_ESTest extends EntropyAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getDefaultStepSize(10);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("2H48|c$ke(");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getDefaultStepSize(547);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getAverage();
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("win");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getAverage();
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("2H48|c$ke(");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getAverage();
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Informational Entropy");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      float[] floatArray0 = new float[8];
      // Undeclared exception!
      try { 
        entropyAlgorithm0.getValues(76, 1, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 21 > end: -54
         //
         verifyException("uk.ac.sanger.artemis.plot.EntropyAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EntropyAlgorithm entropyAlgorithm0 = null;
      try {
        entropyAlgorithm0 = new EntropyAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.EntropyAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getDefaultStepSize(1675);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getDefaultStepSize(1);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getDefaultMinWindowSize();
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getDefaultMaxWindowSize();
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getDefaultWindowSize();
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      float[] floatArray0 = new float[3];
      // Undeclared exception!
      try { 
        entropyAlgorithm0.getValues(1, 821, floatArray0);
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.setRevCompDisplay(true);
      float[] floatArray0 = new float[5];
      // Undeclared exception!
      try { 
        entropyAlgorithm0.getValues(0, 0, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getMinimumInternal();
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getMaximumInternal();
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      assertNotNull(entropyAlgorithm0);
      assertEquals("Reverse Informational Entropy", entropyAlgorithm0.getAlgorithmName());
      assertFalse(entropyAlgorithm0.isUserMaxMin());
      assertTrue(entropyAlgorithm0.scalingFlag());
      assertEquals("entropy", entropyAlgorithm0.getAlgorithmShortName());
      assertFalse(entropyAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, entropyAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, entropyAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, entropyAlgorithm0.getUserMin(), 0.01F);
      
      int int0 = entropyAlgorithm0.getValueCount();
      assertEquals(1, int0);
      assertEquals("Reverse Informational Entropy", entropyAlgorithm0.getAlgorithmName());
      assertFalse(entropyAlgorithm0.isUserMaxMin());
      assertTrue(entropyAlgorithm0.scalingFlag());
      assertEquals("entropy", entropyAlgorithm0.getAlgorithmShortName());
      assertFalse(entropyAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, entropyAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, entropyAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, entropyAlgorithm0.getUserMin(), 0.01F);
  }
}
