/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 18:01:26 GMT 2018
 */

package uk.ac.sanger.artemis.components.alignment;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import java.awt.HeadlessException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.EntryEdit;
import uk.ac.sanger.artemis.components.FeatureDisplay;
import uk.ac.sanger.artemis.components.alignment.BamView;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class BamView_ESTest extends BamView_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      BamView.setStandaloneMode(true);
      boolean boolean0 = BamView.isStandaloneMode();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      SAMFileHeader sAMFileHeader0 = new SAMFileHeader();
      SAMRecord sAMRecord0 = new SAMRecord(sAMFileHeader0);
      sAMRecord0.setReadNegativeStrandFlag(true);
      boolean boolean0 = BamView.isNegativeStrand(sAMRecord0, false);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      String[] stringArray0 = new String[1];
      // Undeclared exception!
      try { 
        BamView.main(stringArray0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      StringVector stringVector0 = StringVector.getStrings("eGo0Z");
      BamView bamView0 = null;
      try {
        bamView0 = new BamView(stringVector0, "eGo0Z", 16000, (FeatureDisplay) null, (Bases) null, (JPanel) null, (JFrame) null);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      SAMFileHeader sAMFileHeader0 = new SAMFileHeader();
      SAMRecord sAMRecord0 = new SAMRecord(sAMFileHeader0);
      boolean boolean0 = BamView.isNegativeStrand(sAMRecord0, true);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      // Undeclared exception!
      try { 
        BamView.isNegativeStrand((SAMRecord) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.BamView", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      List<String> list0 = ResourceBundle.Control.FORMAT_CLASS;
      BamView bamView0 = null;
      try {
        bamView0 = new BamView(list0, "t\"K&<df`HuJwx=u", (-30), (EntryEdit) null, (FeatureDisplay) null, (Bases) null, (JPanel) null, (JFrame) null);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      List<String> list0 = SAMRecord.TAGS_TO_REVERSE;
      // Undeclared exception!
      try { 
        BamView.openFileViewer((SAMRecord) null, (SAMRecord) null, list0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test8()  throws Throwable  {
      boolean boolean0 = BamView.isStandaloneMode();
      assertFalse(boolean0);
  }
}
