/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:09:49 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.GCDeviationAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class GCDeviationAlgorithm_ESTest extends GCDeviationAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("gc_deviation");
      Bases bases0 = new Bases(genbankStreamSequence0);
      genbankStreamSequence0.setFromChar(bases0.letter_index);
      Strand strand0 = bases0.getReverseStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      // Undeclared exception!
      try { 
        gCDeviationAlgorithm0.getValues(2, 2721, (float[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.GCDeviationAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      gCDeviationAlgorithm0.getDefaultStepSize(16000);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      float[] floatArray0 = new float[1];
      // Undeclared exception!
      try { 
        gCDeviationAlgorithm0.getValues((-337), (-609), floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: -337 > end: -609
         //
         verifyException("uk.ac.sanger.artemis.plot.GCDeviationAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      GCDeviationAlgorithm gCDeviationAlgorithm0 = null;
      try {
        gCDeviationAlgorithm0 = new GCDeviationAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("gc_deviation", "k2RqfQFW");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      gCDeviationAlgorithm0.getAverage();
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("3f/");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      gCDeviationAlgorithm0.getAverage();
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      gCDeviationAlgorithm0.getDefaultStepSize(4060);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("gc_deviation", "k2RqfQFW");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      gCDeviationAlgorithm0.getDefaultStepSize((-4153));
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("3f/");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      gCDeviationAlgorithm0.getDefaultMinWindowSize();
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      gCDeviationAlgorithm0.getDefaultMaxWindowSize();
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      gCDeviationAlgorithm0.getDefaultWindowSize();
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("3f/");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      float[] floatArray0 = new float[1];
      gCDeviationAlgorithm0.getValues(1, 2, floatArray0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("gc_deviation");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      // Undeclared exception!
      try { 
        gCDeviationAlgorithm0.getValues(2, 2721, (float[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.GCDeviationAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("3f/");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      int int0 = gCDeviationAlgorithm0.getValueCount();
      assertEquals(1, int0);
      assertTrue(gCDeviationAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("gc_deviation", "k2RqfQFW");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      Float float0 = gCDeviationAlgorithm0.getMaximumInternal();
      assertTrue(gCDeviationAlgorithm0.scalingFlag());
      assertEquals(1.0F, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      gCDeviationAlgorithm0.getMinimumInternal();
  }
}
