    /*
     * Some or all of this work - Copyright (c) 2006 - 2020, Intel Corp.
     * All rights reserved.
     *
     * Redistribution and use in source and binary forms, with or without modification,
     * are permitted provided that the following conditions are met:
     *
     * Redistributions of source code must retain the above copyright notice,
     * this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright notice,
     * this list of conditions and the following disclaimer in the documentation
     * and/or other materials provided with the distribution.
     * Neither the name of Intel Corporation nor the names of its contributors
     * may be used to endorse or promote products derived from this software
     * without specific prior written permission.
     *
     * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
     * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
     * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
     * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
     * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
     * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
     * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
     * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */
    /*
     * Data type conversion and manipulation
     *
     * Convert Data to Buffer
     */
    Name (Z043, 0x2B)
    /* Integer */
    /* 32-bit */
    Name (P320, Package (0x06)
    {
        0x00,
        0x81,
        0x8232,
        0x76543201,
        0xF89ABCDE,
        0xFFFFFFFF
    })
    Name (P321, Package (0x06)
    {
        Buffer (0x04)
        {
             0x00, 0x00, 0x00, 0x00                           // ....
        },

        Buffer (0x04)
        {
             0x81, 0x00, 0x00, 0x00                           // ....
        },

        Buffer (0x04)
        {
             0x32, 0x82, 0x00, 0x00                           // 2...
        },

        Buffer (0x04)
        {
             0x01, 0x32, 0x54, 0x76                           // .2Tv
        },

        Buffer (0x04)
        {
             0xDE, 0xBC, 0x9A, 0xF8                           // ....
        },

        Buffer (0x04)
        {
             0xFF, 0xFF, 0xFF, 0xFF                           // ....
        }
    })
    /* 64-bit */

    Name (P322, Package (0x09)
    {
        0x00,
        0x81,
        0x8232,
        0x76543201,
        0x0000008123456789,
        0x00008CDAE2376890,
        0x0076543201FABCDE,
        0xABCDEF9876543201,
        0xFFFFFFFFFFFFFFFF
    })
    Name (P323, Package (0x09)
    {
        Buffer (0x08)
        {
             0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   // ........
        },

        Buffer (0x08)
        {
             0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   // ........
        },

        Buffer (0x08)
        {
             0x32, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   // 2.......
        },

        Buffer (0x08)
        {
             0x01, 0x32, 0x54, 0x76, 0x00, 0x00, 0x00, 0x00   // .2Tv....
        },

        Buffer (0x08)
        {
             0x89, 0x67, 0x45, 0x23, 0x81, 0x00, 0x00, 0x00   // .gE#....
        },

        Buffer (0x08)
        {
             0x90, 0x68, 0x37, 0xE2, 0xDA, 0x8C, 0x00, 0x00   // .h7.....
        },

        Buffer (0x08)
        {
             0xDE, 0xBC, 0xFA, 0x01, 0x32, 0x54, 0x76, 0x00   // ....2Tv.
        },

        Buffer (0x08)
        {
             0x01, 0x32, 0x54, 0x76, 0x98, 0xEF, 0xCD, 0xAB   // .2Tv....
        },

        Buffer (0x08)
        {
             0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF   // ........
        }
    })
    /* Buffer */

    Name (P325, Package (0x06)
    {
        Buffer (0x01)
        {
             0x01                                             // .
        },

        Buffer (0x04)
        {
             0x01, 0x02, 0x03, 0x04                           // ....
        },

        Buffer (0x08)
        {
             0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08   // ........
        },

        Buffer (0x80)
        {
            /* 0000 */  0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,  // ........
            /* 0008 */  0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10,  // ........
            /* 0010 */  0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,  // ........
            /* 0018 */  0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20,  // .......
            /* 0020 */  0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,  // !"#$%&'(
            /* 0028 */  0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30,  // )*+,-./0
            /* 0030 */  0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,  // 12345678
            /* 0038 */  0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x40,  // 9:;<=>?@
            /* 0040 */  0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,  // ABCDEFGH
            /* 0048 */  0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,  // IJKLMNOP
            /* 0050 */  0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,  // QRSTUVWX
            /* 0058 */  0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, 0x60,  // YZ[\]^_`
            /* 0060 */  0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,  // abcdefgh
            /* 0068 */  0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70,  // ijklmnop
            /* 0070 */  0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,  // qrstuvwx
            /* 0078 */  0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x80   // yz{|}~..
        },

        Buffer (0xC8)
        {
            /* 0000 */  0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,  // ........
            /* 0008 */  0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10,  // ........
            /* 0010 */  0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,  // ........
            /* 0018 */  0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20,  // .......
            /* 0020 */  0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,  // !"#$%&'(
            /* 0028 */  0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30,  // )*+,-./0
            /* 0030 */  0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,  // 12345678
            /* 0038 */  0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x40,  // 9:;<=>?@
            /* 0040 */  0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,  // ABCDEFGH
            /* 0048 */  0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,  // IJKLMNOP
            /* 0050 */  0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,  // QRSTUVWX
            /* 0058 */  0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, 0x60,  // YZ[\]^_`
            /* 0060 */  0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,  // abcdefgh
            /* 0068 */  0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70,  // ijklmnop
            /* 0070 */  0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,  // qrstuvwx
            /* 0078 */  0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x80,  // yz{|}~..
            /* 0080 */  0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88,  // ........
            /* 0088 */  0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, 0x90,  // ........
            /* 0090 */  0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98,  // ........
            /* 0098 */  0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F, 0xA0,  // ........
            /* 00A0 */  0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8,  // ........
            /* 00A8 */  0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF, 0xB0,  // ........
            /* 00B0 */  0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,  // ........
            /* 00B8 */  0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF, 0xC0,  // ........
            /* 00C0 */  0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8   // ........
        },

        Buffer (0x0101)
        {
            /* 0000 */  0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,  // ........
            /* 0008 */  0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10,  // ........
            /* 0010 */  0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,  // ........
            /* 0018 */  0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20,  // .......
            /* 0020 */  0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,  // !"#$%&'(
            /* 0028 */  0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30,  // )*+,-./0
            /* 0030 */  0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,  // 12345678
            /* 0038 */  0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x40,  // 9:;<=>?@
            /* 0040 */  0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,  // ABCDEFGH
            /* 0048 */  0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,  // IJKLMNOP
            /* 0050 */  0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,  // QRSTUVWX
            /* 0058 */  0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, 0x60,  // YZ[\]^_`
            /* 0060 */  0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,  // abcdefgh
            /* 0068 */  0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70,  // ijklmnop
            /* 0070 */  0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,  // qrstuvwx
            /* 0078 */  0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x80,  // yz{|}~..
            /* 0080 */  0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88,  // ........
            /* 0088 */  0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, 0x90,  // ........
            /* 0090 */  0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98,  // ........
            /* 0098 */  0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F, 0xA0,  // ........
            /* 00A0 */  0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8,  // ........
            /* 00A8 */  0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF, 0xB0,  // ........
            /* 00B0 */  0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,  // ........
            /* 00B8 */  0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF, 0xC0,  // ........
            /* 00C0 */  0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8,  // ........
            /* 00C8 */  0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF, 0xD0,  // ........
            /* 00D0 */  0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8,  // ........
            /* 00D8 */  0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF, 0xE0,  // ........
            /* 00E0 */  0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8,  // ........
            /* 00E8 */  0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF, 0xF0,  // ........
            /* 00F0 */  0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8,  // ........
            /* 00F8 */  0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF, 0x00,  // ........
            /* 0100 */  0x01                                             // .
        }
    })
    /* Verify type, length of the obtained buffer */
    /* call to m305 to check the contents */
    Method (M320, 6, NotSerialized)
    {
        If ((ObjectType (Arg1) != 0x03))
        {
            ERR (Arg0, Z043, __LINE__, 0x00, 0x00, Arg2, "Type")
        }
        ElseIf ((SizeOf (Arg1) != (Arg2 + Arg3)))
        {
            ERR (Arg0, Z043, __LINE__, 0x00, 0x00, Arg2, "Sizeof")
        }
        Else
        {
            M305 (Arg0, Arg1, Arg2, Arg4, Arg5)
        }
    }

    /* Checking strings with different lengths */

    Method (M321, 1, Serialized)
    {
        Name (LENS, Buffer (0x0A)
        {
            /* 0000 */  0xC8, 0xC7, 0x81, 0x80, 0x7F, 0x09, 0x08, 0x07,  // ........
            /* 0008 */  0x01, 0x00                                       // ..
        })
        Local1 = 0x00
        While ((Local1 < 0x0A))
        {
            /* Prepare benchmark buffer */

            Local0 = DerefOf (LENS [Local1])
            Local4 = Buffer (Local0){}
            M303 (Local4, Local0)
            /* Convert benchmark buffer to string */

            Local2 = ToString (Local4, Ones)
            /* Create the same benchmark buffer anew */
            /* with null character appended */
            Local5 = Buffer ((Local0 + 0x01)){}
            M303 (Local5, Local0)
            Local5 [Local0] = 0x00
            /* Convert string to buffer */

            ToBuffer (Local2, Local3)
            /* Verify obtained buffer with the benchmark one */

            If ((Local3 != Local5))
            {
                ERR (Arg0, Z043, __LINE__, 0x00, 0x00, Local0, "NotEqual")
            }

            /* Check the source string was not corrupted */

            M307 (Arg0, Local2, Local0, 0x02, "Source")
            /* Check both buffers state too */

            M320 (Arg0, Local3, Local0, 0x01, 0x03, "Dest")
            M320 (Arg0, Local4, Local0, 0x00, 0x04, "Test")
            Local1++
        }
    }

    /* Checking buffers with different lengths */
    /* (zero length in the first order). */
    Method (M322, 1, Serialized)
    {
        Name (LENS, Package (0x02)
        {
            0x00,
            0x0201
        })
        Local1 = 0x00
        While ((Local1 < 0x02))
        {
            /* Prepare benchmark buffer */

            Local0 = DerefOf (LENS [Local1])
            Local4 = Buffer (Local0){}
            M303 (Local4, Local0)
            /*
             * // ToBuffer caused destroying of source buffer (passed
             * // by Data parameter), so they are duplicated below.
             *
             * Store(Local4, Local5)
             */
            ToBuffer (Local4, Local3)
            If ((Local3 != Local4))
            {
                ERR (Arg0, Z043, __LINE__, 0x00, 0x00, Local0, "NotEqual")
            }

            /* Check the buffers were not corrupted */
            /* (because know Data parameter was) */
            M320 (Arg0, Local3, Local0, 0x00, 0x06, "Dest")
            M320 (Arg0, Local4, Local0, 0x00, 0x07, "Source")
            Local1++
        }
    }

    /* Run-method */

    Method (TOB0, 0, Serialized)
    {
        Debug = "TEST: TOB0, Convert Data to Buffer"
        /* From integer */

        If ((F64 == 0x01))
        {
            M302 (__METHOD__, 0x09, "p322", P322, P323, 0x01)
        }
        Else
        {
            M302 (__METHOD__, 0x06, "p320", P320, P321, 0x01)
        }

        /* From string */

        M321 (__METHOD__)
        /* From buffer */

        M322 (__METHOD__)
        M302 (__METHOD__, 0x06, "p325", P325, P325, 0x01)
    }
