# DOSBox - Print the DOSBox pre-run actions for the given application.
# These actions are run inside DOSBox.
# USAGE: dosbox_prerun $application
# RETURN: the pre-run actions, can span over multiple lines,
#         or an empty string if there are none
dosbox_prerun() {
	# Game scripts targeting ./play.it < 2.20 used to set these actions through APP_xxx_PRERUN.
	if ! compatibility_level_is_at_least '2.20'; then
		dosbox_prerun_legacy "$application"
		return 0
	fi

	local application
	application="$1"

	get_value "${application}_DOSBOX_PRERUN"
}

# DOSBox - Print the DOSBox post-run actions for the given application.
# These actions are run inside DOSBox.
# USAGE: dosbox_postrun $application
# RETURN: the post-run actions, can span over multiple lines,
#         or an empty string if there are none
dosbox_postrun() {
	# Game scripts targeting ./play.it < 2.20 used to set these actions through APP_xxx_PRERUN.
	if ! compatibility_level_is_at_least '2.20'; then
		dosbox_postrun_legacy "$application"
		return 0
	fi

	local application
	application="$1"

	get_value "${application}_DOSBOX_POSTRUN"
}

