#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Loop Hero
###

script_version=20230916.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='loop-hero'
GAME_NAME='Loop Hero'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

# Archives

## Full game (gog.com)

ARCHIVE_BASE_2_NAME='loop_hero_1_1054_55873.sh'
ARCHIVE_BASE_2_MD5='28197c34cb00548770b6878f95f69b89'
ARCHIVE_BASE_2_SIZE='220000'
ARCHIVE_BASE_2_VERSION='1.1054-gog55873'
ARCHIVE_BASE_2_URL='https://www.gog.com/game/loop_hero'

ARCHIVE_BASE_1_NAME='loop_hero_1_105_50560.sh'
ARCHIVE_BASE_1_MD5='7ce0680d3dc6d945b0db0e3719addb21'
ARCHIVE_BASE_1_SIZE='160000'
ARCHIVE_BASE_1_VERSION='1.105-gog50560'

ARCHIVE_BASE_0_NAME='loop_hero_1_102_48813.sh'
ARCHIVE_BASE_0_MD5='fc860d85d59d02360d2d6aeb57cc8538'
ARCHIVE_BASE_0_SIZE='160000'
ARCHIVE_BASE_0_VERSION='1.102-gog48813'

## Demo (itch.io)

ARCHIVE_BASE_DEMO_0_NAME='LooPatHerO_demo_linux.zip'
ARCHIVE_BASE_DEMO_0_MD5='8698b73828300da7a519b026cd85d4aa'
ARCHIVE_BASE_DEMO_0_SIZE='23000'
ARCHIVE_BASE_DEMO_0_VERSION='1.0-itch1'
ARCHIVE_BASE_DEMO_0_URL='https://fourquarters.itch.io/loopathero-demo'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_PATH_DEFAULT_DEMO='.'
CONTENT_GAME_BIN_FILES='
Loop_Hero'
CONTENT_GAME_BIN_FILES_DEMO='
LooPatHerO'
CONTENT_GAME_DATA_FILES='
assets/*.dat
assets/*.ini
assets/*.png
assets/*.unx
assets/fonts
assets/local'

APP_MAIN_EXE='Loop_Hero'
APP_MAIN_EXE_DEMO='LooPatHerO'
APP_MAIN_ICON='assets/icon.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_PROVIDES="
$PKG_DATA_ID"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ID="$GAME_ID"
PKG_BIN_ID_DEMO="$GAME_ID_DEMO"
PKG_BIN_PROVIDES="
$PKG_BIN_ID"
PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libcurl.so.4
libdl.so.2
libgcc_s.so.1
libGL.so.1
libGLU.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libssl.so.1.1
libstdc++.so.6
libX11.so.6
libXext.so.6
libXrandr.so.2
libXxf86vm.so.1
libz.so.1'

# Work around broken support for non-US locales

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Work around broken support for non-US locales
export LANG=C'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game icon

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
