#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Enigmatis series:
# - Enigmatis 1
# - Enigmatis 2
# - Enigmatis 3
# send your bug reports to contact@dotslashplay.it
###

script_version=20240603.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID_ENIGMATIS1='enigmatis-1'
GAME_NAME_ENIGMATIS1='Enigmatis 1: The Ghosts of Maple Creek'

GAME_ID_ENIGMATIS2='enigmatis-2'
GAME_NAME_ENIGMATIS2='Enigmatis 2: The Mists of Ravenwood'

GAME_ID_ENIGMATIS3='enigmatis-3'
GAME_NAME_ENIGMATIS3='Enigmatis 3: The Shadow of Karkhala'

# Archives

## Enigmatis 1

ARCHIVE_BASE_ENIGMATIS1_0_NAME='enigmatis_the_ghosts_of_maple_creek_en_gog_1_22618.sh'
ARCHIVE_BASE_ENIGMATIS1_0_MD5='f689351491589ff01153d7e81200954c'
ARCHIVE_BASE_ENIGMATIS1_0_SIZE='1000000'
ARCHIVE_BASE_ENIGMATIS1_0_VERSION='1.0-gog22618'
ARCHIVE_BASE_ENIGMATIS1_0_URL='https://www.gog.com/game/enigmatis_the_ghosts_of_maple_creek'

## Enigmatis 2

ARCHIVE_BASE_ENIGMATIS2_0_NAME='enigmatis_2_the_mists_of_ravenwood_en_gog_1_22643.sh'
ARCHIVE_BASE_ENIGMATIS2_0_MD5='3b632c015135e9dd361c045de98efd34'
ARCHIVE_BASE_ENIGMATIS2_0_SIZE='1700000'
ARCHIVE_BASE_ENIGMATIS2_0_VERSION='1.0-gog22643'
ARCHIVE_BASE_ENIGMATIS2_0_URL='https://www.gog.com/game/enigmatis_2_the_mists_of_ravenwood'

## Enigmatis 3

ARCHIVE_BASE_ENIGMATIS3_0_NAME='enigmatis_3_the_shadow_of_karkhala_en_gog_1_22690.sh'
ARCHIVE_BASE_ENIGMATIS3_0_MD5='2a140d0ad6e3de74484d105c02959940'
ARCHIVE_BASE_ENIGMATIS3_0_SIZE='3000000'
ARCHIVE_BASE_ENIGMATIS3_0_VERSION='1.0-gog22690'
ARCHIVE_BASE_ENIGMATIS3_0_URL='https://www.gog.com/game/enigmatis_3_the_shadow_of_karkhala'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN64_FILES='
*_amd64'
CONTENT_GAME_BIN32_FILES='
*_i386'
CONTENT_GAME_DATA_FILES='
*.cub
*.json'

# Applications

FAKE_HOME_PERSISTENT_DIRECTORIES='
.Artifex Mundi'

APPLICATIONS_LIST='APP_MAIN'

APP_MAIN_ICON='../support/icon.png'

## Enigmatis 1

APP_MAIN_EXE_BIN64_ENIGMATIS1='Enigmatis_TheGhostsOfMapleCreek_amd64'
APP_MAIN_EXE_BIN32_ENIGMATIS1='Enigmatis_TheGhostsOfMapleCreek_i386'

## Enigmatis 2

APP_MAIN_EXE_BIN64_ENIGMATIS2='Enigmatis_TheMistsOfRavenwood_amd64'
APP_MAIN_EXE_BIN32_ENIGMATIS2='Enigmatis_TheMistsOfRavenwood_i386'

## Enigmatis 3

APP_MAIN_EXE_BIN64_ENIGMATIS3='Enigmatis3_amd64'
APP_MAIN_EXE_BIN32_ENIGMATIS3='Enigmatis3_i386'

# Packages

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_DATA_DESCRIPTION='data'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXext.so.6
libXinerama.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

## Enigmatis 1

PKG_DATA_ID_ENIGMATIS1="${GAME_ID_ENIGMATIS1}-data"

PKG_BIN_DEPS_ENIGMATIS1="$PKG_DATA_ID_ENIGMATIS1"
PKG_BIN64_DEPS_ENIGMATIS1="$PKG_BIN_DEPS_ENIGMATIS1"
PKG_BIN32_DEPS_ENIGMATIS1="$PKG_BIN_DEPS_ENIGMATIS1"

## Enigmatis 2

PKG_DATA_ID_ENIGMATIS2="${GAME_ID_ENIGMATIS2}-data"

PKG_BIN_DEPS_ENIGMATIS2="$PKG_DATA_ID_ENIGMATIS2"
PKG_BIN64_DEPS_ENIGMATIS2="$PKG_BIN_DEPS_ENIGMATIS2"
PKG_BIN32_DEPS_ENIGMATIS2="$PKG_BIN_DEPS_ENIGMATIS2"

## Enigmatis 3

PKG_DATA_ID_ENIGMATIS3="${GAME_ID_ENIGMATIS3}-data"

PKG_BIN_DEPS_ENIGMATIS3="$PKG_DATA_ID_ENIGMATIS3"
PKG_BIN64_DEPS_ENIGMATIS3="$PKG_BIN_DEPS_ENIGMATIS3"
PKG_BIN32_DEPS_ENIGMATIS3="$PKG_BIN_DEPS_ENIGMATIS3"

PKG_BIN_DEPENDENCIES_LIBRARIES_ENIGMATIS3="$PKG_BIN_DEPENDENCIES_LIBRARIES
libidn.so.11"
PKG_BIN64_DEPENDENCIES_LIBRARIES_ENIGMATIS3="$PKG_BIN_DEPENDENCIES_LIBRARIES_ENIGMATIS3"
PKG_BIN32_DEPENDENCIES_LIBRARIES_ENIGMATIS3="$PKG_BIN_DEPENDENCIES_LIBRARIES_ENIGMATIS3"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

APP_MAIN_EXE_BIN64=$(context_value 'APP_MAIN_EXE_BIN64')
APP_MAIN_EXE_BIN32=$(context_value 'APP_MAIN_EXE_BIN32')
launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
