#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Astrologaster
# send your bug reports to contact@dotslashplay.it
###

script_version=20240618.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='astrologaster'
GAME_NAME='Astrologaster'

ARCHIVE_BASE_0_NAME='AstrologasterWindows.zip'
ARCHIVE_BASE_0_MD5='049626f1818a1fdd828c3cdadd2052a9'
ARCHIVE_BASE_0_SIZE='710000'
ARCHIVE_BASE_0_VERSION='1.6.0-itch1'
ARCHIVE_BASE_0_URL='https://nyamyam.itch.io/astrologaster'

CONTENT_PATH_DEFAULT='AstrologasterWindows'
CONTENT_GAME_BIN_FILES='
glew32.dll
SDL2.dll
Astrologaster.exe'
## Despite the "Binary" name, this path seems to include only architecture-agnostic data.
CONTENT_GAME_DATA_FILES='
Binary'

USER_PERSISTENT_DIRECTORIES='
Save'

APP_MAIN_EXE='Astrologaster.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
