/*###############################################################################
# Linux Management Providers (LMP), DNS provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_DNSGENERALSETTINGDATA_H_
#define OPENDRIM_DNSGENERALSETTINGDATA_H_

#include <Instance.h>

const static char* OpenDRIM_DNSGeneralSettingData_classnames[] = {"OpenDRIM_DNSGeneralSettingData"};
static string OpenDRIM_DNSGeneralSettingData_NAMESPACE = _NAMESPACE;

class OpenDRIM_DNSGeneralSettingData {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	unsigned short AddressOrigin;
	bool AddressOrigin_isNULL;
	
	bool AppendPrimarySuffixes;
	bool AppendPrimarySuffixes_isNULL;
	
	bool AppendParentSuffixes;
	bool AppendParentSuffixes_isNULL;
	
	vector<string> DNSSuffixesToAppend;
	bool DNSSuffixesToAppend_isNULL;
	
	OpenDRIM_DNSGeneralSettingData() {
		Caption_isNULL = true;
		Description_isNULL = true;
		InstanceID_isNULL = true;
		ElementName_isNULL = true;
		AddressOrigin_isNULL = true;
		AppendPrimarySuffixes_isNULL = true;
		AppendParentSuffixes_isNULL = true;
		DNSSuffixesToAppend_isNULL = true;
	}
	
	~OpenDRIM_DNSGeneralSettingData() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getAddressOrigin(unsigned short& value) const {
		if (AddressOrigin_isNULL==true)
			return NOT_FOUND;
		value = AddressOrigin;
		return OK;
	}
	
	int setAddressOrigin(const unsigned short& newValue) {
		AddressOrigin = newValue;
		AddressOrigin_isNULL = false;
		return OK;
	}

	int getAppendPrimarySuffixes(bool& value) const {
		if (AppendPrimarySuffixes_isNULL==true)
			return NOT_FOUND;
		value = AppendPrimarySuffixes;
		return OK;
	}
	
	int setAppendPrimarySuffixes(const bool& newValue) {
		AppendPrimarySuffixes = newValue;
		AppendPrimarySuffixes_isNULL = false;
		return OK;
	}

	int getAppendParentSuffixes(bool& value) const {
		if (AppendParentSuffixes_isNULL==true)
			return NOT_FOUND;
		value = AppendParentSuffixes;
		return OK;
	}
	
	int setAppendParentSuffixes(const bool& newValue) {
		AppendParentSuffixes = newValue;
		AppendParentSuffixes_isNULL = false;
		return OK;
	}

	int getDNSSuffixesToAppend(vector<string>& value) const {
		if (DNSSuffixesToAppend_isNULL==true)
			return NOT_FOUND;
		value = DNSSuffixesToAppend;
		return OK;
	}
	
	int setDNSSuffixesToAppend(const vector<string>& newValue) {
		DNSSuffixesToAppend = newValue;
		DNSSuffixesToAppend_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_DNSGENERALSETTINGDATA_H_*/
