/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGICW.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgCloseWrite(void)

	Close the output file and replace the user INI file by it.
	Regardless of the success state, the output file is closed.
	After this, cfgOpenSection(NULL) is performed.

ob(ject): cfgCloseWrite
su(bsystem): inifile/2
sh(ort description): Close the INI file currently opened for writing
lo(ng description): Close the INI file currently opened for writing
 with a \em{successful} state.\par
 Then the NULL section is opened.
re(lated to): cfgCreateSection cfgEraseSection cfg_wrOpen cfg_wrClose
fi(le): cfgicw.c
in(itialized by): cfgCreateSection cfgEraseSection cfg_wrOpen

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGICW.C 1.3 1999/12/13 02:22:20 ska Exp ska $";
#endif

int cfgCloseWrite(void)
{	DBG_ENTER("cfgCloseWrite", Suppl_inifile2)
	chkHeap
	DBG_RETURN_BI( cfgi_wrClose(CFG_ERR_NONE))
}
